; ======================================================================
;
;	KB84FIX.ASM
;
;	(C) Copyright 1990 Richard B. Wales <wales@CS.UCLA.EDU>
;	May be distributed and used freely, so long as the original
;	source is included in any distribution, no charge (other than
;	a nominal communications or handling charge) is assessed, and
;	this notice is retained intact.
;
;	This TSR hooks into Int 9H and switches the BKSP, ESCAPE, and
;	Tilde/Grave keys on an 84-key keyboard.  It needs to be loaded
;	as early as possible -- before any other TSR's that hook into
;	the Int 9H vector.
;
;	I wrote this program because I wanted the keys on the top row
;	of my home "clone" system to be arranged in the same way as on
;	the Sun 3/50 workstation I use at school.  I pried off the caps
;	for the three keys in question; this TSR intercepts the key-
;	strokes and makes the keys generate the characters on the caps.
;
;	This program should be readily adaptable to other applications
;	that need to swap keys (e.g., a Dvorak keyboard mapper) or
;	otherwise manipulate the BIOS keystroke buffer.  Note, however,
;	that I assume each keystroke will result in at most one entry
;	being placed in the BIOS buffer; hence, this program would have
;	to be modified somewhat to work with an "extended" keyboard.
;
;	Assembled using Microsoft Assembler (MASM) version 5.1.  After
;	assembly and linkage, use EXE2BIN to convert the program into a
;	.COM file.
;
; ======================================================================

; Segment 0000H (interrupt vectors)
INTVECS	segment	at 0000H
	org	24H
int9vec	dw	?		; Interrupt vector 09H
	dw	?
INTVECS	ends

; Segment 0040H (BIOS data area)
BIOSDTA	segment	at 0040H
	org	17H
kbflags	db	?		; Keyboard flags
	org	1CH
buftail	dw	?		; Tail pointer (character buffer)
BIOSDTA	ends

; Shift-key mask for kbflags
SHFTMSK	equ	03H		; look for left and/or right shift key

; Character codes we are interested in changing
ESCAPE	equ	011BH		; escape
BKSP	equ	0E08H		; backspace
GRAVE	equ	2960H		; grave accent
TILDE	equ	297EH		; tilde

; ======================================================================

CODESEG	segment
	assume	cs:CODESEG, ds:BIOSDTA
	org	100H

; Buffer to hold address of original system Int 9H
; (will overlay the "jmp" at the start of the program)
oldint9	label	dword

begin:	jmp	short init	; Will be overlaid by "oldint9" value
	dw	0		; ditto

; New Int 9H handler
newint9	proc	far

	; Save the registers we'll be playing with
	push	ax
	push	bx
	push	dx
	push	ds

	; Establish the BIOS segment register for accessing BIOS data
	mov	ax, seg BIOSDTA
	mov	ds, ax

	; Get the tail pointer to the character buffer
	mov	bx, [buftail]

	; Call the original (BIOS) Int 9H routine first, and
	; let it put a new character into the circular buffer
	pushf
	call	[oldint9]

	; Did the BIOS routine add a character to the buffer?
	; If so, copy it into a register so we can examine it
	cmp	bx, [buftail]
	je	short done
	mov	dx, [bx]

	; Check for the four codes of interest, and switch them around

	; ESCAPE -> BKSP
	cmp	dx, ESCAPE
	jne	short notesc
	mov	[bx], BKSP
	jmp	short done
notesc:

	; (GRAVE or TILDE) -> ESCAPE
	cmp	dx, GRAVE
	jne	short notgrv
makesc:	mov	[bx], ESCAPE
	jmp	short done
notgrv:	cmp	dx, TILDE
	je	short makesc

	; BKSP -> GRAVE (if unshifted) or TILDE (if shifted)
	cmp	dx, BKSP
	jne	short done
	test	byte ptr kbflags, SHFTMSK
	jnz	short shift
	mov	[bx], GRAVE
	jmp	short done
shift:	mov	[bx], TILDE

	; All done.
done:	pop	ds
	pop	dx
	pop	bx
	pop	ax
	iret
newint9	endp

; ======================================================================

; TSR initialization code

init:
	assume	ds:INTVECS

	; Establish a zero segment register for interrupt vector area
	xor	ax, ax
	mov	ds, ax

	; Save the old Int 9H pointer
	mov	ax, [int9vec]
	mov	word ptr oldint9, ax
	mov	ax, [int9vec+2]
	mov	word ptr oldint9[2], ax

	; Hook in the new Int 9H handler
	cli
	mov	ax, offset newint9
	mov	[int9vec], ax
	mov	ax, cs
	mov	[int9vec+2], ax
	sti

	; Exit via a TSR call
	mov	dx, offset init
	int	27H

CODESEG	ends
	end	begin
