
	TITLE	SEMICOLON_REVERSE
;
;         Version 1.2

; by  William C. Parke for George Page and CHUG Aug. 1988
; 
; This program is a Terminate-and-Stay-Resident routine which
; converts a semicolon to a colon and visa-versa when typed
; from the keyboard.  For those not drilled into QWERTY
; typing, the often used DOS colon is easier to type, not
; requiring a shift with the semicolon key.  Install the
; program in the AUTOEXEC.BAT file after testing.

; Use DOS 2.11 or higher.

; The resident portion of the program takes only 256 bytes.
; (It is actually contained in the original Program Segment
; Prefix. The child environment is de-allocated.)

; Run COLON.COM again to disengage the colon-semicolon reversal.
; Repeated runs of COLON.COM will NOT install multiple copies.
; Instead, COLON.COM will search for itself.  If it finds itself
; already installed, it simply flags a change of the key
; reversal and exits.

; This file assembled under MASM Version 4.0.
; LINK and run EXE2BIN COLON COLON.COM.

COD	SEGMENT BYTE PUBLIC 'CODE'
	ASSUME  CS:COD, DS:COD, ES:COD, SS:COD

	 ORG	100H

BEGIN:	JMP	INIT		; initialize TSR for int 16h interception
SIGN:	DB	':;'
INT16:	CLC			; clc (0f8h) or stc (0f9h) alternate
	JC	OLD16		;  on each run of colon.com
	CMP	AH,2		; int 16h function index
	JC	NEW16		; request for next char
OLD16:	DB	0EAH		; far jump code
JOFS	DW	0		; original INT 16h vector 
JSEG	DW	0
NEW16:	PUSH	BP		; save base pointer
	PUSH	DX		; save dx
	MOV	BP,SP		; use bp as stack-pointer index
	MOV	DX,[BP+8]	; get user flag
	PUSH	DX		; anticipate IRET after call
	DB	9AH		; far call code
COFS	DW	0
CSEG	DW	0
	PUSHF
	POP	DX		; recover int 16h flags
	MOV	[BP+8],DX	; set user flag
	POP	DX		; recover user dx
	POP	BP		; recover user bp
	CMP	AH,27H		; scan code for colon key
	JNZ	EXIT
	XOR	AL,1		; reverse to 3A/3B (colon-semicolon)
EXIT:	IRET

MSG	DB	13,'Colon-Semicolon $'
MSG1	DB	'Reversed.',13,10,'$'
MSG2	DB	'Normal.',13,10,'$'
MSGC	DB	13,'COLON Version 1.2  by '
	DB	'William C. Parke for CHUG, 1988',13,10,'$'
SWFLG	DB	0
GOTIT0:	ADD	BX,OFFSET INT16-70H	; point to beginning of handler
GOTIT:	MOV	AL,SWFLG
	TEST	AL,80H
	JZ	GOTOG
	AND	AL,7FH
	AND	BYTE PTR ES:[BX],NOT 1
	OR	BYTE PTR ES:[BX],AL
	JMP	SHORT GOTSW
GOTOG:	XOR	BYTE PTR ES:[BX],1	; reverse/non-reverse flagger
GOTSW:	TEST	BYTE PTR ES:[BX],1	; nz if normal
	PUSHF
	MOV	DX,OFFSET MSG		; start of message
	MOV	AH,9
	INT	21H
	POPF
	MOV	DX,OFFSET MSG1		; reversed
	JZ	SHOW
	MOV	DX,OFFSET MSG2		; normal
SHOW:	INT	21H
	MOV	AX,4C00H		; exit without resident portion
	INT	21H

INIT:	CALL	GETSW
	MOV	AX,3516H		; get vector for int 16h
	INT	21H
	MOV	JOFS,BX			; set double word far jump
	MOV	JSEG,ES
	MOV	COFS,BX			; set double word far call
	MOV	CSEG,ES
	MOV	AX,ES
	CMP	AX,0F000H		; rom segment
	JNC	INITG			
	CMP	WORD PTR ES:[BX-2],';:'	; our sign
	JZ	GOTIT
	MOV	AH,52H			; get first mcb
	INT	21H
	MOV	AX,ES:[BX-2]		; seg address of first mcb
	XOR	BX,BX			; mcb start
SRCH:	MOV	ES,AX
	CMP	BYTE PTR ES:[BX],4DH	; not last one? (5AH if last)
	JNZ	INITG			; not found
	CMP	WORD PTR ES:INT16[BX-70H-2],';:'	; our sign?
	JZ	GOTIT0
	MOV	AX,ES
	ADD	AX,ES:[BX+3]		; size of mcb
	INC	AX			; point to next block
	MOV	ES,AX			;  in segment es
	JMP	SHORT SRCH

INITG:	MOV	DX,OFFSET MSGC
	MOV	AH,9
	INT	21H
	MOV	DX,OFFSET MSG		; tell user what will happen
	INT	21H
	MOV	DX,OFFSET MSG1		; reversed
	INT	21H
	XOR	AX,AX			; zero
	MOV	ES,AX			; set for bios data segment
	AND	BYTE PTR ES:[0417H],0DFH ; turn off NumLock
	MOV	ES,DS:[002CH]		; environ segment
	MOV	AH,49H			; free up environment
	INT	21H
	MOV	AX,CS
	MOV	ES,AX			; restore es	
	MOV	DI,80H			; use wasted psp buffer area
	MOV	SI,OFFSET BEGIN
	MOV	CX,40H
	REP	MOVSW			; move handler down to org 80h
	MOV	DX,OFFSET INT16 - 80H	; handler start address
	MOV	AX,2516H		; install keyboard preprocessor
	INT	21H
	MOV	DX,10H			; para size of our interrupt handler
	MOV	AX,3100H		; terminate and stay resident
	INT	21H
GETSW:	MOV	SI,80H
	LODSB
	CBW
	MOV	CX,AX
	JCXZ	GETSWR
GETSWS:	LODSB
	DEC	CX
	JCXZ	GETSWR
	CMP	AL,20H
	JZ	GETSWS
	CMP	AL,'/'
	JNZ	GETSWS
	LODSB
	AND	AL,5FH
	CMP	AL,'N'
	JZ	GETN
	CMP	AL,'R'
	JZ	GETR
GETSWR:	RET
GETN:	MOV	SWFLG,10000001B
	RET
GETR:	MOV	SWFLG,10000000B
	RET
COD	ENDS
	END	BEGIN
