/******************************************************************************
* CagdMesh.c - Extract surface control mesh/curve control polygon as polyline *
*******************************************************************************
* Written by Gershon Elber, Aug. 90.					      *
******************************************************************************/

#include "cagd_loc.h"

/******************************************************************************
* Extract the control polygon of a curve as a polyline.			      *
******************************************************************************/
CagdPolylineStruct *CagdCrv2CtrlPoly(CagdCrvStruct *Crv)
{
    int i,
	Length = Crv->Length;
    CagdRType **CrvP = Crv -> Points;
    CagdPtStruct *NewPolyline;
    CagdPolylineStruct *P;

    P = CagdPolylineNew(Length);
    NewPolyline = P -> Polyline;

    for (i = 0; i < Length; i++) {
	CagdCoerceToE3(NewPolyline -> Pt, CrvP, i, Crv -> PType);
	NewPolyline++;
    }
    return P;
}

/******************************************************************************
* Extract the control mesh of a surface as a list of polylines.		      *
******************************************************************************/
CagdPolylineStruct *CagdSrf2CtrlMesh(CagdSrfStruct *Srf)
{
    int i, j, SrfIndex,
	ULength = Srf->ULength,
	VLength = Srf->VLength;
    CagdRType **SrfP = Srf -> Points;
    CagdPtStruct *NewPolyline;
    CagdPolylineStruct *P, *PList = NULL;

    for (j = 0; j < VLength; j++) {	   /* Generate the rows of the mesh. */
	P = CagdPolylineNew(ULength);
	NewPolyline = P -> Polyline;

	SrfIndex = CAGD_MESH_UV(Srf, 0, j); /* Start at the begining of row. */
	for (i = 0; i < ULength; i++) {
	    CagdCoerceToE3(NewPolyline -> Pt, SrfP, SrfIndex, Srf -> PType);
            NewPolyline++;
	    SrfIndex += CAGD_NEXT_U(Srf);
	}
	CAGD_LIST_PUSH(P, PList);
    }

    for (i = 0; i < ULength; i++) {	   /* Generate the cols of the mesh. */
	P = CagdPolylineNew(VLength);
	NewPolyline = P -> Polyline;

	SrfIndex = CAGD_MESH_UV(Srf, i, 0); /* Start at the begining of row. */
	for (j = 0; j < VLength; j++) {
	    CagdCoerceToE3(NewPolyline -> Pt, SrfP, SrfIndex, Srf -> PType);
            NewPolyline++;
	    SrfIndex += CAGD_NEXT_V(Srf);
	}
	CAGD_LIST_PUSH(P, PList);
    }

    return PList;
}
