/**<rmln.c>**************************************************
*                       V O U C H                           *
*   VOUCH 1.1  Copyright (c) 1993, 1994  Awais M Hussain    *
*                   All rights reserved                     *
*************************************************************/
/* Consult <rmln.man> for documentation. 
*/
#include <stdio.h>
#include <alloc.h>
#include <string.h>
#include <stdlib.h>

#define RCNT 4096

int strip( int nl, char *fni, char *fno )
{
  FILE *fi, *fo ;
  int  i, nr, nw ;
  char *buff ;

  if ( (fi = fopen( fni, "rb" )) == (FILE*) NULL ) return(errno) ;
  buff = (char*) malloc(RCNT) ;
  for (i=0; i<nl; ++i) {
    if ( fgets( buff, RCNT, fi ) == (char *) NULL ) {
      free(buff) ; fclose(fi) ; return(11) ;
    }
  }

  if ( (fo = fopen( fno, "wb" )) == (FILE*) NULL ) {
    nr = errno ; free(buff) ; fclose(fi) ; return(nr) ;
  }
  do {
     nr = fread( buff, 1, RCNT, fi ) ;
     nw = fwrite( buff, 1, nr, fo ) ;
     if (nr!=nw) {
       perror("disk write error " ) ;
       free(buff) ;
       fclose( fi ) ; fclose( fo ) ;
       return(8) ;
     }
   } while (nr>0) ;
   fclose( fi ) ; fclose( fo ) ;
   free(buff) ;
   return(0) ;
}/*strip*/

main( int argc, char *argv[] )
{
  int err, nl ;
  char fni[80], fno[80] ;

  if (argc!=4) {
    puts("rmLn 1.1, VOUCH Utility, Copyright (c) 1993, 1994  Awais M. Hussain") ;
    puts("      Removess specified number of topmost lines. ") ;
    puts("Usage: rmln.exe  number_of_lines  <inFile>   <outFile> " ) ;
    exit(1) ;
  }
  strcpy( fni, argv[2] ) ;  
  strcpy( fno, argv[3] ) ;
  nl = atoi( argv[1] ) ;
  err = strip( nl, fni, fno ) ;
  if (err)  { 
    printf( "** file <%s> error: %i\n", fni, err ) ;
    exit(err) ;
  }
  else {
    printf("<%s> created.\n", fno ) ;
    exit(0) ;
  }  
}