-----------------------------------------------------------------
VOUCH  version  1.1.  Copyright (c) 1993, 1994  Awais M. Hussain.
-----------------------------------------------------------------
<vfio.c>

Some file IO routines.

=================================================================

1. 
int copyFile( const char *fn1, const char *fn2, int cp ) ;

Copy/append file <fn1> to file <fn2>.
cp=1 => copy; create a new file <fn2>.
cp=0 => append; append to the file <fn2>.

I: cp : {0,1}-flag.
I: fn1 : source filename.
I: fn2 : target filename.

2. 
int writeLN( unsigned crf, const char *fname, lenLN Lxx, ptrLN xx ) ;

Write LN (Lxx,xx) to file <fname>. 
crf=1 => a new file <fname> is created.
crf=0 => the LN is appended at the end of the file <fname>.

I: crf : {0,1}-flag.
I: fname : filename.
I: Lxx : length of LN.
I: xx : the LN.

The LN is written on a single line, in hex, with the least
significant hex-digit first (to the left). Because of the structure
of LN, the number of digits written is a multiple of 8. (A
long-unsigned contains eight hex digits.) Thus the LN written may
contain leading zero hex-digits.


3.
int readLN( unsigned ind, const char *fname, lenLN *Lxx, ptrLN xx ) ;

Read from file <fname> the ind-th LN in (Lxx,xx).

I: ind: the index of the LN to be read.
I: fname : filename.
I/O: Lxx : length of the LN read. 
O: xx : the LN read.

The LN should be on a single line, in hex, with the least significant
hex-digit first (to the left). No spaces between the digits are
allowed. The number of hex-digits should be a multiple of 8, so upto
7 leading zeros may have to be added. There should be no extra
leading zeros apart from these (see <usrGuide.vch>, Appendix B). When
calling, the argument Lxx should be set equal to more than the
expected length of the LN to be read. If the LN is longer than the
input value of Lxx, the routine returns an error (#50).


4.
int writeS( unsigned crf, const char *fname, char *cmnt ) ;

Write a comment-string "cmnt" to file <fname>.
crf=1 => new file is created.
crf=0 => append.

I: crf : {0,1}-flag.
I: fname : filename.
I: cmnt : the comment string to be written to the file.

5.
void fExt( const char *fn1, const char *nExt, char *fn2 ) ;

The filename string fn1 is copied into filename string fn2 but with
extension nExt.  For example,

	strcpy( fn1, "program.new" ) ;
	fExt( fn1, ".old", fn2 ) ; 

will result in fn2="program.old".

I: fn1 : input filename string.
O: fn2 : output filename string (the space for the string 
         must, of course, be allocated before calling fExt()).
I: nExt: the new 3-character filename extension.


6.
int trunc( unsigned ind, const char *fn ) ;

Truncate file <fn> after the ind-th line. 
It is intended to be used for files containing LNs (on each line).

I: ind : the index of the line after which truncation is desired.
I: fn : filename.

===================================================================