-----------------------------------------------------------------
VOUCH  version  1.1.  Copyright (c) 1993, 1994  Awais M. Hussain.
-----------------------------------------------------------------
<pubkey.c>

Generates the public-key parameters p,q,g. (The last parameter Y is
generated by 'vch/k.')  See <pubkey.doc>.

===================================================================

1.
void randomLN_2( unsigned *Lrr, ptrLN rr ) ;

Generates a random long-number (LN) less than twice (Lrr, rr).  More
often, one needs a LN less than a certain number. In this case, the
returned result should be modulo reduced. For example, suppose a
random LN (Lrr, rr) less than a given number (Lqq,qq) is desired:

Lrr = Lqq ;
*(rr+Lrr-1) = *(qq+Lqq-1) ; /* set MS words equal */
random( &Lrr, rr ) ;
                            /* reduce modulo (Lqq,qq), if required */
if (!isGreater( Lqq, qq, Lrr, rr )) subt( Lqq, qq, &Lrr, rr ) ;

Note: Same as randomLN() in <rndm.c>, except that it does not encrypt
      the random numbers.

I/O: Lrr: length of random LN.
I/O: rr : the random LN.

2.
int rzeros( lenLN Lpn, ptrLN pn ) ;

Returns the number of right-most zero bits in the LN (Lpn,pn).

I: Lpn : length of the LN 
I: pn : the LN.

3.
static void 
clr_mem( ptrLN hh, ptrLN pn, ptrLN bb, ptrLN zz, ptrLN mm) ;

Free some allocated memory. Used by primeLikely(). (Well, C does not
allow nested procedures.)

I: hh, pn, bb, zz, mm.

4.
int primeLikely( int nmax, lenLN Lpp, ptrLN pp ) ;

A probabilistic test for primality of the LN (Lpp,pp) as specified in
NIST DSS. "nmax" is the number of tests performed.  Returns 1, if the
tests succeed.

I: Lpp : length of LN to be tested.
I: pp : the LN to be tested.
I: nmax : number of tests to be performed.

5.
void gen_q( lenLN Lqt ) ;

Generates the q-parameter of the public key in (Lqq,qq) by the method
specified by NIST DSS. The q-parameter is just a prime number of
length Lqt*32 bits. A random number of specified length is chosen and
tested for primality by primeLikely(). If the test fails the trial
'q' is incremented by 2 and subjected to primality test. If the
length of incremented LN is greater than Lqt, a new random number is
generated.

I: Lqt : the desired length of the prime LN.

6.
void gen_p( lenLN Lpt ) ;

Generates the p-parameter of the public key in (Lpp,pp) by the method
specified by NIST DSS. The 'p' is a prime, such that 'q' is a
divisor of 'p-1'.  A random number of length 32*Lpt bits is chosen
and made a multiple of '2q' by subtracting apropriately from it. A
"1" is added and the result tested by primeLikely().

I: Lpt : length of 'p'-parameter desired.

7.
void gen_g( void ) ;

Generates the g-parameter of the public-key in (Lgg,gg) by the method
specified by NIST DSS.

8.
void helpScr( void ) ;

9.
void init( void ) ;

Initializes. Allocates memory to some LNs.

10.
void exit_proc( char *fn ) ;

Cleans up before exit.

I: fn : filename to which any exit error may be associated.

11.
void bell( int len ) ;

Outputs a chaotic sound.

I: len : determines the duration of the sound.

12.
main( int argc, char *argv[] ) ;

------------------------------------------------------------ 

[1] NIST, ``A Digital Signature Standard (DSS),'' Federal Information
    Processing Standard (FIPS) PUB XX, August 19, 1991.
