
;And new in version v2.017 is a cache for searches.

;And you can thank NeoTuri for most of the comments as he requested to
;have comments put in when I asked him to check for a nasty memory
;leak (which I think I've fixed)

;This is a simple pcx viewer + possible alpha blender.
;The easiest way to use is as follows:
;spcx file.pcx -a
;Note that without "-a", alpha blending won't occur.
;When in the program, press 0 to 9 to access the different
;"alpha blending" effects.
;You can skip directly to "number0" if you want to see the various
;alpha blending filters.

[Bits 16]
org 100h

[SECTION .data]

default_fps equ 60 ;the default fps :)
num equ 91 ;timer*den/num = fps (65559*num/den must be less than 65536)
;den equ 150 ;no longer constant

movementsize equ 4 ; The default movement size (in pixels).

;This is the default image used. It's a "diamond" or something.
;dia db 5,4,6,2,6,4,5
;    db 4,6,2,3,2,6,4
;    db 6,2,3,1,3,2,6
;    db 2,3,1,1,1,3,2
;    db 6,2,3,1,3,2,6
;    db 4,6,2,3,2,6,4
;    db 5,4,6,2,6,4,5
dia db 236,207,175,143,111,143,175,207,236
    db 207,175,143,111,079,111,143,175,207
    db 175,143,111,079,047,079,111,143,175
    db 143,111,079,047,255,047,079,111,143
    db 175,143,111,079,047,079,111,143,175
    db 207,175,143,111,079,111,143,175,207
    db 236,207,175,143,111,143,175,207,236
dxs equ 9 ;7
dys equ 7
xs dw dxs
ys dw dys
defpal incbin "pal.raw"
tl dw dia ;Tile Location
gray_palette
; db 0,0,0
; db 0,0,42
; db 0,42,0
; db 0,42,42
; db 42,0,0
; db 42,0,42
; db 42,21,0
; db 42,42,42
; db 21,21,21
; db 21,21,63
; db 21,63,21
; db 21,63,63
; db 63,21,21
; db 63,21,63
; db 63,63,21
; db 63,63,63
 db 0,0,0
 db 3,3,3
 db 7,7,7
 db 11,11,11
 db 15,15,15
 db 19,19,19
 db 23,23,23
 db 27,27,27
 db 31,31,31
 db 35,35,35
 db 39,39,39
 db 43,43,43
 db 47,47,47
 db 52,52,52
 db 57,57,57
 db 63,63,63

fulcrum db 128

;The usage message.
copyright db "SPCX v2.194 Copyright 2001 Michael Thornbury",13,10
          db "Usage: spcx [file["
      pcx db ".pcx]] [-asnfb(O#)h[m(o#)]-file2[.pcx]]$"

image db "image.000",0

;A nice message.

waitmessage db "Please wait...",0
 .length equ $-waitmessage
fps_string db "00000fps",0
fpsmessage db "0000fps",0
 .length equ $-fpsmessage

;What to search for when you want to shell
env db 'COMSPEC='
;Error msg crap.
notfound db "not found.$"
lackmemory db "Not enough memory to load $"
  .doublebuffer db "a double buffer.$"
  .secondbuffer db "a second buffer.$"
  .transbuffer db "a translation buffer.$"
  .intensity db "the intensity buffer.$"
  .heightmap db "the height map.$"
  .buffer db "file reader buffer.$"
  .imagetoolarge db "because image exceeds 64K.$"
  .image db "image buffer.$"
  .alpha db "alpha buffer.$"
no_frameskip_control db 0 ;no frameskip control - 1 off, 0 on
show_fps db 0 ; show the real frame rate
;shell message
exit db "Type 'EXIT' to return to Spcx.$"
;parameters table for shell
parms dw 0
      dw parms
  tcs dw 0
      dd 0
      dd 0
shellon db 0 ;was -s used? 0 - no, 1 - yes
drawalpha db 0 ;use alpha blending? 0 - no, 1 - yes
drawheight db 0 ;use height map? 0 - no, 1 - yes
moveheight db 0 ;move the height map? 0 - no, 1 - yes
direction db 0 ;direction to move
 .stop          equ 00000000b
 .left          equ 00000001b
 .right         equ 00000010b
 .up            equ 00000100b
 .down          equ 00001000b
draws db 0 ;drawalpha + drawheight
basicimage db 0 ;Use the basic image on top, regardless? 0 - no, 1 - yes
;interpolate what is shown?
interpolate db 0 ;0-none, 1-interpolate,
                 ;2-motion_blue, 3-dissolve, 4-"water"
                 ;5-dragger, 6-smoother, 7-gray scale
                 ;8-gray scale, no bleeding of error
interpolater_count equ 9
alterinprogram db 0
;secondary interpolater, for heightmap, identical function to
;interpolate, but functions on heightmap alone
secondinterpolate db 0
;setup timer only once
timersetup db 1
;the mode of the numberkeys: Alpha, Heightmap, Output
numbermode db 0
drawmethods
 dw null
 dw interpolater
 dw motion_blur
 dw dissolver
 dw water
 dw dragger
 dw smoother
 dw scanlines
 dw gray
 dw gray_no_bleed
xlocator dw 0
ylocator dw 0
zlocator dw 1
wlocator dw 1
pause db 0 ; did the user press esc, thus pausing the movement?
methodaddress dw number0 ;offset of the method to use for alpha blending
method dw 9 ; the number of the method
; These are the methods used to blend the pixels..skip down to number0
; procedure to take a look.
layermethods
 dw number0
 dw number1
 dw number2
 dw number3
 dw number4
 dw number5
 dw number6
 dw number7
 dw number8
 dw number9
 .length equ ($-layermethods)/2 ; length, to make it easy on me
;Timer functions to set the frame rate
pass db 0           ;Counter of passes through timer routine in loop.
skiprate db 0       ;skiprate = pass when pass is checked.
;timer counter to continue clock accuracy
count dw 0
;frames per second
fps dw default_fps
;count of frames per second with option "-n"
max_fps dw 0
;present denominator
den dw 5*default_fps ; the new denominator (fps*5)
;0^2 to 63^2 to prevent the need to do three squares
squares_table
 dw    0,    1,    4,    9,   16,
 dw   25,   36,   49,   64,   81,
 dw  100,  121,  144,  169,  196,
 dw  225,  256,  289,  324,  361,
 dw  400,  441,  484,  529,  576,
 dw  625,  676,  729,  784,  841,
 dw  900,  961, 1024, 1089, 1156,
 dw 1225, 1296, 1369, 1444, 1521,
 dw 1600, 1681, 1764, 1849, 1936,
 dw 2025, 2116, 2209, 2304, 2401,
 dw 2500, 2601, 2704, 2809, 2916,
 dw 3025, 3136, 3249, 3364, 3481,
 dw 3600, 3721, 3844, 3969
;default x/y coordinates of first box
defaultcoordinates
 .x1 dw 0
 .y1 dw 0
 .x2 dw 320
 .y2 dw 200
;x/y coordinates of first box
x1 dw 0
y1 dw 0
x2 dw 319
y2 dw 199
;dx/dy (z/v) movement of first box
z1 dw movementsize
v1 dw movementsize
z2 dw -movementsize
v2 dw -movementsize
;the same as x/y, z/v, but for the second box
rx1 dw 49
ry1 dw 39
rx2 dw 119
ry2 dw 89
rz1 dw movementsize
rv1 dw movementsize
rz2 dw -movementsize
rv2 dw -movementsize

[section .bss]

doublebuffer resw 1 ;segement of double buffer
secondbuffer resw 1 ;segement of secondary buffer
properbuffer resw 1 ;the buffer to draw to the screen
transbuffer resw 1
intensity resw 1
heightmap resw 1
alphapalette resw 1
gray_buffer resw 321*3 ; buffer for gray scale
red resb 1 ; red shade, used in reservealphapalette procedure
green resb 1 ; same as red, but green
blue resb 1 ; same as green, but blue
empty resb 1 ; allignment
tred resb 1 ; temp red shade
tgreen resb 1 ; same as red, but green
tblue resb 1 ; same as green, but blue
value resw 1 ; change
deltax resw 1 ; dx
deltay resw 1 ; dy
;temporary coordinates
tx resw 1
ty resw 1
txs resw 1
tys resw 1
tx1 resw 1
ty1 resw 1
tx2 resw 1
ty2 resw 1
trx1 resw 1
try1 resw 1
trx2 resw 1
try2 resw 1
drawer resw 1
darkest_allowed
 .red resb 1
 .green resb 1
 .blue resb 1
brightest_allowed
 .red resb 1
 .green resb 1
 .blue resb 1
;palette used for color->height translation
transpalette resb 256
;for moving the heightmap, if wanting to
line resb 320 ; a line of characters
;fps to go (so that I know when a second is up)
fps_to_go resw 1
;new fps (to alter fps when fps_to_go is empty (hopefully to reduce clock
;impressission))
new_fps resw 1
file resb 128 ; the file name, if any, provided
file2 resb 128 ; the second file name, if any, provided
path resb 128 ; the path of command.com
palette resb 768 ; where I store the palette
efficientpalette resd 256 ; a more quick look-up
org_drv resb 1 ; the original drive
org_dir resb 66 ; the original directory
savss resw 1 ;saved ss/sp when shelled
savsp resw 1
timoff resw 1 ; Older timer offset/segement
timseg resw 1
handle resw 1 ; the file handler
;Most high contrast colors used for "Please wait" sign when
;recalculating alpha palette.
darkestcolor resb 1
greycolor resb 1
lightestcolor resb 1
bufferspace resw 8 ;temporary space used for switching rx1..rv2 with x1..v2
loopy resw 1 ; um..level of y's, I think
total resw 1 ; holder of image size (width*height)
temp resw 1 ; used in verifying that a file is in fact a pcx file
bufseg resw 1 ; the segment of the file buffer reader
stack resw 2048 ; the new stack position
 .end equ $-2

[section .text]

start
mov sp,stack.end ;change the stack position
mov [bufseg],cs
mov byte [file],0
mov byte [file2],0
mov bx,stack.end+2
shr bx,4
inc bx
push cs
pop es
mov ah,4ah
int 21h  ;shrink spcx's memory usage to minimal
cld
call checkcommandline ;check the command line
call command ;get the comspec env. label's contents
call getorg ;get the original directory
;allocate the double buffer
mov di,lackmemory.doublebuffer
mov bx,4000
call create_segment
mov [doublebuffer],ax
;allocate translation buffer
mov di,lackmemory.transbuffer
mov bx,2048
call create_segment
mov [transbuffer],ax
cmp byte [drawheight],1
if e
 mov di,lackmemory.intensity
 mov bx,4096
 call create_segment
 mov [intensity],ax
endif
;setup which to use
cmp byte [alterinprogram],0
if ne
 ;allocate secondary buffer
 mov bx,4000
 mov di,lackmemory.secondbuffer
 call create_segment
 mov [secondbuffer],ax
endif
cmp byte [drawheight],1
if e
 mov bx,4000
 mov di,lackmemory.heightmap
 call create_segment
 mov [heightmap],ax
endif
cmp byte [drawalpha],1
if e
 mov bx,4096
 mov di,lackmemory.alpha
 call create_segment
 mov [alphapalette],ax
endif

redrawheightmap
push cs
pop es
xor bh,bh
mov bl,[secondinterpolate]
shl bx,1
mov ax,[cs:bx+drawmethods]
mov [drawer],ax
cmp byte [file],0
if ne
 mov dx,file
 call loadpcx
; cmp byte [file2],0
; if e
;  call convertimage
;  call copypal
; endif
else
 call copypal
endif
call generate_transbuffer
call highcontrastcolors
call reorganizepalette
cmp byte [secondinterpolate],0
if ne
 mov es,[secondbuffer]
 call clear
 push cs
 pop es
endif
cmp byte [drawheight],1
if e
 call fillheightmap
 call transheightmap
 call findfulcrum
; cmp byte [fulcrum],256-8
; if a
;  mov byte [fulcrum],256-8
; else
;  cmp byte [fulcrum],8
;  if b
;   mov byte [fulcrum],8
;  endif
; endif
endif
cmp byte [file2],0
if ne
 mov ax,cs
 cmp ax,[bufseg]
 if ne
  mov es,[bufseg]
  mov ah,49h
  int 21h
 endif
 push cs
 pop es
 mov dx,file2
 call loadpcx
; call convertimage
; call copypal
 call generate_transbuffer
endif
cmp byte [basicimage],1
if e
 mov ax,cs
 cmp ax,[bufseg]
 if ne
  mov es,[bufseg]
  mov ah,49h
  int 21h
 endif
 push cs
 pop es
 ;call getpalette
 call copypal
 call generate_transbuffer
 mov [bufseg],cs
 mov word [tl],dia
 mov word [xs],dxs
 mov word [ys],dys
endif
call setinterpolater
call reorganizepalette
; find the darkest and lightest colors for use with display procedure
call highcontrastcolors
cmp byte [interpolate],0
if ne
 mov es,[secondbuffer]
 call clear
 push cs
 pop es
endif
cmp byte [drawheight],1
if e
 call fillintensitybuffer
endif
cmp byte [timersetup],1
if e
 cmp byte [drawalpha],1
 if e
  call calculatealphapalette
 endif
 cmp byte [shellon],1 ;should I shell out?
 if e
  call shell
 endif
endif
mov ax,0013h
int 10h
call showpal

cmp byte [timersetup],1
if e
 mov ax,[fps]
 mov [fps_to_go],ax
 mov [new_fps],ax
 mov ax,[den]
 mov [count],ax
 call timer
endif
mov byte [timersetup],0
l2
;pass = counter to detect number of times through counter procedure
;       (which is called by timer interrupt)
mov byte [pass],0
mov es,[doublebuffer] ; es is the segment to draw to
call clear
l1
call move_boxes
call draw_boxes
cld
cmp byte [pause],1 ;should I pause?
if e
 mov byte [pause],0
.again
 xor ah,ah
 int 16h
 or al,32
 cmp al,"p"
 if e
  call save_screen
  jmp .again
 endif
 mov byte [pass],0
endif
cmp byte [no_frameskip_control],1 ;should I skip the frame rate controller?
jne .normal

mov al,[pass]
mov byte [skiprate],al

cmp al,0
if ne
 mov byte [pass],0
 mov ds,[cs:doublebuffer]
 call [cs:drawer] ;outputfilter
 call drawtoscreen ; copy from double buffer to screen
 push cs
 pop ds
 cmp byte [moveheight],1
 if e
  call moveheightmap
 endif
;else
; mov byte [skiprate],1
endif

jmp .next

.normal

mov ds,[doublebuffer]
call [cs:drawer] ;outputfilter
call drawtoscreen ; copy from double buffer to screen
push cs
pop ds
cmp byte [moveheight],1
if e
 call moveheightmap
endif

; Pause here to let the really fast frame wait around.
.loop
cmp byte [pass],0
je .loop

mov al,[pass]
mov [skiprate],al
mov byte [pass],0

.next

call clear ; clear the double buffer

inc word [max_fps]

mov ah,1
int 16h
jnz done ;loop until a key is pressed
jmp l1
done
xor ah,ah
int 16h

cmp al,9 ; chr 9 = tab = pause
if e
 mov byte [pause],1
 jmp l1
endif
cmp byte [moveheight],1
if e
 cmp al,13
 if e
  mov byte [direction],direction.stop
  jmp l1
 endif
 cmp al,0
 if e
  call finddirection
  if c
   jmp l1
  endif
 endif
endif
cmp byte [numbermode],"a"
if e
 cmp byte [drawalpha],1
 if e
  cmp al,"0" ; >=0
  if ae
   cmp al,layermethods.length-1+"0" ; <= lastmethod+"0"..which now is 9+"0"="9"
   if be
    sub al,"0"
    xor ah,ah
    mov [method],ax ;set the method
    call displaymessage
;   call drawtoscreen
    call calculatealphapalette ; and recalculate the alpha palette
    jmp l2 ;then go way above and start over again
   endif
  endif
 endif
endif
cmp byte [alterinprogram],1
if e
 cmp byte [numbermode],"o"
 if e
  mov dl,al
  sub dl,"0"
  cmp dl,0
  jl .ignore
  cmp dl,interpolater_count
  jg .ignore
  mov [interpolate],dl
  call setinterpolater
  call showpal
  push es
  mov es,[secondbuffer]
  call clear
  pop es
  jmp l1
  .ignore
 else
  cmp byte [numbermode],"h"
  if e
   mov dl,al
   sub dl,"0"
   cmp dl,0
   jl .ignore
   cmp dl,interpolater_count
   jg .ignore
   mov [secondinterpolate],dl
   mov ax,cs
   cmp ax,[bufseg]
   if ne
    mov es,[bufseg]
    mov ah,49h
    int 21h
   endif
   mov [bufseg],cs
   mov word [tl],dia
   mov word [xs],dxs
   mov word [ys],dys
   jmp redrawheightmap
  endif
 endif
endif
;cmp byte [no_frameskip_control],0
;if e
 cmp al,"="
 if e
  mov al,"+"
 endif
 cmp al,"+"
 if e
  cmp word [new_fps],9999
  if ne
   inc word [new_fps]
  endif
  jmp l1
 endif
 cmp al,"-"
 if e
  cmp word [new_fps],19
  if ne
   dec word [new_fps]
  endif
  jmp l1
 endif
;endif
or al,32
cmp byte [drawalpha],1
if e
 cmp al,"a"
 je .numbermode
endif
cmp byte [drawheight],1
if e
 cmp al,"h"
 je .numbermode
endif
cmp byte [alterinprogram],1
if e
 cmp al,"o"
 je .numbermode
endif
jmp .done
.numbermode
mov [numbermode],al
jmp l1
.done
call return
mov ax,0003h
int 10h
push cs
pop ds
mov dl,[org_drv]
mov ah,0eh
int 21h
mov dx,org_dir
mov ah,3bh
int 21h
mov dx,copyright ;say bye bye
mov ah,9
int 21h
mov ax,4c00h
int 21h

save_screen
push ds
push cs
pop ds
mov dx,image
xor cx,cx
mov ah,3ch
int 21h
if c
 pop ds
 int 20h
 ret
endif
mov bx,ax
mov ax,0a000h
mov ds,ax
xor dx,dx
mov cx,64000
push bx
mov ah,40h
int 21h
pop bx
mov ah,3eh
int 21h
inc byte [cs:image+8]
pop ds
ret

finddirection
clc
cmp ah,75
if e
 mov byte [direction],direction.left
 stc
endif
cmp ah,77
if e
 mov byte [direction],direction.right
 stc
endif
cmp ah,72
if e
 mov byte [direction],direction.up
 stc
endif
cmp ah,80
if e
 mov byte [direction],direction.down
 stc
endif
cmp ah,71
if e
 mov byte [direction],direction.up
 or byte [direction],direction.left
 stc
endif
cmp ah,73
if e
 mov byte [direction],direction.up
 or byte [direction],direction.right
 stc
endif
cmp ah,79
if e
 mov byte [direction],direction.down
 or byte [direction],direction.left
 stc
endif
cmp ah,81
if e
 mov byte [direction],direction.down
 or byte [direction],direction.right
 stc
endif
ret

setinterpolater
mov ax,[doublebuffer]
xor bh,bh
mov bl,[interpolate]
test bl,bl
if nz
 mov ax,[secondbuffer]
endif
mov [properbuffer],ax
shl bx,1
mov ax,[cs:bx+drawmethods]
mov [drawer],ax
ret

findfulcrum
mov ds,[heightmap]
xor si,si
xor edx,edx
xor eax,eax
mov cx,64000
.l1
lodsb
xor bh,bh
mov bl,al
shl bx,1
mov ax,[cs:bx+squares_table]
add edx,eax
loop .l1
mov eax,edx
xor edx,edx
mov ebx,64000
div ebx
push cs
pop ds
xor bl,bl
mov dx,1
.l2
sub ax,dx
js .skip
inc bl
add dx,2
cmp bl,255
jne .l2
.skip
mov [fulcrum],bl
ret

;word allign palette
reorganizepalette
mov si,palette
mov di,efficientpalette
mov cx,256
.l1
movsw
movsb
xor al,al
stosb
loop .l1
ret

find_allowable_color_range
cld
push cs
pop es
mov si,palette
mov di,0
xor bp,bp ;red_counter
xor bx,bx ;green_counter
xor dx,dx ;blue_counter
mov cx,256
.l1
call correct_count
jc .next
xor ah,ah
lodsb
add bp,ax
lodsb
add bx,ax
lodsb
add dx,ax
.next
loop .l1
mov si,di
mov di,darkest_allowed.red
mov ax,bp
call check_range
mov ax,bx
call check_range
mov ax,dx
call check_range
ret

correct_count
push di
push si
push bx
lodsd
mov ebx,eax
rol ebx,8
xor bl,bl
ror ebx,8
sub si,4
mov di,si
mov si,palette
.l1
cmp di,si
je .done
lodsd
rol eax,8
xor al,al
ror eax,8
dec si
cmp eax,ebx
je .already_seen
jmp .l1
.done
pop bx
pop si
pop di
inc di
clc
ret
.already_seen
pop bx
pop si
pop di
add si,3
stc
ret

check_range
push dx
xor dx,dx
div si
cmp al,31
if a
 mov byte [di+3],63
 mov ah,63
 sub ah,al
 sub al,ah
 mov [di],al
else
 mov byte [di],0
 shl al,1
 mov [di+3],al
endif
inc di
pop dx
ret

generate_transbuffer
;call find_allowable_color_range
mov es,[transbuffer]
xor di,di
mov dl,32
mov byte [blue],0
.l3
mov ch,32
mov byte [green],0
.l2
mov cl,32
mov byte [red],0
.l1
push dx
push cx
call search_without_cache
pop cx
pop dx
add byte [red],2
dec cl
jnz .l1
add byte [green],2
dec ch
jnz .l2
add byte [blue],2
dec dl
jnz .l3
push cs
pop es
ret

fillheightmap
cld
mov si,x1
mov di,bufferspace
movsd
movsd
mov si,defaultcoordinates
mov di,x1
movsd
movsd
push es
mov es,[heightmap]
push word [draws]
mov byte [draws],0
call stretch
pop word [draws]
cmp byte [secondinterpolate],0
if ne
 mov ds,[heightmap]
 call [cs:drawer] ;outputfilter
 mov ds,[cs:secondbuffer]
 mov es,[cs:heightmap]
 xor si,si
 xor di,di
 mov cx,16000
 rep movsd
 push cs
 pop ds
endif
pop es
mov si,bufferspace
mov di,x1
movsd
movsd
ret

;bx and di passed
;bx = paragraphs to allocate
;di = string name of what you're attempting to allocate
create_segment ;intensitybuffer
mov ah,48h
int 21h
if c ;and exit if I can't make one
 mov ah,9
 mov dx,lackmemory
 int 21h
 mov dx,di
 int 21h
 mov ax,4c00h
 int 21h
endif
;mov [intensity],ax
ret

fillintensitybuffer
mov ax,[intensity]
mov es,ax
xor di,di
mov si,palette
mov cx,256
cld
.l1
push di
push cx
lodsw
mov [tred],ax
lodsb
mov [tblue],al
xor ax,ax
mov [red],ax
mov [blue],al
mov bh,[fulcrum]
call fade ;fromblack
mov ax,3f3fh
sub ax,[tred]
mov [tred],ax
mov al,3fh
sub al,[tblue]
mov [tblue],al
xor bh,bh
sub bh,[fulcrum]
call fade ;towhite
pop cx
pop di
inc di
dec cx
jnz .l1
push cs
pop es
ret

fade
xor dx,dx
xor bl,bl
xor ch,ch
mov cl,bh
.a1
push bx
push cx
push dx
call search
add di,255
pop dx
pop cx
pop bx
add bl,[tred]
cmp bl,bh
if ae
 sub byte bl,bh
 inc byte [red]
endif
add dl,[tgreen]
cmp dl,bh
if ae
 sub byte dl,bh
 inc byte [green]
endif
add dh,[tblue]
cmp dh,bh
if ae
 sub byte dh,bh
 inc byte [blue]
endif
dec cx
jnz .a1
ret

;get the highest contrasting colors
highcontrastcolors
push cs
pop es
mov di,darkestcolor
xor ax,ax
mov [red],ax
;mov [green],al
mov [blue],al
call search
mov al,[fulcrum]
shr al,2
mov ah,al
;mov ax,0f0fh
mov [red],ax
mov [blue],al
call search
mov ax,03f3fh ; 63*256+63 in hex
mov [red],ax
;mov [green],al
mov [blue],al
call search
ret

moveheightmap
push ds
push es
mov ds,[cs:heightmap]
test byte [cs:direction],direction.left
if nz
 xor si,si
 cld
 mov es,[cs:heightmap]
 xor di,di
 mov dx,200
 .l1
 lodsb
 mov bl,al
 mov cx,79
 rep movsd
 movsw
 movsb
 mov al,bl
 stosb
 dec dx
 jnz .l1
endif
test byte [cs:direction],direction.right
if nz
 mov si,63999
 std
 mov es,[cs:heightmap]
 mov di,63999
 mov dx,200
 .l2
 lodsb
 mov bl,al
 mov cx,319
 rep movsb
 mov al,bl
 stosb
 dec dx
 jnz .l2
endif
test byte [cs:direction],direction.up
if nz
 xor si,si
 cld
 push cs
 pop es
 mov di,line
 mov cx,80
 rep movsd
 mov es,[cs:heightmap]
 xor di,di
 mov cx,199*80
 rep movsd
 push cs
 pop ds
 mov si,line
 mov cx,80
 rep movsd
endif
test byte [cs:direction],direction.down
if nz
 mov si,63996
 std
 push cs
 pop es
 mov di,line+316
 mov cx,80
 rep movsd
 mov es,[cs:heightmap]
 mov di,63996
 mov cx,199*80
 rep movsd
 push cs
 pop ds
 mov si,line+316
 mov cx,80
 rep movsd
endif
cld
pop es
pop ds
ret

transheightmap
mov si,palette
mov di,transpalette
xor bh,bh
mov cx,256
.l1
mov bl,[si]
inc si
shl bl,1
mov ax,[bx+squares_table]
mov bl,[si]
inc si
shl bl,1
add ax,[bx+squares_table]
mov bl,[si]
inc si
shl bl,1
add ax,[bx+squares_table]
xor bl,bl
mov dx,3
.l2
sub ax,dx
js .skip
add dx,6
add bl,2
cmp bl,63*2
jne .l2
.skip
mov al,bl
shl al,1
stosb
dec cx
jnz .l1
mov ax,[heightmap]
mov es,ax
xor di,di
mov ds,ax
xor si,si
mov cx,64000
xor bh,bh
.l3
lodsb
mov bl,al
mov al,[cs:bx+transpalette]
stosb
dec cx
jnz .l3
mov ax,cs
mov ds,ax
mov es,ax
ret

;converts image from loaded palette based to default palette based
convertimage
cld
mov si,palette
xor dh,dh
.l2
mov di,defpal
mov bp,65535
xor cx,cx
xor dl,dl
.l1
xor bh,bh
mov bl,[si]
sub bl,[di]
if s
 neg bl
endif
inc di
shl bl,1
mov ax,[bx+squares_table]
xor bh,bh
mov bl,[si+1]
sub bl,[di]
if s
 neg bl
endif
inc di
shl bl,1
add ax,[bx+squares_table]
xor bh,bh
mov bl,[si+2]
sub bl,[di]
if s
 neg bl
endif
inc di
shl bl,1
add ax,[bx+squares_table]
cmp ax,bp
if b
 mov bp,ax
 mov dl,cl
 cmp bp,0
 je .skip
endif
inc cx
cmp cx,256
jne .l1
.skip
mov bl,dh
mov [bx+transpalette],dl
add si,3
inc dh
jnz .l2
mov ax,[bufseg]
mov es,ax
xor di,di
mov ds,ax
xor si,si
mov dx,[cs:ys]
.l4
mov cx,[cs:xs]
xor bh,bh
.l3
lodsb
mov bl,al
mov al,[cs:bx+transpalette]
stosb
dec cx
jnz .l3
dec dx
jnz .l4
mov ax,cs
mov ds,ax
mov es,ax
ret

;display "Please wait..." message
displaymessage
mov si,waitmessage
mov di,(99-4)*320+159-(waitmessage.length-1)*4
call display
ret

;the ???fps message
displayfps
mov ax,[new_fps]
mov si,fpsmessage+3
mov cx,4
mov bx,10
.l1
xor dx,dx
div bx
add dl,"0"
mov [si],dl
dec si
dec cx
jnz .l1
mov si,fpsmessage
mov di,(99-4)*320+159-(fpsmessage.length-1)*4
call display
ret

;count of fps
display_max_fps
mov si,fps_string
mov di,191*320+(320-8*8)
call display
ret

make_fps_string
push ds
push si
push dx
push cx
push bx
mov ax,cs
mov ds,ax
mov ax,[max_fps]
mov si,fps_string+4
mov cx,5
mov bx,10
.l1
xor dx,dx
div bx
add dl,"0"
mov [si],dl
dec si
dec cx
jnz .l1
pop bx
pop cx
pop dx
pop si
pop ds
ret

;display, ripped out of my game back; displays text on the screen
display
;push es
;push word 0a000h
;pop es
.l1
push di
lodsb
test al,al
if z
 pop di
; pop es
 ret
endif
xor ah,ah
shl ax,3
push si
mov si,ax
add si,000eh
push word 0ffa6h
pop ds
mov dx,8
.l2
mov cx,8
mov bl,128
lodsb
mov bh,al
.l3
test bh,bl
if nz
 mov al,[cs:lightestcolor]
else
 mov al,[cs:darkestcolor]
endif
stosb
shr bl,1
dec cx
jnz .l3
add di,320-8
dec dx
jnz .l2
push cs
pop ds
pop si
pop di
add di,8
jmp .l1

screentobuffer
mov ax,0a000h
mov ds,ax
mov es,[cs:doublebuffer]
xor si,si
xor di,di
mov cx,16000
rep movsd
ret

; a very simple copy routine
drawtoscreen 
push es
push si
push di
push cx
push ds
push ds
pop es
push cs
pop ds
cmp byte [show_fps],1
if e
 call display_max_fps
endif
;cmp byte [no_frameskip_control],0
;if e
 mov ax,[new_fps]
 cmp [fps],ax
 if ne
  call displayfps
 endif
;endif
pop ds
mov ax,0a000h
mov es,ax
xor si,si
xor di,di
mov cx,16000
rep movsd
pop cx
pop di
pop si
pop es
ret

interpolater
push es
;mov ds,[cs:doublebuffer]
mov es,[cs:secondbuffer]
mov si,321
mov di,321
mov bp,198
.l2
mov cx,318
.l1
call adder
shr eax,2
and eax,00000000001111110011111100111111b
xor bh,bh
mov bl,[si]
shl bx,2
add eax,[cs:bx+efficientpalette]
shr eax,1
and eax,00000000001111110011111100111111b
mov [cs:red],eax
call search
inc si
dec cx
jnz .l1
add di,2
add si,2
dec bp
jnz .l2
;jmp similar

similar
push es
pop ds
pop es
null
;call drawtoscreen
ret

adder
xor bh,bh
mov bl,[si-1]
shl bx,2
mov eax,[cs:bx+efficientpalette]
xor bh,bh
mov bl,[si+1]
shl bx,2
add eax,[cs:bx+efficientpalette]
xor bh,bh
mov bl,[si-320]
shl bx,2
add eax,[cs:bx+efficientpalette]
xor bh,bh
mov bl,[si+320]
shl bx,2
add eax,[cs:bx+efficientpalette]
ret

dragger
push es
;mov ds,[cs:doublebuffer]
mov es,[cs:secondbuffer]
xor si,si
xor di,di
mov cx,64000
.a1
lodsb
cmp al,[cs:darkestcolor]
if ne
 mov [es:di],al
endif
inc di
loop .a1
push ds
pop es
mov ds,[cs:secondbuffer]
;mov es,[cs:doublebuffer]
mov si,321
mov di,321
mov bp,198
.l2
mov cx,318
.l1
call adder
shr eax,2
and eax,00000000001111110011111100111111b
xor bh,bh
mov bl,[es:si]
cmp bl,[cs:darkestcolor]
if ne
 shl bx,2
 mov edx,[cs:bx+efficientpalette]
 add edx,eax
 test edx,00000000011000000110000001100000b
 if z
  mov eax,edx
  shr eax,1
  and eax,00000000001111110011111100111111b
 endif
endif
mov [cs:red],eax
call search
inc si
dec cx
jnz .l1
add di,2
add si,2
dec bp
jz .copy
jmp .l2
.copy
push ds
push es
pop ds
pop es
xor si,si
xor di,di
mov cx,16000
rep movsd
push ds
pop es
jmp similar

;motion blur
motion_blur
push es
;mov ds,[cs:doublebuffer]
mov es,[cs:secondbuffer]
mov si,321
mov di,321
mov bp,198
.l2
mov cx,318
.l1
call adder
shr eax,2
and eax,00000000001111110011111100111111b
xor bh,bh
mov bl,[es:si]
shl bx,2
add eax,[cs:bx+efficientpalette]
shr eax,1
and eax,00000000001111110011111100111111b
mov [cs:red],eax
call search
inc si
dec cx
jnz .l1
add di,2
add si,2
dec bp
jnz .l2
jmp similar

;dissolver
dissolver
push es
;mov ds,[cs:doublebuffer]
mov es,[cs:secondbuffer]
mov si,321
mov di,321
mov bp,198
.l2
mov cx,318
.l1
call adder
shr eax,2
and eax,00000000001111110011111100111111b
mov [cs:red],eax
call search
inc si
dec cx
jnz .l1
add di,2
add si,2
dec bp
jnz .l2
jmp similar

smoother
push es
;mov ds,[cs:doublebuffer]
mov es,[cs:secondbuffer]
mov si,642
mov di,642
mov bp,196
.l2
mov cx,316
.l1
sub si,321
call ugly
mov edx,eax
add si,2
call ugly
add edx,eax
add si,640
call ugly
add edx,eax
sub si,2
call ugly
add edx,eax
mov si,di
call adder
shr eax,1
and eax,00000000011111110111111101111111b
add eax,edx
shr eax,2
and eax,00000000001111110011111100111111b
xor bh,bh
mov bl,[si]
shl bx,2
add eax,[cs:bx+efficientpalette]
shr eax,1
and eax,00000000001111110011111100111111b
mov [cs:red],eax
call search
inc si
dec cx
jnz .l1
add di,4
add si,4
dec bp
jnz .l2
jmp similar

ugly
call adder
shr eax,3
and eax,00000000000111110001111100011111b
ret

gray
push es
push cs
pop es
xor eax,eax
mov di,gray_buffer
mov cx,160*3
rep stosd
mov es,[cs:secondbuffer]
xor si,si
xor di,di
mov dx,200
.l2
mov bp,gray_buffer
mov cx,320
.l1
lodsb
xor bh,bh
mov bl,al
shl bx,2
mov eax,[cs:bx+efficientpalette]
xor bh,bh
mov bl,al
add bx,[cs:bp+2]
cmp bx,0
if l
 mov byte [cs:green],0
else
 cmp bx,63
 if g
  mov byte [cs:green],63
 else
  mov [cs:green],bl
 endif
endif
mov [cs:bp+2],bx
shr eax,8
xor bh,bh
mov bl,al
add bx,[cs:bp]
cmp bx,0
if l
 mov byte [cs:red],0
else
 cmp bx,63
 if g
  mov byte [cs:red],63
 else
  mov [cs:red],bl
 endif
endif
mov [cs:bp],bx
shr eax,8
xor bh,bh
mov bl,al
add bx,[cs:bp+4]
cmp bx,0
if l
 mov byte [cs:blue],0
else
 cmp bx,63
 if g
  mov byte [cs:blue],63
 else
  mov [cs:blue],bl
 endif
endif
mov [cs:bp+4],bx
call short_search
xor bh,bh
mov bl,al
shl bx,2
mov eax,[cs:bx+efficientpalette]
xor bh,bh
mov bl,al
sub bx,[cs:bp+2]
sar bx,3
mov [cs:bp+2],bx
add [cs:bp+8],bx
shr eax,8
xor bh,bh
mov bl,al
sub bx,[cs:bp]
sar bx,3
mov [cs:bp],bx
add [cs:bp+6],bx
shr eax,8
xor bh,bh
mov bl,al
sub bx,[cs:bp+4]
sar bx,3
mov [cs:bp+4],bx
add [cs:bp+10],bx
add bp,6
dec cx
if nz
 jmp .l1
endif
dec dx
if nz
 jmp .l2
endif
jmp similar

gray_no_bleed
push es
mov es,[cs:secondbuffer]
xor si,si
xor di,di
mov dx,200
.l2
mov cx,320
.l1
lodsb
xor bh,bh
mov bl,al
shl bx,2
mov eax,[cs:bx+efficientpalette]
mov [cs:green],al
shr eax,8
mov [cs:red],al
shr eax,8
mov [cs:blue],al
call short_search
dec cx
jnz .l1
dec dx
jnz .l2
jmp similar

scanlines
push ds
mov ds,[cs:bufseg]
mov ax,[cs:ylocator]
mov bx,[cs:xs]
xor dx,dx
mul bx
mov si,[cs:tl]
add si,ax
mov ax,[cs:x1]
mov bx,[cs:x2]
cmp ax,bx
if g
 xchg ax,bx
endif
mov [cs:tx1],ax
mov [cs:tx2],bx
mov ax,[cs:y1]
mov bx,[cs:y2]
cmp ax,bx
if g
 xchg ax,bx
endif
mov [cs:ty1],ax
mov [cs:ty2],bx
mov ax,[cs:rx1]
mov bx,[cs:rx2]
cmp ax,bx
if g
 xchg ax,bx
endif
mov [cs:trx1],ax
mov [cs:trx2],bx
mov ax,[cs:ry1]
mov bx,[cs:ry2]
cmp ax,bx
if g
 xchg ax,bx
endif
mov [cs:try1],ax
mov [cs:try2],bx
mov di,321
mov bp,[cs:ys]
cmp bp,100
if a
 add si,[cs:xlocator]
endif
sub bp,[cs:ylocator]
mov dx,100
mov word [cs:ty],1
push si
.l2
mov word [cs:tx],1
push si
mov bx,160
mov cx,[cs:xs]
cmp cx,160
if b
 sub cx,[cs:xlocator]
 add si,[cs:xlocator]
endif
.l1
mov ax,[cs:tx]
cmp ax,[cs:tx1]
jl .pass1
cmp ax,[cs:tx2]
jg .pass1
mov ax,[cs:ty]
cmp ax,[cs:ty1]
jl .pass1
cmp ax,[cs:ty2]
jg .pass1
jmp .fail
.pass1
mov ax,[cs:tx]
cmp ax,[cs:trx1]
jl .clear
cmp ax,[cs:trx2]
jg .clear
mov ax,[cs:ty]
cmp ax,[cs:try1]
jl .clear
cmp ax,[cs:try2]
jg .clear
jmp .fail
.clear
movsb
inc di
jmp .skip
.fail
inc si
add di,2
.skip
add word [cs:tx],2
dec cx
if z
 mov cx,[cs:xs]
 pop si
 push si
endif
dec bx
jnz .l1
add word [cs:ty],2
pop si
add di,320
add si,[cs:xs]
dec bp
if z
 mov bp,[cs:ys]
 mov si,[cs:tl]
 cmp bp,100
 if a
  add si,[cs:xlocator]
 endif
endif
dec dx
if nz
 jmp .l2
endif
pop si
mov ax,[cs:xlocator]
add ax,[cs:zlocator]
cmp word [cs:xs],160
if a
 add ax,160
endif
cmp ax,[cs:xs]
if ae
 mov word [cs:zlocator],-1
 dec ax
endif
cmp word [cs:xs],160
if a
 sub ax,160
endif
test ax,ax
if le
 mov word [cs:zlocator],1
endif
mov [cs:xlocator],ax
mov ax,[cs:ylocator]
add ax,[cs:wlocator]
cmp word [cs:ys],100
if a
 add ax,100
endif
cmp ax,[cs:ys]
if ae
 mov word [cs:wlocator],-1
 dec ax
endif
cmp word [cs:ys],100
if a
 sub ax,100
endif
test ax,ax
if le
 mov word [cs:wlocator],1
endif
mov [cs:ylocator],ax
pop ds
ret

;and a bad water effect
water
push es
;mov ds,[cs:doublebuffer]
mov es,[cs:secondbuffer]
mov si,321
mov di,321
mov bp,198
.l2
mov cx,318
.l1
call adder
shr eax,2
and eax,00000000001111110011111100111111b
xor bh,bh
mov bl,[si]
shl bx,2
mov ebx,[cs:bx+efficientpalette]
mov edx,eax
call positive
call positive
call positive
ror edx,9
;ror ebx,8
and edx,00000000000111110001111100011111b
xor eax,edx
mov [cs:red],eax
call search
inc si
dec cx
jnz .l1
add di,2
add si,2
dec bp
jnz .l2
jmp similar

positive
sub dl,bl
if s
 neg dl
endif
ror edx,8
ror ebx,8
ret

clear ; clear the double buffer (es = double buffer segment)
cld
mov al,[darkestcolor]
mov ah,al
mov bx,ax
shl eax,16
mov ax,bx
xor di,di
mov cx,16000
rep stosd
ret

draw_boxes
;mov al,[drawalpha]
;push ax
;xor al,al
;mov byte [drawalpha],0
call stretch ;draw the box
;pop ax
;mov [drawalpha],al
call switch
call stretch ;draw the box
call switch
ret

move_boxes
cld
call compare ;move the box
call switch ;exchange box1 and box2 coordinates
call compare ;move the box
call switch ;exchange box1 and box2 coordinates
ret

switch ; switch rx1 with x1, ry1 with y1, etc
push es
push cs
pop es
mov si,x1
mov di,bufferspace
mov cx,8
rep movsw
;.l1
;lodsw
;push ax
;loop .l1
mov si,rx1
mov di,x1
mov cx,8
rep movsw
mov si,bufferspace
mov di,rx1
mov cx,8
rep movsw
;std
;mov di,rv2
;mov cx,8
;.l2
;pop ax
;stosw
;loop .l2
pop es
ret

compare
mov si,x1
mov bl,[skiprate]
mov dx,319
mov cx,4
.l1
mov ax,[si+8] ;si+8 = z1
imul bl
mov di,[si] ; si = x1

add di,ax
test di,di
if le
 mov word [si+8],movementsize
; xor di,di
 mov word [si],0
 jmp .l2
else
 cmp di,dx
 if ae
  mov word [si+8],-movementsize
  mov [si],dx
;  mov di,dx
 jmp .l2
 endif
endif
mov [si],di
.l2
add si,2
xor dx,504 ; dx = the "upper" bound (the right/bottom of the screen)
           ; xor dx,504 gives 199 -> 319 or 319 -> 199
dec cx
jnz .l1
ret


stretch ; this stretches the image at offset tl to the x1,x2,y1,y2 coordinates
        ; note: tl equ stretch.tl, and is therefore unwittenly directly set by
        ; all accesses to tl.
cld
mov si,[tl]
cmp byte [draws],0
if ne
 cmp byte [drawalpha],1
 if e
  mov gs,[alphapalette]
 endif
 cmp byte [drawheight],1
 if e
  mov gs,[intensity]
 endif
endif
mov di,[y1]
mov ax,di
shl di,8
shl ax,6
add di,ax
add di,[x1] ;find one corner

;;Warning - Ugly code. I know it works, though. :)

mov dx,320
mov bp,[y2]
mov ax,[x2]
sub bp,[y1]
if s
 neg bp
 mov dx,-320
else
 if z
  ret
 endif
endif
sub ax,[x1]
if s
 neg ax
 add dx,ax
 std
else
 if z
  ret
 endif
 sub dx,ax
endif
;mov [value],dx
; eax = [ value  ] [   ??   ]
; ebx = [   ??   ] [ deltax ]
; ecx = [   xs   ] [   ??   ]
; edx = [   ys   ] [   ??   ]
; esi = [ deltay ] [   si   ]
; edi = [   bp   ] [   di   ]
; ebp = [   xs   ] [   bp   ]
mov bx,ax
ror esi,16
ror edx,16
mov si,bp
mov dx,[ys]
ror edi,16
mov di,bp
mov eax,edx
ror ebp,16
ror edx,16
mov bp,[xs]
mov cx,bp
ror edi,16
ror ecx,16
mov fs,[bufseg]
mov ax,es
mov ds,ax
cmp byte [cs:draws],0
if ne
 cmp byte [cs:drawheight],1
 if e
  mov ds,[cs:heightmap]
 endif
endif
.l1
ror esi,16
push si
mov cx,bx
mov dx,bx
.a2
mov al,[fs:si]
mov ah,al
.l2
cmp byte [cs:draws],0
if ne
 ror ebx,16
 mov bh,[ds:di]
 mov bl,ah
 cmp byte [cs:draws],1
 if ne
  mov gs,[cs:intensity]
  mov bl,[gs:bx]
  mov gs,[cs:alphapalette]
  mov bh,[es:di]
 endif
 mov al,[gs:bx]
 ror ebx,16
endif
stosb
sub dx,bp
if g
 dec cx
 jnz .l2
else
 .l3
 inc si
 add dx,bx
 jle .l3
 dec cx
 jnz .a2
endif
pop si
ror eax,16
ror ebp,16
ror edx,16
add di,ax
sub bp,dx
if le
 ror ecx,16
 ror edi,16
 .l4
 add si,cx
 add bp,di
 jle .l4
 ror ecx,16
 ror edi,16
endif
ror eax,16
ror ebp,16
ror edx,16
ror esi,16
dec si
jz .done
jmp .l1
.done
push cs
pop ds
cld
ret

;;Ignore this section

;blank
;mov ax,[x2]
;sub ax,[x1]
;cmp ax,0
;if l
; neg ax
; mov dx,[x2]
;else
; mov dx,[x1]
;endif
;inc ax
;mov bx,ax
;mov di,[y1]
;imul di,320
;add di,dx
;mov ax,0
;mov cx,bx
;shr cx,1
;if c
; stosb
;endif
;rep stosw
;mov di,[y2]
;imul di,320
;add di,dx
;mov cx,bx
;shr cx,1
;if c
; stosb
;endif
;rep stosw
;mov bx,[y2]
;sub bx,[y1]
;cmp bx,0
;if l
; neg bx
; mov dx,[y2]
;else
; mov dx,[y1]
;endif
;imul dx,320
;inc bx
;mov di,dx
;add di,[x1]
;mov cx,bx
;.l1
;stosb
;add di,319
;loop .l1
;mov di,dx
;add di,[x2]
;mov cx,bx
;.l2
;stosb
;add di,319
;loop .l2
;ret

;; ^- Old code I don't want to throw away, yet..

loadpcx ; this loads the pcx file
;mov dx,file
mov ax,3d00h
int 21h
if c ; a file?
 mov ax,3h
 int 10h
 mov ah,9
; mov dx,file ;filename
 int 21h
 mov dx,notfound ;"not found."
 int 21h
 mov ax,4c00h
 int 21h
endif
mov bx,ax
mov [handle],ax
mov dx,temp
mov cx,2
mov ah,3fh
int 21h
;Verifies it is in fact a pcx file by checking its header a bit..
;if it's not, then it'll just use the default image (dia, at the top)
cmp word [temp],050ah
if ne
 ret
endif
mov dx,temp
mov cx,2
mov ah,3fh
int 21h
cmp word [temp],0801h
if ne
 ret
endif
call getsize ; get size of image
call pal ; load palette
;allocate file reader buffer
mov bx,1024 ; setup the file reader buffer
mov di,lackmemory.buffer
call create_segment
push ax
mov bx,[handle] ;and this part actually decodes the pcx file
mov ax,4200h
xor cx,cx
mov dx,128
int 21h
pop ds
cld
mov si,16384
call checkload
mov es,[cs:bufseg]
xor di,di
.l2
lodsb
call checkload
cmp al,192
if b
 stosb
else
 sub al,192
 mov cl,al
 lodsb
 call checkload
 rep stosb
endif
cmp di,[cs:total]
jb .l2
push ds
pop es
mov ah,49h
int 21h
push cs
push cs
pop ds
pop es
mov bx,[handle]
mov ah,3eh
int 21h
mov word [tl],0
ret

; resets si to 0 if si is at the end of the buffer..then loads in a new
; buffer worth of data from the file

checkload
cmp si,16384
if e
 push ax
 push cx
 mov bx,[cs:handle]
 mov cx,16384
 xor dx,dx
 mov ah,3fh
 int 21h
 pop cx
 pop ax
 xor si,si
endif
ret

;no longer used code..was my way of avoiding putting out error messages.
;basically, if you put in something wrong, it'd use the default

;leaves
;mov ax,cs
;mov ds,ax
;mov [bufseg],ax
;mov byte [palon],0
;mov word [xs],7
;mov word [ys],7
;mov word [x1],0
;mov word [y1],0
;mov word [x2],319
;mov word [y2],199
;mov sp,stack.end
;jmp leaveto

getsize ;gets size of image
mov bx,[handle]
mov ax,4200h
xor cx,cx
mov dx,4
int 21h
mov dx,bufferspace
mov cx,8
mov ah,3fh
int 21h
mov ax,[bufferspace+6]
sub ax,[bufferspace+2]
inc ax
mov [ys],ax
push ax
mov bx,[handle]
mov ax,4200h
xor cx,cx
mov dx,66
int 21h
mov dx,xs
mov cx,2
mov ah,3fh
int 21h
pop ax
mov bx,[xs]
mul bx
;did the multipcation cause a carry flag? Too big of an image (over 64K)
if c
 mov dx,lackmemory
 mov ah,9
 int 21h
 mov dx,lackmemory.imagetoolarge
 int 21h
 mov ax,4c00h
 int 21h
endif
mov [total],ax
shr ax,4
inc ax
;allocate image segment
mov bx,ax
mov di,lackmemory.image
call create_segment
mov [bufseg],ax
cmp byte [draws],0
if ne
 cmp byte [drawheight],1
 if e
  ret
 endif
endif
;now lets center the image
mov ax,[ys]
shr ax,1
mov bx,100
sub bx,ax
if s
 xor bx,bx
endif
mov [y1],bx
add ax,100
cmp ax,199
if a
 mov ax,199
endif
mov [y2],ax
mov ax,[xs]
shr ax,1
mov bx,160
sub bx,ax
if s
 xor bx,bx
endif
mov [x1],bx
add ax,160
cmp ax,319
if a
 mov ax,319
endif
mov [x2],ax
ret

pal ;pretty straight forward palette loading from the pcx file
mov bx,[handle]
mov cx,-1
mov dx,-768
mov ax,4202h
int 21h
mov dx,palette
mov cx,768
mov ah,3fh
int 21h
clc
mov si,palette
mov di,palette
mov cx,768
.l1
lodsb
shr al,2
stosb
loop .l1
ret

showpal ;and this actually loads the palette
cld
mov dx,3c8h
xor al,al
out dx,al
inc dx
cmp byte [interpolate],8
if ge
 mov si,gray_palette
 mov cx,16*3
else
 mov si,palette
 mov cx,768
endif
rep outsb
ret

command ; this gets the comspec env label's contents
mov byte [path],0
mov word [tcs],cs
mov ds,[2ch]
xor si,si
.s1
cmp word [ds:si],0000
je .s2
mov di,env
mov cx,8
rep cmpsb
test cx,cx
jnz .s1
mov di,path
.s3
lodsb
stosb
test al,al
jnz .s3
.s2
push cs
pop ds
ret

getorg ;get original drive/directory, to return to when shell is done
mov ah,19h
int 21h
mov [org_drv],al
mov dl,al
inc dl
mov byte [org_dir],'\'
mov si,org_dir+1
mov ah,47h
int 21h
ret

;tries to do a DOS shell (well, assumedly)
shell
cmp byte [cs:path],0
if e
 ret
endif
mov ax,0003h
int 10h
push cs
push cs
pop ds
pop es
mov dx,exit
mov ah,9
int 21h
mov dx,path
mov bx,parms
mov ax,4b00h
mov [savss],ss
mov [savsp],sp
int 21h
mov ss,[savss]
mov sp,[savsp]
push cs
pop ds
mov dl,[org_drv]
mov ah,0eh
int 21h
mov dx,org_dir
mov ah,3bh
int 21h
ret

; a pretty simpler command line parser..
; count the "-"s in bl..when there's a space seperater, bl goes to zero
; when bl = 1, actually attempt to check for options
; when bl = 0, and it's not a space, copy the data to the filename buffer
; if the filename buffer isn't empty, make sure there's a .pcx at the end
; along with a nul char for opening the file plus a "$" in case we have to
; print it cause it doesn't exist (and the nul char acts as a space, in that
; case, to boot)

checkcommandline
xor ch,ch
mov cl,[80h]
test cl,cl
if z
 ret
endif
cld
mov si,81h
mov di,file
mov bp,file2
xor bx,bx
.l1
lodsb
cmp al," "
if e
 xor bx,bx
else
 test bh,bh
 if z
  cmp bl,2
  if e
   mov [bp],al
   inc bp
  else
   cmp al,"-"
   if e
    inc bl
   else
    cmp bl,1
    if e
     or al,32
     call find_interpolater
     cmp al,"n"
     if e
      mov byte [no_frameskip_control],1
     endif
     cmp al,"f"
     if e
      mov byte [show_fps],1
     endif
     cmp al,"s"
     if e
      mov byte [shellon],1
     endif
     cmp al,"m"
     if e
      mov byte [moveheight],1
     endif
     cmp al,"a"
     if e
      mov byte [drawalpha],1
     endif
     cmp al,"h"
     if e
      mov byte [drawheight],1
     endif
     cmp al,"b"
     if e
      mov byte [basicimage],1
     endif
    endif
   endif
  endif
 endif
 test bl,bl
 if z
  stosb
  inc bh
 endif
endif
loop .l1
cmp byte [drawheight],0
if e
 mov byte [moveheight],0
endif
mov al,[drawheight]
add al,[drawalpha]
mov [draws],al
mov ax,file
call terminate
mov di,bp
mov ax,file2
call terminate
cmp byte [drawalpha],1
if e
 mov byte [numbermode],"a"
else
 cmp byte [alterinprogram],1
 if e
  mov byte [numbermode],"o"
 else
  cmp byte [drawheight],1
  if e
   mov byte [numbermode],"h"
  endif
 endif
endif
ret

terminate
cmp di,ax
if ne
 cmp word [di-4],".p"
 je .h2
 mov si,pcx
 mov cx,2
 rep movsw
 .h2
 xor al,al
 stosb
 mov al,"$"
 stosb
endif 
ret

find_interpolater
cmp al,"o"
if e
 cmp cx,1
 if a
  mov dl,[si]
  sub dl,"0"
  cmp dl,0
  jl .ignore
  cmp dl,interpolater_count
  jg .ignore
  inc si
  dec cx
  mov byte [alterinprogram],1
  cmp byte [si-2],"o"
  if e
   mov [secondinterpolate],dl
  else
   mov [interpolate],dl
  endif
 endif
endif
.ignore
ret

;this is an 8-bit alpha blender, using a "method" to join the lower color(ah)
;and the upper color(al)..the search procedure does the actual searching

calculatealphapalette
cld
push es
mov es,[alphapalette]
mov si,[method]
shl si,1
mov ax,[si+layermethods]
mov [cs:methodaddress],ax ; basically, [methodaddress] = [layermethod+[method]*2]
xor di,di
mov bx,palette ;And the search begin
.l1
mov si,palette
.l2
push bx
call layerfix ; This is where the considerations of mixing begin
mov [red],al
inc bx
call layerfix
mov [green],al
inc bx
call layerfix
mov [blue],al
call search ; find the closest color
pop bx
cmp si,palette+256*3
jb .l2
add bx,3
cmp bx,palette+256*3
jb .l1
pop es
ret

layerfix
lodsb
mov ah,[bx]
call [methodaddress]
ret

; ah = bottom layer, al = top layer..for this program, that means
; ah = what is already on the screen, al = what is about to be drawn on
; ah/al vary from 0 to 63
; al is what contains the result; dx is usable

;This is the most simple blender mixing the top layer (al) with the bottom
;layer (ah), giving each an equal share.

;(It may be important to note that this is a 6-byte based routine doing
;color effects on red, green, and blue seperately)

number0
add al,ah
shr al,1
ret

;This more advanced blender attempts to keep colors from going darker than
;the bottom layer. It in general gives a better effect.

number1
cmp ah,al
if a
 add al,ah
 shr al,1
endif
ret

;From here on down to number 9 are a collection of other effects.

;number2 just picks the brighter color as the color to show

number2
cmp ah,al
if a
 mov al,ah
endif
ret

;number3 picks the darker color, so long as it isn't black

number3
cmp al,ah
if a
 test ah,ah
 if nz
  mov al,ah
 endif
endif
ret

;number4 brightens the darker color and darkens the brighter color,
;then combines them

number4
cmp al,ah
if a
 shr al,1
 shl ah,1
else
 shr ah,1
 shl al,1
endif
add al,ah
ret

;number5 is an ok alpha blender

number5
or al,ah
ret

;number6 filters each color then combines them

number6
and al,00101010b
and ah,00010101b
or al,ah
ret

;number7 applies another filter that removes the brightest bit

number7
and al,00011111b
and ah,00011111b
add al,ah
ret

;number8 only shows the contents of one box, when they pass each other

number8
mov dl,al
and dl,ah
and al,010101010b
and ah,001010101b
or al,ah
add al,dl
cmp al,63
if a
 mov al,63
endif
;xor ah,00111111b
;or al,ah
ret

;number9 is yet another attempt at an alpha blender

number9
push bx
xor bh,bh
mov bl,al
shl bx,1
mov dx,[cs:bx+squares_table]
xor bh,bh
mov bl,ah
shl bx,1
add dx,[cs:bx+squares_table]
xor al,al
mov bx,1
.l2
sub dx,bx
js .skip
inc al
add bx,2
cmp al,63
jne .l2
.skip
pop bx
ret
;shr ah,1
;add al,ah
;cmp al,63
;if a
; mov al,63
;endif
;ret

;and this uses a simple formula to find which color is closest..basically:
;f(x) = (palette_red[x]-this_red)^2+(palette_green[x]-this_green)^2+(palette_blue[x]-this_blue)^2
;bp = the smallest f(x) for x from 0 to 255
;dl = the actual x so far that gives the smallest f(x)
search_without_cache
push ds
push si
push cs
pop ds
mov si,palette
xor cx,cx
xor bh,bh
xor dx,dx
mov bp,65535
.l1
mov bl,[si]
;cmp bl,[darkest_allowed.red]
;if l
; add si,3
; jmp .not_allowed
;endif
;cmp bl,[brightest_allowed.red]
;if g
; add si,3
; jmp .not_allowed
;endif
sub bl,[red]
if s
 neg bl
endif
inc si
shl bl,1
mov ax,[bx+squares_table]
mov bl,[si]
;cmp bl,[darkest_allowed.green]
;if l
; add si,2
; jmp .not_allowed
;endif
;cmp bl,[brightest_allowed.green]
;if g
; add si,2
; jmp .not_allowed
;endif
sub bl,[green]
if s
 neg bl
endif
inc si
shl bl,1
add ax,[bx+squares_table]
mov bl,[si]
;cmp bl,[darkest_allowed.blue]
;if l
; inc si
; jmp .not_allowed
;endif
;cmp bl,[brightest_allowed.blue]
;if g
; inc si
; jmp .not_allowed
;endif
sub bl,[blue]
if s
 neg bl
endif
inc si
shl bl,1
add ax,[bx+squares_table]
cmp ax,bp
if b
 mov bp,ax
 mov dl,cl
 cmp bp,0
 je .skip
endif
.not_allowed
inc cx
cmp cx,256
jnb .skip
jmp .l1
.skip
mov al,dl
stosb
pop si
pop ds
ret

short_search
push ds
push dx
push cx
push bp
push si
push cs
pop ds
mov si,gray_palette
xor cx,cx
xor bh,bh
xor dx,dx
mov bp,65535
.l1
mov bl,[si]
sub bl,[red]
if s
 neg bl
endif
inc si
shl bl,1
mov ax,[bx+squares_table]
mov bl,[si]
sub bl,[green]
if s
 neg bl
endif
inc si
shl bl,1
add ax,[bx+squares_table]
mov bl,[si]
sub bl,[blue]
if s
 neg bl
endif
inc si
shl bl,1
add ax,[bx+squares_table]
cmp ax,bp
if b
 mov bp,ax
 mov dl,cl
 cmp bp,0
 je .skip
endif
inc cx
cmp cx,16
jb .l1
.skip
mov al,dl
stosb
pop si
pop bp
pop cx
pop dx
pop ds
ret

search
push ds
push si
mov ds,[cs:transbuffer]
mov eax,[cs:red]
rol eax,16
xor bh,bh
mov bl,al
shl bx,5
and bx,0000011111000000b
rol eax,8
add bl,al
shl bx,5
and bx,01111111111000000b
rol eax,8
add bl,al
shr bx,1
mov si,bx
movsb
pop si
pop ds
ret

;;ask the vga registers for the palette (used by the default image which
;;doesn't have a stored palette but uses the vga's standard palette instead)
;getpalette
;cld
;mov dx,3c7h
;xor al,al
;out dx,al
;mov dx,3c9h
;mov di,palette
;mov cx,768
;rep insb
;ret

copypal
cld
mov si,defpal
mov di,palette
mov cx,768/4
rep movsd
ret

;This sets the timer speed, then introduces the new timer.
timer
call settimer
;store old timer address
mov ax,3508h
int 21h
mov [cs:timoff],bx
mov [cs:timseg],es
;set new timer address
mov dx,cs
mov ds,dx
mov dx,counter
mov ax,2508h
int 21h
ret

;and this sets the timer speed
settimer
push ax
push bx
push dx
mov al,36h
out 43h,al
;rewrite from a fixed frame rate. Here goes the idea.
;the normal timer goes at 18.2 ticks/sec. To set the timer, one
;simply adjusts the number of ticks/sec. 65536*18.2=max timer speed
;65536/(fps/18.2) gives the right timer speed, as we want to update
;the time every 1/18.2 of a second. Anyways, I use interpolation to
;remove the need for fractions.
;To give an example, at 30fps, we call the timer 30/18.2 times per second
;That gives us 150/91, as a rational number. So, 65536/(150/91) =
;65535*91/150. But, in assembly, dx:ax is one 32-bit number (for use with
;the div instruction. Now, dx:ax*num for dx:ax=65536 is dx=1, ax=0. So,
;dx=num causes dx:ax*91. So, we need to divide by 150. Notice, though,
;that we only have fps (30)..and 30*5=150. In fact, fps*5 always works
;(execpt when fps is less than 18.2..but that story is further down)
;So, that's what is done to get the denominator of 150 (not that it matters
;to treat it as a fraction once it's as integers)
xor dx,dx
mov bx,5
mov ax,[cs:fps]
mul bx
mov bx,ax
mov [cs:den],ax
mov dx,num
xor ax,ax
;Now, here's the special case. For divide to work, dx:ax/bx must make
;ax=quotient, dx=remainder. But, if ax can't hold the quotient, then an
;int 0h is triggered (divide overflow). But wait! For dx:ax/bx to generate
;a number over 65535, dx*65536/bx = dx/bx*65536, so dx/bx must be 1 or
;greater. But, that just means dx>=bx, so if bx>dx, then we're okay.
;Otherwise, from above, ax=0 (which is the timer's way of interpretting
;65536, since 65536 doesn't fit in a 16-bit register.
cmp bx,dx
if a
 div bx
endif
;And then pass ax in parts
out 40h,al
mov al,ah
out 40h,al
pop dx
pop bx
pop ax
ret

counter
push ax
;Okay, the counter was called. Lets count how many times.
inc byte [cs:pass]
dec word [cs:fps_to_go]
if z
; cmp byte [cs:no_frameskip_control],1
; if e
;  mov ax,[cs:max_fps]
;  shl ax,1
;  mov [cs:new_fps],ax
; endif
 mov ax,[cs:fps]
 cmp [cs:new_fps],ax
 if ne
  mov ax,[cs:new_fps]
  mov [cs:fps],ax
  call settimer
 endif
 mov [cs:fps_to_go],ax
 cmp byte [cs:show_fps],1
 if e
  call make_fps_string
  mov word [cs:max_fps],0
 endif
endif
;count = num+num+...
;For the example of 36.4fps, num=1, den=2
;First time, count=1
;Second time, count=2
;but count>=den, so count=count-2..count=0
;and we call the timer. And you'll notice the timer is then held accurate.
;Note: It's obviously I cheated in this example, as you can't use
;non-integers in the program, but using 30fps would take 30*5 loops to work
;out correctly so that count=0, again (91/150*150=91). But, the same
;principle is used in all forms of linearly interpolation, so it still works
;consistently here.
sub word [cs:count],num
if le
 mov ax,[cs:den]
 add word [cs:count],ax
 pop ax
 jmp far [cs:timoff]
else
 mov al,20h
 out 20h,al
 pop ax
 iret
endif

return
;reset timer to default
mov al,36h
out 43h,al
xor al,al
out 40h,al
out 40h,al
mov ds,[cs:timseg]
mov dx,[cs:timoff]
mov ax,2508h
int 21h
ret
