

ppmquant(1)                Unix Programmer's Manual                ppmquant(1)


NAME
     ppmquant - quantize the colors in a portable pixmap down to  a  specified
     number

SYNOPSIS
     ppmquant [-floyd|-fs] ncolors [ppmfile]
                           -------  -------
     ppmquant [-floyd|-fs] -map mapfile [ppmfile]
                                -------  -------

DESCRIPTION
     Reads a portable  pixmap  as  input.   Chooses  ncolors  colors  to  best
                                                     -------
     represent the image, maps the existing colors to the new ones, and writes
     a portable pixmap as output.

     The quantization method is Heckbert's "median cut".

     Alternately, you can skip the color-choosing step by specifying your  own
     set of colors with the -map flag.  The mapfile is just a ppm file; it can
                                            -------           ---
     be any shape, all that matters is the colors in  it.   For  instance,  to
     quantize down to the 8-color IBM TTL color set, you might use:
         P3
         8 1
         255
           0   0   0
         255   0   0
           0 255   0
           0   0 255
         255 255   0
         255   0 255
           0 255 255
         255 255 255
     If you want to quantize one pixmap to use the colors in another one, just
     use  the  second one as the mapfile.  You don't have to reduce it down to
     only one pixel of each color, just use it as is.

     The -floyd/-fs flag  enables  a  Floyd-Steinberg  error  diffusion  step.
     Floyd-Steinberg   gives   vastly  better  results  on  images  where  the
     unmodified quantization has banding or other artifacts,  especially  when
     going to a small number of colors such as the above IBM set.  However, it
     does take substantially more CPU time, so the default is off.

     All flags can be abbreviated to their shortest unique prefix.

REFERENCES
     "Color Image Quantization for Frame Buffer  Display"  by  Paul  Heckbert,
     SIGGRAPH '82 Proceedings, page 297.

SEE ALSO
     ppmquantall(1), pnmdepth(1), ppmdither(1), ppm(5)

AUTHOR
     Copyright (C) 1989, 1991 by Jef Poskanzer.







                               12 January 1991                               1

