/*******************************************
 ***                 FRACT3              ***
 ***                --------             ***
 ***     A fractal picture generator     ***
 ***                                     ***
 ***         Programming by BSv          ***
 ***     Mathematics by Per Spongeus     ***
 ***>>>>>>>>>>>>>>>>>><<<<<<<<<<<<<<<<<<<***
 ***   BSv:  bengt.svensson@hhj.hj.se    ***
 ***          http://pcbsv.hhj.hj.se     ***
 ***                                     ***
 ***   Per:  per@isy.liu.se              ***
 ***-------------------------------------***
 ***                                     ***
 ***      This program is Freeware       ***
 ***         No Copyrights 1995          ***
 ***                                     ***
 *** Please leave this remark untouched! ***
 *******************************************/

#include <stdio.h>
#include <conio.h>
#include <math.h>
#include <graph.h>

struct complex cadd(struct complex a, struct complex b)
{
	struct complex r;
	r.x=a.x+b.x;
	r.y=a.y+b.y;
	return(r);
}

struct complex cmult(struct complex a, struct complex b)
{
	struct complex r;
	r.x=a.x*b.x-a.y*b.y;
	r.y=a.x*b.y+a.y*b.x;
	return(r);
}

struct complex cpow(struct complex z, int pow)
{
	struct complex r;
	int t;
	r.x=1;
	r.y=0;
	for (t=1;t<=pow;t++)
		r=cmult(r,z);
	return(r);
}

struct complex ckonj(struct complex z)
{
	struct complex r;
	r.x=z.x;
	r.y=-z.y;
	return(r);
}

struct complex cdiv(struct complex a, struct complex b)
{
	struct complex r;
	double buff;
	r=cmult(a,ckonj(b));
	buff=(double)(cabs(cmult(b,ckonj(b))));
	r.x=(double)(r.x)/(double)(buff);
	r.y=(double)(r.y)/(double)(buff);
	return(r);
}

struct complex cexp(struct complex z)
{
	struct complex r;
	r.x=exp(z.x)*cos(z.y);
	r.y=exp(z.x)*sin(z.y);
	return(r);
}

struct complex cneg(struct complex a)
{
		a.x=-1*a.x;
		a.y=-1*a.y;
		return(a);
}

struct complex g(struct complex z)
{
	struct complex r,a,b;
	a.x=4;a.y=4;
	b.x=0;b.y=-6;
	r=cdiv(cadd(cpow(z,3),cneg(a)),cexp(z));
	//r=cdiv(a,b);
	return(r);
}

main()
{
	struct complex z;
	struct videoconfig vc;
	int x,y,divergent,ggr,xpp,ypp;
	short col;
	double fel,k=1.35;
	FILE *fil;
	printf("\n\n\n");       
	printf("     Welcome to Fract3\n");
	printf("    -------------------\n");
	printf("  (NC) No Copyrights 1995\n");
	printf("     Programming by BSV\n\n");   
	printf("Input x++: ");scanf("%d",&xpp);
	printf("Input y++: ");scanf("%d",&ypp);
	printf("Input k:   ");scanf("%f",&k);
	_setvideomode(_MAXRESMODE);
	_getvideoconfig(&vc);
	_clearscreen(_GVIEWPORT);
	for(y=1;y<=479;y+=ypp)
		 {
		 for(x=1;x<=639;x+=xpp)
		 {
	z.x=(double)(x-350)/165;z.y=(double)(y-400)/165;
	divergent=0;
	ggr=0;
	do
	{
			z=g(z);
			if(cabs(z)>75) divergent=1;
			ggr++;
	}
	while(ggr<1 && divergent==0);
	if (divergent==0) fel=cabs(cadd(z,cneg(g(z))));
	if(kbhit()) {fclose(fil);_setvideomode(_TEXTC80);exit(0);}
			 if(fel<k*0.2)
		 col=1;
	else if(fel<k*0.5)
		 col=2;
	else if(fel<k*0.8)
		 col=3;
	else if(fel<k*1)
		 col=4;
	else if(fel<k*1.5)
		 col=5;
	else if(fel<k*2)
		 col=6;
	else if(fel<k*2.5)
		 col=7;
	else if(fel<k*4)
		 col=8;
	else if(fel<k*6)
		 col=9;
	else if(fel<k*8)
		 col=10;
	else if(fel<k*10)
		 col=11;
	else if(fel<k*15)
		 col=12;
	else if(fel<k*20)
		 col=13;
	else if(fel<k*30)
		 col=14;
	else if(fel<k*50)
		 col=15;
	else
		 col=0 ;
	_setcolor(col);
	_setpixel(x,y);
		 }
		}
	getch();_setvideomode(_TEXTC80);
}
