/*
    Copyright (C) 1996,99  Marian Krivos
        nezmar@internet.alcatel.sk

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    file2asm.c - file compiler

    Modified by: Alain Rouge
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>
//#include <conio.h>
#ifdef __DJGPP__
#include <io.h>
#endif
#include <unistd.h>
#include <ctype.h>

 int stricmp(const char  *s1, const char *s2)
 {
  while	(tolower(*s1) == tolower(*s2))
  {
	if (*s1	== 0)
	  return 0;
	s1++;
	s2++;
  }
  return (int)tolower(*s1) - (int)tolower(*s2);
 }

#ifdef __linux__
long	filelength(char *name)
{
    struct stat status;
    if (stat(name, &status)==-1) return 0;
    return status.st_size;
}
#endif

int main(int argc, char **argv)
{
	FILE *in,*out;
    long  sz, data[8];
    char s[50], *p=argv[1], name[50];
    int i=0, j, wasm=0 ;


   if (argc < 2)
   {
   printf("\nusage: 'file2asm filename[.ext]' [-wasm] to produce filename.asm\n");
   return 1;
   }

   if (argc == 3) if (!strcmp(argv[1],"-wasm") || !strcmp(argv[2],"-wasm")) wasm = 1;

   for(;;)
	{
      if ( (*p == '.') || (*p == '\0') ) break;
      s[i] = *p++;
      if (!(s[i]=='.' || s[i]=='\\')) i++;
	}

   s[i] = 0;
   strcpy(name,s);
	
   if (wasm)
       strcpy(s+i,".asm");
      else
       strcpy(s+i,".nsm");

   in  = fopen(argv[1], "rb");
   out = fopen(s      , "w");

   if (in==NULL || out==NULL) return 3;

#ifndef __linux__
   sz = filelength(fileno(in));
#else   
   sz = filelength(argv[1]);
#endif   
   if (sz<1) return -1; // error

   printf("process file %s %ld bytes ... ", argv[1], sz);
   fflush(stdout);

   if (wasm)
    {
   fprintf(out,
   "; generated by FILE2ASM ver 1.0\n;\n.MODEL small,C\n\tassume nothing\n\tglobal _%s : near\nDATA\tsegment word public 'DATA'\n_%s:\n\tDD\t%ld\n"
   ,name,name,sz);
    }
    else
    {
   fprintf(out,
   "; generated by FILE2ASM ver 1.0\n;\nsection .data\n\tglobal _%s\n_%s:\n\tDD\t%ld\n"
   ,name,name,sz);
    }

   j = sz % (4*8);
   i = sz / (4*8);

   for(;i;i--)
   {
   fread(data,8,4,in);
   fprintf(out,"\tDD\t0x%lx, 0x%lx, 0x%lx, 0x%lx, 0x%lx, 0x%lx, 0x%lx, 0x%lx\n",
            data[0],data[1],data[2],data[3],data[4],data[5],data[6],data[7]);
   }

   for(;j;j--)
   {
   fread(data,1,1,in);
   fprintf(out,"\tDB\t0x%x\n",(unsigned char)data[0]);
   }

   if (wasm)
    fprintf(out,"\nDATA\tENDS\n\n\tend\n");
   else
    fprintf(out,"\n\tend\n");

   printf("%s done.\n", s);
   fflush(stdout);

   fclose(in);
   fclose(out);
   return 0;
}


