/*
    Copyright (C) 1996,99  Marian Krivos
    nezmar@internet.alcatel.sk

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

	fastgl.h   - declarations of many objects for FastGL 

*/
#ifndef	__WINDOW_H
#define	__WINDOW_H

#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>

#ifdef __QNX__
#include <signal.h>
#include <process.h>
#include <sys/mouse.h>
#include <sys/dev.h>
#include <sys/proxy.h>
#include <sys/kernel.h>	
#include <unistd.h>	
#endif

#include "base.h"

#define	TRUE   1
#define	FALSE  0

#ifndef	M_PI
#define	M_PI	3.1415926
#endif

#ifdef __MSDOS__
#define	F01		315
#define	F02		316
#define	F03		317
#define	F04		318
#define	F05		319
#define	F06		320
#define	F07		321
#define	F08		322
#define	F09		323
#define	F10		324
#define	F11		389
#define	F12		390
#define	HOME	0x247
#define	END		0x24f
#define	CR		0x0d
#define	ESC		0x1b
#define	BACKSP	0x08
#define	KLEFT	0x24b
#define	KUP		0x248
#define	KDOWN	0x250
#define	KRIGHT	0x24d
#define	DEL		0x253
#define	INSERT	0x252
#define	PGUP	0x249
#define	PGDOWN	0x251
#define	TAB		  9
#define	LF		 10
#define	ALT_X	0x12d
#define	CTRL_TAB	0x194
#define	ALT_F4	0x16b
#define	ALT_UP	408
#define	ALT_DOWN	416
#define	ALT_RIGHT 413
#define	ALT_LEFT	 411
#define CTRL_Y			25
#define CTRL_PGUP		631
#define CTRL_PGDOWN		629
#endif

#ifdef	__linux__
#define	F01		0x341
#define	F02		0x342
#define	F03		0x343
#define	F04		0x344
#define	F05		0x345
#define	F06		0x537
#define	F07		0x538
#define	F08		0x539
#define	F09		0x530
#define	F10		0x531
#define	F11		0x533
#define	F12		0x534
#define	HOME		0x331
#define	END		0x334
#define	CR		0x0d
#define	ESC		0x1b
#define	BACKSP		0x7F
#define	KUP		0x241
#define	KDOWN		0x242
#define	KRIGHT		0x243
#define	KLEFT		0x244
#define	DEL		819
#define	INSERT	0x332
#define	PGUP	821
#define	PGDOWN	822
#define	TAB		  9
#define	LF		 10
#define	ALT_X	376
#define	CTRL_TAB	0x109
#define	ALT_F4	0x536

#define	ALT_UP	449
#define	ALT_DOWN	457
#define	ALT_RIGHT 454
#define	ALT_LEFT	 452
#endif

#ifdef __QNX__
#define	F01		385
#define	F02		386	
#define	F03		387	
#define	F04		388	
#define	F05		389	
#define	F06		390	
#define	F07		391	
#define	F08		392	
#define	F09		393	
#define	F10		394	
#define	F11		430	
#define	F12		431
#define	HOME	416
#define	END		424
#define	CR		0x0d
#define	ESC		0x1b
#define	BACKSP	0x7f
#define	KLEFT	420
#define	KUP		417
#define	KDOWN	425
#define	KRIGHT	422
#define	DEL		428
#define	INSERT	427
#define	PGUP	418
#define	PGDOWN	426
#define	TAB		  9
#define	LF		 10
#define	ALT_X	504
#define	CTRL_TAB	415
#define	ALT_F4	468
#define	ALT_UP	449
#define	ALT_DOWN	457
#define	ALT_RIGHT 454
#define	ALT_LEFT	 452
#endif

enum typ_item {	_DOUBLE='d', _INT='i', _STRING='s',	_COMMENT='c' };

#define	MAX_CONF_ITEMS	500

enum events	{ NOEVENT, KEYEVENT, MOUSEEVENT, QUITEVENT, ACCELEVENT,
	  TERMINATEEVENT, RESIZEEVENT, INPUTEVENT1, INPUTEVENT2,
	  MOVEEVENT, CLICKRIGHTEVENT, CLICKLEFTEVENT, DRAGLEFTEVENT, 
	  DRAGRIGHTEVENT, GETFOCUSEVENT, LOSTFOCUSEVENT, INITEVENT,
	  BUTTONHOLDEVENT, WINDOWMOVEEVENT, STARTDRAGLEFTEVENT, STARTDRAGRIGHTEVENT,
	  // NOTE> this must be at end
 	  LASTEVENT};
enum bs	{ BDOWN, BUP, WHIDE, WVISIBLE, WDEACTIVE, WACTIVE};
enum BmpType { BMP_NONE, BMP_FILE, BMP_IMAGE, BMP_MEM };

#define	IM		 	CScheme->window_fore // CBLACK standard menu fore & background colors
#define	PM			CScheme->window_back

#define	BNORMAL		7
#define	BPUSHED		3
#define	BDISABLED	5
#define	BUNVISIBLE	6

#define	WFRAMED		0x0001
#define	WTITLED		0x0002
#define	WMODAL		0x0004
#define	WSOLID		0x0008
#define	WHIDEN		0x0010
#define	WUNMOVED	0x0020
#define	WMENU		0x0040
#define	WNOPICTO	0x0080
#define	WBITMAP		0x0100
#define	WCLICKABLE	0x0200
#define	WDIRTY		0x0400
#define	WTEMPHIDEN	0x0800
#define	WLOCKED		0x1000
#define	WTRIGGER	0x2000
#define	WLASTFOCUS	0x4000
#define	WSIZEABLE	0x8000
#define	WUSELAST	0x00010000
#define	WMINIMIZE	0x00020000
#define	WSTATUSBAR	0x00040000
#define	WEXIST		0x00080000
#define	WHORIZONTAL	0x00100000
#define	WVERTICAL	0x00200000
#define	WLINEMENU	0x00400000

#define	WMENUWINDOWTYPE	   0x80000000

#define	WSTANDARD	(WCLICKABLE|WTITLED|WFRAMED)

#define	APP_WINDOWDATABASE		1
#define	APP_CFG					2
#define	APP_ENABLEALTX			4
#define	APP_MAGNIFIER			8
#define	APP_ROOTWINDOW			16
#define APP_ALL					0x1F

// some global fnc

extern "C" void	IError(char	*s,	int	flag);
extern "C" int GetMouseX(void);
extern "C" int GetMouseY(void);
extern "C" void	RemoveMousePointer(void);

int	 GetFreeColors(void);
void SetColorFuzzy(int a);
int	 CreateColor(int,int,int);
int	 CreateColor(int,int,int,int);
void GetColor( char	&, char	&, char	&, int);
void DeleteColor(int);
void SetRepeatDelay(int	c1,	int	c2);
void SaveScreen(void);

extern long IntCounter; // counter of userevent pass

class BaseGui;
class Control;
class Window;
class Bitmap;
class EditBox;
class ButtonGroup;

typedef struct
{
	int		window_back, window_fore;
	int		active_title;
	int		inactive_title;
	int		wnd_bord1;
	int		wnd_bord2;
	int		wnd_bord3;
	int		statusbar;
	int		menu_back;
	int		menu_fore;
	int		button_fore;
	int		button_back;
	int		button_fore_pushed;
	int		button_back_pushed;
	int		button_bord1;
	int		button_bord2;
	int		button_bord3;
	int		edit_back;
	int		edit_fore;
	int		edit_bord1;
	int		edit_bord2;
	int		slider;
	int		menuwindow_back;
	int		menuwindow_fore;
	int		pdmenu_back_active;
	int		pdmenu_fore_active;
	int		pdmenu_gray;
} ColorScheme;

extern ColorScheme * CScheme;

class Node {
	friend class Config;
	typ_item type;
	char name[34];
	int	i;
	char  s[130];
	double d;
	void ModifyNode(char * comment)	// Modify comment
	{
		type = _COMMENT;
		*name =	0;
		strcpy(s, comment);
	}
	void ModifyNode(char * meno, char *	val) // Modify string
	{
		type = _STRING;
		strcpy(name, meno);
		strcpy(s, val);
	}
	void ModifyNode(char * meno, int val) // Modify integer
	{
		type = _INT;
		strcpy(name, meno);
		i	 = val;
	}
	void ModifyNode(char * meno, double	val) // Modify double
	{
		type = _DOUBLE;
		strcpy(name, meno);
		d	 = val;
	}
};
	
class Config {
	protected:
		int	find(char *	s);
		void CreateEmpty(void);
		char name[36];
		FILE *f;
		int	crc;
		int	entries;
		int	change;
		Node pole[MAX_CONF_ITEMS];
		void ReadConfig(void);
		void WriteConfig(void);
		void   WriteComment(char * s);
	public:
		
		int	   ReadInt(char	* s);
		char const * ReadString(char * s);
		double ReadDouble(char * s);
		int	   ReadInt(char	* s, int &p);
		int	   ReadString(char * s,	char *p, int max);
		int	   ReadString(char * s,	char **p);
		int	   ReadDouble(char * s,	double &p);
		void   WriteInt(char * s, int);
		void   WriteString(char	* s, char *);
		void   WriteDouble(char	* s, double);

		Config(char	*);
		~Config();
};

//
//  Create a palette entry at 'index'
//

class Palette {
		char	b,g,r,alfa;
	public:
		friend class ColorSystem;
		Palette(void)
		{
		 	r =	g =	b =	alfa = 0;
		}
};

class ColorSystem {
		class Palette ColorsArray[256];
		int	 colorsFree, startFree;
		int	 range;
	public:
		void SetColorFuzzy(int a) {	range =	a&15; }
		int	 GetFreeColors(void) { return colorsFree; }
		void ReservedColors(void);
		~ColorSystem();
		ColorSystem()
		{
			startFree =	0;
			range =	0;
			colorsFree=	256-startFree;
			ReservedColors();
		}
		void CreatePaletteEntry(int	rc,	int	gc,	int	bc,	int	idx);
		void GetPaletteEntry(char &rc, char	&gc, char &bc, int i)
		{
		 	rc = ColorsArray[i].r;
			gc = ColorsArray[i].g;
			bc = ColorsArray[i].b;
		}
		void DeleteColor(int idx)
		{
			if (ColorsArray[idx].alfa==1) // is free
			{
			 	ColorsArray[idx].r = (char)idx;	// create an gray color
				ColorsArray[idx].g = (char)idx;
				ColorsArray[idx].b = (char)idx;
				ColorsArray[idx].alfa=0;
				colorsFree++;
			}
			else if	(ColorsArray[idx].alfa>1) ColorsArray[idx].alfa--;
		}
		void RefreshPalette(void);
		int	CreateColor(int	r, int g, int b); //return -1 if no space ...
		int	CreateColor(int	r, int g, int b, int index); // force color
};


//
//	data structure to event-driven ...
//

class GuiEvent {
	protected:
		static	int	ismouse,user_pid;
		static	char *eventName[];
		int		type;
		int		key;
		int		buttons, x,	y, w, h;
		friend class BaseGui;
		friend class App;
		void AutoRepeatStart(Control *);
		void AutoRepeatEnd(void);
		void AutoRepeatDo(void);
	public:
		Window	*wnd;	// address of destination
		int		guiType;
		Control *accel;
		GuiEvent(int a=NOEVENT,	int	b=0, int c=0, int d=0)
		{ 
			type= a;
			key	= b;
			x	= c;
			y	= d;
			accel = 0;
		}
		int	Key(void) {	return key;	}
		char 	*Name(void) { if (type<0 || type>=LASTEVENT) return eventName[LASTEVENT]; return eventName[type]; }
		int	GetX(void) { return	x; }
		int	GetY(void) { return	y; }
		int	GetW(void) { return	w; }
		int	GetH(void) { return	h; }
		int	Type(void) { return	type; }
		int	Buttons(void) {	return buttons;	}
		GuiEvent * GetUserEvent(int);
		void   TranslateUserEvent(void);
		static void	InitUserEvent(void);
		static void	CloseUserEvent(void);
		static void	GetDragVector(int &a, int &b, int &c, int &d);
		static void	SetDragShape(void(*a)(int,int,int,int)=0);
};

typedef	void (*Widget)(void);

typedef	void (*GuiHwnd)(GuiEvent *);

typedef	int	(*MainHwnd)(GuiEvent *);

typedef	void (*PCHARFNC)(char *);

//
//	base objects for all graphics objects
//

extern FILE	*f;

class WindowItem
{
	public:
		int	x,y,w,h;
		char *name;
		WindowItem *next;
		WindowItem()
		{
			char s[80],*p=s;
			int	c;
			fread(&x,sizeof(int),1,::f);
			fread(&y,sizeof(int),1,::f);
			fread(&w,sizeof(int),1,::f);
			fread(&h,sizeof(int),1,::f);
			while ((c=fgetc(::f)) != 0)	*p++=(char)c;
			*p=0;
			name = new char[strlen(s)+1];
			strcpy(name,s);
		}
		WindowItem(int xx, int yy, int ww, int hh, char	*s)
		{
			x=xx;
			y=yy;
			w=ww;
			h=hh;
			name = new char[strlen(s)+1];
			strcpy(name,s);
		}
		~WindowItem()
		{
			fwrite(&x,sizeof(int),1,::f);
			fwrite(&y,sizeof(int),1,::f);
			fwrite(&w,sizeof(int),1,::f);
			fwrite(&h,sizeof(int),1,::f);
			fputs(name,::f);
			fputc(0,::f);
			delete name;
		}
};

class WindowDatabase {
		static int xyCounter;
		friend class WindowItem;
		static WindowItem *first;
		static WindowItem **endpointer;
	public:
		WindowDatabase();
		~WindowDatabase();
		static void	Add(int	&, int &, int &, int &,	char *,int);
		static void	DatabaseResize(int , int , char	*);
		static void	DatabaseRelocate(int , int , char *);
		static WindowItem *	find(char *s);
};

class BaseGui {
	protected:
		int		 id;
		int 	 parameter1;
		int		 type;
		char 	*name;
		int		 ink, paper;
		int		 x,y,w,h;
		unsigned long	status;
		BaseGui	*last, * next;
		void	 PositionCheck(int &x, int &y, int &w, int &h);
	public:
		virtual	void MoveIn(void){}
		virtual	void MoveOut(void){}
		void         SetColors(void) { set_colors(ink, paper); }
		void		 SetParam(int a) { parameter1 = a; }
		int			 GetParam(void)  { return parameter1; }
		void		 SetLast(BaseGui *l) { last	= l; }
		void		 SetNext(BaseGui *l) { next	= l; }
		BaseGui(const BaseGui &)
		{
			printf("No COPY Constructor defined!\n");
			exit(-1);
		}
		static	  	int	counter;
		void	  	Resize(int dx, int dy)	 { w +=	dx;	h += dy; WindowDatabase::DatabaseResize(w,h,name); }
		void	  	Relocate(int xx, int yy) { x +=	xx;	y += yy; WindowDatabase::DatabaseRelocate(x,y,name); }
		int		  	GetX(void) { return	x; }
		int		  	GetY(void) { return	y; }
		int		  	GetW(void) { return	w; }
		int		  	GetH(void) { return	h; }
		int		  	IsVisible(void)	{ return !(status&(WHIDEN|WTEMPHIDEN));	}
		int		  	GetId(void)	{ return id; }
		int		  	GetType(void) {	return type; }
		char	* 	GetName(void) {	return name; }
		void	  	SetName(char *s) { delete name;	name = new char[strlen(s)+1]; strcpy(name,s); }
		int		  	GetCnt(void) { return counter; }
		char	  	GetInk(void) { return (char)ink; }
		char	  	GetPaper(void) { return	(char)paper; }
		void 	  	SetStatus(long s) {	status = s;	}
		long	  	GetStatus(void)	{ return status; }
		BaseGui	* 	Over(BaseGui *od, BaseGui *po);
		BaseGui	* 	OverSprite(BaseGui *od,	int	x, int y, int w, int h);
		BaseGui	* 	GetNext(void) {	return next; }
		BaseGui	* 	GetLast(void) {	return last; }
		static	  	BaseGui	* FindId(BaseGui *,	int	idw);
		BaseGui	* 	FindName(BaseGui *,	char *);
		static	  	BaseGui	* Find(BaseGui *p,GuiEvent *e);
		BaseGui	* 	FindEvent(BaseGui *p,GuiEvent *e);
		BaseGui(int	xs,	int	ys,	int	ws,	int	hs,	char *nm, int typ, int i, int p, long flag);
		enum Type {	WINDOW,	CHECKBUTTON, PUSHBUTTON, POINTBUTTON, EDITBOX,
			MENUBUTTON, MENUBUTTON2, MENUWINDOW, SLIDEBAR, PSEUDOWINDOW, LISTBOX};
		void Rechain(BaseGui *l, BaseGui *n);  // place to object chain
		virtual	~BaseGui();
};

#pragma	pack(1);

class Bitmap {
	struct RGB3
	{
		char bBlue;				 /* Blue component of the color definition */
		char bGreen;			 /* Green component of the color definition*/
		char bRed;				 /* Red component of the color definition  */
	};
	struct RGB4
	{
		char bBlue;				 /* Blue component of the color definition */
		char bGreen;			 /* Green component of the color definition*/
		char bRed;				 /* Red component of the color definition  */
		char fcOptions;			 /* Reserved, must be zero                 */
	};
	struct bitmap_file_header
	{
		unsigned short	usType;
		unsigned long	cbSize;
		short			reserve1, reserve2;
	};
	struct bitmap_info
	{
		unsigned short	imageOffset;
		short			reserve;
	};
	struct bitmap_info_header1
	{
	  unsigned long	 size;
	  unsigned short cx;			   /* Bit-map width in pels                  */
	  unsigned short cy;			   /* Bit-map height in pels                 */
	  unsigned short cPlanes;		   /* Number of bit planes                   */
	  unsigned short cBitCount;		   /* Number of bits per pel within a plane  */
	  unsigned long	 ulCompression;	   /* Compression scheme used to store the bitmap */
	  unsigned long	 cbImage;		   /* Length of bit-map storage data in chars*/
	  unsigned long	 cxResolution;	   /* x resolution of target device          */
	  unsigned long	 cyResolution;	   /* y resolution of target device          */
	  unsigned long	 cclrUsed;		   /* Number of color indices used           */
	  unsigned long	 cclrImportant;	   /* Number of important color indices      */
	};
	struct bitmap_info_header2
	{
	  unsigned long	 size;
	  unsigned long	 cx;			   /* Bit-map width in pels                  */
	  unsigned long	 cy;			   /* Bit-map height in pels                 */
	  unsigned short cPlanes;		   /* Number of bit planes                   */
	  unsigned short cBitCount;		   /* Number of bits per pel within a plane  */
	  unsigned long	 ulCompression;	   /* Compression scheme used to store the bitmap */
	  unsigned long	 cbImage;		   /* Length of bit-map storage data in chars*/
	  unsigned long	 cxResolution;	   /* x resolution of target device          */
	  unsigned long	 cyResolution;	   /* y resolution of target device          */
	  unsigned long	 cclrUsed;		   /* Number of color indices used           */
	  unsigned long	 cclrImportant;	   /* Number of important color indices      */
	};

	protected:
		bitmap_file_header	bmfh;
		bitmap_info			bmi;
		union {
			bitmap_info_header1	bmih1;
			bitmap_info_header2	bmih2;
		} bmih;
		union {
			RGB3 rgb3[256];
			RGB4 rgb4[256];
		} rgb;

		char		 *name;
		int			 w,h;
		int			 w_real;  // unaligned real widtht
		long		 *cUsedTable;
		void		 turn_bitmap(int cnt, char *from, char *to);
		char		 *bitmap;

	public:
		int			 type;
		Bitmap(char	*name);
		Bitmap(void	*memimage);
		Bitmap(Window *);
		Bitmap(int,int,int color=CBLACK);
		void		 BitmapDraw(int	a=0, int b=0, int c=-1,	int	d=-1);
		~Bitmap();
		int		  BitmapSave(char *);
		int		  GetW(void) { return w; }
		int		  GetWREAL(void) { return w_real; }
		int		  GetH(void) { return h; }
		char *	  GetArray(void) {return bitmap;}
		void		clear(int c) { memset(bitmap, c, w*h); }
};

#pragma	pack();

//
//	Base object fo controls (some buttons, menu & input boxes ..
//

class ButtonGroup
{
		int		count;
		int		type; // 1-check,point; 2-push; 0 undefined
		Control * 	curr;
		Control *	array[32];
	public:
		ButtonGroup()
		{
			count = type = 0;
			curr = 0;
		}
		void AddToGroup(Control *p, int activ = 0);
		void RefreshGroup(Control *c);
};

class Control :	public BaseGui {
	protected:
		Widget		fnc;			// handler
		Window		*owner;			// owner of this
		ButtonGroup 	*grp;		// if is group members
		int		key;			// hotkey
		int		xr,	yr;			 // x,y real coordinates
		int		local_id;
		Bitmap		*icon;
		Control(int	xs,	int	ys,	int	ws,	int	hs,	char *nm, int typ, int key,	int	flag, Window *,	Widget f=0,	int	p=CGRAY1, int i=CDARK);
		Control(int	xs,	int	ys,	int	typ, int key, int flag,	Window *, Bitmap *,	Widget f=0);
		~Control();
		void		Underscore(int xo, int yo, int c);
		static		Control	*cControl; // current activated control
		Widget	 	GetHandler(void) { cControl	= this;	return fnc;	}
		void 		frame(void);
	public:
		void		RegisterToGroup(ButtonGroup *g) { grp = g;}
		void		RemoveFromGroup(void) { grp = 0; }
		virtual		void SetName(char *s) {	BaseGui::SetName(s); draw(); }
		void		SetKey(int k) {	if (k>='a' && k<='z') k	= toupper(k); key=k; draw(); }
		virtual		void draw(void)	{}
		void		Enable(void);
		void		Disable(void);
		void		Relocate(int xx, int yy) { xr += xx; yr	+= yy; }
		virtual		void ClickUp(int a);  // if TRUE, so call handler
		virtual		void ClickDown(void) {}
		virtual		void ClickMove(int,int) {}
		void		SetTrigger(int a) {	if (a) SetStatus(GetStatus()|WTRIGGER);	else	SetStatus(GetStatus()&(~WTRIGGER));	draw();}
		int	   		GetTrigger(void) { return GetStatus()&WTRIGGER?1:0;	}
		static 		Control * ButtonFind(GuiEvent *e,int	n);
		int			Key(void) {	return key;	}
		int	   		GetXr(void)	{ return xr; }
		int	   		GetYr(void)	{ return yr; }
		Window		*GetOwner(void)	{ return owner;	}
		static 		Control *GetLastActive(void)	{ return cControl; }
		void		RefreshGroup(void);
		int			GetLocalId() { return local_id; }
};

class PushButton : public Control {
	protected:
			virtual	void draw(void);
	public:
		PushButton(int xs, int ys, int ws, int hs, char	*nm, int key, int flag,	Window *w, Widget f=0)
			: Control(xs, ys, ws, hs, nm, PUSHBUTTON, key, flag, w,	f)
			{
			 	draw();
			}
		PushButton(int xs, int ys, int key,	int	flag, Window *w, Bitmap	*bm, Widget f=0)
			: Control(xs, ys,PUSHBUTTON, key, flag,	w, bm, f)
			{
			 	draw();
			}
		void ClickDown(void);
		void ClickUp(int);
		void MoveIn(void);
		void MoveOut(void);
		void Push(void);
		void Release(void);
};

class CheckButton :	public Control {
			virtual	void draw(void);
			int		* variable;
	public:
		CheckButton(int	xs,	int	ys,	char *nm, int key, int flag, Window	*w,	int	fg,	int	bg,	Widget f=0, int *var=0)
			: Control(xs, ys, strlen(nm)*8+24, 16, nm, CHECKBUTTON,	key, flag, w, f,bg,fg)
			{
				variable = var;
				if (variable) SetTrigger(*variable); else draw();
			}
		void ChangeItem(int *v) { variable = v; SetTrigger(*v); draw(); }
};

class PointButton :	public Control {
			virtual	void draw(void);
			int		* variable;
	public:
		PointButton(int	xs,	int	ys,	char *nm, int key, int flag, Window	*w,	int	fg,	int	bg,	Widget f=0, int *var=0)
			: Control(xs, ys, strlen(nm)*8+24, 16, nm, POINTBUTTON,	key, flag, w, f,bg,fg)
			{
				variable = var;
				if (variable) SetTrigger(*variable); else draw();
			}
		void ChangeItem(int *v) { variable = v; SetTrigger(*v); draw(); }
};

extern EditBox *ininput;

class EditBox :	public Control {
	protected:
		virtual	void draw(void);
		void	draw(int);
		int		w1,w2,min,max,data_type,first,passwd,check_range;
		double	mind,maxd;
		void  *	ptr;
		static char	buf[128];
		int	 pos, maxpos, iline, icol, offset,size;
		void TestRange(void)
		{
                        if (check_range==0) return;
			if (data_type==0)
			{
				int	dato = *(int *)ptr;
				if (dato<min) *(int	*)ptr =	min;
				else if	(dato>max) *(int *)ptr = max;
			}
			else if	(data_type==2)
			{
				double dato	= *(double *)ptr;
				if (dato<mind) *(double	*)ptr =	mind;
				else if	(dato>maxd)	*(double *)ptr = maxd;
			}
		}
	public:
		~EditBox()
		{
			if (ininput	== this)
				ininput	= 0;
		}
		void MoveIn(void);
		void MoveOut(void);
		void ClickUp(int);
		int	 inputproc(int);
		void input(void);
		void PasswdMode(int m) { passwd = m; draw(); }
		void ChangeItem(int	*p)
		{
			assert(data_type==0);
			ptr	= p;
			draw();
		}
		void ChangeItem(char *p)
		{
			assert(data_type==1);
			ptr= p;
			draw();
		}
		void ChangeItem(double *p)
		{
			assert(data_type==2);
			ptr	= p;
			draw();
		}
		void SetSize(int ns)
		{
			pos = offset = 0;
			assert(ns>0 && ns<128);
			size = ns;
			draw();
		}
		EditBox(int xs,	int ys,	int ws1, int ws2, char *nm, int	key, Window *w,	int *pt, int ink, int paper, Widget f, int mn, int mx, int check);
		EditBox(int	xs,	int	ys,	int	ws1, int ws2, char *nm,	int	key, Window	*w,	char *pt, int ink, int paper, Widget f);
		EditBox(int xs,	int ys,	int ws1, int ws2, char *nm, int	key, Window *w,	double *pt, int	ink, int paper,	Widget f, double mn, double mx, int check);
};

class BaseMenu : public	Control	{
			virtual	void draw(void);
	public:
		void MoveIn(void);
		void MoveOut(void);
		virtual	void ClickUp(int a);  // if TRUE, so call handler
		BaseMenu(int x,	int	y, int ww, int hh, char	*nm, int key, Window *w, int bg, int fg, Widget	f, int type)
			: Control(x,y,ww, hh, nm, type, key, BNORMAL, w, f,bg,fg)
			{
				draw();
			}
};

class Slider  : public Control
{
	protected:
		virtual void draw(void) {}
		int		minv,maxv,*val,steps,smer; // 0 je vodorovny, 1 zvysly
		Widget  fnc;
		Window	*wnd;
		void 	frame(int,int,int,int,int f=0);
	public:
		Slider(Window *win, int xs, int ys, int ws, int hs, int minimal, int maximal, int s, int *v, Widget f=0) :
			Control(xs, ys, ws, hs, 0, SLIDEBAR, 0, BNORMAL, win, f)
		{
			wnd  = win;
			if (minimal>maximal)
			{
				minv = maximal;
				maxv = minimal;
			}
			else
			{
				minv = minimal;
				maxv = maximal;
			}
			if (*v<minv) *v=minv;
			if (*v>maxv) *v=maxv;
			val  = v;
			steps= s;
			smer = h>w;
			fnc  = f;
		}
};

class SlideBarH : public Slider 
{
// 3 - 16 - val - 3 - 38
	public:
		SlideBarH(int x, int y, int min, int max, int step, int *val, Window *win, Widget f=0):
			Slider(win,x,y,(max-min)/step+16+6+38,16,min,max,step,val,0)
		{
			draw();
			fnc = f;
		}
		void    redraw(void)
		{
			Widget tmp = fnc;
			fnc = 0;
			draw();
			fnc = tmp;
		}
		virtual void draw(void);
		virtual void ClickMove(int dx, int dy);
		virtual void ClickDown(void);
};

class Window : public BaseGui {
	protected:
		int		c_menupos;
		char 	*save;
		char 	*image;
		Window	**itself;
		void 	(*handler)(GuiEvent	*);
		BaseGui	*Buttony;
		BaseGui	*lastButton; // last in list
		int		nControls;	 // pocet buttonov priradenych oknu
		static	int	nWnd;
		int		wsur,hsur,xpos,ypos;
		int		xwrk,ywrk,wwrk,hwrk;
		static	int	allControls;
		static	int	hresult;
		static	Window *current, *first;  // last in list of all windows
		virtual	void draw(void);
		virtual	void DrawTitleMem(int color);
		int		OverWnd(void);
		static void	RepaintBlock(int x,	int	y, int w, int h)
		{
			RamToVideo(x,y,current->GetX()+x,current->GetY()+y,w,h);
		}
		void	init(void);
		long	WindowStatus(long status);
		void	WindowHide(void);
		void	WindowShow(void);
		void	WindowRecopy(void);
		int		OdkryOkno(void);
		static	void ZakryOkno(void);
		int		OdkryteOkno(Window *pokial,	int	x, int y, int w, int h);
		int		Rozporcuj(int X1, int Y1, int X2, int Y2, int *in, int *out);
		int		GetXM(int);
		int		GetYM(void);
		friend	volatile void DestroyWindow(void);
		friend	void   GuiEvent::TranslateUserEvent(void);
		friend	int	isgmkey(int	k);
	public:
		char *	  GetArray(void) {return image;}
		static	int	TestNullHandler(void)
		{
			if (current->GetStatus()&WNOPICTO)
			{
				IError("Can`t close this window",0);
				return 1;
			}
			return 0;
		}
		void	  wputc(int);
		void	  move(int x=0,	int	y=0) { wputc(-1); xpos=x; ypos=y; }
		int		  GetWW(void) {	return wsur; }
		int		  GetHW(void) {	return hsur; }
		static	  Window * GetCurrent(void)	{ return current; }
		BaseGui	* GetCurrentControls(void) { return	Buttony; }
		void	  WindowRepaint(int	xr,	int	yr,	int	w, int h);
		void	  Context(void);
		static void	HideAll(void);
		static void	ShowAll(void);
		friend class Control;
		Window(Window **, int xs, int ys, int ws, int hs, char *nm,	GuiHwnd=0, int i=IM, int p=PM, int flag=WTITLED|WFRAMED|WCLICKABLE);
		Window(Bitmap *);
		Window(int x, int y, int w, int h);
		Window(Window **);	// root window
		~Window();
		PushButton *AddPushButton(int xs, int ys, int ws, int hs, char *nm,	int	key=0, void	(*f)(void)=0, int flag=BNORMAL)
		{
			return new PushButton(xs, ys, ws, hs, nm, key, flag,this,f);
		}
		PushButton *AddPushButton(int xs, int ys, int key, Bitmap *bm, void	(*f)(void)=0, int flag=BNORMAL)
		{
			if (bm->type==0) return	0;
			return new PushButton(xs, ys, key, flag,this,bm,f);
		}
		SlideBarH *AddSlideBarH(int xs, int ys, int min, int max, int step, int *val, Widget f=0)
		{
			return new SlideBarH(xs, ys, min, max, step, val, this,f);
		}
		CheckButton	*AddCheckButton(int	xs,	int	ys,	char *nm, int key=0, int * variable=0, void	(*f)(void)=0, int flag=BNORMAL)
		{
			return new CheckButton(xs, ys, nm, key,	flag,this,GetInk(),GetPaper(),f,variable);
		}
		PointButton	*AddPointButton(int	xs,	int	ys,	char *nm, int key=0, int * variable=0, void	(*f)(void)=0, int flag=BNORMAL)
		{
			return new PointButton(xs, ys, nm, key,	flag,this,GetInk(),GetPaper(),f,variable);
		}
		EditBox	*AddEditBox(int	xs,	int	ys,	int	ws1, int ws2, char *nm,	int	key, int *p, Widget f, int min, int max)
		{
			return new EditBox(xs, ys, ws1,	ws2, nm, key, this,	p, GetInk(),GetPaper(),	f, min,	max, 1);
		}
		EditBox	*AddEditBox(int	xs,	int	ys,	int	ws1, int ws2, char *nm,	int	key, int *p, Widget f=0)
		{
			return new EditBox(xs, ys, ws1,	ws2, nm, key, this,	p, GetInk(),GetPaper(),	f, 0, 0, 0); // no checking
		}
		EditBox	*AddEditBox(int	xs,	int	ys,	int	ws1, int ws2, char *nm,	int	key, char *p, Widget f=0)
		{
			return new EditBox(xs, ys, ws1,	ws2, nm, key, this,	p, GetInk(),GetPaper(),	f);
		}
		EditBox	*AddEditBox(int	xs,	int	ys,	int	ws1, int ws2, char *nm,	int	key, double *p, Widget f, double min, double max)
		{
			return new EditBox(xs, ys, ws1,	ws2, nm, key, this,	p, GetInk(),GetPaper(),	f, min,	max, 1);
		}
		EditBox	*AddEditBox(int	xs,	int	ys,	int	ws1, int ws2, char *nm,	int	key, double *p, Widget f=0)
		{
			return new EditBox(xs, ys, ws1,	ws2, nm, key, this,	p, GetInk(),GetPaper(),	f, 0, 0, 0); // no checking
		}
		BaseMenu *AddBaseMenu(char *nm,	int	key=0, Widget f=0)
		{
				return new BaseMenu(GetXM(strlen(nm)*8+8), GetYM(),	strlen(nm)*8+8,	16,	nm,	key, this, CScheme->menu_back, CScheme->menu_fore, f, MENUBUTTON);
		}
		void WindowMove(int,int);
		void WindowFocus(void);
		void WindowText(int	x, int y, char *s);
		void WindowText(int	x, int y, char *s, int color);
		void WindowText(int	x, int y, char *s, int color, int bk);
		void WindowBox(int x, int y, int a,	int	b);
		void WindowBox(int x, int y, int a,	int	b, int c);
		void WindowPixel(int x,	int	y, int c);
		void WindowPixel(int x,	int	y);
		unsigned WindowGetPixel(int	x, int y)
		{
			if (x<0	|| y<0 || x>wwrk ||	y>hwrk)	return 256;
			return image[(x+xwrk)+(y+ywrk)*GetW()];
		}
		void WindowRect(int	x, int y, int a, int b);
		void WindowRect(int	x, int y, int a, int b,	int	c);
		void WindowLine(int	x, int y, int a, int b);
		void WindowLine(int	x, int y, int a, int b,	int	c);
		void WindowDrawCircle(int x, int y,	int	r, int c);
		void WindowDrawCircle(int x, int y,	int	r);
		void WindowFillCircle(int x, int y,	int	r, int c);
		void WindowFillCircle(int x, int y,	int	r);
		void WindowScrollDown(int p1, int p2, int p3, int p4 ,int p5);
		void WindowScrollUp(int	p1,	int	p2,	int	p3,	int	p4 ,int	p5);
		void WindowStatusBar(int, char *s, int c=IM);
		int	 TitleFind(GuiEvent	*e);
		static void	WindowInvalidate(void);
		static Window *	WindowFind(GuiEvent	*e);
		int	 printf(const char *, ...);
		int	 printf(int,int,const char *, ...);
		void SendToWindow(GuiEvent *p);
		static void	nextwnd(void);
		void WindowLock(void) {	SetStatus(GetStatus()|WLOCKED);	}
		void WindowUnLock(void);
		void WindowResize(int, int);
		void puts(char *s) { while(*s) wputc(*s++);	}
		void WindowPutBitmap(int x,	int	y, int xs, int ys,	int	w, int h, Bitmap *p);
		void WindowGetBitmap(int x,	int	y,	int	xs,	int	ys,	int	w, int h, Bitmap *p);
		void SetName(char *s) {	BaseGui::SetName(s); WindowStatus(WACTIVE);	}
		void Iconize(void);
		void WindowFillPolygon(int,	int	[][2], int col=-1);
		void WindowDrawPolygon(int,	int	[][2], int col=-1);
		void WindowSpline(int points[8]);
		void FlushInput(void);
		void WindowSetWorkRect(int,int,int,int);
		void WindowGetWorkRect(int&,int&,int&,int&);
		void RemoveControls(void);
};

#define	MAX_EVENT_QUEQUE	10	 // numbers of events to app per one user event ...

class App {
		static	GuiEvent *event, *queque;
		static	void (*DelayProc)(void);
		static	int	quequeIndex;
		static	void (*OnEverySecond)(int);
		static  Window *Root;
	public:
		int		flags;
		int		video;
		ColorSystem	*farby;
		int		Argc;
		char	**Argv;
		friend int	CreateColor(int,int,int);
		friend void	GetColor( char &, char &, char &, int);
		friend void	DeleteColor(int);
		friend int GetFreeColors(void);
		friend void	SetColorFuzzy(int);
		void   RefreshPalette(void)
		{
			farby->RefreshPalette();
		}
		static	void SetDelayProc(void (*fnc)(void))
		{
			DelayProc =	fnc;
		}
		static	void CallDelayProc(void)
		{
			if (DelayProc) DelayProc();
		}
		App(int, int &,	char **	&, int b, int f=APP_ENABLEALTX);
		~App();
		static	void SendToApp(GuiEvent	*x)
		{
			if (quequeIndex<MAX_EVENT_QUEQUE)
			{
				memcpy(queque+quequeIndex++,x,sizeof(GuiEvent));
			}
		}
		void	Run(MainHwnd hwnd=0);
		static	void AppDone(void)
		{
			GuiEvent e(QUITEVENT);
			SendToApp(&e);
		}
		static	void Timer(void);
		static void	SetTimerProc(void ((*p)(int)))
		{
			OnEverySecond =	p;
		}
		static void DisableSwitching(void)
		{
#ifdef __linux__
#ifndef LINUXFB
			vga_lockvc();
#endif
#endif
		}
		static void EnableSwitching(void)
		{
#ifdef __linux__
#ifndef LINUXFB
			vga_unlockvc();
#endif
#endif
		}
		Window * GetRootWindow(void)
		{
			assert(Root);
			return Root;
		}
};

extern App *cApp; // current app
extern Widget call_handler;
extern Config *cfg;
extern Window *oldidw, *idw;
extern Control *oldidm,*idm;
extern int fulldrag;

class MenuWindow : public Window {
		static GuiHwnd Proc;
		static MenuWindow *	CurrentMenu;
		static void	MenuWindowHandler(GuiEvent *p);
		int		offset;
		int		cid;
	public:
		MenuWindow(int x, int y, int w,	int	h, char	*name="MenuWindow", GuiHwnd proc=0, int bg=CScheme->menuwindow_back):
			Window(0,x,y,w,h,name,MenuWindowHandler,CScheme->menuwindow_fore,bg,WFRAMED|WCLICKABLE|WNOPICTO|WMENUWINDOWTYPE)
		{
			offset = 0;
			cid = -1;
			Proc = proc;
			CurrentMenu	= this;
		}
		~MenuWindow()
		{
			CurrentMenu	= 0;
		}
		int	GetXM(void)
		{
			return 4;
		}
		int	GetYM(int a)
		{
			return (offset+=a,offset-a);
		}
		BaseMenu *AddMenu(char *nm,	int	key=0, Widget f=0)
		{
			return new BaseMenu(GetXM(), GetYM(18),	GetWW()-8, 18, nm, key,	this, GetPaper(), GetInk(), f, MENUBUTTON2);
		}
		CheckButton	*AddCheckButton(char *nm, int key=0, int * variable=0, Widget f=0, int flag=BNORMAL)
		{
			return new CheckButton(GetXM(),	GetYM(18), nm, key,	flag,this,GetInk(),GetPaper(),f,variable);
		}
		PointButton	*AddPointButton(char *nm, int key=0, int * variable=0, Widget f=0, int flag=BNORMAL)
		{
			return new PointButton(GetXM(),	GetYM(18), nm, key,	flag,this,GetInk(),GetPaper(),f,variable);
		}
		EditBox	*AddEditBox(int	ws1, int ws2, char *nm,	int	key, int *p, Widget f, int min, int max)
		{
			return new EditBox(GetXM(),	GetYM(24), ws1,	ws2, nm, key, this, p, GetInk(),GetPaper(), f, min, max, 1);
		}
		EditBox	*AddEditBox(int	ws1, int ws2, char *nm,	int	key, int *p, Widget f=0)
		{
			return new EditBox(GetXM(),	GetYM(24), ws1,	ws2, nm, key, this, p, GetInk(),GetPaper(), f, 0, 0, 0);
		}
		EditBox	*AddEditBox(int	ws1, int ws2, char *nm,	int	key, char *p, Widget f=0)
		{
			return new EditBox(GetXM(),	GetYM(24), ws1,	ws2, nm, key, this,	p, GetInk(),GetPaper(),	f);
		}
		EditBox	*AddEditBox(int	ws1, int ws2, char *nm,	int	key, double	*p,	Widget f, double min, double max)
		{
			return new EditBox(GetXM(),	GetYM(23), ws1,	ws2, nm, key, this,	p, GetInk(),GetPaper(),	f, min,	max, 1);
		}
		EditBox	*AddEditBox(int	ws1, int ws2, char *nm,	int	key, double	*p,	Widget f=0)
		{
			return new EditBox(GetXM(),	GetYM(23), ws1,	ws2, nm, key, this,	p, GetInk(),GetPaper(),	f, 0, 0, 0);
		}
		void Separator(void)
		{
			int i;
			WindowBox(GetXM(), i=GetYM(7)+3, GetWW()-8, 1, CGRAYED);
			WindowBox(GetXM(), i+1, GetWW()-8, 1, CWHITED);
		}
};

void SendEvent(Window *w, int event, int key=0,	int	x=0, int y=0);
int RegisterJob(Widget w);
unsigned int CalculateCRC(unsigned StartCRC, void *Addr, unsigned Size);
#endif
