//
//	25.01.1999 Marian Krivos (nezmar@usa.net)
//
//	RAD main file

#include <fastgl.h>
#include <widgets.h>

#include "rad_def.h"
#include "rad_type.h"
#include "rad_sym.h"

Window *mWnd;
Projekt *prj;
const Wind windx={ 0, 0, DBFHEIGHT,300, 180, WSTANDARD,IM,PM,-1, "form1" };
Flags flg={1,1,0,0,0,0,0,1,0,0,0,0};
EditBox *eb0,*eb1,*eb2,*eb3,*eb4, *eb5, *eb6, *eb7, *eb8, *eb9;
static PointButton	*pb0, *pb1,	*pb2, *pb3,	*pb4, *pb5,	*pb6, *pb7,	*pb8, *pb9, *pb10, *pb11;
ListBox *lBox, *lBox2;
Window *dlgWnd;
char gps[256];
char srcname[64];
int isCode;

static Window *ColorsManagementPtr;
static int rrr;
static int ggg;
static int bbb, ccc=16;
int change_only = 0;

static char *rad_str[]=
{
"UNDEFINE",
"STRING",
"BOX",
"RECT",
"LINE",
"CIRCLE",
"PUSHBUT",
"CHECKBUT",
"POINTBUT",
"EDITBOX1",
"EDITBOX2",
"EDITBOX3",
"SLIDEBAR",
"LISTBOX",
"MENU",
"FCIRCLE",
};

static int *color_settings;
static Accel *current_accel;
static Window * SetColorsPtr;

static void ColorsManagement(void);
void Editor(char *, int);
// ------------------------------------------------------------------------

static void Redraw(void)
{
	prj->Redraw(&prj->Okno[prj->curr]);
	if (dlgWnd) dlgWnd->WindowFocus();
}

static void AddToRc(void)
{
	current_accel->flags ^= ACCF_ADDTORC;
}

static void Transp(void)
{
	current_accel->flags ^= ACCF_TRANSP;
}

static void RangeCheck(void)
{
	current_accel->flags ^= ACCF_CHECK;
}

static void RedrawTransp(void)
{
	Transp();
	Redraw();
}

static Window *form1Ptr;

static void form1Proc(GuiEvent *p)
{
	int tmp;
	switch(p->Type()) {
		case INITEVENT:
			set_ppop(_GSET);
			tmp = set_font(1);
			p->wnd->WindowText(16, 16, "This is an utility to generate source", 0, 1);
			p->wnd->WindowText(56, 32, "skeleton for FastGL library", 0, 1);
			p->wnd->WindowText(120, 60, "written by", 0, 1);
			p->wnd->WindowText(72, 78, "(c) 1999 MARIAN KRIVOS", 0, 1);
			set_font(tmp);
			break;
		case KEYEVENT:
		case CLICKLEFTEVENT:
		case CLICKRIGHTEVENT:
			delete p->wnd;
			break;
		case TERMINATEEVENT:
			break;
	}
}

static void About(void)
{
	form1Ptr = new Window(&form1Ptr, 272, 334, 340, 108, "", form1Proc, 0, 1, 0x285);
}

// Dialog proc for widget settings
static void DialogOk(void)
{
	if (!change_only) prj->PridajWidget();
	delete dlgWnd;
	change_only = 0;
}

static void DialogCancel(void)
{
	delete dlgWnd;
	change_only = 0;
}

static void SetColorsProc(GuiEvent *p)
{
	int	xWnd = p->GetX()-8;
	int	yWnd = p->GetY()-8;
	int i,j;

	switch(p->Type()) 
	{
		case KEYEVENT:
			delete p->wnd;
			break;
		case INITEVENT:
			set_ppop(_GSET);
			for(i=0; i<16; i++) for(j=0; j<16; j++) 
			{
				if (prj->paleta[(j+i*16)*4] || !i)
				{
					p->wnd->WindowBox(8+j*20,  8+i*20, 16, 16, j+i*16);
					p->wnd->WindowRect(8+j*20, 8+i*20, 16, 16, 0);
					if (*color_settings == (j+i*16)) p->wnd->WindowRect(8+j*20-1, 8+i*20-1, 18, 18, CYELLOW);
				}
			}
			break;
		case CLICKLEFTEVENT:
			if (yWnd<0 || xWnd<0) return;
			xWnd = xWnd/20;
			yWnd = yWnd/20;
			if (yWnd>15 || xWnd>15) return;
			if (!prj->paleta[(xWnd+yWnd*16)*4] && !(xWnd<16 && !yWnd)) return;
			if (color_settings) *color_settings = xWnd + yWnd*16;
			color_settings = 0;
			delete p->wnd;
			prj->Redraw(&prj->Okno[prj->curr]);
			break;
	}
}

static void SetColors(char *name)
{
	if (SetColorsPtr) return;
	SetColorsPtr = new Window(&SetColorsPtr, 240, 80, 340, 420-56, name, SetColorsProc, 0, CGRAY2, 0x203|WUSELAST);
}

static void SetFontProc(GuiEvent *p)
{
	if (p->Type() == ACCELEVENT)
	{
		prj->font = Control::GetLastActive()->GetLocalId()+1;
		prj->DrawAll(1);
	}
}

static void SetFont(void)
{
	MenuWindow *m1Wnd = new MenuWindow(GetMouseX(), GetMouseY()+10, 120, 97,"",SetFontProc);
	m1Wnd->AddMenu("Font 04 x 06");
	m1Wnd->AddMenu("Font 08 x 08");
	m1Wnd->AddMenu("Font 08 x 16");
	m1Wnd->AddMenu("Font 12 x 20");
	m1Wnd->AddMenu("Font 16 x 25");
}

Window *Set_KeyPtr;

AccKey acckey[] =
{
{F01, "F1 key", "F01"},
{F02, "F2 key", "F02"},
{F03, "F3 key", "F03"},
{F04, "F4 key", "F04"},
{F05, "F5 key", "F05"},
{F06, "F6 key", "F06"},
{F07, "F7 key", "F07"},
{F08, "F8 key", "F08"},
{F09, "F9 key", "F09"},
{F10, "F10 key", "F10"},
{F11, "F11 key", "F11"},
{F12, "F12 key", "F12"},
{HOME,"HOME key", "HOME"},
{END,"END key", "END"},
{CR,"CR key", "CR"},
{ESC,"ESC key", "ESC"},
{BACKSP,"BCKSPC key", "BACKSP"},
{KLEFT,"LEFT ARROW", "KLEFT"},
{KUP,"UP ARROW", "KUP"},
{KDOWN,"DOWN ARROW", "KDOWN"},
{KRIGHT,"RIGHT ARROW", "KRIGHT"},
{DEL,"DELETE key", "DEL"},
{INSERT,"INSERT key", "INSERT"},
{PGUP,"PAGE UP", "PGUP"},
{PGDOWN,"PAGE DOWN", "PGDOWN"},
{TAB,"TAB key", "TAB"},
{LF,"LF key", "LF"},
{ALTX,"ALT+X key", "ALTX"},
{CTRLTAB,"CTRL+TAB", "CTRLTAB"},
{ALTF4,"ALT+F4", "ALTF4"},
{ALTUP,"ALT+UP key", "ALTUP"},
{ALTDOWN,"ALT+DOWN key", "ALTDOWN"},
{ALTRIGHT,"ALT+RIGHT key", "ALTRIGHT"},
{ALTLEFT,"ALT+LEFT key", "ALTLEFT"}
};

static void Set_KeyProc(GuiEvent *p);

static void SetKeyProc2(GuiEvent *p)
{
	GuiEvent e(NOEVENT);
	if (p->Type() == ACCELEVENT)
	{
		current_accel->flags |= ACCF_PREDEF;
		current_accel->key = -p->accel->GetLocalId();
		Set_KeyPtr->SendToWindow(&e);
	}
}

static void Set_KeyProc(GuiEvent *p)
{
	static PushButton *idb1,*idb0,*idb2;
	static EditBox *eb;
	static int old = current_accel->key;
	
	switch(p->Type()) {
		case INITEVENT:
			set_ppop(_GSET);
			eb = p->wnd->AddEditBox(11, 136, 80, 56, "Key Code", 0, &current_accel->key);
			p->wnd->WindowText(27, 26, "Input a key code or press");
			p->wnd->WindowText(44, 52, "a key on the keyboard only");
			p->wnd->WindowText(68, 80, "NOTE: the ENTER key you must", 11, 5);
			p->wnd->WindowText(100, 105, "assign in the input box!", 11, 5);
			idb2 = p->wnd->AddPushButton(12, 163, 134, 21, "Predefined keys", 0, 0);
			p->wnd->WindowRect(8, 8, 314, 120, 12);
			idb0 = p->wnd->AddPushButton(169, 151, 64, 21, "Ok");
			idb1 = p->wnd->AddPushButton(255, 151, 64, 21, "Cancel");
			break;
		case KEYEVENT:
			if (p->Key() == CR)
			{
				delete p->wnd;
				return;
			}
			if (p->Key() >=0 && p->Key() < 256 && p->Key() != CR)
			{
				current_accel->key = p->Key();
				eb->ChangeItem(&current_accel->key);
				current_accel->flags &= ~ACCF_PREDEF;
			}
			break;
		case ACCELEVENT:
			if (p->Key() == idb2->GetId())
			{
				MenuWindow *m1Wnd = new MenuWindow(GetMouseX(), GetMouseY()+10, 120, (sizeof(acckey)/sizeof(AccKey))*18+8, "", SetKeyProc2);
				for(int i=0; i<sizeof(acckey)/sizeof(AccKey); i++)
				{
					m1Wnd->AddMenu(acckey[i].str);
				}
			}
			else if (p->Key() == idb0->GetId())
			{
				delete p->wnd;
			}
			else if (p->Key() == idb1->GetId())
			{
				current_accel->key = old;
				delete p->wnd;
			}
		case TERMINATEEVENT:
			return;
	}
	if (current_accel->flags&ACCF_PREDEF)
	{
		sprintf(gps," name %s    ", acckey[-current_accel->key].str);
		eb->Disable();
	}
	else
	{
		sprintf(gps," char '%c', hex %04x ", current_accel->key, current_accel->key);
		eb->Enable();
	}
	p->wnd->WindowText(24,4,gps);
}

static void SetKey(void)
{
	Set_KeyPtr = new Window(&Set_KeyPtr, 212, 309, 338, 219, "Set Key", Set_KeyProc, 12, 5, 0x283);
}

static void SetInk(void)
{
	assert(current_accel);
	color_settings = &current_accel->ink;
	SetColors("Set Ink");
}

static void SetPaper(void)
{
	assert(current_accel);
	color_settings = &current_accel->paper;
	SetColors("Set Paper");
}

static void SetInkW(void)
{
	color_settings = &prj->Okno[prj->curr].ink;
	SetColors("Set Window Ink");
}

static void SetPaperW(void)
{
	color_settings = &prj->Okno[prj->curr].paper;
	SetColors("Set Window Paper");
}

static void SetBoxSize(void)
{
	current_accel->flags |= ACCF_VARSIZE;
}

static void SetBoxSize2(void)
{
	current_accel->flags &= ~ACCF_VARSIZE;
	current_accel->ww = (current_accel->h-16)/8; // width in chars
	eb9->ChangeItem(&current_accel->ww);
	Redraw();
}

static void SetVideoProc(GuiEvent *p)
{
	if (p->Type() == ACCELEVENT)
	{
		prj->video_mode = Control::GetLastActive()->GetLocalId();
		prj->DrawAll(1);
	}
}

static void Video_mode(void)
{
	MenuWindow *m1Wnd = new MenuWindow(GetMouseX(), GetMouseY()+10, 120, 122, "", SetVideoProc);
	m1Wnd->AddMenu("320 x 200");
	m1Wnd->AddMenu("640 x 480");
	m1Wnd->AddMenu("800 x 600");
	m1Wnd->AddMenu("1024 x 768");
	m1Wnd->AddMenu("1280 x 1024");
	m1Wnd->AddMenu("1600 x 1200");
}

static void Back_color(void)
{
	color_settings = &prj->back_color;
	SetColors("Set Background Color");
}

void ShowDialog(RadType type, Accel *ptr)
{
	int x=300, y=400;
	Control *cb;
	
	if (dlgWnd)
	{
		x = dlgWnd->GetX();
		y = dlgWnd->GetY();
		delete dlgWnd;
	}

	current_accel = ptr;

	if (change_only) sprintf(gps, "Change : %s", rad_str[ptr->type]);
	else sprintf(gps, "Add : %s", rad_str[type]);
	if (prj->Okno[prj->curr].items>=MAX_ACCEL && !change_only) return; // no more space

	dlgWnd = new Window(&dlgWnd, x,y,354,240,gps, 0, 0, CGRAY2, WSTANDARD|WNOPICTO);
	dlgWnd->AddPushButton( 40,162,80,21,"OK",CR,DialogOk);
	dlgWnd->AddPushButton(220,162,80,21,"CANCEL",ESC,DialogCancel);
	dlgWnd->WindowText(8,190,"press <ENTER> when OK, or <ESC> to cancel", CWHITE);
	if (!change_only) // pridanie novej polozky
	{
		memset(ptr,0,sizeof(Accel)); // fill blank item
		ptr->x    = 8;
		ptr->y    = 8;
		ptr->w    = 64;
		ptr->h    = 21;
		ptr->ww   = 4;
		ptr->hh   = 2;
		ptr->ink  = prj->Okno[prj->curr].ink;
		ptr->paper= prj->Okno[prj->curr].paper;
		ptr->type =	type;
		ptr->flags = 0;
		if (ptr->type==RAD_PUSHBUTTON)
		{
			ptr->w  =64;
			ptr->h  =21;
		}
		if (ptr->type>=RAD_EDITBOX1 && ptr->type<=RAD_EDITBOX3)
		{
			ptr->w  = 64;
			ptr->h  = 40;
			ptr->ww = (ptr->h-16)/8; // width in chars
		}
		if (ptr->type==RAD_SLIDEBAR)
		{
			ptr->w  =0;
			ptr->h  =100;
			ptr->key=1;
		}
	}

	if (ptr->type != RAD_MENU)
	{
		eb5 = dlgWnd->AddEditBox(0, 8,72,48,"X-coor:",'X',&ptr->x, Redraw, 0, 2000);
		eb6 = dlgWnd->AddEditBox(0,32,72,48,"Y-coor:",'Y',&ptr->y,Redraw,0,2000);
	}
	switch(ptr->type)
	{
		case RAD_BOX:
		case RAD_RECT:
		case RAD_LINE:
			eb8 = dlgWnd->AddEditBox(120,32,72,56,"Height:",'H',&ptr->h, Redraw);
		case RAD_CIRCLE:
		case RAD_FILLCIRCLE:
			eb7 = dlgWnd->AddEditBox(120, 8,72,56,"Width:",'W',&ptr->w, Redraw);
		case RAD_STRING:
			cb = dlgWnd->AddPointButton(8,80,"Transparent Colors",'T',0, RedrawTransp);
			cb->SetTrigger(ptr->flags&ACCF_TRANSP);
			dlgWnd->AddPushButton(264, 8,72,21,"Ink",'I', SetInk);
			if (ptr->type==RAD_STRING)
			{
				dlgWnd->AddPushButton(264,32,72,21,"Paper",'P', SetPaper);
				EditBox *eb = dlgWnd->AddEditBox(0,  56,72,264,"Name:",'N',ptr->name, Redraw);
				eb->SetSize(MAXNAME-1);
				eb->ClickUp(1);
			}
			break;

		case RAD_EDITBOX1:
		case RAD_EDITBOX2:
			if (ptr->type==RAD_EDITBOX1)  // integer
			{
				if (!change_only)
				{
					ptr->max  = 0x7FFFFFFF;
					ptr->min  = 0x80000000;
				}
				dlgWnd->AddEditBox(0  ,128,72, 108,"Min:",'M', &ptr->min);
				dlgWnd->AddEditBox(156,128,72, 108,"Max:",'A', &ptr->max);
			}
			else
			{
				if (!change_only)
				{
					ptr->mind = -9999999999.;
					ptr->maxd = 9999999999.;
				}
				dlgWnd->AddEditBox(0  ,128,72, 108,"Min:",'M', &ptr->mind);
				dlgWnd->AddEditBox(156,128,72, 108,"Max:",'M', &ptr->maxd);
			}
			cb = dlgWnd->AddPointButton(260,36,"Check",0,0,RangeCheck);
			cb->SetTrigger(ptr->flags&ACCF_CHECK);
		case RAD_EDITBOX3:
			eb9 = dlgWnd->AddEditBox(208,80,72,56,"Size:",'S',&ptr->ww,SetBoxSize,1,127);
			eb8 = dlgWnd->AddEditBox(120,32,72,56,"Width2:",'2',&ptr->h, SetBoxSize2);
			eb7 = dlgWnd->AddEditBox(120, 8,72,56,"Width1:",'1',&ptr->w, Redraw);
		case RAD_SLIDEBAR:
		case RAD_PUSHBUTTON:
			if (ptr->type != RAD_EDITBOX1 && ptr->type != RAD_EDITBOX2 && ptr->type != RAD_EDITBOX3)
			{
				dlgWnd->AddEditBox(120,32,72,56,"Height:",'H',&ptr->h, Redraw);
				dlgWnd->AddEditBox(120, 8,72,56,"Width:",'W',&ptr->w, Redraw);
			}
		case RAD_CHECKBUTTON:
		case RAD_POINTBUTTON:
		case RAD_MENU:
			dlgWnd->AddEditBox(0, 80,72,138,"Fnc:",'F', ptr->fnc);
			if (ptr->type!=RAD_PUSHBUTTON && ptr->type!=RAD_MENU)
			{
				dlgWnd->AddEditBox(4,104,72,138,"Variable",'V', ptr->variable);
				cb = dlgWnd->AddPointButton(220,110,"Add to .RC",0, 0, AddToRc);
				cb->SetTrigger(ptr->flags&ACCF_ADDTORC);
			}
			dlgWnd->AddPushButton(262,8,72,21,"Key",'K', SetKey);
			if (ptr->type!=RAD_SLIDEBAR) dlgWnd->AddEditBox(0,  56,72,264,"Name:",'N',ptr->name, Redraw);
			break;
		case RAD_LISTBOX:
			dlgWnd->AddEditBox(116, 8,64,48,"X-num:",'N',&ptr->ww, Redraw);
			dlgWnd->AddEditBox(116,32,64,48,"Y-num:",'U',&ptr->hh, Redraw);
			dlgWnd->AddEditBox(224, 8,64,48,"W-one:",'W',&ptr->w, Redraw);
			dlgWnd->AddEditBox(224,32,64,48,"H-one:",'H',&ptr->h, Redraw);
			dlgWnd->AddEditBox(0, 80,72,138,"Fnc:",'F', ptr->fnc);
			break;
	}
}

static void Dialog(RadType r);

static void AddString(void)
{
	Dialog(RAD_STRING);
}

static void AddBox(void)
{
	Dialog(RAD_BOX);
}

static void AddRect(void)
{
	Dialog(RAD_RECT);
}

static void AddLine(void)
{
	Dialog(RAD_LINE);
}

static void AddCircle(void)
{
	Dialog(RAD_CIRCLE);
}

static void AddFillCircle(void)
{
	Dialog(RAD_FILLCIRCLE);
}

static void AddPush(void)
{
	Dialog(RAD_PUSHBUTTON);
}

static void AddCheck(void)
{
	Dialog(RAD_CHECKBUTTON);
}

static void AddPoint(void)
{
	Dialog(RAD_POINTBUTTON);
}

static void AddEditBox1(void)
{
	Dialog(RAD_EDITBOX1);
}

static void AddEditBox2(void)
{
	Dialog(RAD_EDITBOX2);
}

static void AddEditBox3(void)
{
	Dialog(RAD_EDITBOX3);
}

static void AddSlide(void)
{
	Dialog(RAD_SLIDEBAR);
}

static void AddListBox(void)
{
	Dialog(RAD_LISTBOX);
}

static void AddMenu(void)
{
	Dialog(RAD_MENU);
}

static void Dialog(RadType r)
{
	Wind *p = &prj->Okno[prj->curr];
	ShowDialog(r, &p->table[p->items]);
}

static void ControlItem(void)
{
	if (!prj) return;
	MenuWindow *m1Wnd = new MenuWindow(GetMouseX(), GetMouseY()+10, 130,152);
	m1Wnd->AddMenu("Push Button",'P',AddPush);
	m1Wnd->AddMenu("Check Button",'C',AddCheck);
	m1Wnd->AddMenu("Point Button",'O',AddPoint);
	m1Wnd->AddMenu("Edit Box 1",'E',AddEditBox1);
	m1Wnd->AddMenu("Edit Box 1.0",'D',AddEditBox2);
	m1Wnd->AddMenu("Edit Box 's'",'B',AddEditBox3);
	m1Wnd->AddMenu("SlideBarH",'S',AddSlide);
	m1Wnd->AddMenu("Menu",'M',AddMenu);
}

static void AddWindow(void)
{
	prj->AddWindow();
}

static void RemoveWindow(void)
{
	prj->DeleteWindow();
}

static void DuplicateWindow(void)
{
	prj->DuplicateWindow();
}

static void WindowItem(void)
{
	MenuWindow *m1Wnd = new MenuWindow(GetMouseX(), GetMouseY()+10, 150,62);
	m1Wnd->AddMenu("Add Window",'A',AddWindow);
	m1Wnd->AddMenu("Remove Window",'R',RemoveWindow);
	m1Wnd->AddMenu("Duplicate Window",'D',DuplicateWindow);
}

static void WidgetItem(void)
{
	MenuWindow *m1Wnd = new MenuWindow(GetMouseX(), GetMouseY()+10, 100,27);
	m1Wnd->AddMenu("ListBox",'L',AddListBox);
//	m1Wnd->AddMenu("DialogBox     [F2]",F02,AddDialogBox);
//	m1Wnd->AddMenu("ProgressBar   [F3]",F03,AddProgressBar);
}

static void ShapeItem(void)
{
	MenuWindow *m1Wnd = new MenuWindow(GetMouseX(), GetMouseY()+10, 120,116);
	m1Wnd->AddMenu("Text string",'T',AddString);
	m1Wnd->AddMenu("Box",'B',AddBox);
	m1Wnd->AddMenu("Rect",'R',AddRect);
	m1Wnd->AddMenu("Line",'L',AddLine);
	m1Wnd->AddMenu("Circle",'C',AddCircle);
	m1Wnd->AddMenu("Fill Circle",'C',AddFillCircle);
}

static Window *OKPtr;

static void OKProc(GuiEvent *p)
{
	switch(p->Type()) {
		case INITEVENT:
			set_ppop(_GSET);
			p->wnd->WindowText(24, 24, "Code has been generated succesfully!", CBLUE);
#ifdef __linux__
			p->wnd->WindowText(24, 44, "USE: gcc -fPIC file.cc -o file -lfgl -lvga", CBLUELIGHT);
#endif
#ifdef __MSDOS__
#ifdef __WATCOMC__
			p->wnd->WindowText(24, 44, "USE: wcc386 file.cc & wlink (with libfgl as DOS4G) ", CBLUELIGHT);
#else
			p->wnd->WindowText(24, 44, "USE: gcc file.cc -o file -lfgl ", CBLUELIGHT);
#endif
#endif
#ifdef __QNX__
			p->wnd->WindowText(24, 44, "USE: wcc386 file.cc & wlink (with libfgl as DOS4G) ", CBLUELIGHT);
#endif
			p->wnd->WindowText(24, 64, "        Press any key ...", CBLUE);
			break;
		case KEYEVENT:
		case CLICKLEFTEVENT:
		case CLICKRIGHTEVENT:
			delete p->wnd;
			break;
	}
}

static void GenerateCode(void)
{
	if (Compile(prj))
	{
		remove(srcname);
		isCode = 0;
	}
	else
	{
		OKPtr = new Window(&OKPtr, 200, 363, 390, 132, "OK", OKProc, 0, 15, 0x223|WMODAL);
	}
}

static void ViewCode(void)
{
	if (isCode) Editor(srcname, FONT0816);
}

static void OptionsItem(void)
{
	MenuWindow *m1Wnd = new MenuWindow(GetMouseX(), GetMouseY()+10, 178,160);
	m1Wnd->AddPointButton("Enable [alt+x]",'X', &prj->app_altx);
	m1Wnd->AddPointButton("Enable cfg",'C', &prj->app_cfg);
	m1Wnd->AddPointButton("Enable magnify",'M', &prj->app_magnify);
	m1Wnd->AddPointButton("Enable wnd saving",'W', &prj->app_wnd);
	m1Wnd->AddPointButton("Enable rootwindow",'R', &prj->app_root);
	m1Wnd->Separator();
	m1Wnd->AddMenu("Video mode",'V', Video_mode);
	m1Wnd->AddMenu("Background",'B', Back_color);
	m1Wnd->AddMenu("Font",'F', SetFont);
}

static void NewPrj(void)
{
	delete prj;
	prj = new Projekt();
	prj->Update();
	prj->Redraw(prj->Okno);
}

static void OpenPrj2(char *s)
{
	delete prj;
	prj = new Projekt(s);
	prj->Update();
}

static void OpenPrj(void)
{
	new FileDialog(OpenPrj2, 0, ".wnd", "Open Projekt", FDIALOG_MODAL | FDIALOG_SAVEDIR);
}

static void SavePrj2(char *s)
{
	if (strstr(s, ".wnd")) strcpy(prj->prjname, s);
	else
	{
		sprintf(prj->prjname, "%s.wnd", s);
	}
	prj->Save();
	OpenPrj2(s = strdup(prj->prjname));
	free(s);
}

static void SavePrj(void)
{
	prj->Save();
}

static void SaveAsPrj(void)
{
	new FileDialog(SavePrj2, 0, ".wnd", "Save Projekt", FDIALOG_MODAL | FDIALOG_SAVEDIR | FDIALOG_SAVE);
}

static void Forward2(void)
{
	prj->Forward();
}

static void Backward2(void)
{
	prj->Backward();
}

static void Delete2(void)
{
	prj->DeleteItem();
}

static void Clone2(void)
{
	prj->Clone();
}

static void EditMenu(void)
{
	MenuWindow *m1Wnd = new MenuWindow(GetMouseX(), GetMouseY()+10, 100, 81);
	m1Wnd->AddMenu("Forward", 'F', Forward2);
	m1Wnd->AddMenu("Backward",'B', Backward2);
	m1Wnd->AddMenu("Clone",'C', Clone2);
	m1Wnd->AddMenu("Delete",'D', Delete2);
}

static void FileMenu(void)
{
	MenuWindow *m1Wnd = new MenuWindow(GetMouseX(), GetMouseY()+10, 100, 124);
	m1Wnd->AddMenu("New",'N',NewPrj);
	m1Wnd->AddMenu("Open",'O',OpenPrj);
	m1Wnd->AddMenu("Save",'S',SavePrj);
	m1Wnd->AddMenu("Save As",'A',SaveAsPrj);
	m1Wnd->Separator();
	m1Wnd->AddMenu("About",'B',About);
	m1Wnd->AddMenu("Quit",'Q',App::AppDone);
}

static void ChangeColor(void)
{
	set_colors(0,3);
	cApp->farby->CreatePaletteEntry(rrr,ggg,bbb,ccc);
}

static void ColorsManagementProc(GuiEvent *p)
{
	static PushButton *pb1, *pb2;
	static SlideBarH *sl1, *sl2, *sl3;
	int	xWnd = p->GetX()-8;
	int	yWnd = p->GetY()-80;
	int i,j;
	switch(p->Type()) 
	{
		case TERMINATEEVENT:
			if (color_settings) *color_settings = ccc;
			color_settings = 0;
			break;
		case INITEVENT:
			set_ppop(_GSET);
			sl1 = p->wnd->AddSlideBarH(8, 4,  0, 63, 1, &rrr, ChangeColor);
			sl2 = p->wnd->AddSlideBarH(8, 20, 0, 63, 1, &ggg, ChangeColor);
			sl3 = p->wnd->AddSlideBarH(8, 36, 0, 63, 1, &bbb, ChangeColor);
			p->wnd->WindowBox(140, 4, 48, 48, ccc);
			set_colors(15,3);
			p->wnd->printf(200, 24, "%3d\n", ccc);
			pb1 = p->wnd->AddPushButton(236, 4,  88, 21, "Add Color", 'A');
			pb2 = p->wnd->AddPushButton(236, 32, 88, 21, "Del Color", 'D');
			for(i=0; i<16; i++) for(j=0; j<16; j++) 
			{
				if ((j+i*16) == ccc) p->wnd->WindowRect(8+j*20-2, 64+i*20-2, 20, 20, 0);
				if (prj->paleta[(j+i*16)*4] || !i) p->wnd->WindowRect(8+j*20-1, 64+i*20-1, 18, 18, CYELLOW);
				p->wnd->WindowBox(8+j*20,  64+i*20, 16, 16, j+i*16);
				p->wnd->WindowRect(8+j*20, 64+i*20, 16, 16, 0);
			}
			break;
		case CLICKLEFTEVENT:
			if (yWnd<0 || xWnd<0) return;
			xWnd = xWnd/20;
			yWnd = yWnd/20;
			if (yWnd>14 || xWnd>15) return;
			p->wnd->WindowRect(8+(ccc%16)*20-2, 64+(ccc/16)*20-2, 20, 20, 3);
			ccc = xWnd + yWnd*16 + 16;
			set_colors(15,3);
			p->wnd->printf(200, 24, "%3d\n", ccc);
			p->wnd->WindowBox(140, 4, 48, 48, ccc);
			p->wnd->WindowRect(8+(ccc%16)*20-2, 64+(ccc/16)*20-2, 20, 20, 0);
			rrr = prj->paleta[ccc*4+1];
			ggg = prj->paleta[ccc*4+2];
			bbb = prj->paleta[ccc*4+3];
			sl1->draw();
			sl2->draw();
			sl3->draw();
			break;
		case ACCELEVENT:
			if (p->Key() == pb1->GetId())
			{
				prj->paleta[ccc*4+0] = 1;
				prj->paleta[ccc*4+1] = rrr;
				prj->paleta[ccc*4+2] = ggg;
				prj->paleta[ccc*4+3] = bbb;
				p->wnd->WindowRect(8+(ccc%16)*20-1, 64+(ccc/16)*20-1, 18, 18, CYELLOW);
			}
			else if (p->Key() == pb2->GetId())
			{
				prj->paleta[ccc*4+0] = 0;
				prj->paleta[ccc*4+1] = 0;
				prj->paleta[ccc*4+2] = 0;
				prj->paleta[ccc*4+3] = 0;
				p->wnd->WindowRect(8+(ccc%16)*20-1, 64+(ccc/16)*20-1, 18, 18, 3);
			}
			break;
	}
}

static void ColorsManagement(void)
{
	if (ColorsManagementPtr) return;
	ColorsManagementPtr = new Window(&ColorsManagementPtr, 240, 80, 340, 420, "ColorsManagement", ColorsManagementProc, 0, CGRAY2, 0x203|WUSELAST);
}

static void RedrawOkno(void)
{
	unsigned long f=0;
	if (flg.title)	f|=WTITLED;
	if (flg.frame)	f|=WFRAMED;
	if (flg.modal)	f|=WMODAL;
	if (flg.solid)	f|=WSOLID;
	if (flg.nomove)	f|=WUNMOVED;
	if (flg.menu)	f|=WMENU;
	if (flg.nopicto)	f|=WNOPICTO;
	if (flg.clickable)	f|=WCLICKABLE;
	if (flg.focus)	f|=WLASTFOCUS;
	if (flg.sizeable)	f|=WSIZEABLE;
	if (flg.uselast)	f|=WUSELAST;
	if (flg.statusbar)	f|=WSTATUSBAR;
	prj->Okno[prj->curr].flags = f;
	if (prj) prj->Redraw(&prj->Okno[prj->curr]);
}

static void RedrawOkno2(void)
{
	RedrawOkno();
	lBox2->RedrawItem();
}

void DrawLBox(int x, int y, int idx, int f, void *)
{
	if (f)
	{
		mWnd->WindowBox(x,y,160,16,IM);
		set_colors(PM,IM);
	}
	else
	{
		mWnd->WindowBox(x,y,160,16,PM);
		set_colors(IM,PM);
	}
	sprintf(gps,"%s:%s\n", rad_str[prj->Okno[prj->curr].table[idx].type], prj->Okno[prj->curr].table[idx].name);
	gps[20]='\n'; //be care
	gps[21]=0; //be care
	set_ppop(_GSET);
	mWnd->printf(x,y,gps);
}

void DrawLBox2(int x, int y, int idx, int f, void *)
{
	if (f)
	{
		mWnd->WindowBox(x,y,100,16,IM);
		set_colors(PM,IM);
	}
	else
	{
		mWnd->WindowBox(x,y,100,16,PM);
		set_colors(IM,PM);
	}
	sprintf(gps,"%s\n", prj->Okno[idx].name);
	gps[12]='\n'; 	//be care
	gps[13]=0; 		//be care
	set_ppop(_GSET);
	mWnd->printf(x,y,gps);
}

void mainWnd(GuiEvent *p)
{
	int k,x,y;
	Wind *w;
	
	x = p->GetX();
	y = p->GetY();
	k = p->Key();

	switch(p->Type())
	{
		case MOVEEVENT:
			set_colors(IM,CGRAY2);
			mWnd->printf(214, 164, "X:%4d, Y:%4d\n", p->GetX(), p->GetY());
			break;
		case CLICKLEFTEVENT:
			k = lBox->Test(x,y);
			if (k != -1)
			{
				lBox->SetToItem(k);
				change_only = 1;
				ShowDialog((RadType)0, &prj->Okno[prj->curr].table[lBox->GetCurrent()]);
				break;
			}
			k = lBox2->Test(x,y);
			if (k != -1)
			{
				lBox2->SetToItem(k);
				prj->curr = k;
				prj->Update();
				prj->Redraw(prj->wind());
			}
			break;
		case KEYEVENT:
			w = prj->Okno+prj->curr;
			if (k==KUP)
			{
				if (dlgWnd) delete dlgWnd;
				if (w->current != -1)
				{
					SelectCurrent(w);
				}
				lBox->Up();
				w->current = lBox->GetCurrent();
				SelectCurrent(w);
			}
			else if (k==KDOWN)
			{
				if (dlgWnd) delete dlgWnd;
				if (w->current != -1)
				{
					SelectCurrent(w);
				}
				lBox->Down();
				w->current = lBox->GetCurrent();
				SelectCurrent(w);
			}
			else if (k==INSERT) prj->AddWindow();
			else if (k==PGUP) prj->Up();
			else if (k==PGDOWN)	prj->Down();
			else if (k==KRIGHT)   Forward2();
			else if (k==KLEFT) Backward2();
			else if (k==F03)  ViewCode();
			else if (k==F09)  GenerateCode();
			else if (k==DEL)  Delete2();
			else if (k==CR && lBox->GetSize())
			{
				change_only = 1;
				ShowDialog((RadType)0, &prj->Okno[prj->curr].table[lBox->GetCurrent()]);
			}
			break;
		case TERMINATEEVENT:
			delete lBox;
			break;
		case INITEVENT:
			mWnd->AddBaseMenu("File ", 'F', FileMenu);
			mWnd->AddBaseMenu("Edit ", 'E', EditMenu);
			mWnd->AddBaseMenu("Options ", 'O', OptionsItem);
			mWnd->AddBaseMenu("Window ", 'W', WindowItem);
			mWnd->AddBaseMenu("Control ", 'C', ControlItem);
			mWnd->AddBaseMenu("Widget ", 'G', WidgetItem);
			mWnd->AddBaseMenu("Shape ", 'S', ShapeItem);
			mWnd->AddBaseMenu("Color ", 'L', ColorsManagement);
			mWnd->AddBaseMenu("Compile ", 'M', GenerateCode);
			mWnd->AddBaseMenu("Source ", 'R', ViewCode);

			eb0 = mWnd->AddEditBox(0,  8,72,264,"Name:" ,'N',prj->Okno[prj->curr].name,RedrawOkno2);
			eb1 = mWnd->AddEditBox(0, 32,72,40,"X-coor:",'X',&prj->Okno[prj->curr].x,RedrawOkno,0,2000);
			eb2 = mWnd->AddEditBox(0, 56,72,40,"Y-coor:",'Y',&prj->Okno[prj->curr].y,RedrawOkno,0,2000);
			eb3 = mWnd->AddEditBox(112,32,72,40,"Width:",'W',&prj->Okno[prj->curr].w,RedrawOkno,0,1600);
			eb4 = mWnd->AddEditBox(112,56,72,40,"Height",'H',&prj->Okno[prj->curr].h,RedrawOkno,0,1200);
			mWnd->AddPushButton(256,32,72,21,"Ink",'I',SetInkW);
			mWnd->AddPushButton(256,56,72,21,"Paper",'P', SetPaperW);

			pb0 = mWnd->AddPointButton(8,83,"Title",'T',&flg.title,RedrawOkno);
			pb1 = mWnd->AddPointButton(8,83+21*1,"Frame",'F',&flg.frame,RedrawOkno);
			pb2 = mWnd->AddPointButton(8,83+21*2,"Modal",'M',&flg.modal,RedrawOkno);
			pb3 = mWnd->AddPointButton(8,83+21*3,"Solid",'S',&flg.solid,RedrawOkno);
			pb4 = mWnd->AddPointButton(8,83+21*4,"No-move",'N',&flg.nomove,RedrawOkno);

			pb5 = mWnd->AddPointButton(100,83+21*0,"Menu",0,&flg.menu,RedrawOkno);
			pb6 = mWnd->AddPointButton(100,83+21*1,"No-picto",0,&flg.nopicto,RedrawOkno);
			pb7 = mWnd->AddPointButton(100,83+21*2,"Clickable",0,&flg.clickable,RedrawOkno);
			pb8 = mWnd->AddPointButton(100,83+21*3,"Last focus",0,&flg.focus,RedrawOkno);
			pb9 = mWnd->AddPointButton(100,83+21*4,"Sizeable",0,&flg.sizeable,RedrawOkno);

			pb10= mWnd->AddPointButton(210,83+21*0,"Use last val",0,&flg.uselast,RedrawOkno);
			pb11= mWnd->AddPointButton(210,83+21*1,"Statusbar",0,&flg.statusbar,RedrawOkno);

			lBox = new ListBox(464,22,1,10,160,16,prj->Okno[prj->curr].items,DrawLBox,mWnd);
			lBox2= new ListBox(350,22,1,10,100,16,prj->nwin,DrawLBox2,mWnd);
			lBox2->SetToItem(prj->curr);
			break;
	}
}

void Projekt::Update(void)
{
	set_font(FONT0816);
	flg.title =	prj->Okno[prj->curr].flags&WTITLED?1:0;
	flg.frame =	prj->Okno[prj->curr].flags&WFRAMED?1:0;
	flg.modal =	prj->Okno[prj->curr].flags&WMODAL?1:0;
	flg.solid =	prj->Okno[prj->curr].flags&WSOLID?1:0;
	flg.nomove=	prj->Okno[prj->curr].flags&WUNMOVED?1:0;
	flg.menu  =	prj->Okno[prj->curr].flags&WMENU?1:0;
	flg.nopicto=prj->Okno[prj->curr].flags&WNOPICTO?1:0;
	flg.clickable=prj->Okno[prj->curr].flags&WCLICKABLE?1:0;
	flg.focus =	prj->Okno[prj->curr].flags&WLASTFOCUS?1:0;
	flg.sizeable=prj->Okno[prj->curr].flags&WSIZEABLE?1:0;
	flg.uselast=prj->Okno[prj->curr].flags&WUSELAST?1:0;
	flg.statusbar=prj->Okno[prj->curr].flags&WSTATUSBAR?1:0;
	
	if (mWnd==0)
	{
		sprintf(gps, "FastGL Sourcer %d.%d - %s      ", VERSION/100, (VERSION%100)/10, prjname);
		mWnd = new Window(&mWnd, 0,0, 640, DBFHEIGHT, gps, mainWnd,0,CGRAY2,WFRAMED|WMENU|WTITLED|WCLICKABLE|WNOPICTO);
	}
	else // update only
	{
		sprintf(gps, "FastGL Sourcer %d.%d - %s      ", VERSION/100, (VERSION%100)/10, prjname);
		mWnd->SetName(gps);
		eb0->ChangeItem(prj->Okno[prj->curr].name);

		eb1->ChangeItem(&prj->Okno[prj->curr].x);
		eb2->ChangeItem(&prj->Okno[prj->curr].y);
		eb3->ChangeItem(&prj->Okno[prj->curr].w);
		eb4->ChangeItem(&prj->Okno[prj->curr].h);
		
		pb0->ChangeItem(&flg.title);
		pb1->ChangeItem(&flg.frame);
		pb2->ChangeItem(&flg.modal);
		pb3->ChangeItem(&flg.solid);
		pb4->ChangeItem(&flg.nomove);
		pb5->ChangeItem(&flg.menu);
		pb6->ChangeItem(&flg.nopicto);
		pb7->ChangeItem(&flg.clickable);
		pb8->ChangeItem(&flg.focus);
		pb9->ChangeItem(&flg.sizeable);
		pb10->ChangeItem(&flg.uselast);
		pb11->ChangeItem(&flg.statusbar);
		lBox->SetSize(prj->Okno[prj->curr].items);
		lBox2->SetSize(prj->nwin);
	}
	set_colors(0, CGRAY2);
	mWnd->printf(464,4,"List of %3d Objects\n", prj->Okno[prj->curr].items);
	mWnd->WindowRect(4,80,332,105,0);
	if (lBox->GetSize()) lBox->SetToItem(0);
	lBox2->SetToItem(prj->curr);
}

int AppProc(GuiEvent *p)
{
	if (p->Type() == MOVEEVENT)
	{
		if (mWnd) mWnd->SendToWindow(p);
	}
	return 0;
}

int main(int argc, char **argv)
{
	App MyApp(4,argc,argv,CBLACK,APP_ENABLEALTX|APP_WINDOWDATABASE|APP_MAGNIFIER);

	set_fcolor(1);
	for(int i=0; i<X_width; i+=32) for(int j=0; j<Y_width; j+=32)
	{
		fill_rect(16,16,i+16,j+16);
		fill_rect(16,16,i,j);
	}
	if (argc==2)
		prj = new Projekt(argv[1]);
	else prj = new Projekt("form1.wnd");

	prj->Update();

	MyApp.Run(AppProc);
	if (prj) delete prj;
	color_settings = 0;
	if (ColorsManagementPtr) delete ColorsManagementPtr;
	if (OKPtr) delete OKPtr;
	if (mWnd) delete mWnd;
	if (Set_KeyPtr) delete Set_KeyPtr;
	if (form1Ptr) delete form1Ptr;
	return 0;
}
