/*** SOURCE4.C - Creates a .3DV file with the definition of a curve
	     by Lenimar N. Andrade, ccendm03@brufpb.bitnet
      Dep. of Mathematics - Universidade Federal da Paraba - Brazil ***/

#include <stdio.h>
#include <math.h>
#include <conio.h>

unsigned nu = 300;
FILE *arq;

/* Parametric equations of the curve */
float f1(float t) { return t/10; }
float f2(float t) { return t/10*sin(t); }
float f3(float t) { return t/10*cos(t); }

/* ------------------------------------------------------------------------- */

void CalcPoints2(float umin, float umax) {

  float u, incrU;
  unsigned i;

  incrU = (umax - umin)/nu;

  fprintf(arq, "%u\n", (nu + 1));
  for (u = umin; u < umax + incrU/2; u+= incrU)
    fprintf(arq, "%6.3f %6.3f %6.3f\n", f1(u), f2(u), f3(u));

  fprintf(arq, "%u\n", nu + 1);
  for (i = 1; i <= nu + 1; i++)
    if (i == 1)
      fprintf(arq, "%u %u\n", i, 0);
    else
      fprintf(arq, "%u %u\n", i, YELLOW);
}

/* ------------------------------------------------------------------------- */

void PrintMsg(void) {

  fprintf(arq, "\n%s", "3D curve f(t) = (t/10, t/10*sin(t), t/10*cos(t))");
  fprintf(arq, "\n%s", "Lenimar Nunes de Andrade, ccendm03@brufpb.bitnet\n");
}

/* ------------------------------------------------------------------------- */

void main(void) {

  if ((arq = fopen("demo4.3dv", "wt")) == NULL) return;
  CalcPoints2(-30, 30);
  PrintMsg();
  fclose(arq);
}

/* ------------------------------------------------------------------------- */

/*** END OF "SOURCE4.C" ***/
