module is_file
!  -------------
!  Copyright (C) 1995, Garnatz and Grovender, Inc.
!
!  Permission to distribute this software and its documentation within
!  your department or organization, is granted only under the terms
!  of our Software Licensing Agreement.  A fee must be paid for use
!  of this software.
!
!  For a copy of the Software Licensing Agreement write to:
!
!  Garnatz and Grovender, Inc.
!  5301 26th Avenue South
!  Minneapolis Minnesota USA 55417-1923
!
!  This general terms of the Software Licensing Agreement provide for
!  distribution of this software under what is generally called a
!  "shareware" agreement.  If you are using this software, you are
!  requested to acquire a license to use it at one of the following
!  4 levels:
!
!  INDIVIDUAL USE:
!  level 0:  1 developer with source, and runtime on 1 computer    $95.00
!  MULTIPLE USE:
!  level 1:  1 developer, and up to 10 runtime copies             $250.00
!  level 2:  up to 10 developers, and up to 100 runtime copies    $850.00
!  level 3:  unlimited developers, and unlimited runtime copies  $7500.00
!
!  Upon payment and acceptance of the Software Licensing Agreement you
!  will be entitled to many benefits, including 1) updates and bugfixes
!  as needed, 2) complete documentation, 3) additional utility programs to
!  inquire into the status of files and repair damaged files, 4) access to
!  fee-based consulting and other services.
!
!  This software is provided as is and Garnatz and Grovender, Inc. disclaims
!  all warranties with regard to this software, including all implied warranties
!  of merchantability and fitness for a particular purpose.  In no event
!  shall Garnatz and Grovender, Inc. be liable for any special, indirect or
!  consequential damages or any damages whatsoever resulting from loss of
!  use, data or profits, whether in an action of contract, negligence or
!  other tortious action, arising out of or in connection with the use or
!  performance of this software.
!  -------------
!
! Customize this file by entering your key(2x) and data fields below.
!
      type data_record_type_isdata
         character (len=8)                  :: key       ! YOUR KEY GOES HERE
         character (len=120)                :: data      ! YOUR DATA GOES HERE
      end type
!
      integer, parameter, private :: maxitbl = 50    ! block size on index file
!
      type data_record_type_isidx
         character(len=8), dimension(maxitbl) :: key   !YOUR KEY HERE TOO
         integer,          dimension(maxitbl) :: index
         integer                              :: ngood
         character(len=1)                     :: level
      end type
      private data_record_type_isidx
!
      type ixtree
         type (ixtree), pointer                 :: next
         type (ixtree), pointer                 :: prev
         type (data_record_type_isidx), pointer :: ixrec
         integer                                :: ix_rno
         integer                                :: cur_pos
      end type
      private ixtree
!
      type is_block_defn
         private
         type (pk_block_defn_isdata), pointer :: pk_block
         type (pk_block_defn_isidx),  pointer :: isidx_block
         type (data_record_type_isidx)        :: master
         type (ixtree)                        :: head
         type (ixtree), pointer               :: ixhead
         type (ixtree), pointer               :: ixptr
         logical                              :: found
      end type
!
      logical, parameter :: clean    = .true.
      logical, parameter :: is_debug = .false.
!
      private ixclean
      private delrec
      private putrec
      private split_block
      private findrec
      private next_rec
      private prev_rec
!
!  Two copies of the "pkf" file data types follow: 1) _isidx 2) _isdata
!
      type pk_record_isidx
         integer :: v_d_flag
         type (data_record_type_isidx) :: dat
      end type
      private pk_record_isidx
!
      type pk_block_defn_isidx
         character (len=128) :: name
         character (len=8) :: v_name
         integer :: v_num
         character (len=48) :: copyrt
         integer :: num_recs
         integer :: del_ptr
         integer :: rec_len
         integer :: num_indx
         integer :: rsv3
         integer :: rsv2
         integer :: rsv1
         logical :: writable
         integer :: unit
         integer :: hdr_len
         integer :: first_loc
      end type
      private pk_block_defn_isidx
!
      type (pk_record_isidx), private              :: pk_record_temp_isidx
      type (pk_block_defn_isidx), private, pointer :: pk_block_isidx
!
      private pk_file_create_isidx
      private pk_file_close_isidx
      private pk_get_record_isidx
      private pk_put_record_isidx
      private pk_delete_record_isidx
      private pk_file_open_isidx
      private pk_new_record_isidx
!
      type pk_record_isdata
         integer :: v_d_flag
         type (data_record_type_isdata) :: dat
      end type
      private pk_record_isdata
!
      type pk_block_defn_isdata
         character (len=128) :: name
         character (len=8) :: v_name
         integer :: v_num
         character (len=48) :: copyrt
         integer :: num_recs
         integer :: del_ptr
         integer :: rec_len
         integer :: num_indx
         integer :: rsv3
         integer :: rsv2
         integer :: rsv1
         logical :: writable
         integer :: unit
         integer :: hdr_len
         integer :: first_loc
      end type
      private pk_block_defn_isdata
!
      type (pk_record_isdata), private              :: pk_record_temp_isdata
      type (pk_block_defn_isdata), private, pointer :: pk_block_isdata
!
      private pk_file_create_isdata
      private pk_file_close_isdata
      private pk_get_record_isdata
      private pk_put_record_isdata
      private pk_delete_record_isdata
      private pk_file_open_isdata
      private pk_new_record_isdata
      private find_unit
!
      integer, parameter :: PKERR_ILLREC = -11
      integer, parameter :: PKERR_FILE = -12
      integer, parameter :: PKERR_MEM = -13
      integer, parameter :: PKERR_NOFILE = -14
!
      integer, save, private :: extended_error
!
contains
! ------------------------------------------------
!     public functions and subroutines
! ------------------------------------------------
      subroutine is_file_create (fname, unit1, unit2, err)
         implicit none
         character (len=*), intent (in) :: fname
         integer, intent (in), optional :: unit1
         integer, intent (in), optional :: unit2
         integer, intent (out), optional :: err
         integer :: ijerr, ierr, jerr, irec, unitu

         type (pk_block_defn_isidx), pointer :: tpkblk
         type (data_record_type_isidx) :: master
!
         ijerr = 0
         if (present(unit1)) then
            unitu = unit1
         else
            unitu = find_unit()
         end if
         call pk_file_create_isdata (fname, unit=unitu, err=ierr)
         if (present(unit2)) then
            unitu = unit2
         else
            unitu = find_unit()
         end if
         call pk_file_create_isidx (fname, unit=unitu, err=jerr)
         ijerr = abs (ierr) + abs (jerr)
         !print*,' IS files created ', err
         if (ijerr == 0) then
            tpkblk => pk_file_open_isidx (fname, unit=unitu, err=ierr)
            !print*,' IS open index created ', ierr
            master%level = 'B'
            master%ngood = 0
            if (clean) then
               master%index = 0 ! initialize - not really needed
               master%key = ' ' ! initialize - not really needed
            end if
            irec = pk_new_record_isidx (tpkblk, master, jerr)
            !print*,' IS write master index ',irec,jerr
            if (irec /= 1) then
               ijerr = ijerr + 100
            end if
            ijerr = ijerr + abs (ierr) + abs (jerr)
            call pk_file_close_isidx (tpkblk, ierr)
            ijerr = ijerr + abs (ierr)
         end if
         if( present (err)) err = ijerr
         !print*,' IS master created ', err
      end subroutine is_file_create
! ----------------------------------------------------------
      function is_file_open (fname, unit1, unit2, err) result (is_block)
         implicit none
         type (is_block_defn), pointer :: is_block
         character (len=*), intent (in) :: fname
         integer, intent (in), optional :: unit1
         integer, intent (in), optional :: unit2
         integer, intent (out), optional :: err
         integer :: ijerr, ierr, jerr, unitu
!
         allocate(is_block, stat=ijerr)
         is_block%found = .false.
         if (present(unit1)) then
            unitu = unit1
         else
            unitu = find_unit()
         end if
         is_block%pk_block => &
               &  pk_file_open_isdata (fname, unit=unitu, err=ierr)
!
         if (present(unit2)) then
            unitu = unit2
         else
            unitu = find_unit()
         end if
         is_block%isidx_block =>  &
               &  pk_file_open_isidx (fname, unit=unitu, err=jerr)
!
         ijerr =  ijerr + abs (ierr) + abs (jerr)
!
         is_block%head%ixrec => is_block%master
         is_block%ixhead => is_block%head
         is_block%ixptr => is_block%ixhead
         is_block%ixhead%ix_rno = 1
         is_block%found = .false.
         nullify (is_block%ixhead%prev)
         nullify (is_block%ixhead%next)
         if (ijerr == 0) then
            call pk_get_record_isidx (is_block%isidx_block,&
           & is_block%ixhead%ix_rno, is_block%master, ierr)
            ijerr = ijerr + abs (ierr)
         end if
         call is_pos_begin (is_block, ierr)
         ijerr = ijerr + abs (ierr)
         if (ijerr /= 0) then
            call pk_file_close_isdata(is_block%pk_block)
            call pk_file_close_isidx(is_block%isidx_block)
            deallocate(is_block)
         end if
         if (present (err)) err = ijerr
      end function is_file_open
! ----------------------------------------------------------
      subroutine is_get_record (is_block, is_key, data_record, err)
         implicit none
         type (is_block_defn), pointer :: is_block
         character (len=*), intent (in) :: is_key
         type (data_record_type_isdata), intent (out) :: data_record
         integer, intent (out), optional :: err
         integer :: ierr, irec
!
         if(.not. associated(is_block)) then
            ierr = -100
            if (present(err)) err = ierr
            return
         end if
         is_block%ixptr => is_block%ixhead
         irec = findrec (is_block, is_key)
         if (irec == 0) then
            ierr = 1
            is_block%found = .false.
            if (present(err)) err = ierr
            return
         end if
         is_block%found = .true.
         call pk_get_record_isdata (is_block%pk_block, irec, data_record, ierr)
         if (present(err)) err = ierr
      end subroutine is_get_record
! ----------------------------------------------------------
      subroutine is_put_record (is_block, data_record, err)
         implicit none
         type (is_block_defn), pointer :: is_block
         type (data_record_type_isdata), intent (in) :: data_record
         integer, intent (out), optional :: err
         integer :: ierr, irec
!
         if(.not. associated(is_block)) then
            ierr = -100
            if (present(err)) err = ierr
            return
         end if
         ierr = 0
         is_block%ixptr => is_block%ixhead
         irec = findrec (is_block, data_record%key)
         if (irec /= 0) then
            ierr = 1
            if (present(err)) err = ierr
            return
         end if
         !print*,' put record - ready to put '
         irec = pk_new_record_isdata (is_block%pk_block, data_record, ierr)
         if (ierr /= 0) then
            if (present(err)) err = ierr
            return
         end if
         call putrec (is_block, data_record%key, irec)
         if (present(err)) err = ierr
      end subroutine is_put_record
! ----------------------------------------------------------
      subroutine is_replace_record (is_block, data_record, err)
         implicit none
         type (is_block_defn), pointer :: is_block
         type (data_record_type_isdata) :: data_record
         integer, intent (out), optional :: err
         type (data_record_type_isdata) :: trec
         integer :: ierr, irec
!
         if(.not. associated(is_block)) then
            ierr = -100
            if (present(err)) err = ierr
            return
         end if
         is_block%ixptr => is_block%ixhead
         irec = findrec (is_block, data_record%key)
         if (irec == 0) then
            ierr = 1
            if (present(err)) err = ierr
            return
         end if
         !print*,' replace - found record to replace'
         call pk_get_record_isdata (is_block%pk_block, irec, trec, ierr)
         if (ierr /= 0) then
            if (present(err)) err = ierr
            return
         end if
         call pk_put_record_isdata (is_block%pk_block, irec, data_record, ierr)
         if (present(err)) err = ierr
         is_block%found = .true.
      end subroutine is_replace_record
! ----------------------------------------------------------
      subroutine is_delete_record (is_block, is_key, err)
         implicit none
         type (is_block_defn), pointer :: is_block
         character (len=*), intent (in) :: is_key
         integer, intent (out), optional :: err
         integer :: ierr, irec, ix
!
         if(.not. associated(is_block)) then
            ierr = -100
            if (present(err)) err = ierr
            return
         end if
         ierr = 0
         is_block%ixptr => is_block%ixhead
         irec = findrec (is_block, is_key)
         if (irec <= 0) then
            ierr = 1
            if (is_debug) print *, ' del_rec error1 ', irec
            if (present(err)) err = ierr
            return
         else
            call pk_delete_record_isdata (is_block%pk_block, irec, ierr)
            if (ierr /= 0) then
               if (present(err)) err = ierr
               if (is_debug) print *, ' del_rec error2 ', irec, ierr
               return
            end if
         end if
         !print*,' delete - found record to delete'
         call delrec (is_block)
         if (present(err)) err = ierr
! re-establish position for next sequential op.
         ix = findrec (is_block, is_key)
      end subroutine is_delete_record
! ----------------------------------------------------------
      subroutine is_file_close (is_block, err)
         implicit none
         type (is_block_defn), pointer :: is_block
         integer, intent (out), optional :: err
         integer :: ijerr, jerr, ierr, master_loc
!
         if(.not. associated(is_block)) then
            ierr = -100
            if (present(err)) err = ierr
            return
         end if
         is_block%ixptr => is_block%ixhead
         call ixclean (is_block%ixptr%next)
         master_loc = is_block%ixhead%ix_rno
         !print*,' close - write master at ',master_loc
         call pk_put_record_isidx (is_block%isidx_block, master_loc, &
           & is_block%master, ierr)
         ijerr = abs (ierr)
         call pk_file_close_isdata (is_block%pk_block, ierr)
         call pk_file_close_isidx (is_block%isidx_block, jerr)
         ijerr = ijerr + abs (ierr) + abs (jerr)
         deallocate(is_block, stat=ierr)
         ijerr = ijerr + abs (ierr)
         if (present(err)) err = ijerr
!
      end subroutine is_file_close
! ----------------------------------------------------------
      subroutine is_pos_begin (is_block, err)
         implicit none
         type (is_block_defn), pointer :: is_block
         integer, intent (out), optional :: err
         type (data_record_type_isidx), pointer :: iptr
         integer :: ierr, it, it_tmp
!
         if(.not. associated(is_block)) then
            ierr = -100
            if (present(err)) err = ierr
            return
         end if
         ierr = 0
         is_block%ixptr => is_block%ixhead
         is_block%ixptr%cur_pos = 1
         iptr => is_block%ixptr%ixrec
         do while (iptr%level /= 'B')
            it = is_block%ixptr%ixrec%index (1)
            it_tmp = -99
            if (associated(is_block%ixptr%next))   &
               & it_tmp = is_block%ixptr%next%ix_rno
            if ( .not. associated(is_block%ixptr%next) .or.  &
               & it_tmp /= it) then
               ! was -- & is_block%ixptr%next%ix_rno /= it) then
               call ixclean (is_block%ixptr%next)
               allocate (is_block%ixptr%next, stat=ierr)
               is_block%ixptr%next%prev => is_block%ixptr
               nullify (is_block%ixptr%next%next)
               nullify (is_block%ixptr%next%ixrec)
               it = is_block%ixptr%ixrec%index (1)
               is_block%ixptr => is_block%ixptr%next
               is_block%ixptr%ix_rno = it
               allocate (is_block%ixptr%ixrec, stat=ierr)
               iptr => is_block%ixptr%ixrec
               call pk_get_record_isidx (is_block%isidx_block, it,&
              & is_block%ixptr%ixrec, ierr)
               if (ierr /= 0) then
                  if (present(err)) err = ierr
                  return
               end if
            else
               is_block%ixptr => is_block%ixptr%next
            end if
            iptr => is_block%ixptr%ixrec
            is_block%ixptr%cur_pos = 1
         end do
         is_block%ixptr%cur_pos = 0
         is_block%found = .false.
         if (present(err)) err = ierr
      end subroutine is_pos_begin
! ----------------------------------------------------------
      subroutine is_pos_eof (is_block, err)
         implicit none
         type (is_block_defn), pointer :: is_block
         integer, intent (out), optional :: err
         type (data_record_type_isidx), pointer :: iptr
         integer :: ierr, it, it_tmp
!
         if(.not. associated(is_block)) then
            ierr = -100
            if (present(err)) err = ierr
            return
         end if
         ierr = 0
         is_block%ixptr => is_block%ixhead
         iptr => is_block%ixptr%ixrec
         is_block%ixptr%cur_pos = iptr%ngood
         do while (iptr%level /= 'B')
            it = iptr%index (iptr%ngood)
            it_tmp = -99
            if (associated(is_block%ixptr%next))  &
              & it_tmp = is_block%ixptr%next%ix_rno
            if ( .not. associated(is_block%ixptr%next) .or.  &
              & it_tmp /= it) then
               call ixclean (is_block%ixptr%next)
               allocate (is_block%ixptr%next, stat=ierr)
               is_block%ixptr%next%prev => is_block%ixptr
               nullify (is_block%ixptr%next%next)
               nullify (is_block%ixptr%next%ixrec)
               is_block%ixptr => is_block%ixptr%next
               is_block%ixptr%ix_rno = it
               allocate (is_block%ixptr%ixrec, stat=ierr)
               iptr => is_block%ixptr%ixrec
               call pk_get_record_isidx (is_block%isidx_block, it,&
              & is_block%ixptr%ixrec, ierr)
               it = is_block%ixptr%ixrec%index (iptr%ngood)
               if (ierr /= 0) then
                  if (present(err)) err = ierr
                  return
               end if
            else
               is_block%ixptr => is_block%ixptr%next
            end if
            iptr => is_block%ixptr%ixrec
            is_block%ixptr%cur_pos = iptr%ngood
         end do
         is_block%ixptr%cur_pos = iptr%ngood + 1
         is_block%found = .false.
         if (present(err)) err = ierr
      end subroutine is_pos_eof
! ----------------------------------------------------------
      subroutine is_get_next_record (is_block, data_record, err)
         implicit none
         type (is_block_defn), pointer :: is_block
         type (data_record_type_isdata), intent (out) :: data_record
         integer, optional, intent (out) :: err
         integer :: irec
         integer :: ierr
!
         if(.not. associated(is_block)) then
            ierr = -100
            if (present(err)) err = ierr
            return
         end if
         irec = next_rec (is_block)
         !print*,' call next_rec '
         if (irec <= 0) then
            ierr = -1
            if (present(err)) err = ierr
            return
         end if
         call pk_get_record_isdata (is_block%pk_block, irec, data_record, ierr)
         if (present(err)) err = ierr
      end subroutine is_get_next_record
! ----------------------------------------------------------
      subroutine is_get_prev_record (is_block, data_record, err)
         implicit none
         type (is_block_defn), pointer :: is_block
         type (data_record_type_isdata), intent (out) :: data_record
         integer, intent(out), optional :: err
         integer :: ierr, irec
!
         if(.not. associated(is_block)) then
            ierr = -100
            if (present(err)) err = ierr
            return
         end if
         irec = prev_rec (is_block)
         !print*,' call prev_rec '
         if (irec <= 0) then
            ierr = -1
            if (present(err)) err = ierr
            return
         end if
         call pk_get_record_isdata (is_block%pk_block, irec, data_record, ierr)
         if (present(err)) err = ierr
      end subroutine is_get_prev_record
! ----------------------------------------------------------
!     private functions and subroutines
! ----------------------------------------------------------
      recursive function findrec (is_block, is_key) result (irec)
         implicit none
         type (is_block_defn), pointer :: is_block
         character (len=*), intent (in) :: is_key
         integer :: irec
         type (data_record_type_isidx), pointer :: iptr
         integer :: err, is, ie, it, it_tmp
!
         iptr => is_block%ixptr%ixrec
         is = 1
         ie = iptr%ngood
         irec = 0
         is_block%found = .false.
         !print*,' findrec - start is/ie ',is,ie
         if (ie < is) then
            if (is_debug) print *, ' findrec - not found early return '
            is_block%ixptr%cur_pos = 0
            return
         end if
10       continue
         it = (is+ie+1) / 2
         if (is < ie) then
            if (is_key == iptr%key(it)) then
               go to 100
            else if (is_key > iptr%key(it)) then
               is = it
            else
               ie = it - 1
            end if
         else if (is == ie) then
            go to 100
         else
            it = is
            go to 100
         end if
         go to 10
!
100      continue
         if (it > iptr%ngood) it = iptr%ngood
         is_block%ixptr%cur_pos = it
         if (iptr%level == 'B') then
            irec = iptr%index (it)
            if (is_key == iptr%key(it)) then
               is_block%found = .true.
               return
            else if(it == 1 .and. is_key < iptr%key(it)) then
!      key is before first value in block
                is_block%ixptr%cur_pos = 0
            end if
            irec = 0
            !print*,' findrec - not found return '
            return
         end if
!
         !print*,' findrec - long index chain '
         it = iptr%index (it)
         it_tmp = -99
         if (associated(is_block%ixptr%next))  &
            & it_tmp = is_block%ixptr%next%ix_rno
         if (associated(is_block%ixptr%next) .and. &
            &  it_tmp == it) then
            is_block%ixptr => is_block%ixptr%next
         else
            call ixclean (is_block%ixptr%next)
            allocate (is_block%ixptr%next, stat=err)
            nullify (is_block%ixptr%next%next)
            is_block%ixptr%next%prev => is_block%ixptr
            is_block%ixptr => is_block%ixptr%next
            allocate (is_block%ixptr%ixrec, stat=err)
            is_block%ixptr%ix_rno = it
            !print*,' findrec - get isidx block ', it
            call pk_get_record_isidx (is_block%isidx_block, it,  &
               & is_block%ixptr%ixrec, err)
            iptr => is_block%ixptr%ixrec
            if (err /= 0) return
         end if
         !print*,' findrec - recurse,is_key ',is_key
         irec = findrec (is_block, is_key)
      end function findrec
! ----------------------------------------------------------
      subroutine delrec (is_block)
         implicit none
         type (is_block_defn), pointer :: is_block
         integer :: it, itn, ng
!
         !print*,' delrec called '
         ng = is_block%ixptr%ixrec%ngood
         it = is_block%ixptr%cur_pos
         if (ng > 1) then
            if (it /= ng) then
               is_block%ixptr%ixrec%index (it:ng-1) =  &
                  & is_block%ixptr%ixrec%index (it+1:ng)
               is_block%ixptr%ixrec%key (it:ng-1) =  &
                  & is_block%ixptr%ixrec%key (it+1:ng)
            end if
         end if
         if (clean) then
            is_block%ixptr%ixrec%index (ng) = 0
            is_block%ixptr%ixrec%key (ng) = ' '
         end if
         is_block%ixptr%ixrec%ngood = ng - 1
         ng = ng - 1
         call pk_put_record_isidx (is_block%isidx_block, &
              & is_block%ixptr%ix_rno, is_block%ixptr%ixrec)
         if ( .not. associated(is_block%ixptr%prev)) then
             return
         end if
! if empty node
         if (ng == 0) then
            call pk_delete_record_isidx (is_block%isidx_block, &
              & is_block%ixptr%ix_rno)
            is_block%ixptr => is_block%ixptr%prev
            ng = is_block%ixptr%ixrec%ngood
            it = is_block%ixptr%cur_pos
            if (is_debug) print *, ' delrec empty node ', it, ng
            if (ng > 1) then
               is_block%ixptr%ixrec%index (it:ng-1) = &
                  & is_block%ixptr%ixrec%index (it+1:ng)
               is_block%ixptr%ixrec%key (it:ng-1) = &
                  & is_block%ixptr%ixrec%key (it+1:ng)
            end if
            if (clean) then
               is_block%ixptr%ixrec%index (ng) = 0
               is_block%ixptr%ixrec%key (ng) = ' '
            end if
            is_block%ixptr%ixrec%ngood = ng - 1
            ng = ng - 1
            ! special case when deleteing last record on the file
            if (ng == 0) is_block%ixptr%ixrec%level = 'B'
            call pk_put_record_isidx (is_block%isidx_block, &
           & is_block%ixptr%ix_rno, is_block%ixptr%ixrec)
         end if
! collapse index if only 1 entry, and not at the top
         if ((associated(is_block%ixptr%prev)) .and. (ng == 1) .and.&
        & (is_block%ixptr%ixrec%level /= 'B')) then
            is_block%ixptr => is_block%ixptr%prev
            it = is_block%ixptr%cur_pos
            !print*,' delrec collapse node ',it
            is_block%ixptr%ixrec%key (it) = is_block%ixptr%next%ixrec%key(1)
            is_block%ixptr%ixrec%index (it) = is_block%ixptr%next%ixrec%index(1)
            is_block%ixptr%next%ixrec%ngood = 0
            call pk_delete_record_isidx (is_block%isidx_block, &
           & is_block%ixptr%next%ix_rno)
            call pk_put_record_isidx (is_block%isidx_block, &
           & is_block%ixptr%ix_rno, is_block%ixptr%ixrec)
         end if
! in any case, if deleting the first index, trace back up the tree.
         do while ((it ==  1) .and. associated(is_block%ixptr%prev))
            is_block%ixptr => is_block%ixptr%prev
            itn = is_block%ixptr%cur_pos
            !print*,' delrec first node trace ',it,itn
            is_block%ixptr%ixrec%key (itn) = is_block%ixptr%next%ixrec%key (it)
            call pk_put_record_isidx (is_block%isidx_block, &
              & is_block%ixptr%ix_rno, is_block%ixptr%ixrec)
            it = itn
         end do
      end subroutine delrec
! ----------------------------------------------------------
      recursive subroutine ixclean (tptr)
         implicit none
         type (ixtree), pointer :: tptr
         integer :: err
!
         !print*,' ixclean called '
         if ( .not. associated(tptr)) return
         if (associated(tptr%next)) call ixclean (tptr%next)
         !print*,' ixclean - dealloc ',tptr%cur_pos, tptr%ix_rno
         deallocate (tptr%ixrec, stat=err)
         deallocate (tptr, stat=err)
      end subroutine ixclean
! ----------------------------------------------------------
      subroutine putrec (is_block, is_key, iloc)
         implicit none
         type (is_block_defn), pointer :: is_block
         character (len=*), intent (in) :: is_key
         integer, intent (in) :: iloc
         type (data_record_type_isidx), pointer :: iptr
         type (ixtree), pointer :: tptr
         integer :: it
!
         !print*,' putrec - ngood ',is_block%ixptr % ixrec % ngood
         if (is_block%ixptr%ixrec%ngood == maxitbl) then
! must split block
            !print*,'  putrec - call split block'
            call split_block (is_block, is_key)
         end if
!
         iptr => is_block%ixptr%ixrec
         !if(.not.associated(iptr)) print*,' putrec - not associated'
         it = is_block%ixptr%cur_pos
         if ((it < 1) .or. ((it == 1) .and. (is_key < iptr%key(1)))) then
         !print*,' putrec - add at beginning of block ',it,'*',is_key,'*',iptr % key(1),'*'
! add before the first entry of a block
            it = 1
            is_block%ixptr%cur_pos = it
            if (iptr%ngood >= maxitbl) stop ' error - putrec1 table&
           & full '
            if (iptr%ngood >= 1) then
               iptr%key (2:iptr%ngood+1) = iptr%key (1:iptr%ngood)
               iptr%index (2:iptr%ngood+1) = iptr%index (1:iptr%ngood)
            end if
            iptr%ngood = iptr%ngood + 1
            iptr%key (1) = is_key
            iptr%index (1) = iloc
!   since we have just added an entry at the beginning of the block,
!   we have to trace all the way up the tree and change the first entry,
!   if it is the first entry, of all the upper level blocks.
            tptr => is_block%ixptr
            do while (associated(tptr%prev))
               tptr => tptr%prev
               if (tptr%cur_pos /= 1) exit  ! no longer the first entry
               tptr%ixrec%key (1) = is_key
               !print*,' putrec1 - write isidx at record ',tptr % ix_rno
               call pk_put_record_isidx (is_block%isidx_block, tptr%ix_rno,&
              & tptr%ixrec)
            end do
         else
            if (iptr%ngood >= maxitbl) stop ' error - putrec2 table&
           & full '
!  somewhere in the middle, or at the end of a block
            it = it + 1
            !print*,' putrec - add in middle/end of block ',it
            is_block%ixptr%cur_pos = it
            if (it <= iptr%ngood) then ! not at end
               iptr%key (it+1:iptr%ngood+1) = iptr%key (it:iptr%ngood)
               iptr%index (it+1:iptr%ngood+1) = iptr%index (it:iptr%ngood)
            end if
            iptr%ngood = iptr%ngood + 1
            iptr%key (it) = is_key
            iptr%index (it) = iloc
         end if
         !print*,' putrec2 - write isidx at record ',is_block%ixptr % ix_rno
         call pk_put_record_isidx (is_block%isidx_block, &
            & is_block%ixptr%ix_rno, iptr)
!
      end subroutine putrec
! ----------------------------------------------------------
      subroutine split_block (is_block, is_key)
         implicit none
         type (is_block_defn), pointer :: is_block
         character (len=*), intent(in) :: is_key
         type (data_record_type_isidx), pointer :: iptr
         integer :: ng, nng, ih, it, newloc, err
         logical :: top
!
         !if(.not.associated(is_block%ixptr%ixrec)) print*,' split_block - not associated'
         main_loop: do while (is_block%ixptr%ixrec%ngood == maxitbl)
            top = .not. associated (is_block%ixptr%prev)
            if (top) then
               ng = 0
            else
               ng = is_block%ixptr%prev%ixrec%ngood
            end if
            do while (( .not. top) .and. ng == maxitbl)
               is_block%ixptr => is_block%ixptr%prev
               top = .not. associated (is_block%ixptr%prev)
               if (top) then
                  ng = 0
               else
                  ng = is_block%ixptr%prev%ixrec%ngood
               end if
            end do
!
            if (top) then
               ih = maxitbl / 2
               allocate (iptr, stat=err)
               iptr%ngood = ih
               iptr%level = is_block%ixptr%ixrec%level
               iptr%key (1:ih) = is_block%ixptr%ixrec%key (1:ih)
               iptr%index (1:ih) = is_block%ixptr%ixrec%index (1:ih)
               if (clean) then
                  iptr%index (ih+1:maxitbl) = 0
                  iptr%key (ih+1:maxitbl) = ' '
               end if
               newloc = pk_new_record_isidx (is_block%isidx_block, iptr)
               is_block%ixptr%ixrec%index (1) = newloc
               ng = is_block%ixptr%ixrec%ngood
               nng = ng - ih
               ih = ih + 1
               iptr%ngood = nng
               iptr%key (1:nng) = is_block%ixptr%ixrec%key (ih:ng)
               iptr%index (1:nng) = is_block%ixptr%ixrec%index (ih:ng)
               if (clean) then
                  iptr%index (nng+1:maxitbl) = 0
                  iptr%key (nng+1:maxitbl) = ' '
               end if
               is_block%ixptr%ixrec%ngood = 2
               is_block%ixptr%ixrec%level = 'I'
               is_block%ixptr%ixrec%key (2) = iptr%key (1)
               newloc = pk_new_record_isidx (is_block%isidx_block, iptr)
               is_block%ixptr%ixrec%index (2) = newloc
               if (clean) then
                  is_block%ixptr%ixrec%index (3:maxitbl) = 0
                  is_block%ixptr%ixrec%key (3:maxitbl) = ' '
               end if
               !print*,' splitblock - write isidx at record ',is_block%ixptr % ix_rno
               call pk_put_record_isidx (is_block%isidx_block, &
                 & is_block%ixptr%ix_rno, is_block%ixptr%ixrec)
               deallocate (iptr, stat=err)
            else
!   not at the top.
!   split block into two, guarenteed prev block has at least one space
               ng = is_block%ixptr%ixrec%ngood
!   choice: split at (or near) insertion point.
               ih = Max (3, Min(ng-2, is_block%ixptr%cur_pos))
!   other choice: split in half.
           !   ih = maxitbl / 2      ! half way split
               allocate (iptr, stat=err)
               iptr%level = is_block%ixptr%ixrec%level
               nng = ng - ih
               ih = ih + 1
               iptr%ngood = nng
               iptr%key (1:nng) = is_block%ixptr%ixrec%key (ih:ng)
               iptr%index (1:nng) = is_block%ixptr%ixrec%index (ih:ng)
               if (clean) then
                  iptr%index (nng+1:maxitbl) = 0
                  iptr%key (nng+1:maxitbl) = ' '
                  is_block%ixptr%ixrec%index (ih:maxitbl) = 0
                  is_block%ixptr%ixrec%key (ih:maxitbl) = ' '
               end if
               is_block%ixptr%ixrec%ngood = ih - 1
               !print*,' splitblock2 - write isidx at record ',is_block%ixptr % ix_rno
               call pk_put_record_isidx (is_block%isidx_block, &
                  & is_block%ixptr%ix_rno, is_block%ixptr%ixrec)
               newloc = pk_new_record_isidx (is_block%isidx_block, iptr)
               is_block%ixptr => is_block%ixptr%prev
!     insert new key into previous index block
               it = is_block%ixptr%cur_pos
               if (is_block%ixptr%ixrec%ngood >= maxitbl) &
                  & stop ' error - splitblock table full '
               !print*,' splitblock inserting at upper level ', it,is_block%ixptr%ixrec%ngood
               if (it == is_block%ixptr%ixrec%ngood) then
!     insert at end of block - don't have to move stuff around
                  is_block%ixptr%ixrec%ngood = is_block%ixptr%ixrec%ngood + 1
                  is_block%ixptr%ixrec%key (is_block%ixptr%ixrec%ngood) = &
                     & iptr%key (1)
                  is_block%ixptr%ixrec%index (is_block%ixptr%ixrec%ngood) = &
                     & newloc
               else
                  ng = is_block%ixptr%ixrec%ngood
                  it = it + 1
                  is_block%ixptr%ixrec%key (it+1:ng+1) = &
                     & is_block%ixptr%ixrec%key (it:ng)
                  is_block%ixptr%ixrec%index (it+1:ng+1) = &
                     & is_block%ixptr%ixrec%index&
                 & (it:ng)
                  is_block%ixptr%ixrec%ngood = is_block%ixptr%ixrec%ngood + 1
                  is_block%ixptr%ixrec%key (it) = iptr%key (1)
                  is_block%ixptr%ixrec%index (it) = newloc
               end if
               !print*,' splitblock3 - write isidx at record ',is_block%ixptr % ix_rno
               call pk_put_record_isidx (is_block%isidx_block, &
                 & is_block%ixptr%ix_rno, is_block%ixptr%ixrec)
               deallocate (iptr, stat=err)
            end if
!  re-establish ixtree for current record
            is_block%ixptr => is_block%ixhead
            it = findrec (is_block, is_key)
         end do main_loop
      end subroutine split_block
! ----------------------------------------------------------
      function next_rec (is_block) result (irec)
         implicit none
         type (is_block_defn), pointer :: is_block
         integer :: irec
         type (ixtree), pointer :: tptr
         integer :: err, it
!
         if (is_block%ixptr%cur_pos < is_block%ixptr%ixrec%ngood) then
            is_block%ixptr%cur_pos = is_block%ixptr%cur_pos + 1
            irec = is_block%ixptr%ixrec%index (is_block%ixptr%cur_pos)
            is_block%found = .true.
         else if (is_block%ixptr%ixrec%ngood <= is_block%ixptr%cur_pos) then
            tptr => is_block%ixptr
10          if (associated(tptr%prev)) then
               tptr => tptr%prev
            else
               is_block%found = .false.
               irec = -1
               return
            end if
            if (tptr%ixrec%ngood == tptr%cur_pos) go to 10
            is_block%ixptr => tptr
! done going up the tree, now go back down
            call ixclean (is_block%ixptr%next)
            is_block%ixptr%cur_pos = is_block%ixptr%cur_pos + 1
            do while (is_block%ixptr%ixrec%level /= 'B')
               allocate (is_block%ixptr%next, stat=err)
               !if(err .ne. 0) print*,' next_rec err1'
               nullify (is_block%ixptr%next%next)
               nullify (is_block%ixptr%ixrec)
               is_block%ixptr%next%prev => is_block%ixptr
               it = is_block%ixptr%ixrec%index (is_block%ixptr%cur_pos)
               is_block%ixptr => is_block%ixptr%next
               is_block%ixptr%cur_pos = 1
               is_block%ixptr%ix_rno = it
               allocate (is_block%ixptr%ixrec, stat=err)
               !if(err .ne. 0) print*,' next_rec err2'
               !print*,' next_rec - get record = ',it
               call pk_get_record_isidx (is_block%isidx_block, it,&
              & is_block%ixptr%ixrec, err)
            end do
            irec = is_block%ixptr%ixrec%index (is_block%ixptr%cur_pos)
            is_block%found = .true.
         else
            is_block%found = .false.
            irec = -1
         end if
      end function next_rec
! ----------------------------------------------------------
      function prev_rec (is_block) result (irec)
         implicit none
         type (is_block_defn), pointer :: is_block
         integer :: irec
         type (ixtree), pointer :: tptr
         integer :: err, it
!
         if (is_block%found) then
            if (is_block%ixptr%cur_pos > 1) then
               is_block%ixptr%cur_pos = is_block%ixptr%cur_pos - 1
               irec = is_block%ixptr%ixrec%index (is_block%ixptr%cur_pos)
               return
            else if (is_block%ixptr%cur_pos /= 0) then
               tptr => is_block%ixptr
10             if (associated(tptr%prev)) then
                  tptr => tptr%prev
               else
                  is_block%found = .false.
                  irec = -1
                  return
               end if
               if (tptr%cur_pos == 1) go to 10
               is_block%ixptr => tptr
! done going up the tree, now go back down
               call ixclean (is_block%ixptr%next)
               is_block%ixptr%cur_pos = is_block%ixptr%cur_pos - 1
               do while (is_block%ixptr%ixrec%level /= 'B')
                  allocate (is_block%ixptr%next, stat=err)
                  nullify (is_block%ixptr%next%next)
                  nullify (is_block%ixptr%ixrec)
                  is_block%ixptr%next%prev => is_block%ixptr
                  it = is_block%ixptr%ixrec%index (is_block%ixptr%cur_pos)
                  is_block%ixptr => is_block%ixptr%next
                  is_block%ixptr%ix_rno = it
                  allocate (is_block%ixptr%ixrec, stat=err)
                  !print*,' prev_rec - get record = ',it
                  call pk_get_record_isidx (is_block%isidx_block, it,&
                 & is_block%ixptr%ixrec, err)
                  is_block%ixptr%cur_pos = is_block%ixptr%ixrec%ngood
               end do
               irec = is_block%ixptr%ixrec%index (is_block%ixptr%ixrec%ngood)
               is_block%found = .true.
               return
            else
               is_block%found = .false.
               irec = -1
               return
            end if
         else ! not found
            if (is_block%ixptr%cur_pos > is_block%ixptr%ixrec%ngood) then
               irec = is_block%ixptr%ixrec%index (is_block%ixptr%ixrec%ngood)
               is_block%ixptr%cur_pos = is_block%ixptr%ixrec%ngood
            else if (is_block%ixptr%cur_pos == 0) then
               is_block%found = .false.
               irec = -1
               return
            else
               irec = is_block%ixptr%ixrec%index (is_block%ixptr%cur_pos)
            end if
            is_block%found = .true.
         end if
      end function prev_rec
! ----------------------------------------------------------
!
!     "pkf" version for _isidx
!
      subroutine pk_file_create_isidx (name, unit, err)
         implicit none
         character (len=*), intent (in) :: name
         integer, intent (in), optional :: unit
         integer, intent (out), optional :: err
         type (pk_record_isidx), pointer :: ptr_pk
!
         integer :: lenf
         integer :: ierr
         integer :: unitu
         integer :: lenhdr
         type (pk_block_defn_isidx), pointer :: pk_block_isidx
         character (len=128) :: fname
!
         extended_error = 0
         if (present(unit)) then
            unitu = unit
         else
            unitu = find_unit ()
            if (unitu <= 0) then
               ierr = PKERR_NOFILE
               go to 99
            end if
         end if
         allocate (ptr_pk)
         inquire (iolength=lenf) ptr_pk
         deallocate (ptr_pk)
         lenf = ((lenf+7)/8)*8
         !print*,' created length is ',lenf
!
         allocate (pk_block_isidx)
         inquire (iolength=lenhdr) pk_block_isidx
         pk_block_isidx%name = name
         pk_block_isidx%copyrt = 'Copyright(c) Garnatz and Grovender,&
        & Inc. 1995.'
         pk_block_isidx%v_name = 'isidx_fl'
         pk_block_isidx%v_num = 102
         pk_block_isidx%num_recs = 0
         pk_block_isidx%del_ptr = 0
         pk_block_isidx%rec_len = lenf
         pk_block_isidx%num_indx = 0
         pk_block_isidx%rsv1 = 0
         pk_block_isidx%rsv2 = 0
         pk_block_isidx%rsv3 = 0
         pk_block_isidx%writable = .true.
         pk_block_isidx%unit = -1
         pk_block_isidx%first_loc = Max (1, (lenhdr-1) /lenf+1)
         pk_block_isidx%hdr_len = lenhdr
         !print*,' created header/ first_loc ',lenhdr,pk_block_isidx % first_loc
         ierr = 0
         fname = trim (name) // '.ix'
         open (unit=unitu, file=fname, status='new', access='direct',&
        & recl=lenhdr, form='unformatted', action='write', iostat=ierr,&
        & err=98)
         write (unitu, iostat=ierr, rec=1, err=98) pk_block_isidx
         close (unitu, iostat=ierr)
         if (ierr /= 0) go to 98
         deallocate (pk_block_isidx, stat=ierr)
         if (ierr /= 0) then
            extended_error = ierr
            ierr = PKERR_MEM
         end if
         go to 99
98       continue
         extended_error = ierr
         ierr = PKERR_FILE
99       continue
         if (present(err)) then
            if (ierr /= 0) then
               err = ierr
            else
               err = 0
            end if
         end if
      end subroutine pk_file_create_isidx
! ----------------------------------------------------------
      function pk_file_open_isidx (name, unit, action, err) result&
     & (pk_block_isidx)
         implicit none
         character (len=*), intent (in) :: name
         integer, intent (in), optional :: unit
         character (len=*), optional, intent (in) :: action
         integer, intent (out), optional :: err
!
         type (pk_block_defn_isidx), pointer :: pk_block_isidx
         integer :: ierr
         integer :: unitu
         integer :: lenhdr
         character (len=128) :: fname
         character (len=9) :: my_action
!
         extended_error = 0
         if (present(unit)) then
            unitu = unit
         else
            unitu = find_unit ()
            if (unitu <= 0) then
               ierr = PKERR_NOFILE
               go to 99
            end if
         end if
!
         if (present(action)) then
            my_action = action
         else
            my_action = 'readwrite'
         end if
!
         ierr = 0
         nullify (pk_block_isidx)
         allocate (pk_block_isidx, stat=ierr)
         if (ierr /= 0) go to 99
         inquire (iolength=lenhdr) pk_block_isidx
! open key file header and read control information
         fname = trim (name) // '.ix'
         !print*, ' open header file ', lenhdr
         open (unit=unitu, file=fname, status='old', access='direct',&
        & recl=lenhdr, form='unformatted', action=my_action,&
        & iostat=ierr, err=98)
         if (ierr /= 0) go to 98
         read (unit=unitu, rec=1, iostat=ierr, err=98) pk_block_isidx
         pk_block_isidx%unit = unitu
         pk_block_isidx%name = fname
         close (unit=unitu, iostat=ierr, err=98)
! open data file
         !print*, ' open data file ', pk_block_isidx%rec_len
         open (unit=unitu, file=fname, access='direct', &
        & recl=pk_block_isidx%rec_len, form='unformatted',&
        & action='readwrite', iostat=ierr, err=98)
         if (present(err)) then
            err = ierr
         end if
         return
98       continue
         extended_error = ierr
         if (present(err)) then
            err = PKERR_FILE
         end if
         return
99       continue
         if (present(err)) then
            err = PKERR_MEM
         end if
      end function pk_file_open_isidx
! ----------------------------------------------------------
      subroutine pk_file_close_isidx (pk_block_isidx, err)
         implicit none
         integer, intent (out), optional :: err
         type (pk_block_defn_isidx), pointer :: pk_block_isidx
!
         integer :: ierr
         character (len=128) :: fname
!
         extended_error = 0
         ierr = 0
         if ((pk_block_isidx%unit <= 0) .or.  &
        & ( .not. pk_block_isidx%writable)) then
            ierr = PKERR_ILLREC
            go to 97
         end if
! close data file
         close (unit=pk_block_isidx%unit, iostat=ierr, err=99)
! open, update, and close control file
         fname = pk_block_isidx%name
         open (unit=pk_block_isidx%unit, file=fname, status='old',&
        & recl=pk_block_isidx%hdr_len, access='direct', form='unformatted&
        &', action='readwrite', iostat=ierr, err=99)
         if (ierr /= 0) go to 99
         write (unit=pk_block_isidx%unit, rec=1, iostat=ierr, err=99)&
        & pk_block_isidx
         close (unit=pk_block_isidx%unit, iostat=ierr, err=99)
         deallocate (pk_block_isidx, stat=ierr)
97       continue
         if (present(err)) then
            err = ierr
         end if
         return
99       continue
         extended_error = ierr
         if (present(err)) then
            err = PKERR_FILE
         end if
      end subroutine pk_file_close_isidx
! ----------------------------------------------------------
      subroutine pk_get_record_isidx (pk_block_isidx, pk_rno, data_record,&
     & err)
         implicit none
         type (pk_block_defn_isidx), pointer :: pk_block_isidx
         integer, intent (in) :: pk_rno
         type (data_record_type_isidx), intent (out) :: data_record
         integer, intent (out), optional :: err
!
         integer :: ierr
!
         ierr = 0
         extended_error = 0
         if ((pk_rno <= 0) .or. (pk_rno > pk_block_isidx%num_recs)) then
            ierr = PKERR_ILLREC
            go to 99
         end if
         read (unit=pk_block_isidx%unit, rec= &
           & pk_rno+pk_block_isidx%first_loc, iostat=ierr, err=98) &
           & pk_record_temp_isidx
         data_record = pk_record_temp_isidx%dat
         if (pk_record_temp_isidx%v_d_flag /= -1) then
            ierr = PKERR_ILLREC
         end if
         go to 99
98       continue
         extended_error = ierr
         ierr = PKERR_FILE
99       continue
         if (present(err)) then
            err = ierr
         end if
      end subroutine pk_get_record_isidx
! ----------------------------------------------------------
      subroutine pk_put_record_isidx (pk_block_isidx, pk_rno, data_record,&
     & err)
         implicit none
         type (pk_block_defn_isidx), pointer :: pk_block_isidx
         integer, intent (in) :: pk_rno
         type (data_record_type_isidx), intent (in) :: data_record
         integer, intent (out), optional :: err
!
         integer :: ierr
!
         ierr = 0
         extended_error = 0
         pk_record_temp_isidx%dat = data_record
         pk_record_temp_isidx%v_d_flag = -1
         write (unit=pk_block_isidx%unit, rec= &
            & pk_rno+pk_block_isidx%first_loc, iostat=ierr, err=99) &
            & pk_record_temp_isidx
99       continue
         if (present(err)) then
            err = ierr
         end if
      end subroutine pk_put_record_isidx
! ----------------------------------------------------------
      function pk_new_record_isidx (pk_block_isidx, data_record, err)&
     & result (rno)
         implicit none
         type (pk_block_defn_isidx), pointer :: pk_block_isidx
         integer :: rno
         type (data_record_type_isidx), intent (in) :: data_record
         integer, intent (out), optional :: err
!
         integer :: ierr
!
         ierr = 0
         extended_error = 0
         if (pk_block_isidx%del_ptr > 0) then
            rno = pk_block_isidx%del_ptr
            read (unit=pk_block_isidx%unit, rec= &
              & rno+pk_block_isidx%first_loc, iostat=ierr, err=99) &
              & pk_record_temp_isidx
            if (ierr /= 0) then
               rno = -1
               go to 99
            end if
            pk_block_isidx%del_ptr = pk_record_temp_isidx%v_d_flag
         else
            pk_block_isidx%num_recs = pk_block_isidx%num_recs + 1
            rno = pk_block_isidx%num_recs
         end if
!
         pk_record_temp_isidx%v_d_flag = -1
         pk_record_temp_isidx%dat = data_record
         write (unit=pk_block_isidx%unit, rec=rno+pk_block_isidx%first_loc,&
        & iostat=ierr, err=99) pk_record_temp_isidx
!
         if (present(err)) err = ierr
         return
99       continue
         extended_error = ierr
         if (present(err)) then
            err = PKERR_FILE
         end if
      end function pk_new_record_isidx
! ----------------------------------------------------------
      subroutine pk_delete_record_isidx (pk_block_isidx, pk_rno, err)
         implicit none
         type (pk_block_defn_isidx), pointer :: pk_block_isidx
         integer, intent (in) :: pk_rno
         integer, intent (out), optional :: err
!
         type (data_record_type_isidx) :: data_record
         integer :: ierr
!
         ierr = 0
         call pk_get_record_isidx (pk_block_isidx, pk_rno, data_record,&
        & ierr)
         if (ierr /= 0) go to 99
         pk_record_temp_isidx%v_d_flag = pk_block_isidx%del_ptr
         pk_block_isidx%del_ptr = pk_rno
!
         write (unit=pk_block_isidx%unit, rec= &
           & pk_rno+pk_block_isidx%first_loc, iostat=ierr, err=99) &
           & pk_record_temp_isidx
         if (present(err)) err = ierr
         return
99       continue
         extended_error = ierr
         if (present(err)) then
            err = PKERR_FILE
         end if
      end subroutine pk_delete_record_isidx
!
! ----------------------------------------------------------
!     "pkf" version for _isdata
!
      subroutine pk_file_create_isdata (name, unit, err)
         implicit none
         character (len=*), intent (in) :: name
         integer, intent (in), optional :: unit
         integer, intent (out), optional :: err
         type (pk_record_isdata), pointer :: ptr_pk
!
         integer :: lenf
         integer :: ierr
         integer :: unitu
         integer :: lenhdr
         type (pk_block_defn_isdata), pointer :: pk_block_isdata
         character (len=128) :: fname
!
         extended_error = 0
         if (present(unit)) then
            unitu = unit
         else
            unitu = find_unit ()
            if (unitu <= 0) then
               ierr = PKERR_NOFILE
               go to 99
            end if
         end if
         allocate (ptr_pk)
         inquire (iolength=lenf) ptr_pk
         deallocate (ptr_pk)
         lenf = ((lenf+7)/8)*8
         !print*,' created length is ',lenf
!
         allocate (pk_block_isdata)
         inquire (iolength=lenhdr) pk_block_isdata
         pk_block_isdata%name = name
         pk_block_isdata%copyrt = 'Copyright(c) Garnatz and Grovender,&
        & Inc. 1995.'
         pk_block_isdata%v_name = 'isdata_f'
         pk_block_isdata%v_num = 102
         pk_block_isdata%num_recs = 0
         pk_block_isdata%del_ptr = 0
         pk_block_isdata%rec_len = lenf
         pk_block_isdata%num_indx = 0
         pk_block_isdata%rsv1 = 0
         pk_block_isdata%rsv2 = 0
         pk_block_isdata%rsv3 = 0
         pk_block_isdata%writable = .true.
         pk_block_isdata%unit = -1
         pk_block_isdata%first_loc = Max (1, (lenhdr-1) /lenf+1)
         pk_block_isdata%hdr_len = lenhdr
         !print*,' created header/ first_loc ',lenhdr,pk_block_isdata % first_loc
         ierr = 0
         fname = trim (name) // '.dt'
         open (unit=unitu, file=fname, status='new', access='direct',&
        & recl=lenhdr, form='unformatted', action='write', iostat=ierr,&
        & err=98)
         write (unitu, iostat=ierr, rec=1, err=98) pk_block_isdata
         close (unitu, iostat=ierr)
         if (ierr /= 0) go to 98
         deallocate (pk_block_isdata, stat=ierr)
         if (ierr /= 0) then
            extended_error = ierr
            ierr = PKERR_MEM
         end if
         go to 99
98       continue
         extended_error = ierr
         ierr = PKERR_FILE
99       continue
         if (present(err)) then
            if (ierr /= 0) then
               err = ierr
            else
               err = 0
            end if
         end if
      end subroutine pk_file_create_isdata
! ----------------------------------------------------------
      function pk_file_open_isdata (name, unit, action, err) result&
     & (pk_block_isdata)
         implicit none
         character (len=*), intent (in) :: name
         integer, intent (in), optional :: unit
         character (len=*), optional, intent (in) :: action
         integer, intent (out), optional :: err
!
         type (pk_block_defn_isdata), pointer :: pk_block_isdata
         integer :: ierr
         integer :: unitu
         integer :: lenhdr
         character (len=128) :: fname
         character (len=9) :: my_action
!
         extended_error = 0
         if (present(unit)) then
            unitu = unit
         else
            unitu = find_unit ()
            if (unitu <= 0) then
               ierr = PKERR_NOFILE
               go to 99
            end if
         end if
!
         if (present(action)) then
            my_action = action
         else
            my_action = 'readwrite'
         end if
!
         ierr = 0
         nullify (pk_block_isdata)
         allocate (pk_block_isdata, stat=ierr)
         if (ierr /= 0) go to 99
         inquire (iolength=lenhdr) pk_block_isdata
! open key file header and read control information
         fname = trim (name) // '.dt'
         !print*, ' open header file ', lenhdr
         open (unit=unitu, file=fname, status='old', access='direct',&
        & recl=lenhdr, form='unformatted', action=my_action,&
        & iostat=ierr, err=98)
         if (ierr /= 0) go to 98
         read (unit=unitu, rec=1, iostat=ierr, err=98) pk_block_isdata
         pk_block_isdata%unit = unitu
         pk_block_isdata%name = fname
         close (unit=unitu, iostat=ierr, err=98)
! open data file
         !print*, ' open data file ', pk_block_isdata%rec_len
         open (unit=unitu, file=fname, access='direct', &
        & recl=pk_block_isdata%rec_len, form='unformatted',&
        & action='readwrite', iostat=ierr, err=98)
         if (present(err)) then
            err = ierr
         end if
         return
98       continue
         extended_error = ierr
         if (present(err)) then
            err = PKERR_FILE
         end if
         return
99       continue
         if (present(err)) then
            err = PKERR_MEM
         end if
      end function pk_file_open_isdata
! ----------------------------------------------------------
      subroutine pk_file_close_isdata (pk_block_isdata, err)
         implicit none
         integer, intent (out), optional :: err
         type (pk_block_defn_isdata), pointer :: pk_block_isdata
!
         integer :: ierr
         character (len=128) :: fname
!
         extended_error = 0
         ierr = 0
         if ((pk_block_isdata%unit <= 0) .or.  &
        & ( .not. pk_block_isdata%writable)) then
            ierr = PKERR_ILLREC
            go to 97
         end if
! close data file
         close (unit=pk_block_isdata%unit, iostat=ierr, err=99)
! open, update, and close control file
         fname = pk_block_isdata%name
         open (unit=pk_block_isdata%unit, file=fname, status='old',&
        & recl=pk_block_isdata%hdr_len, access='direct', form='unformatted&
        &', action='readwrite', iostat=ierr, err=99)
         if (ierr /= 0) go to 99
         write (unit=pk_block_isdata%unit, rec=1, iostat=ierr, err=99)&
        & pk_block_isdata
         close (unit=pk_block_isdata%unit, iostat=ierr, err=99)
         deallocate (pk_block_isdata, stat=ierr)
97       continue
         if (present(err)) then
            err = ierr
         end if
         return
99       continue
         extended_error = ierr
         if (present(err)) then
            err = PKERR_FILE
         end if
      end subroutine pk_file_close_isdata
! ----------------------------------------------------------
      subroutine pk_get_record_isdata (pk_block_isdata, pk_rno, data_record,&
     & err)
         implicit none
         type (pk_block_defn_isdata), pointer :: pk_block_isdata
         integer, intent (in) :: pk_rno
         type (data_record_type_isdata), intent (out) :: data_record
         integer, intent (out), optional :: err
!
         integer :: ierr
!
         ierr = 0
         extended_error = 0
         if ((pk_rno <= 0) .or. (pk_rno > pk_block_isdata%num_recs)) then
            ierr = PKERR_ILLREC
            go to 99
         end if
         read (unit=pk_block_isdata%unit, rec= &
           & pk_rno+pk_block_isdata%first_loc, iostat=ierr, err=98) &
           & pk_record_temp_isdata
         data_record = pk_record_temp_isdata%dat
         if (pk_record_temp_isdata%v_d_flag /= -1) then
            ierr = PKERR_ILLREC
         end if
         go to 99
98       continue
         extended_error = ierr
         ierr = PKERR_FILE
99       continue
         if (present(err)) then
            err = ierr
         end if
      end subroutine pk_get_record_isdata
! ----------------------------------------------------------
      subroutine pk_put_record_isdata (pk_block_isdata, pk_rno, data_record,&
     & err)
         implicit none
         type (pk_block_defn_isdata), pointer :: pk_block_isdata
         integer, intent (in) :: pk_rno
         type (data_record_type_isdata), intent (in) :: data_record
         integer, intent (out), optional :: err
!
         integer :: ierr
!
         ierr = 0
         extended_error = 0
         pk_record_temp_isdata%dat = data_record
         pk_record_temp_isdata%v_d_flag = -1
         write (unit=pk_block_isdata%unit, rec= &
           & pk_rno+pk_block_isdata%first_loc, iostat=ierr, err=99) &
           & pk_record_temp_isdata
99       continue
         if (present(err)) then
            err = ierr
         end if
      end subroutine pk_put_record_isdata
! ----------------------------------------------------------
      function pk_new_record_isdata (pk_block_isdata, data_record, err)&
     & result (rno)
         implicit none
         type (pk_block_defn_isdata), pointer :: pk_block_isdata
         integer :: rno
         type (data_record_type_isdata), intent (in) :: data_record
         integer, intent (out), optional :: err
!
         integer :: ierr
!
         ierr = 0
         extended_error = 0
         if (pk_block_isdata%del_ptr > 0) then
            rno = pk_block_isdata%del_ptr
            read (unit=pk_block_isdata%unit, rec= &
              & rno+pk_block_isdata%first_loc, iostat=ierr, err=99) &
              & pk_record_temp_isdata
            if (ierr /= 0) then
               rno = -1
               go to 99
            end if
            pk_block_isdata%del_ptr = pk_record_temp_isdata%v_d_flag
         else
            pk_block_isdata%num_recs = pk_block_isdata%num_recs + 1
            rno = pk_block_isdata%num_recs
         end if
!
         pk_record_temp_isdata%v_d_flag = -1
         pk_record_temp_isdata%dat = data_record
         write (unit=pk_block_isdata%unit, rec=rno+pk_block_isdata%first_loc,&
        & iostat=ierr, err=99) pk_record_temp_isdata
!
         if (present(err)) err = ierr
         return
99       continue
         extended_error = ierr
         if (present(err)) then
            err = PKERR_FILE
         end if
      end function pk_new_record_isdata
! ----------------------------------------------------------
      subroutine pk_delete_record_isdata (pk_block_isdata, pk_rno, err)
         implicit none
         type (pk_block_defn_isdata), pointer :: pk_block_isdata
         integer, intent (in) :: pk_rno
         integer, intent (out), optional :: err
!
         type (data_record_type_isdata) :: data_record
         integer :: ierr
!
         ierr = 0
         call pk_get_record_isdata (pk_block_isdata, pk_rno, data_record,&
        & ierr)
         if (ierr /= 0) go to 99
         pk_record_temp_isdata%v_d_flag = pk_block_isdata%del_ptr
         pk_block_isdata%del_ptr = pk_rno
!
         write (unit=pk_block_isdata%unit, rec= &
           & pk_rno+pk_block_isdata%first_loc, iostat=ierr, err=99) &
           & pk_record_temp_isdata
         if (present(err)) err = ierr
         return
99       continue
         extended_error = ierr
         if (present(err)) then
            err = PKERR_FILE
         end if
      end subroutine pk_delete_record_isdata
! ----------------------------------------------------------
      function find_unit () result (unitu)
         integer :: unitu
!
         integer :: ierr
         logical tf1, tf2
!
         do i =  99, 1, -1
            unitu = i
            inquire (unit=unitu, opened=tf1, exist=tf2, iostat=ierr)
            if ( .not. tf1 .and. tf2 .and. ierr==0) return
         end do
         unitu = -1
      end function find_unit
!
      integer function ext_err() result (ierr)
         ierr = extended_error
      end function ext_err
!
end module is_file
