( MIDI Maker for the 2.25 Forth & up - variables 1 )            only vocabulary midimaker immediate forth also video also       mouse also midimaker definitions                                &220 variable SB_Base                       ( sound card base ) 128 11 * array instruments                  ( tbl of settings ) 128 32 * array names                       ( instrument names ) 128 array channels                    ( list of channel links ) 0 variable curins                             ( current sound ) 0 variable tempo                  ( a rough estimate of tempo ) 2 variable sote                          ( smallest note size ) 0. 2variable curtime               ( where we are in the song ) 0 variable channel                          ( current channel ) 0. 2variable looppos                ( position of loop if any ) 89 variable notetbl 109 , 132 , 155 ,           ( note values )     179 , 205 , 233 , 3 , 18 , 34 , 51 , 71 , -->                                                                               ( MIDI Maker for the new Forth - variables 2 )                  60 array filename                          ( target file name ) 0. 2variable fileblk                         ( where they are ) 0. 2variable filelen                            ( file length ) 0   variable filetyp                         ( file type flag ) 14 variable nclr                     ( note color we're using ) 14 variable lclr                     ( note color we're using ) 0 variable scanned                     ( file has been loaded ) 0. 2variable flg@ 0 ,                 ( location of flag tail ) 0. 2variable notecen                   ( note center location ) 0. 2variable sot                         ( last test or value ) 0. 2variable anote 0 ,                  ( last note displayed ) 0. 2variable bnote 0 ,                       ( mousey detects ) 0. 2variable mhit@                       ( mouse hit location ) 0. 2variable maxtime                     ( max time from file ) 0. 2variable ctime -->                           ( event time ) ( MIDI Maker for the new Forth - variables 3 )                  0 variable timet                    ( display time ticks flag ) 0 variable 1scan                          ( scan counter flag ) 0 variable timest                                ( staff time ) 0. 2variable vtemp                              ( virt. temp  ) 0. 2variable templen                            ( temp length ) 0. 2variable laspos                        ( last mouse place ) 0. 2variable pwid                              ( picture size ) 0. 2variable mofs                      ( mouse offset pointer ) 32 32 * array notep                            ( note picture ) 32 32 * array backp                            ( back picture ) 0 variable rolf                               ( the roll flag ) 0 variable insf                              ( an insert flag ) 0 variable dwid 1 , 0 , 11 , 99 , 1 , 4 , 4 ,    ( cmd widths ) 0 variable tofs -->                   ( amount of time offset )                                                                 ( MIDI Maker for the new Forth - variables 4 )                  0 variable ctype       ( command type, insert, change, delete ) 0. 2variable vdp                                ( virtual top ) 108 array buf1                                  ( data sought ) 108 array trgt                                  ( data sought ) 108 array data                        ( data added or changed ) 0. 2variable sprp                              ( catch system ) 0 variable bclr                           ( button text color ) : 16/ 16 / ;                                                    : 15& 15 and ;                                    ( shortcuts ) : cwid 15& 2 * dwid + @ ; -->                                                                                                                                                                                                                                                                                                                                                                   ( MIDI Maker for the new Forth - variables 1 )                  : 1key ( c -- c ) key -dup 0= if key 128 + then ;                                   ( get a keystrike as a complex character )  : ?mou noop ; : unmouse begin mbutton 0= until ;                                            ( mouse search & release detects )  : ?key begin ?terminal if 1key else mbutton if ?mou unmouse          then 0 then -dup until ;      ( get key or mouse action )  : cur2@ cur 2@ ; : cur2! cur 2! ;               ( used often )  : up-button ( x y w h -- ) 2over -3 +under 2- 2over 6 +under 4+        30 square 2over 2over 3 +under 2+ 27 square 29 square ;  : dn-button ( x y w h -- ) 2over -3 +under 2- 2over 6 +under 4+        27 square 2over 2over 3 +under 2+ 30 square 28 square ;  : .btn ( x y w h f a -- ) >r 5 pick >r 4 pick >r if dn-button        28 else up-button 29 then attr @ attrb @ rot attrb ! bclr @     attr ! cur2@ r> 2+ r> cur2! r> count 1- type cur2! attrb !      attr ! ; -->                                               ( mouse gui button routines )                                   : ?adr ( pfa -- xmin xmax ymin ymax ) >r r 2+ @ r 10 + @ over +      r 6 + @ r> 14 + @ over + ;                                               ( extract x & y limits from mouse callback word ) : set-mouse mok? if 1 1 mspeed 2! maxx 0 msetx drop maxy 0           msety drop else text ." Error! Mouse not found..." cr           quit then ;                                                : ", [compile] ' , [compile] ' , ;   ( compile two word pfas )  : do-btns ( tbla -- ) dup 2+ swap @ 0 do dup @ ?adr my -rot          within -rot mx -rot within and if dup 2+ @ cfa execute          leave then 4+ loop drop ;   ( process mouse when clicked ) : mexit unloop unloop unloop rdrop ;                            : @env ( -- ofs seg ) 0 &2c cs@ 16 - l@ ;                       : env-end? ( ofs seg -- ofs seg f ) 2dup l@ 0= ; -->                                                                                                                                            ( buttons 1 -- & find card )                                    : $blaster ," BLASTER" 1+ 1 7 ;                                 : =blaster? ( ofs seg -- ofs seg f ) $blaster 0 do >r >r 2dup      env-end? -rot lc@ r c@ = r> -rot r> and dup -rot 0= or          if leave else >r 1+ rot 1+ -rot r> then loop nip ;           : find-b ( ofs seg -- ofs seg f ) 0 begin drop 2dup lc@ &42 =       if 1 1 else 1 +under env-end? 0 swap then until ;           : find-blaster ( -- ofs seg f ) @env begin find-b if =blaster?      if 1 1 else 0 then else 0 1 then until ;                    : find-adr ( ofs seg -- ofs seg ) 2dup begin 2dup lc@ &41 = if      2 +under 2dup lc@ 48 - 16 * &200 + SB_Base ! 1 else 1 +under    2dup lc@ 0= then until 2drop ;                              : find-SB find-blaster if find-adr then 2drop ;                 : @r ( ofs -- adr ) curins @ 11 * + instruments + ; -->                                 ( point to table instrument register )                                                                  ( MIDI Maker -- & variables 1 )                                 : voicereg ( b # -- ) SB_Base @ swap over pc! 3 0 do hsync          loop 1+ pc! ;         ( write a voice register with data )  : ->reg ( reg# chan# -- reg# ) 3 over > if + else 6 over > if       + 5 + else 9 over > if + 10 + else drop then then then ;    : note-off ( chan# -- ) &0b0 + 0 swap voicereg ;                : note-on  ( octive# notev chan# -- ) over if 160 + 2dup            voicereg 16 + 0 over voicereg nip swap 4 * &21 + swap           voicereg else 3drop then ;  ( performs a note-off/note-on ) : transnote ( note# -- octive# notev ) 12 /mod swap 6 over <        if 1 +under then 2 * notetbl + @ ;                          : clro bclr ! attr ! attrb ! ;              ( set text colors ) : clr1 29  0  0 clro ;                            ( colors #1 ) : clr2  0 14  0 clro ;                            ( colors #2 ) : clr3 29  4  0 clro ; -->                        ( colors #3 )                                                                 ( MIDI maker -- player data )                                   : clr4 29  0 25 clro ;                            ( colors #4 ) : clr5  1 12  0 clro ;                            ( colors #5 ) : setvoice ( chan# -- ) &20 over ->reg pad 1+ 4 0 do 2dup c@        swap voicereg 1+ over 3 + over c@ swap voicereg 1+ &20          +under loop nip over &0c0 + over c@ swap voicereg 1+ swap       &0e0 swap ->reg 2dup swap c@ swap voicereg 3 + swap 1+ c@       swap voicereg ;  ( data at pad+1 )               ( whew! )  : .is clr2 35 135 cur2! curins @ dup 3 .r clr1 ."   channel: "       channels + c@ clr2 3 .r 50 10 cur2! clr1 ." Named: " clr2       space curins @ 32 * names + 30 type ;                      : .ib 2 fx* ! 2 fy* ! 6 6 455 195 0 ,"        Instrument Builder 1.0" .btn 1 fx* ! 1 fy* ! clr1 36 10 cur2! ." Current Instrum"      ." ent:" .is clr3 76 50 cur2! ." Modulator" 76 320 cur2!        ." Carrier" ; -->                                                                                                          ( now the fun one -- set voice: data in pad+1 )                 : b? ( bits ofs -- f ) @r c@ and ;                  ( helper1 ) : .20-1  10  92 15 12 128 0 b? ," AM"  .btn ;                   : .20-2  35  92 20 12  64 0 b? ," VIB" .btn ;                   : .20-3  65  92 15 12  32 0 b? ," EG"  .btn ;                   : .20-4  90  92 20 12  16 0 b? ," KSR" .btn ;                   : .20-5  94 120 cur2! clr1 ." Multiplier:" 15 0 b? clr2 2 .r ;  : .23-1 270  92 15 12 128 1 b? ," AM"  .btn ;                   : .23-2 294  92 20 12  64 1 b? ," VIB" .btn ;                   : .23-3 325  92 15 12  32 1 b? ," EG"  .btn ;                   : .23-4 350  92 20 12  16 1 b? ," KSR" .btn ;                   : .23-5  94 380 cur2! clr1 ." Multiplier:" 15 1 b? clr2 2 .r ;  : br dup 128 / swap 32 / 2 and + dup 3 = if 1+ then ;           : .40-1 110  10 cur2! clr1 ." Attenuation: " 192 2 b? br 15         * 0 <# # 46 hold # #> clr2 type clr1 space ." dB/Octive." ;  -->                                                            ( MIDI maker -- instrument builder: gui interface 1 )           : .40-2 124  10 cur2! clr1 ." Total Level: " 63 2 b? clr2 2          .r ;                                                       : .43-1 110 270 cur2! clr1 ." Attenuation: " 192 3 b? br 15         * 0 <# # 46 hold # #> clr2 type clr1 space ." dB/Octive." ; : .43-2 124 270 cur2! clr1 ." Total Level: " 63 3 b? clr2 2          .r ;                                                       : .60-1 138  10 cur2! clr1 ." Attack:  " 240 4 b? 16/ clr2 2        .r ;                                                        : .60-2 138 100 cur2! clr1 ." Decay  : "  15 4 b? 15& clr2           2 .r ;                                                     : .63-1 138 270 cur2! clr1 ." Attack:  " 240 5 b? 16/ clr2          2 .r ;                                                      : .63-2 138 360 cur2! clr1 ." Decay  : "  15 5 b? 15& clr2           2 .r ; -->                                                                                                                 ( MIDI maker -- instrument builder: gui interface 2 )           : .80-1 152  10 cur2! clr1 ." Sustain: "  240 6 b? 16/ clr2         2 .r ;                                                      : .80-2 152 100 cur2! clr1 ." Release: "   15 6 b? 15& clr2          2 .r ;                                                     : .83-1 152 270 cur2! clr1 ." Sustain: "  240 7 b? 16/ clr2         2 .r ;                                                      : .83-2 152 360 cur2! clr1 ." Release: "  15 7 b? 15& clr2           2 .r ;                                                     : .stype clr2 dup 0= if ." Sine  Wave " then dup 1 = if            ." Half  Sine " then dup 2 = if ." Ripple Sine" then 3 = if     ."  Sawtooth  " then ;                                       : .e0-1 166  10 cur2! clr1 ." Wave: " 3  9 b? .stype ;          : .e3-1 166 270 cur2! clr1 ." Wave: " 3 10 b? .stype ;          : .c0-1 180  74 60 12 1 8 b? ," Connected"  .btn ;              : .play1  70 182 27 12 0 ," Play"  .btn ; -->                   ( MIDI maker -- instrument builder: gui interface 3 )           : .c0-2 180 180 cur2! clr1 ." Feedback: " 14 8 b? 2 / clr2 . ;  : .exit1 330 182 30 12 0 ," Exit"  .btn ;                       : .load1 380 182 30 12 0 ," Load"  .btn ;                       : .save1 420 182 30 12 0 ," Save"  .btn ;                       : .play2  25 182 33 12 0 ," Aplay"  .btn ;                      : .it .is .20-1 .20-2 .20-3 .20-4 .20-5 .23-1 .23-2 .23-3 .23-4     .23-5 .40-1 .40-2 .43-1 .43-2 .60-1 .60-2 .63-1 .63-2 .80-1     .80-2 .83-1 .83-2 .e0-1 .e3-1 .c0-1 .c0-2 .play1 .exit1         .play2 .load1 .save1 ;   ( text locations for mouse below ) : curi 135  35 20 12 ; : cnam  60  50 280 12 ;                  : m1   180  93 14 12 ; : m2   440  93 14 12 ;                   : att1  90 109 20 12 ; : att2 350 109 20 12 ;                   : lvl1  91 123 12 12 ; : lvl2 351 123 12 12 ;                   : at1   65 137 12 12 ; : dc1  156 137 12 12 ;                   : at2  325 137 12 12 ; : dc2  416 137 12 12 ; -->               ( MIDI maker -- instrument builder: gui interface 4 )           : sus1  64 151 12 12 ; : rel1 155 151 12 12 ;                   : sus2 324 151 12 12 ; : rel2 415 151 12 12 ;                   : wav1  50 165 70 12 ; : wav2 310 165 70 12 ;                   : fbk  245 180 12 12 ; : chri 222  35 13 12 ;                   : @mm mbutton 1 - if -1 else 1 then ;                           : @ci @mm curins swap over @ + 127 and swap ! .it ;             : bt ( bits ofs -- f ) @r swap toggle ;           ( helper 2 )  : @20-1 128 0 bt .20-1 ; : @20-2  64 0 bt .20-2 ;               : @20-3  32 0 bt .20-3 ; : @20-4  16 0 bt .20-4 ;               : @20-5  15 0 b? @mm + 15& 240 0 b? + 0 @r c! .20-5 ;           : @23-1 128 1 bt .23-1 ; : @23-2  64 1 bt .23-2 ;               : @23-3  32 1 bt .23-3 ; : @23-4  16 1 bt .23-4 ;               : @23-5  15 1 b? @mm + 15& 240 1 b? + 1 @r c! .23-5 ;           : @nam clr2 50 60 cur2! curins @ 32 * names + dup 30 erase 30       expect .is ; -->                                            ( MIDI maker -- instrument builder: gui interface 5 )           : b* br dup 4 = if 1- then @mm + dup 1 and 128 * swap 2 and          32 * + ;                                     ( helper 3 )  : @40-1 192 2 b? b* 63 2 b? + 2 @r c! .40-1 ;                   : @40-2 63 2 b? @mm + 63 and 192 2 b? + 2 @r c! .40-2 ;         : @43-1 192 3 b? b* 63 3 b? + 3 @r c! .43-1 ;                   : @43-2 63 3 b? @mm + 63 and 192 3 b? + 3 @r c! .43-2 ;         : @60-1 240 4 b? @mm 16 * + 240 and 15 4 b? + 4 @r c! .60-1 ;   : @60-2 15 4 b? @mm + 15& 240 4 b? + 4 @r c! .60-2 ;            : @63-1 240 5 b? @mm 16 * + 240 and 15 5 b? + 5 @r c! .63-1 ;   : @63-2 15 5 b? @mm + 15& 240 5 b? + 5 @r c! .63-2 ;            : @80-1 240 6 b? @mm 16 * + 240 and 15 6 b? + 6 @r c! .80-1 ;   : @80-2 15 6 b? @mm + 15& 240 6 b? + 6 @r c! .80-2 ;            : @83-1 240 7 b? @mm 16 * + 240 and 15 7 b? + 7 @r c! .83-1 ;   : @83-2 15 7 b? @mm + 15& 240 7 b? + 7 @r c! .83-2 ; -->                                                                        ( MIDI maker -- instrument builder: gui interface 6 )           : @c0-1 1 8 bt .c0-1 ;                                          : @c0-2 14 8 b? @mm 2 * + 14 and 1 8 b? + 8 @r c! .c0-2 ;       : @e0-1 3 9 b? @mm + 3 and 9 @r c! .e0-1 ;                      : @e3-1 3 10 b? @mm + 3 and 10 @r c! .e3-1 ;                    : @exit1 drop mexit ;                                           0 variable lnote ," HJLMOQSTHHJLHLJHHJLHGHHJLMLJHGCEGHH" drop   : ins>raw 0 @r pad 3 over c! 1+ 11 cmove 0 setvoice ;           : wait1  10 0 do vsync loop ;                                   : play3 ( note# -- ) transnote 0 note-on wait1 0 note-off ;     : play2 ( note# -- ) transnote 0 note-on unmouse 0 note-off ;   : @play1 70 182 27 12 1 ," Play" .btn ins>raw lnote @ 84 < if       lnote @ play2 12 lnote +! else lnote dup @ 80 - + c@ 36 -       play2 1 lnote +! lnote @ 118 > if 0 lnote ! then then           .play1 ; -->                                                                                                                ( MIDI maker -- instrument builder: gui interface 7 )           : @play2 25 182 33 12 1 ," Aplay" .btn ins>raw begin lnote @ 84     < if lnote @ play3 12 lnote +! else lnote dup @ 80 - + c@       36 - play3 1 lnote +! lnote @ 118 > if 0 lnote ! then then      wait1 mbutton 0= until .play2 ;                             : @chi @mm curins @ channels + swap over c@ + 0 max 10 mod          swap c! .it ;          ( channel assignment table )         : pos1 460 0 2dup cur2! cr cr cur2! ;                           : fn1 pos1 ." File name: " here 1+ 50 expect here 1+ ;          : fw1 ( hdl adr len -- ) rot &4000 &21 int# 4nip if ." File wr"      ." ite error." quit then ;                                 : fr1 ( hdl adr len -- ) rot &3f00 &21 int# 4nip if ." File re"      ." ad error." quit then ;                                  : @save1 fn1 0 0 &3c00 &21 int# if ." File create error." 4drop     quit then 3nip dup dup instruments 128 11 * fw1 names 128       32 * fw1 0. rot &3e00 &21 int# 4drop drop ; -->             ( MIDI maker -- instrument builder: gui interface 7 )           : @load1 fn1 0 0 &3d00 &21 int# if ." File open error." 4drop       quit then 3nip dup dup instruments 128 11 * fr1 names 128       32 * fr1 0. rot &3e00 &21 int# 4drop drop ;                                                                                 34 variable btn1 ", curi @ci  ", .20-1 @20-1 ", .20-2 @20-2     ", .20-3 @20-3 ", .20-4 @20-4 ", m1    @20-5 ", .23-1 @23-1     ", .23-2 @23-2 ", .23-3 @23-3 ", .23-4 @23-4 ", m2    @23-5     ", att1  @40-1 ", lvl1  @40-2 ", att2  @43-1 ", lvl2  @43-2     ", at1   @60-1 ", dc1   @60-2 ", at2   @63-1 ", dc2   @63-2     ", sus1  @80-1 ", rel1  @80-2 ", sus2  @83-1 ", rel2  @83-2     ", .c0-1 @c0-1 ", fbk   @c0-2 ", wav1  @e0-1 ", wav2  @e3-1     ", .play1 @play1 ", .exit1 @exit1 ", .play2 @play2 ", chri @chi ", cnam @nam ", .load1 @load1 ", .save1 @save1 -->                                                                                                                                              ( MIDI maker -- instrument builder: gui interface 8 )           : mt1 mhide btn1 do-btns mshow ;            ( mouse service )   : buildi ' mt1 cfa ' ?mou ! mhide .ib .it mshow ?key clr2 0 0       467 207 0 mhide square mshow ;                              : y/n ( -- f ) ."  (Y/N)?" key &df and 89 = ;                   : get-fblk ( -- blk# ) #files @ dup 1+ maxfiles > if text           ." File handles exceeded!" cr quit then 1- >file 2+ @ 500 +     dup 8000 > if text ." File block limit exceeded!" cr quit       then ;          ( attempt to allocate block adr for file )  : cfrm1 ( adr -- adr|0 ) pos1 ." Forget " dup count type y/n if     #files @ 1- >file 4+ @ over 1+ = if #files @ 1- close dup       256 erase 1 #files -! else pos1 ." File not on top..." cr       drop 0 then else drop 0 then ;                              : @f1 ( -- ) fileblk 2@ vptr1 2! ; -->                                                                                                                                                          ( MIDI maker - files 1 )                                        : get-fo ( adr -- len ) fn1 over 55 erase over 1+ 52 0 do over      c@ over c! dup c@ 0= if leave then 1+ 1 +under loop nip over    - over c! get-fblk swap hidden (open) midimaker #files @        1- >file 6 + 2@ ;                                           : ftype? ( blk# -- f ) block dup @ &494a = over 2+ c@ &4d = and      if 1 else dup @ &4d34 = over 2+ c@ &44 = and if 2 else dup      @ &544d = over 2+ @ &6468 = if 3 else 4 then then then          nip ;                              ( determine file type ) : pf1 ( -- ) get-fo filelen 2! #files @ 1- >file 2+ @ dup 1024       m* fileblk 2! ftype? filetyp ! 0 scanned ! 0. maxtime 2!        0. looppos 2! ;                                            : get-f1 filename @ if filename cfrm1 -dup if pf1 then else          filename pf1 then ; -->              ( get/open new file )                                                                                                                                 ( MIDI maker - display rules )                                  : onscr1 ( -- ~t f ) ctime 2@ curtime 2@ d- 0< over 8 * maxx >       or 0= ;                        ( is this time on screen? ) : skipv ( # -- ) 0 do vptr1 vc> drop loop ;      ( skip ahead ) : ptime 0. ctime 2! @f1 8 skipv ;                 ( 1st event ) : cskip ( cmd -- ) cwid -dup if skipv then ;                                                              ( skip command data ) : cmd? ( c # -- c f ) over 15& = ;              ( test cmd )    : ofend? ( -- f ) fileblk 2@ filelen 2@ d+ vptr1 2@ d< ;        : endof? ( -- f ) fileblk 2@ filelen 2@ d+ vptr1 2@ 1. d+ d< ;                                                 ( end of file? ) : gt1 ( -- ) vptr1 v2> dup pad ! ctime 2+ @ < if 1 ctime +!         then pad @ ctime 2+ ! ;        ( get & compute event time ) : $1 ," C C#D D#E F F#G G#A A#B " ; -->                                                                                                                                                         ( MIDI Maker -- sheet display -- Eeek! )                        : nex-tim ( c -- c ~t ) >r vptr1 2@ pad @ ctime 2@ ( save em )       r cskip begin gt1 vptr1 vc> dup 16/ dup 8 > swap r 16/ =        or swap cskip endof? or if ctime 2@ 1 else 0 then until         2over ctime 2! 2swap d- ofend? or if drop 64 then swap pad      ! -rot vptr1 2! r> swap ;                                             ( compute time to next cmd on this or all channels ) : $note1 ," @ABCDEFGHKLMNOPQRSTUV[\^_`abcdefijklmnopqrstuv" ;       ( display string values )                                ( god what a pain in the neck! ) : @notey ( n -- y ) $note1 1+ + c@ 63 and 4 * 220 swap - ;      : @notef ( n -- # ) $note1 1+ + c@ 128 and 128 = ;              : @notex ( ~t -- x ) 8 * 4+ ;    ( note factored for searches ) : staf1 ( x y -- x y' ) 5 0 do 2dup 2dup 8 +under 29 line 8 +       loop ; -->               ( notes are 8 pixels in diameter )                                   ( add a note's carrier line ) ( MIDI Maker -- sheet display -- Eeek! )                        : .sl ( x y -- x y ) over 7 - over over 14 + over 7 line ;                                        ( add a note's carrier line ) : +staff ( ~t -- ) 1scan @ 0= if dup 8 * dup 0 8 237 0 square       16 4 0 do staf1 16 + i 1 = if 8 + then loop 2drop timet @       if dup 0 curtime 2@ d+ tempo @ m/mod 2drop 0= if 14 else 7      then swap 8 * 0 over 235 5 roll line else drop then             else drop then ;   ( draw 4 staffs, with extra note space ) : staff 80 0 do i +staff loop ;             ( draw full staff ) : +lines ( x y -- x y ) dup 8 = over 56 = or over 112 = or over      176 = or if .sl then ;       ( add lines to middle notes ) : @note ( ~t n -- x y # ) dup 0< if drop @notex 280 0 else swap     @notex swap dup @notey swap @notef >r 2dup notecen 2!           +lines r> then ;                      ( locate on screen )  : nclr+ ( n -- c ) nclr @ + dup lclr ! ;                        : .whole ( ~t n -- ) @note 4 swap nclr+ 2 circle ; -->          ( MIDI Maker -- sheet display -- Eeek! )                        : .half  ( ~t n -- ) @note 4 swap nclr+ -1 circle ;             : .flag ( ~t n -- ) @note drop 4 +under dup 56 < over 132 178       within or if 2dup 20 + -2 else 2dup 20 - 2 then flg@ 4+ !       2dup flg@ 2! lclr @ line ;                                  : .quarter ( ~t n -- ) 2dup .half .flag ;                       : .dot notecen 2@ 8 +under 1 lclr @ -1 circle ;                 : .eighth ( ~t n -- ) .quarter flg@ 2@ over 5 + over lclr @        line ;                                                       : .16th ( ~t n -- ) .eighth flg@ 2@ flg@ 4+ @ + over 5 + over       lclr @ line ;                                               : .32nd ( ~t n -- ) .16th flg@ 2@ flg@ 4+ @ 2 * + over 5 +          over lclr @ line ;                                          : notl ( l * -- l f ) sote @ * dup sot ! pleat dup 2 * within ;   -->                           ( test versus min note length )                                                                 ( MIDI Maker -- sheet display -- Eeek! )                        : lnot ( * -- n ) sote @ * dup sot ! - dup 0 > if .dot sot @ 2       / dup sot +! - then ;                                      : mhit? notecen 2@ dup 4- swap 4+ my -rot within swap dup 4-        swap 4+ mx -rot within and nclr @ 11 > and if vptr1 to          mhit@ sot @ sot 2+ ! anote to bnote anote 4+ @ bnote 4+ !       then ;                                   ( mouse on note? ) : .note ( ~time note length -- ) -rot >r >r dup anote 4+ ! 2r       anote 2! 1 notl if 2r .32nd 1 lnot then 2 notl if 2r .16th      2 lnot then 4 notl if 2r .eighth 4 lnot then 8 notl if 2r       .quarter 8 lnot then 16 notl if 2r .half 16 lnot then dup 0     > if 2r .whole 32 lnot then mhit? drop unloop ;                                                   ( attempt to print note ) : .note1 ( c -- c ) onscr1 if over nex-tim nip vptr1 2@ vc@         swap .note else drop then ; -->               ( show note )                                                                 ( MIDI Maker -- sheet display -- Eeek! )                        : eclr ( c -- c ) dup 16/ channel @ = 1scan @ if if 14 nclr !       .note1 then else 0= if 6 nclr ! .note1 then then ;                                            ( set note color & display )  : cmd1 ( c -- c ) 1 cmd? if scanned @ if eclr else onscr1 nip       if nex-tim 0 max sote @ min sote ! then then 1 skipv then ;                                                     ( note on ) : .bar ( -- ) onscr1 if 8 *  48 8 3 nclr @ square else drop          then ;                                            ( rest ) : dclr ( c -- c ) dup 16/ channel @ = 1scan @ if if 14 nclr !       .bar then else 0= if 6 nclr ! .bar then then ;   ( set it ) : cmd2 ( c -- c ) 2 cmd? if scanned @ if dclr then then ;                                                          ( note off ) : insblank? ( a -- f ) 0 swap 11 over + swap do i c@ or loop        0= ; -->                           ( is instrument empty? )                                                                 ( MIDI Maker -- sheet display instrument loader )               : fndins ( n -- n ) 0 128 rot do i 11 * instruments + insblank?     if i + leave then loop ;                ( find empty slot ) : .ok1 370 150 20 12 curins @ 128 < 0= ," OK" .btn ;            : @ok1 curins @ 128 < if unmouse 215  85 210 95 0 square mexit      then ;                                                      : .next 240 150 30 12 curins @ 128 < 0= ," NEXT" .btn ;         : .is1 130 300 cur2! clr2 curins @ 3 .r ;                       : 'is1 300 130 30 12 ;                    ( callback location ) : @cvi @mm curins swap over @ + 127 and swap ! .is1 ;           : @next curins @ 1 max fndins -dup clr1 110 240 cur2! if ." To"     ."  blank instrument: " else 128 ." No blank found, target"     ." : " then curins ! .ok1 .is1 .next ;                      : .ldfv 220  90 200  80 0 ,"   Transfer File Voice Setting"         .btn @next ; -->                                                                                                            ( MIDI maker -- Sheet Display scan )                            3 variable btn2 ", .ok1 @ok1 ", .next @next ", 'is1 @cvi        : mt2 mhide btn2 do-btns mshow ;              ( mouse service ) : ldins ' ?mou @ ' mt2 cfa ' ?mou ! .ldfv mshow ?key mhide drop     ' ?mou ! curins @ 11 * instruments + 11 0 do vptr1 vc> over     c! 1+ loop drop curins @ channels + over 16/ swap c! ;                                      ( load instruments into table ) : eid ( c t -- ) onscr1 if 8 * 230 swap cur2@ >r >r cur2! emit       r> r> cur2! else 2drop then ;                                                    ( add cmd characters to display listing ) : cmd3 ( c -- c ) 3 cmd? if 86 eid scanned @ if 11 skipv else        ldins then then ;                            ( set voice ) : cmd4 ( c -- c ) 4 cmd? if 65 scanned @ if 99 skipv else 9 0        do i 16 * ldins loop then then ;               ( set all ) : cmd5 ( c -- c ) 5 cmd? if 62 eid 1 skipv then ; -->                                                            ( loop start ) ( MIDI maker -- sheet display 3 )                               : cmd6 ( c -- ) 6 cmd? over 7 cmd? nip or if 60 eid 4 skipv          then drop ;                                   ( loop end ) : scan-cmd vptr1 vc> cmd1 cmd2 cmd3 cmd4 cmd5 cmd6 endof? ;     : setmins scanned @ 0= if 32767 sote ! then 0. mhit@ 2! 0 sot        2+ ! ;                            ( set min times to max ) : gt2 timest @ 80 < if ctime 2@ curtime 2@ d- drop 2+ dup            timest @ do i +staff loop timest ! then ;                                                     ( add staff between events ) : scan0 scanned @ if ptime begin gt1 ctime 2@ curtime 2@ d-          80. 2over d< -rot nip 0< if vptr1 vc> cskip 0 else gt2          scan-cmd then or until then ;           ( perform a pass ) : scan1 0 timest ! 0 1scan ! scan0 endof? if ctime 2@ curtime       2@ d- drop 1+ 80 swap do i +staff loop then 1 1scan ! scan0     ; -->                               ( double pass display )                                                                 ( MIDI maker -- sheet display 4 )                               : typerr1 2 > if pos1 ." Unknown File Type." 0 else 1 then ;                                         ( speak of unholy things ) : scanf filetyp @ typerr1 if setmins ptime begin gt1 ctime to       maxtime scan-cmd until sote @ 16 * tempo ! 1 scanned ! then     ;              ( sote is min. length, tempo 16 times that ) : .pos curtime 2@ 100. du* maxtime 2@ du/ dnip drop ( % ) 75        240 490 12 27 square 490 100 */ 75 + 75 max 555 min 240 10      12 30 square ;                               ( slider bar ) : note-menu 14 nclr ! 61 -1 sote @ 1 max dup sote ! 6 0 do 3        pick 3 pick 3 pick .note 2 * rot 3 + -rot loop 3drop ;                                                    ( the note menu ) : .fwrd 580 240 15 12 0 ," "  .btn ;        ( forward button ) : .top   10 240 20 12 0 ," " .btn ;           ( home button ) : .back  45 240 15 12 0 ,"  " .btn ; -->       ( back button )                                                                 ( MIDI maker -- sheet display -- gui)                           : .end  610 240 20 12 0 ," " .btn ;            ( end button ) : +ch 200 350 8 8 0 ," " .btn ;                                : -ch 214 350 8 8 0 ," " .btn ;                                : +tm 200 330 8 8 0 ," " .btn ;                                : -tm 214 330 8 8 0 ," " .btn ;                                ( gui symbols 1 ) hex 0 variable syms -2 allot                  ( voice ) 0000 , 0ff0 , 1ff8 , 1ff8 , 3ffc , 3ffc , 1ff8 ,                1ff8 , 0ff0 , 03c0 , 07e0 , 0ff0 , 1ff8 , 3ffc ,                7ffe , ffff , ffff , ffff , ffff , 0000 ,             ( play  ) 6000 , 7000 , 7800 , 7c00 , 7e00 , 7f3f , 7fbf ,                7fff , 7fff , 7fff , 7fff , 7fff , 7fff , 7fbf ,                7f3f , 7e00 , 7c00 , 7800 , 7000 , 6000 ,             ( disk  ) 0000 , 0000 , 7fff , 7fff , 7fff , 7fff , 7fff ,                7fff , 7e3f , 7e3f , 7fff , 7fff , 7e3f , 7e3f ,                7e3f , 7e3f , 7fff , 7fff , 0000 , 0000 , -->         ( gui symbols 2 )                                               ( bloop ) 0000 , 0000 , 0033 , 0033 , 0033 , 0033 , 0333 ,                0333 , 0033 , 0033 , 0033 , 0033 , 0333 , 0333 ,                0033 , 0033 , 0033 , 0033 , 0000 , 0000 ,             ( eloop ) 0000 , 0000 , cc00 , cc00 , cc00 , cc00 , ccc0 ,                ccc0 , cc00 , cc00 , cc00 , cc00 , ccc0 , ccc0 ,                cc00 , cc00 , cc00 , cc00 , 0000 , 0000 ,             ( rest  ) 0000 , 0000 , 0000 , 0000 , 0000 , 3ffc , 3ffc ,                3ffc , 3ffc , 3ffc , 3ffc , 0000 , 0000 , 0000 ,                0000 , 0000 , 0000 , 0000 , 0000 , 0000 ,             ( instr ) 0000 , 0c00 , 3e00 , ff00 , c700 , 0700 , 0700 ,                0700 , 0700 , 073c , 077e , 07c3 , 07c3 , 077e ,                073c , 077c , 07fc , 07f8 , 03f0 , 0000 ,             ( natrl ) 0000 , 0030 , 0030 , 0030 , 0030 , 0ff0 , 0ff0 ,                0ff0 , 0c30 , 0c30 , 0c30 , 0c30 , 0ff0 , 0ff0 ,                0ff0 , 0c00 , 0c00 , 0c00 , 0c00 , 0000 , -->         ( gui symbols 3 )                                               ( erase ) 0000 , 0000 , 0000 , 0000 , fc00 , fe00 , ff00 ,                ff80 , 7fc0 , 3fe0 , 1ff0 , 0ff8 , 07fc , 03fe ,                01ff , 00ff , 0000 , 0000 , 0000 , 0000 ,             ( timeT ) 0000 , 0000 , 7ffe , 7ffe , 7ffe , 0380 , 0380 ,                0380 , 0380 , 0380 , 0380 , 0380 , 0380 , 0380 ,                0380 , 0380 , 0380 , 0000 , 0000 , 0000 ,             ( sharp ) 0000 , 0000 , 0c30 , 0c30 , 0c30 , 0c30 , 7ffe ,                7ffe , 0c30 , 0c30 , 0c30 , 0c30 , 7ffe , 7ffe ,                0c30 , 0c30 , 0c30 , 0c30 , 0000 , 0000 ,             ( exit  ) 0000 , 0000 , 03e0 , 0c18 , 0104 , 280a , 2412 ,                4221 , 4141 , 4081 , 4141 , 4221 , 2412 , 280a ,                1004 , 0c18 , 03e0 , 0000 , 0000 , 0000 , decimal -->                                                                                                                                                                                                 ( gui symbols 3 -- status )                                     : .roy ( y d x -- ) dup 16 + swap do 2/ 14 * i 4 pick rot plot       loop 2drop ;                                               : .sym ( x y s -- ) 40 * syms + -rot dup 20 + swap do over @         over i -rot .roy 2 +under loop 2drop ;                     : .chs1 0 270 450 180 1 square 275 38 cur2! clr5 -2 font            ." FILE: " clr2 space filename count type -3 font ;         : .chs2 clr5 290 20 cur2! -2 font ." Length: " clr2 filelen 2@      8 d.r  290 220 cur2! clr5 ." Max Time: " clr2 maxtime 2@ 8      d.r -3 font ;                                               : .chs3 clr5 330 107 cur2! -2 font ." Tempo: " clr2 tempo @ 3       .r -3 font ;                                                : .chs4 clr5 350 90 cur2! -2 font ." Channel: " clr2 channel @      2 .r -3 font ; -->                                                                                                                                                                          ( status )                                                      : .chs5 clr5 305 210 cur2! -2 font ." Page Time: " clr2 curtime     2@ 8 d.r space -3 font ;                                    : .chs6 -2 font clr5 370 118 cur2! ." Note: " clr2 bnote dup @       3 .r 2 spaces @ 12 mod 2 * $1 + 1+ 2 type -3 font ;        : .chs7 clr5 390 66 cur2! -2 font  ." Time Index: " bnote 2+        dup @ 0 curtime 2@ d+ clr2 8 d.r 2+ @ clr5 410 126 cur2!        ." Len: " clr2 4 .r space -3 font ;                         : .chs8 595 340 16 16 2drop 9 .sym 603 348 10 timet @ 14 * 9        circle ;                                                    : .voi  533 339 16 16 2drop  0 .sym ;                           : .pla  505 370 16 16 2drop  1 .sym ;                           : .dis  535 370 16 16 2drop  2 .sym ;                           : .blp  565 310 16 16 2drop  3 .sym ;                           : .elp  590 310 16 16 2drop  4 .sym ; -->                                                                                       ( MIDI maker -- sheet display 4 )                               : .res  503 340 16 16 2drop  5 .sym ;                           : .ins  565 370 16 16 2drop  6 .sym ;                           : .nat  535 310 16 16 2drop  7 .sym ;                           : .era  563 340 16 16 2drop  8 .sym ;                           : .shp  505 310 16 16 2drop 10 .sym ;                           : .exi  595 370 16 16 2drop 11 .sym ;                           : .chs .chs1 .chs2 .chs3 .chs4 .chs5 .chs6 .chs7 .chs8 note-menu     .top .end .fwrd .back .pos +ch -ch +tm -tm .pla .dis .voi       .ins .exi .shp .nat .era .res .blp .elp ;                  : @top 0. curtime 2! .chs5 scan1 .pos ;    ( simple callbacks ) : @back curtime dup 2@ tempo @ 0 d- 2dup 0. d< if 2drop 0. then     rot 2! .chs5 scan1 .pos ;                                   : @end maxtime 2@ 80. d- curtime 2! .chs5 scan1 .pos ;          : @-ch channel @ 1- 0 max channel ! .chs4 scan1 ;               : @+ch channel @ 1+ 9 min channel ! .chs4 scan1 ; -->           ( MIDI maker -- sheet display 4 )                               : @fwrd curtime dup 2@ tempo @ 0 d+ 2dup maxtime 2@ 40. d- d<       0= if 2drop maxtime 2@ 40. d- then rot 2! .chs5 scan1 .pos      ;                                                           : @+tm tempo @ 1+ 80 min tempo ! .chs3 scan1 ;                  : @-tm tempo @ 1- 0 max tempo ! .chs3 scan1 ;                   : @att timet 1 toggle .chs8 scan1 ;                             : uncatch sprp 2@ s0 2! ' (abort) cfa ' abort ! 0 warning ! ;   : catch2 sp! rp! uncatch unloop r> 4+ >r ." File Error!" 0           filename ! ;                                               : catch1 s0 2@ sprp 2! sp@ s0 ! rp@ r0 ! ' catch2 cfa ' abort !     -1 warning ! ;                   ( catch file open errors ) : @dis catch1 get-f1 uncatch scanf .chs ;                       : @exi drop 13 mexit ;                                          : @ins ' ?mou @ buildi ' ?mou ! ; -->                                                                                           ( manual mouse driver )                                         : picget 2dup pwid 2! 2swap getpic notep backp 1024 cmove ;     : grab1 ( adr -- adr ) notep over @ cfa execute 17 - 15 32          picget -4 -20 mofs 2! ;                      ( note grab )  : grab2 ( adr -- adr ) notep over @ 2+ dup @ swap 4+ @ 30 30        picget -8 -8 mofs 2! ;                                      : @im pwid 2@ laspos 2@ mofs 2@ rot + -rot + swap ;             : .mous1 backp @im getpic ;                                     : .mous2 vmode c@ notep @im 4 vmode c! putpic vmode c! ;        : .mous3 backp @im putpic ;                                     : mmove mx my laspos 2! .mous1 begin mx my laspos 2@ d= 0= if       .mous3 mx my laspos 2! .mous1 .mous2 then mbutton 0= until      .mous3 mx my laspos 2! ;            ( allow mouse to move ) : mtime ( -- time ) mx 8 / 0 curtime 2@ d+ ;                    : mnote ( -- note ) -1 77 0 do my i @notey 4- dup 8 + within if     drop i leave then loop ; -->                                ( data file functions )                                         : same-com? ( -- f ) vptr1 2@ vptr1 v2> trgt 2+ @ = vptr1 vc>       trgt 4+ c@ = and -rot vptr1 2! ;              ( same cmd? ) : find-time begin endof? 0= gt1 ctime 2@ trgt 2@ 2over 2over d=     0= >r d< r> and and while vptr1 vc> cskip repeat endof? 0=      if -2. vptr1 2+! then ; ( advance to timing word if found ) : find-com ( -- f ) vptr1 2@ 0 10 0 do gt1 vptr1 vc> dup 16/        trgt 4+ c@ 16/ = ctime 2@ trgt 2@ d= and if drop 1+ leave       2nip vptr1 2@ rot else cskip then loop -rot 3 pick if 3. d-     then vptr1 2! ;         ( short find of command specified ) : @shp grab2 mmove mtime trgt 2! channel @ 16 * trgt 4+ c!          ptime find-time find-com if vptr1 2@ 3. d+ 2dup vc@ 1+ -rot     vc! then ;                           ( raise note 1 value ) : @nat grab2 mmove mtime trgt 2! channel @ 16 * trgt 4+ c!          ptime find-time find-com if vptr1 2@ 3. d+ 2dup vc@ 1- -rot     vc! then ; -->                        ( drop note 1 value ) ( sub-menus )                                                   : yea  235 120 20 12 0 ," Yes" .btn ; : @yea drop 89 mexit ;    : nea  275 120 20 12 0 ," No" .btn ;  : @nea drop 78 mexit ;    : men1 220 100 90 40 0 ,"  Insert Note?" .btn yea nea ;         : rol1 220 100 90 40 0 ,"  Roll events?" .btn yea nea ;         2 variable btn3 ", yea @yea ", nea @nea                         : mt3 mhide btn3 do-btns mshow ;                                : ask2 ' ?mou @ ' mt3 cfa ' ?mou ! rol1 mshow ?key mhide swap       ' ?mou ! dup 13 = if drop 78 then rolf ! unmouse ;          : ask1 ' ?mou @ ' mt3 cfa ' ?mou ! men1 mshow ?key mhide swap       ' ?mou ! dup 13 = if drop 78 then insf ! unmouse ;          : add-to fileblk 2@ filelen 2@ d+ vptr2 2! trgt 2+ @ vptr2 >v2      trgt 4+ c@ dup vptr2 >vc cwid dup 3 + 0 filelen 2+! -dup if     0 do trgt 5 + i + c@ vptr2 >vc loop then ; -->                                                      ( add com to file end )                                                                 ( data file functions 2 )                                       : >hole ( -- ) filelen 2@ fileblk 2@ d+ vptr2 2! 2048 0 do 0         vptr2 >vc loop vptr2 to vdp ;              ( make a hole ) : expand filelen 2@ 2dup templen 2! >hole vptr1 to vtemp begin       vptr1 vc> vptr2 >vc 1. d- 2dup d0= until 2drop vdp to           vptr1 vptr2 2@ fileblk 2@ d- filelen 2! vtemp to vptr2 ;                            ( make a hole & assign it for search ) : sdata ( adr -- ) dup 2@ ctime 2! 2+ dup @ vptr2 >v2 2+ dup c@     dup vptr2 >vc cwid -dup if 0 do 1+ dup c@ vptr2 >vc loop        then drop ;                     ( send block data to file ) : rdata ( adr -- ) dup gt1 ctime 2@ rot 2! 4+ vptr1 vc> 2dup        swap c! cwid -dup if 0 do 1+ vptr1 vc> over c! loop then        drop ; -->                               ( read file data )                                                                                                                                                                                                 ( data file functions 3 )                                       : eloop endof? 0= if begin buf1 rdata buf1 sdata mbutton drop       endof? until then ;                     ( roll event area ) : -event vptr2 2@ vptr1 to vptr2 trgt rdata trgt 4+ c@ cwid 0       filelen 2-! eloop vptr2 2! ;    ( delete pointed to event ) : chop flush filelen 2@ #files @ 1- >file @ >r r &4200 &21 int#     4nip drop r 0. fw1 r> 0. fw1 ;         ( try to chop file ) : tim-nex ( -- f ) tofs @ 0< if trgt to ctime else 0 ctime 2+ !     then 0 begin gt1 vptr1 vc> dup 16/ dup 8 > swap trgt 4+ c@      16/ = or over 15& 3 > or if drop 3. vptr1 2-! 1+ 1 else         cskip ofend? then mbutton drop until vptr1 2@ 2. d+ vc@ 15&     4 < and ;                              ( adv. ptr to next ) : repln same-com? insf @ 78 = and if vptr1 to vptr2 trgt sdata      then ;                                 ( replace cmd data ) : delta ( -- ) tofs @ s->d trgt 2+! ; -->                                                                                       ( data file functions 4 )                                       : gamma ( -- ) vptr1 2@ tim-nex if -event sot 2@ tofs @ s->d d+     trgt 2@ d- drop tofs ! delta else 0 tofs ! then vptr1 2!        sot to ctime ;               ( compute time of next event ) : beta vptr1 2@ tim-nex if -event delta else 0 tofs ! then sot      to ctime vptr1 2! ;                        ( advance next ) : roll-em trgt to sot gamma tofs @ if mhour mcursor mshow begin     vptr1 2@ data rdata data 4+ c@ 16/ trgt 4+ c@ 16/ = if trgt     sdata vptr1 2! beta else trgt 2@ data 2@ d< if trgt sdata       beta tofs @ 0< if vptr1 2! else 2drop data sdata then else      2drop data sdata then then endof? tofs @ 0= or mbutton drop     until trgt 2@ data 2@ d= endof? and if trgt sdata then then     eloop mhide marrow mcursor ;                                : rollf ( n -- ) expand insf @ 89 = if 0. ctime 2! trgt sdata       then rolf @ 89 = if roll-em else eloop then templen to          filelen s->d filelen 2+! chop ; -->                         ( data file functions 5 )                                       : rscan scanf .chs scan1 ;                                      : setn1 ( n -- ) mnote trgt 5 + ! mtime trgt 2! channel @ 16 *      1+ trgt 4+ c! ;                                             : add-note 0 insf ! 0 rolf ! sote @ * tofs ! grab1 mmove my 224     < if setn1 ptime find-time endof? if add-to else find-com       if same-com? if ask1 else 89 insf ! then else 89 insf !         then repln ask2 4 rollf then rscan then ;                   : @era grab2 0 -16 mofs 2! mmove my 235 < if mtime trgt 2!          channel @ 16 * trgt 4+ c! ptime find-time find-com if vptr1     2@ trgt rdata trgt 4+ c@ cwid ask2 rolf @ 89 = if expand        -rot vptr2 2! 0 tofs ! trgt to ctime roll-em templen to         filelen else -rot vptr2 2! eloop then 3 + 0 filelen 2-!         chop then rscan then ; -->             ( wield the rubber )                                                                                                                                 ( command call backs )                                          : note1 487 275 8 8 2drop ;   : @note1 1 add-note ;             : note2 510 275 8 8 2drop ;   : @note2 2 add-note ;             : note3 534 275 8 8 2drop ;   : @note3 4 add-note ;             : note4 559 275 8 8 2drop ;   : @note4 8 add-note ;             : note5 584 275 8 8 2drop ;   : @note5 5 add-note ;             : note6 608 275 8 8 2drop ;   : @note6 16 add-note ;                                                         ( note menu adds ) : @res grab2 0 -8 mofs 2! mmove my 235 < if mtime trgt 2!           channel @ 16 * 2+ trgt 4+ c! ptime find-time endof? if          add-to else 89 insf ! 3 rollf then rscan then ;                                                         ( insert note off ) : .is2 110 290 cur2! clr2 curins @ 3 .r 130 225 cur2! clr1          ."   Assigned to channel: " curins @ channels + c@ clr2 3       .r ; -->                                                                                                                    ( sub-menus 2 )                                                 : upa  317 110 9 9 0 ," " .btn ;                               : @upa curins @ 1+ 127 min curins ! .is2 unmouse ;              : dna  334 110 9 9 0 ," " .btn ;                               : @dna curins @ 1- 0 max curins ! .is2 unmouse ;                : ien1 220  90 200 80 0 ,"   Use Voice of Instrument:" .btn         upa dna .is2 .ok1 ;                                         3 variable btn4 ", upa @upa ", dna @dna ", .ok1 @ok1            2 variable btn5 ", yea @yea ", nea @nea                         : lol1 210  90 110 50 0 ,"  Wrong File Type," .btn 105 230 clr1       cur2! ."  Convert?" yea nea clr2 ;                        : mt4 mhide btn4 do-btns mshow ;                                : mt5 mhide btn5 do-btns mshow ;                                : ask3 ' ?mou @ ' mt4 cfa ' ?mou ! ien1 mshow ?key mhide swap       ' ?mou ! drop unmouse ; -->                                                                                                 ( sub-menus 2 )                                                 : ask4 ' ?mou @ ' mt5 cfa ' ?mou ! lol1 mshow ?key mhide swap       ' ?mou ! dup 13 = if drop 78 then unmouse ;                 : jen1 220 100 100 40 0 ,"  Loop On Zero?" .btn yea nea ;       : ask5 ' ?mou @ ' mt5 cfa ' ?mou ! jen1 mshow ?key mhide swap       ' ?mou ! dup 13 = if drop 78 then unmouse ;                 : @voi grab2 0 -8 mofs 2! mmove my 235 < if mtime trgt 2!           channel @ 16 * 3 + trgt 4+ c! ask3 channel @ curins @           channels + c! 0 @r trgt 5 + 11 cmove ptime find-time endof?     if add-to else find-com same-com? and if 0 78 else 14 89        then insf ! rollf then rscan then ;                         : 1ftype filetyp @ 1 = if ask4 89 = if @f1 &4d34 vptr1 >v2 &44      vptr1 >vc 2 filetyp ! else rdrop scan1 then then ; -->                                                                                                                                                                                                      ( command call backs )                                          : @elp grab2 0 -8 mofs 2! mmove my 235 < looppos 2@ d0= 0= and      if mtime trgt 2! 1ftype ask5 89 = if 7 else 6 then trgt 4+      c! looppos 2@ swap trgt 5 + 2! ptime find-time endof? if        add-to else 89 insf ! 7 rollf 0. looppos 2! then rscan then     ;                                                           : gt# 0 begin key dup emit dup 48 58 within over 8 = or while       dup 8 = if drop 10 / else 48 - swap 10 * + then repeat drop     ;                                                           : lol2 210  90 110 50 0 ,"     Loop Count?" .btn 105 230 clr2         2dup cur2! 10 spaces cur2! space gt# ;                    : @blp grab2 0 -8 mofs 2! mmove my 235 < looppos 2@ d0= and if      mtime trgt 2! 1ftype 5 trgt 4+ c! lol2 trgt 5 + c! ptime        find-time vptr1 2@ fileblk 2@ d- 4. d+ looppos 2! endof? if     add-to else 89 insf ! 4 rollf then rscan then ; -->                                                                         ( slow player routine )                                         : 3cmd 3 cmd? if data 4+ pad 11 cmove dup 16/ setvoice then ;                                            ( manually set voice ) : 1cmd 1 cmd? if data 5 + c@ transnote 3 pick 16/ note-on then       ;                                     ( manual play note ) : 2cmd 2 cmd? if dup 16/ note-off then ;           ( note off )                                                                 : 4cmd 4 cmd? if data 5 + 9 0 do dup pad 1+ 11 cmove i setvoice      11 + loop drop then ;                   ( set all voices ) : 5cmd 5 cmd? if data 5 + c@ tofs ! then ;                      : leap data 5 + 2@ swap fileblk 2@ d+ vptr1 2! 0. ctime ! data       rdata data 2@ looppos 2! ;                                 : 6cmd 6 cmd? if 1 tofs -! tofs @    if leap then then ;        : 7cmd 7 cmd? if 1 tofs -! tofs @ 0= if leap then then ;        : mpla data 4+ c@ 1cmd 2cmd 3cmd 4cmd 5cmd 6cmd 7cmd drop ; -->                                                                 ( slow player routine 2 -- master menu )                        : @pla unmouse 0. looppos 2! 0 tofs ! ptime data rdata begin        data 2@ looppos 2@ d= if mpla data rdata else 3 0 do vsync      loop 1. looppos 2+! then endof? ?terminal or mbutton or         until ;                                                                                                                     26 variable btn6 ", .top @top ", .fwrd @fwrd ", .back @back     ", .end @end ", +ch @+ch ", -ch @-ch ", .chs8  @att ", +tm @+tm ", -tm @-tm ", .dis @dis ", .exi @exi ", .ins @ins ", .shp @shp ", note1 @note1 ", note2 @note2 ", .nat @nat ", note3 @note3    ", note4 @note4 ", note5 @note5 ", note6 @note6 ", .era @era    ", .res @res ", .voi @voi ", .elp @elp ", .blp @blp             ", .pla @pla -->                                                                                                                                                                                                                                                ( MIDI maker -- main )                                          : mt6 mhide btn6 do-btns 0. bnote 2! 0 bnote 4+ ! my 240 252         within mx 75 565 within and if maxtime 2@ mx 75 - 0 du*         490. du/ dnip curtime 2! .pos .chs5 scan1 then my 240 < if      scan1 .chs6 .chs7 then mshow ;           ( mouse service ) : mbuild ' mt6 cfa ' ?mou ! mhide scan1 .chs mshow ?key clr2        mhide ;                                                     : main1 hgr -3 font >font set-mouse mbuild drop text .files ;                                                          ( main ) only definitions also midimaker also forth                      : midi ( n -- ) find-sb main1 ;                                 only also video also forth definitions                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ( end )                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         