{************************************************}
{                                                }
{   Turbo Pascal 6.0                             }
{   Turbo Vision browser program                 }
{                                                }
{   Copyright (c) 1990 by Borland International  }
{                                                }
{************************************************}

{$X+}

Program FileView;

{$M 16384,16384,655360}

Uses
  DOS, Objects, Drivers, Memory, Views, Menus, Dialogs, StdDlg, MsgBox, App;

Var dir : SearchRec;
Const
  cmFileOpen  = 100;
  cmChangeDir = 101;
  hlChangeDir = cmChangeDir;     { History list ID for change dir box }
  first_b : Boolean = True;
Var
  testevent : tevent;
Type
  
  { TLineCollection }
  
  PLineCollection = ^TLineCollection;
  TLineCollection = Object (TCollection)
    Procedure FreeItem (P: Pointer); Virtual;
  End;
  
  { TFileViewer }
  
  PFileViewer = ^TFileViewer;
  TFileViewer = Object (TScroller)
    FileLines: PCollection;
    IsValid: Boolean;
    Constructor Init (Var Bounds: TRect; AHScrollBar, AVScrollBar: PScrollBar;
    Var FileName: PathStr);
    Destructor Done; Virtual;
    Procedure Draw; Virtual;
    Function Valid (Command: Word): Boolean; Virtual;
  End;
  
  { TFileWindow }
  
  PFileWindow = ^TFileWindow;
  TFileWindow = Object (TWindow)
    Constructor Init (Var FileName: PathStr);
  End;
  
  { TFileViewerApp }
  
  PFileViewerApp = ^TFileViewerApp;
  TFileViewerApp = Object (TApplication)
    Procedure HandleEvent (Var Event: TEvent); Virtual;
    Procedure InitMenuBar; Virtual;
    Procedure InitStatusLine; Virtual;
    Procedure OutOfMemory; Virtual;
  End;
  
  { TLineCollection }
  Procedure TLineCollection. FreeItem (P: Pointer);
Begin
  DisposeStr (P);
End;

{ TFileViewer }
Constructor TFileViewer. Init (Var Bounds: TRect; AHScrollBar,
  AVScrollBar: PScrollBar; Var FileName: PathStr);
Var
  FileToView: Text;
  Line: String;
  MaxWidth: Integer;
  
Begin
  TScroller. Init (Bounds, AHScrollbar, AVScrollBar);
  GrowMode := gfGrowHiX + gfGrowHiY;
  IsValid := True;
  FileLines := New (PLineCollection, Init (5, 5) );
  {$I-}
  Assign (FileToView, FileName);
  Reset (FileToView);
  If IOResult <> 0 Then
  Begin
    MessageBox ('Cannot open file ' + Filename+ '.', Nil, mfError + mfOkButton);
    IsValid := False;
  End
  Else
  Begin
    MaxWidth := 0;
    While Not EoF (FileToView) And Not LowMemory Do
    Begin
      ReadLn (FileToView, Line);
      If Length (Line) > MaxWidth Then MaxWidth := Length (Line);
      FileLines^. Insert (NewStr (Line) );
    End;
    Close (FileToView);
  End;
  {$I+}
  SetLimit (MaxWidth, FileLines^. Count);
End;

Destructor TFileViewer. Done;
Begin
  Dispose (FileLines, Done);
  TScroller. Done;
End;

Procedure TFileViewer. Draw;
Var
  B: TDrawBuffer;
  C: Byte;
  I: Integer;
  S: String;
  P: PString;
Begin
  C := GetColor (1);
  For I := 0 To Size. Y - 1 Do
  Begin
    MoveChar (B, ' ', C, Size. X);
    If Delta. Y + I < FileLines^. Count Then
    Begin
      P := FileLines^. At (Delta. Y + I);
      If P <> Nil Then S := Copy (P^, Delta. X + 1, Size. X)
      Else S := '';
      MoveStr (B, S, C);
    End;
    WriteLine (0, I, Size. X, 1, B);
  End;
End;

Function TFileViewer. Valid (Command: Word): Boolean;
Begin
  Valid := IsValid;
End;

{ TFileWindow }
Constructor TFileWindow. Init (Var FileName: PathStr);
Const
  WinNumber: Integer = 1;
Var
  R: TRect;
Begin
  Desktop^. GetExtent (R);
  TWindow. Init (R, Filename, WinNumber);
  Options := Options Or ofTileable;
  Inc (WinNumber);
  GetExtent (R);
  R. Grow ( - 1, - 1);
  Insert (New (PFileViewer, Init (R,
  StandardScrollBar (sbHorizontal + sbHandleKeyboard),
  StandardScrollBar (sbVertical + sbHandleKeyboard), Filename) ) );
End;

{ TFileViewerApp }
Procedure TFileViewerApp. HandleEvent (Var Event: TEvent);

Procedure FileOpen;
Var
  D: PFileDialog;
  FileName: PathStr;
  W: PWindow;
Begin
  If (ParamCount > 0) And first_b Then
    D := PFileDialog (ValidView (New (PFileDialog, Init (ParamStr (1), 'Open a File',
    '~N~ame', fdOpenButton, 100{fdOpenButton, 100} ) ) ) )
  Else
    D := PFileDialog (ValidView (New (PFileDialog, Init ('*.*', 'Open a File',
    '~N~ame', fdOpenButton, 100) ) ) );
  If D <> Nil Then
  Begin
    If ( (ParamCount > 0) And first_b) Or (Desktop^. ExecView (D) <> cmCancel) Then
    Begin
      first_b := False;
      D^. GetFileName (FileName);
      W := PWindow (ValidView (New (PFileWindow, Init (FileName) ) ) );
      If W <> Nil Then Desktop^. Insert (W);
    End;
    Dispose (D, Done);
  End;
End;

Procedure ChangeDir;
Var
  D: PChDirDialog;
Begin
  D := PChDirDialog (ValidView (New (PChDirDialog, Init (0, hlChangeDir) ) ) );
  If D <> Nil Then
  Begin
    DeskTop^. ExecView (D);
    Dispose (D, Done);
  End;
End;

Procedure Tile;
Var
  R: TRect;
Begin
  Desktop^. GetExtent (R);
  Desktop^. Tile (R);
End;

Procedure Cascade;
Var
  R: TRect;
Begin
  Desktop^. GetExtent (R);
  Desktop^. Cascade (R);
End;

Begin
  TApplication. HandleEvent (Event);
  
  Case Event. What Of
    evCommand:
    Begin
      Case Event. Command Of
        cmFileOpen: FileOpen;
        cmChangeDir: ChangeDir;
        cmCascade: Cascade;
        cmTile: Tile;
        Else
        Begin
          Exit;
        End;
      End;
      ClearEvent (Event);
    End;
  End;
  If ( (ParamCount > 0) And first_b)  Then
  Begin
    fileopen;
  End;
End;

Procedure TFileViewerApp. InitMenuBar;
Var
  R: TRect;
Begin
  GetExtent (R);
  R. B. Y := R. A. Y + 1;
  MenuBar := New (PMenuBar, Init (R, NewMenu (
  NewSubMenu ('~F~ile', 100, NewMenu (
  NewItem ('~O~pen...', 'F3', kbF3, cmFileOpen, hcNoContext,
  NewItem ('~C~hange dir...', '', kbNoKey, cmChangeDir, hcNoContext,
  NewItem ('E~x~it', 'Alt-X', kbAltX, cmQuit, hcNoContext, Nil) ) ) ),
  NewSubMenu ('~W~indows', hcNoContext, NewMenu (
  NewItem ('~R~esize/move', 'Ctrl-F5', kbCtrlF5, cmResize, hcNoContext,
  NewItem ('~Z~oom', 'F5', kbF5, cmZoom, hcNoContext,
  NewItem ('~N~ext', 'F6', kbF6, cmNext, hcNoContext,
  NewItem ('~C~lose', 'Alt-F3', kbAltF3, cmClose, hcNoContext,
  NewItem ('~T~ile', '', kbNoKey, cmTile, hcNoContext,
  NewItem ('C~a~scade', '', kbNoKey, cmCascade, hcNoContext, Nil) ) ) ) ) ) ), Nil) ) ) ) );
End;

Procedure TFileViewerApp. InitStatusLine;
Var
  R: TRect;
Begin
  GetExtent (R);
  R. A. Y := R. B. Y - 1;
  StatusLine := New (PStatusLine, Init (R,
  NewStatusDef (0, $FFFF,
  NewStatusKey ('', kbF10, cmMenu,
  NewStatusKey ('~Alt-X~ Exit', kbAltX, cmQuit,
  NewStatusKey ('~F3~ Open', kbF3, cmFileOpen,
  NewStatusKey ('~F5~ Zoom', kbF5, cmZoom,
  NewStatusKey ('~Alt-F3~ Close', kbAltF3, cmClose, Nil) ) ) ) ), Nil) ) );
End;

Procedure TFileViewerApp. OutOfMemory;
Var
  D: PDialog;
  R: TRect;
  C: Word;
Begin
  MessageBox ('Not enough memory available to complete operation.',
  Nil, mfError + mfOkButton);
End;

Var
  FileViewerApp: TFileViewerApp;
  
Begin
  If ParamCount > 1 Then
  Begin
    FindFirst (ParamStr (1), AnyFile, dir);
    If DosError <> 0 Then
      first_b := False;
  End;
  FileViewerApp. Init;
  FileViewerApp. Run;
  FileViewerApp. Done;
End.
