/*
 * comsub.h - include file for routines to perform command substitution
 *			  and environment variable parsing and expansion
 *
 * Author:	R. Brittain 4/11/90
 *			This code placed in the public domain
 *
 */

#include <stdio.h>
#include "popen.h"

#define MEMCHECK(x)		if ((x) == NULL) fatal("Out of memory",1)
#define TRUE 			(1)
#define FALSE 			(0)
#define MAXARGLINE		127

#ifdef UNIXCOMPAT
 #define ENV				'$'		/* character prefacing environment vars */
 #define BKQ				'`'		/* character used to quote command subst */
 #define EXE				'@'		/* character to preface .exe/.com commands */
 #define strupr(x)			(x)		/* disable upper-casing env-vars */
#else
 #define ENV				'%'		/* character prefacing environment vars */
 #define BKQ				'`'		/* character used to quote command subst */
 #define EXE				'@'		/* character to preface .exe/.com commands */
#endif

typedef struct {				/* structure to use for growing string types */
	char *b;					/* base of string */
	char *p;					/* current "head" of string */
	int	 len;					/* length allocated */
	int	 inc;					/* how much to grow by each time we fill up */
} estring;

/* prototypes */

void 	fatal(char *msg, int status);
char 	*endptr(char *p);
char 	*mfgets(FILE *);
int 	expand_backquotes(int *argc, char ***argv);
int		rebuild_argv(int *argc, char ***argv);
char 	*expand_env(char *s);
char 	*addstring(estring *es, char *add, int count);
