/*
 * This program is used to convert the old TDE 4.0 macro buffer to the new
 * TDE 5.0 configuration format. Just place all the filenames you want
 * converted on the command line. The new files will have the same name, but
 * with a ".tdm" extension. Be warned, though, if the new file should already
 * exist, it will be overwritten.
 * Once you have the new files, you might want to load them through TDE and
 * save them back to get the function version and verify their correctness.
 *
 * Program Name:  mac2cfg
 * Author:        Jason Hood
 * Date:          August 26, 1998
 */


#include <stdio.h>
#include <string.h>
#include "mac2cfg.h"


MACRO macro;
FILE* mac;


/*
 * Name:    write_macro
 * Date:    August 26, 1998
 * Notes:   write the macro associated with key, as a combination of literals
 *           and keys on the one line.
 */
void write_macro( int key )
{
  int literal = 0;
  int next;
  int ch;

  fprintf( mac, "%s Macro ", keys[key] );
  for (next = macro.first_stroke[key]; next != -1;
       next = macro.strokes[next].next)
  {
    ch = macro.strokes[next].key;
    if (ch < 256)
    {
      if (!literal)
      {
        fputc( '\"', mac );
        literal = 1;
      }
      fputc( ch, mac );
    }
    else
    {
      if (literal)
      {
        fputc( '\"', mac );
        literal = 0;
      }
      fprintf( mac, " %s", keys[ch - 256] );
    }
  }
  if (literal) fputc( '\"', mac );
  fputc( '\n', mac );
}


int main( int argc, char *argv[] )
{
  FILE* fp;
  char  macname[256];
  int   j, k;

  for (j = 1; j < argc; ++j)
  {
    if ((fp = fopen( argv[j], "rb" )) == NULL)
      printf( "Unable to open \"%s\"\n", argv[j] );
    else
    {
      fread( &macro.first_stroke[0], sizeof(int), MAX_KEYS, fp );
      fread( &macro.strokes[0], sizeof(STROKES), STROKE_LIMIT, fp );
      fclose( fp );

      /*
       * Change the extension to ".tdm".
       */
      strcpy( macname, argv[j] );
      for (k = strlen( macname ) - 1; k >= 0 && !(macname[k] == '/' ||
           macname[k] == '\\' || macname[k] == '.'); --k) ;
      if (k >= 0 && macname[k] == '.')
        strcpy( macname+k, ".tdm" );
      else
        strcat( macname, ".tdm" );

      /*
       * Create the new macro configuration file.
       */
      if ((mac = fopen( macname, "w" )) == NULL)
        printf( "Unable to create \"%s\"\n", macname );
      else
      {
        for (k = 0; k < MAX_KEYS; ++k)
          if (macro.first_stroke[k] != STROKE_LIMIT+1)
            write_macro( k );
        fclose( mac );
      }
    }
  }

  return 0;
}
