$ If F$Mode () .eqs. "INTERACTIVE"
$   Then
$       VERIFY = F$Verify (0)
$   Else
$       VERIFY = F$Verify (1)
$ EndIf
$ On Control_Y Then GoTo EXIT
$ On Error     Then GoTo EXIT
$!========================================================================
$!
$!  Name      : MAKE_XV.COM
$!
$!  Purpose   : Compile and Link XV (v2.00) under VMS
$!  Suggested usage: @ MAKE_XV.COM
$!                OR
$!                   Submit /NoPrint /Log = Sys$Disk:[] /Notify MAKE-XV.COM
$!
$!  Created:  9-JAN-1992   by David Jones (jonesd@kcgl1.eng.ohio-state.edu)
$!  Updated: 19-JAN-1992   by Rick Dyson  (dyson@iowasp.physics.uiowa.edu)
$!
$!========================================================================
$ THIS_PATH = F$Element (0, "]", F$Environment ("PROCEDURE")) + "]"
$ If F$Trnlnm ("X11") .eqs. "" Then Define X11 DECW$Include
$ If F$Trnlnm ("SYS") .eqs. "" Then Define Sys Sys$Share
$!
$!USER CUSTOMIZING POINT!!!!!
$!
$!  If you want to use the LZW decompression programs available from the 
$!  DECUS libraries, you will need to add the ",HAVE_LZW" string to the
$!  list of define statements in the following compiler defintion line.
$!  The default will be to use the supplied VMS version of the Unix-like
$!  decompression program.  much better!! ;)
$!
$ CC = "Cc /NoList /Define = (HAVE_JPEG,WANT_PDS) /Include = [.jpeg]"
$!
$ sources = "xv,xvmisc,xvevent,xvcolor,xvimage,pseudo_root,xvroot,vms,xvdir,"+ -
	"xvgam,vmsreaddir,xvbutt,xvdial,xvpds,xv24to8,xvsmooth,xvctrl,"+ -
	"xvdflt,xvgif,xvgifwr,gifmapf,xvgraf,xvps,xvinfo,xvscrl,xvpm," + -
	"xvpbm,xvpopup,xvsunras,xvxbm,xvjpeg,argproc"
$!
$ If F$Search ("bitmaps.h") .eqs. "" Then GoSub COPY_BITMAPS
$ new_objects = ""
$ If F$Search ("[.jpeg]jpeglib.olb") .eqs. ""
$   Then
$       default = F$Environment ("Default")
$       Set Default [.jpeg]
$       Write Sys$Output "Building JPEG library..."
$       @[-]make_jpeg
$       Set Default 'default'
$       new_objects = ",[.jpeg]jpeglib/lib"
$ EndIf
$!
$ If F$Search ("gifdecomp.obj") .eqs. ""
$   Then
$       Write Sys$Output "Assembling GIFDECOMP.MAR
$       Macro gifdecomp
$       new_objects = ",gifdecomp"
$ EndIf
$!
$!  search for missing object files.
$!
$ sndx = 0
$NEXT_SOURCE:
$   sfile = F$Element (sndx, ",", sources)
$   sndx = sndx + 1
$   If sfile .eqs. "," Then GoTo SOURCES_DONE
$   ofile = F$Parse (".OBJ", sfile)
$   If F$Search (ofile) .nes. "" Then GoTo NEXT_SOURCE
$   Write Sys$Output "Compiling ", sfile, ".c ..."
$   CC 'sfile'.c
$   If F$Search (ofile) .nes. "" Then new_objects = new_objects + "," + sfile
$   GoTo NEXT_SOURCE
$!
$SOURCES_DONE:
$   If new_objects .eqs. "" .and. p1 .eqs. "" Then GoTo EXIT
$   new_objects = new_objects - ","
$!
$   Write Sys$Output "Building decompress.c ..."
$   CC decompress.c
$   Link /Executable = decompress.exe decompress,options/Option
$   Write Sys$Output "Building vdcomp.c ..."
$   CC vdcomp.c
$   Link /Executable = vdcomp.exe vdcomp,options/Option
$   Write Sys$Output "Building bggen.c ..."
$   CC bggen.c
$   Link /Executable = bggen.exe bggen,argproc,options/Option
$   Write Sys$Output "Linking new XV image..."
$   Link /Executable = xv.exe Sys$Input/Option 'p1'
xv,xvmisc,xvevent,xvcolor,xvimage,pseudo_root,xvroot,vms,argproc,xvdir
xvgam,vmsreaddir,xvbutt,xvdial,xvpds,xv24to8,xvsmooth,xvctrl,xvdflt,xvgif
xvgifwr,gifmapf,gifdecomp,xvgraf,xvps,xvinfo,xvscrl,xvpm,xvpbm,xvpopup
xvsunras,xvxbm,xvjpeg,[.jpeg]jpeglib/lib
Sys$Share:DECW$XlibShr/Share,DECW$DWTLibShr/Share,VAXCRTL/Share
$   GoTo Exit
$!
$! subroutine to generate new bitmaps.h file.
$!
$COPY_BITMAPS:
$   Create bitmaps.h
$   bmlist = "grasp,penn,down,down1,up,up1,scrlgray,gray50,gray25,i_fifo," + -
        "i_chr,i_dir,i_blk,i_lnk,i_sock,i_reg,rb_off,rb_on,rb_off1,rb_on1," + -
        "fc_left,fc_leftm,fc_mid,fc_midm,fc_right,fc_rightm,fc_left1,fc_left1m,"+ -
        "fc_right1,fc_right1m,icon,dial_cw1,dial_cw2,dial_ccw1,dial_ccw2,"+ -
        "iconmask,gf1_addh,gf1_delh,gf1_line,gf1_rst,gf1_spln,gf1_gamma," + -
        "h_rotl,h_rotr,h_sinc,h_sdec,h_flip,cb_off,cb_on,cb_off1,cb_on1,h_sat," +-
        "h_desat,root_weave,cboard50,mb_chk"
$!
$   ndx = 0
$APPEND_NEXT:
$   name = F$Element (ndx, ",", bmlist)
$   If name .eqs. "," Then Return
$   ndx = ndx + 1
$   Append [.bitmaps]'name'. []bitmaps.h
$   GoTo APPEND_NEXT
$!
$EXIT:
$   VERIFY = F$Verify (VERIFY)
$   Exit
