/*
 * qic02.h - qic02 stuff definitions
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* controller I/O ports */
#define BASE    iobase		/* base of controller registers */
#define DATA    BASE		/* data register (read/write) */
#define CONTROL BASE+1		/* control register (write) */
#define STATUS  BASE+1		/* status register (read) */
#define DMAGO   BASE+2		/* start DMA (dummy write) */
#define RSTDMA  BASE+3		/* reset DMA logic (dummy write) */

/* control register bits */
#define RSTSAC  0x80		/* reset SAC */
#define REQ     0x40		/* request to LSI chip */
#define IEN     0x20		/* global interrupt enable */
#define DNIEN   0x10		/* done interrupt enable */

/* status register bits */
#define IRQF    0x80		/* interrupt request flag */
#define RDY     0x40		/* ready from LSI chip (active LOW) */
#define EXC     0x20		/* exception from LSI chip (active LOW) */
#define DONE    0x10		/* DMA logic done (active LOW) */
#define DIRC    0x08		/* direction from LSI chip (1=to controller) */

#define RDYEXC_MASK 0x60

/* exception positions */
#define FIL     0x01		/* File mark detected */
#define BNL     0x02		/* Block not located */
#define UDE     0x04		/* Unrecoverable data error */
#define EOM     0x08		/* End of medium */
#define WRP     0x10		/* Write protected cartridge */
#define DFF     0x20		/* Device fault or SELF TEST failed */
#define CNI     0x40		/* Cartridge not in place */
#define ST0     0x80		/* Flag(s) set in this byte (0) */

#define POR     0x01		/* Power on or RESET occurred */
#define EOD     0x02		/* End of recorded data */
#define PAR     0x04		/* Bus parity error */
#define BOM     0x08		/* Beginning of medium */
#define MBD     0x10		/* Marginal block detected */
#define NDT     0x20		/* No data detected */
#define ILL     0x40		/* Illegal command */
#define ST1     0x80		/* Flag(s) set in this byte (1) */

/* common exception causes */
#define CNIerr  1		/* no cartridge */
#define WRPerr  2		/* write protected */
#define EOMerr  3		/* end of media */
#define RWAerr  4		/* read / write abort */
#define RBBerr  5		/* read error, bad block xfer */
#define RFBerr  6		/* read error, filler block xfer */
#define EODerr  7		/* end of data */
#define EDMerr  8		/* end of data & EOM */
#define RFMerr  9		/* read a filemark */
#define ILLerr  10		/* illegal command */
#define PORerr  11		/* power on / reset */
#define MARerr  12		/* marginal block detected */
#define PARerr  13		/* bus parity error detected */
#define THCerr  14		/* throughcheck error detected */
#define DEADerr 15		/* Device dead, read status failed */

/* FATAL error, tape drive must be dead */
#define DEADerr 15		/* drive dead, even read status fails */

/* standard QIC02 commands */
#define BOT        0x21		/* Position to beginning of tape (rewind) */
#define ERASE      0x22		/* Erase tape */
#define RETENSION  0x24		/* Re-tension tape */
#define WRITE      0x40		/* Write to tape */
#define WRMARK     0x60		/* Write file mark to tape */
#define READ       0x80		/* Read from tape */
#define RDMARK     0xa0		/* Read file mark from tape */
#define RDSTATUS   0xc0		/* Read status from tape drive */

/* optional QIC02 commands */
#define SPACEFORW  0x81		/* Space forward */
#define SPACEREV   0x89		/* Space reverse */
#define SEEKEOD    0xa3		/* Seek to End Of Data */

/* Vendor unique (2150L) QIC02 commands */
#define SETQIC24   0x27		/* Set device format QIC-24 */
#define SETQIC120  0x28		/* Set device format QIC-120 */
#define SETQIC150  0x29		/* Set device format QIC-150 */
#define SEEKBLK    0xad		/* Seek block N */
#define RDBLKADDR  0xae		/* Read block address */
#define RDRESCNT   0xc8		/* Read residual block count */

/* usefull abrv. */
#define setreq        outportb(CONTROL, REQ)
#define resetreq      outportb(CONTROL, 0)
#define outdata(a)    outportb(DATA, (a))
#define indata        inportb(DATA)
#define not_rdy       (inportb(STATUS) & RDY)
#define wait_rdy      while (inportb(STATUS) & RDY)
#define wait_nrdy     while (!(inportb(STATUS) & RDY))
#define wait_exc      while (inportb(STATUS) & EXC)
#define wait_stat     while ((inportb(STATUS) & RDYEXC_MASK) == RDYEXC_MASK)
#define wait_dma      while (inportb(STATUS) & DONE)
#define errstat(a,b)  (statusbyte[a] & b)
#define is_exception  !(inportb(STATUS) & EXC)

