{

Tests the speed of DOS disk writes and reads.

Version 1.01

(c) Copyright 1994, Michael Gallias

Target: Real

}


Program DDS;

{$F-} {$O-} {$A+} {$G-}
{$V-} {$B-} {$X-} {$N+} {$E+}

{$M 2048, 65535, 65535}

Uses Dos,Calendar,PasStr,CRT;

Const
  TempFile = 'TEMP.$$$';

Type
  BigBlock      = Array [1..64000] of Byte;

Var
  Speeds  :Array[1..1000] of Real;
  Total   :Word;
  P       :^BigBlock;
  F       :File;

Function AvSpeed:Real;

Var
  Tot:Real;
  X  :Word;

Begin
  Tot:=0.0;
  For X:=1 to Total do
    Tot:=Tot + Speeds[X];
  If Total>0.0 Then Tot:=Tot / Total;
  AvSpeed:=Tot;
End;

Procedure CreateFile;

Var
  X  :Byte;

Begin
  Assign(F,'TEMP.$$$');
  Rewrite(F,1);
  For X:=1 to 10 do
    BlockWrite(F,P^,64000);
  If IOResult>0 Then
  Begin
    WriteLn('Not enough disk space.');
    Close(F);
    Assign(F,'TEMP.$$$');
    Erase(F);
    If IOResult>0 Then;
    Halt;
  End
  Else
    Close(F);
End;

Procedure WriteSpeed;

Var
  X       :Byte;
  Time    :TimeDate;
  Speed   :Real;
  Sec100  :LongInt;
  Sec100a,
  Sec100b :Word;
  Tot1    :LongInt;

Begin
  Total:=0;
  Assign(F,TempFile);
  Repeat
    Reset(F,1);
    GetTime(Time.Hour,Time.Min,Time.Sec,Sec100a);
    GetDate(Time.Year,Time.Month,Time.Day,Time.WeekDay);
    Tot1:=TotalSeconds(Time);      {The Current Time, In Seconds}
    For X:=1 to 10 do
      BlockWrite(F,P^,64000);
    GetTime(Time.Hour,Time.Min,Time.Sec,Sec100b);
    GetDate(Time.Year,Time.Month,Time.Day,Time.WeekDay);
    Tot1:=TotalSeconds(Time) - Tot1;     {Current Time Less The Time Above}
    Sec100:=Integer(Sec100b) - Integer(Sec100a);
    Sec100:=Sec100+LongInt(Tot1)*100;    {Time Taken in ms}
    If Sec100=0 Then Sec100:=1;
    Speed:=(640000.0 / (Sec100 / 100.0)) / 1024.0;   {Speed}
    Inc(Total);
    Speeds[Total]:=Speed;
    PushXYPos;
    WriteLn('Last     Write: ',Speed:5:2,' kb per second.  ');
    If Total>1 Then
      WriteLn('Average  Write: ',AvSpeed:5:2,' kb per second.   ',Total:4,' Tests Complete.  ');
    PopXYPos;
  Until KeyPressed Or (Total=1000);
  Close(F);
  KeyBuffer(Clear);
  WriteLn;
  WriteLn;
  WriteLn;
End;

Procedure ReadSpeed;

Var
  X       :Byte;
  Time    :TimeDate;
  Speed   :Real;
  Sec100  :LongInt;
  Sec100a,
  Sec100b :Word;
  Tot1    :LongInt;

Begin
  Total:=0;
  Assign(F,TempFile);
  Repeat
    Reset(F,1);
    GetTime(Time.Hour,Time.Min,Time.Sec,Sec100a);
    GetDate(Time.Year,Time.Month,Time.Day,Time.WeekDay);
    Tot1:=TotalSeconds(Time);      {The Current Time, In Seconds}
    For X:=1 to 10 do
      BlockRead(F,P^,64000);
    GetTime(Time.Hour,Time.Min,Time.Sec,Sec100b);
    GetDate(Time.Year,Time.Month,Time.Day,Time.WeekDay);
    Tot1:=TotalSeconds(Time) - Tot1;     {Current Time Less The Time Above}
    Sec100:=Integer(Sec100b) - Integer(Sec100a);
    Sec100:=Sec100+LongInt(Tot1)*100;    {Time Taken in ms}
    If Sec100=0 Then Sec100:=1;
    Speed:=(640000.0 / (Sec100 / 100.0)) / 1024.0;   {Speed}
    Inc(Total);
    Speeds[Total]:=Speed;
    PushXYPos;
    WriteLn('Last     Read : ',Speed:5:2,' kb per second.  ');
    If Total>1 Then
      WriteLn('Average  Read : ',AvSpeed:5:2,' kb per second.   ',Total:4,' Tests Complete.  ');
    PopXYPos;
  Until KeyPressed Or (Total=1000);
  Close(F);
  KeyBuffer(Clear);
  WriteLn;
  WriteLn;
  WriteLn;
End;

Begin
  WriteLn;
  WriteLn('Pure DOS Disk Speed          Version 1.01            Michael Gallias 1992');
  WriteLn;
  WriteLn;
  WriteLn;
  WriteLn;
  GotoXY(1,WhereY-3);
  New(P);
  CreateFile;
  WriteSpeed;
  WriteLn;
  WriteLn;
  WriteLn;
  WriteLn;
  GotoXY(1,WhereY-3);
  ReadSpeed;
  Dispose(P);
  Assign(F,TempFile);
  Erase(F);
End.

