#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <conio.h>
#include <bios.h>

char version[] = "Version:  Mk 1.5     27 October 1993" ;

#define FALSE		0
#define TRUE		1
#define LOC_PT		0x1BE
#define LOC_NT		0x1AA 
#define LOC_GWR		0x1A9 
#define MAGIC_LOC	0x1FE
#define MAGIC_0		0x55
#define MAGIC_1		0xAA
#define NT_ENTRY_SIZE	5 
#define SECSIZE		0x200
#define sw_printf	if (sw_fancy) printf

struct disk_param {
	unsigned int cyl ;
	unsigned int head ;
	unsigned int sect ;
};

/* Global variables */
int sw_help = FALSE, sw_null = FALSE, sw_number = FALSE ;
int sw_bios = FALSE, sw_ide = FALSE, sw_details = FALSE, sw_fancy = TRUE ;
unsigned int device = 0 ;

/* MAIN PROGRAM --- MAIN PROGRAM --- MAIN PROGRAM --- MAIN PROGRAM */
int main (argc, argv)
/***************************************************************/
/*                                                             */
/*  --- Partition Table and Hard Disk Examination Program ---  */
/*                                                             */
/*  Some code used by this program was derived from:           */
/*      Pfdisk, Version 1.2.1 by Gordon W. Ross, Aug. 1990     */
/*          and later modified by S. Lubkin  Oct. 1991         */
/*      Dug_ide, Version 1.0 by Doug Merrett, 12 Jan 1993      */
/*                                                             */
/* Both programs like this program are public domain freeware. */
/*                                                             */
/*          (c) Copyright 1993 by Gary A. Allen, Jr.           */
/*            Program written by Gary A. Allen, Jr.            */
/*            Version:  Mk 1.5      27 October 1993            */
/*                                                             */
/***************************************************************/

int argc ;
char *argv[] ;
{
register int i, j ;

int num_drv_bios, num_drv_act ;            /* Number of Hard disks */
int useNTable;		/* boot sector uses name table */
int cyl_bgn[4], cyl_lst[4], head_bgn[4], head_end[4] ;
int sect_bgn[4], sect_end[4], type_code[4] ;
int sw_active[4] ;

unsigned int dd[256]; 		/* Disk Data */
unsigned int pbc,pbh,pbs;	/* physical beginning  c,h,s */
unsigned int pec,peh,pes;	/* physical ending     c,h,s */

char chr, cmd[8] ;
char *prt_nam[4], *output_string ;
char buffer[SECSIZE];	/* The boot block buffer */
char *active;

long sect_str[4], sect_lng[4] ;

unsigned long lsbeg,lslen;	/* logical sectors: begin, length */

static char fancy1[81] = {
0xc9,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xd1,0xcd,0xcd,
0xcd,0xcd,0xd1,0xcd,0xcd,0xcd,0xcd,0xd1,0xcd,0xcd,
0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,
0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xd1,0xcd,
0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,
0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xd1,
0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xd1,
0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xbb,
0} ;
static char fancy2[] =
	"\xba Part \xb3" "Type\xb3" "Boot\xb3" "     Beginning"
	"      \xb3" "      Ending        \xb3"
	"Starting \xb3" "Number of\xba" ;

static char plain1[] =
	"  Part  Type Boot      Beginning             Ending         "
	"Starting  Number of\n" ;

static char fancy3[] =
	"\xba" " Type \xb3" "Code\xb3" "Part\xb3" "Side Cylinder Sector\xb3"
	"Side Cylinder Sector\xb3" 
	" Sector  \xb3" " Sectors \xba";

static char plain2[] =
	"  Type  Code Part Side Cylinder Sector "
	"Side Cylinder Sector  Sector    Sectors \n";

static char fancy4[81] = {
	0xcc,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xd8,0xcd,0xcd,
	0xcd,0xcd,0xd8,0xcd,0xcd,0xcd,0xcd,0xd8,0xcd,0xcd,
	0xcd,0xcd,0xd1,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,
	0xcd,0xd1,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xd8,0xcd,
	0xcd,0xcd,0xcd,0xd1,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,
	0xcd,0xcd,0xd1,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xd8,
	0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xd8,
	0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xb9,
0} ;

static char fancy5[] =
"\xba" "%6.6s\xb3" "%#4x\xb3" "%4.4s\xb3" "%3u \xb3" "%7u \xb3" "%5u \xb3"
"%3u \xb3" "%7u \xb3" "%5u \xb3" "%8lu \xb3" "%8lu \xba" ;

static char plain3[] =
" %6.6s %#4x %4.4s %3u  %7u  %5u  %3u  %7u  %5u  %8lu  %8lu \n" ;

static char fancy6[81] = {
	0xc7,0xc4,0xc4,0xc4,0xc4,0xc4,0xc4,0xc5,0xc4,0xc4,
	0xc4,0xc4,0xc5,0xc4,0xc4,0xc4,0xc4,0xc5,0xc4,0xc4,
	0xc4,0xc4,0xc5,0xc4,0xc4,0xc4,0xc4,0xc4,0xc4,0xc4,
	0xc4,0xc5,0xc4,0xc4,0xc4,0xc4,0xc4,0xc4,0xc5,0xc4,
	0xc4,0xc4,0xc4,0xc5,0xc4,0xc4,0xc4,0xc4,0xc4,0xc4,
	0xc4,0xc4,0xc5,0xc4,0xc4,0xc4,0xc4,0xc4,0xc4,0xc5,
	0xc4,0xc4,0xc4,0xc4,0xc4,0xc4,0xc4,0xc4,0xc4,0xc5,
	0xc4,0xc4,0xc4,0xc4,0xc4,0xc4,0xc4,0xc4,0xc4,0xb6,
0} ;

static char fancy7[81] = {
	0xc8,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcf,0xcd,0xcd,
	0xcd,0xcd,0xcf,0xcd,0xcd,0xcd,0xcd,0xcf,0xcd,0xcd,
	0xcd,0xcd,0xcf,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,
	0xcd,0xcf,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcf,0xcd,
	0xcd,0xcd,0xcd,0xcf,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,
	0xcd,0xcd,0xcf,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcf,
	0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcf,
	0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xbc,
0} ;

struct part {	/* An entry in the partition table */
	unsigned char	active;		/* active flag (0x80 or 0) */
	unsigned char	b_head;		/* begin head */
	unsigned char	b_sect ;	/* 	 sector */
	unsigned char	b_cyl;		/*	 cylinder */
	unsigned char	sysid;		/* system id */
	unsigned char	e_head;		/* end  head */
	unsigned char	e_sect ;	/* end	sector */
	unsigned char	e_cyl;		/* end	cylinder */
	/* These two are just longs, but this way is machine independent. */
	unsigned long	lsBeg;		/* logical sectors, beginning */
	unsigned long	lsLen;		/* logical sectors, length */
} *pp ;	/* partition table entry */

struct disk_param dk, lg, le ;

/* Function Prototype */
int getGeometry(int, struct disk_param*) ;
int getBBlk(int, char*) ;
char *getascii(unsigned int in_data[], int off_start, int off_end);
char *nameID(unsigned int);
void listPTable(void) ;
void long2chs(unsigned long, struct disk_param*, struct disk_param*) ;
void switch_list(void) ; 
void cmd_switch(char, int, char *[]) ;
void bugs(void), help(void) ;

/* Print heading */
printf("          ") ;
printf("  --- Partition Table and Hard Disk Examination Program ---\n") ;
printf("                    ") ;
printf("  Program written by Gary A. Allen, Jr.          \n") ;
printf("                    ") ;
printf("  %s\n",version) ;
printf("                    ") ;
printf("(c) Copyright 1993 by Gary A. Allen, Jr.\n\n") ;

/* Scan the after the dos command PART.EXE for switches or file name */
if (argc > 1) {
for (i = 1; i <= argc-1; i++) {
	/* Flush command vector */
	for (j = 0; j <= 7; j++) cmd[j] = '\0' ;
	/* Get command vector */
	sscanf(argv[i],"%c%c%c%c%c%c%c%c%c", &chr, &cmd[0], &cmd[1],
		&cmd[2], &cmd[3], &cmd[4], &cmd[5], &cmd[6], &cmd[7]) ;
	sw_null = FALSE ;
	if (chr == '?') help() ;
	if (chr == '-') {
		for (j = 0; j <= 7; j++) {
			cmd_switch(cmd[j], i, argv) ;
			if (sw_number) {
				i++ ;
				sw_number = FALSE ;
				break ;
			}
			if (sw_null) break ;
		} /* end of command "for" loop */

		if (j >= 7) {
printf("\n!!!! Too many commands on one \"-\" switch group.\n") ;
printf("!!!! Break up the commands into several \"-\" switch groups.\n") ;
			bugs() ;
		}
	} /* end of the "-" marker block */

	/* Deal with garbage on the command line */
	else {
printf ("\n!!!! The following on the command line was not understood:  %s \n",
	argv[i]);
		bugs() ;
	} /* garbage block */

} /* end of argument token "for" loop */

if (sw_help) help() ;
} /* end of the command switch block */

/* determine actual number of disk drives */
num_drv_act = 0 ;
while (!getGeometry(num_drv_act++,&dk)) ;
num_drv_act-- ;

if (num_drv_act == 0) {
printf("!!!! There is no hard disk on this computer!\n") ;
	bugs() ;
}

/* State the drive number */
if (num_drv_act != 1) printf("Describing hard disk #%d\n", device);

/* Ask BIOS how many disk drives there are */
/* Byte at Segment 40H Offset 75H */
num_drv_bios = peekb(0x40, 0x75) ;  /* BIOS Data area, Number of Hard disks */

/* Say how many drives are on this machine if the number is interesting */
if ((num_drv_act != num_drv_bios) || num_drv_act > 1) {
printf("BIOS reports %d hard disk(s) but ", num_drv_bios) ;
printf("there are actually %d disk(s) on this computer.\n", num_drv_act) ;
}

/* Deal with the error of asking for the wrong disk drive */
if ((device + 1) > num_drv_act) {
printf("!!!! There are only %d hard disk(s) on this computer but you\n",
	num_drv_act);
printf("!!!! requested disk #%d (master disk is disk #0).\n", device);
	bugs() ;
}

/* get disk parameters */
if (getGeometry(device,&dk)) {
printf("!!!! Function getGeometry found device %d not valid.\n", device);
	bugs() ;
}

/* Get the boot block. */
if (getBBlk(device, buffer) < 0) {
	printf("!!!! Could not read device number %d.\n", device);
	bugs() ;
}

/* Check the magic number. */
if ((buffer[MAGIC_LOC] & 0xFF) != MAGIC_0 ||
      (buffer[MAGIC_LOC+1] & 0xFF) != MAGIC_1) {
printf("\nWarning:  The boot sector has been found to have an invalid\n") ;
printf("magic number!  Do not reboot the hard disk until you fix this\n") ;
printf("problem.  You will need a partition editor like Pfdisk, Edpart\n") ;
printf("or the Norton Utility to do the fix.\n\n") ;
} /* end of the magic number "if" block */

/* Does it use a name table (for a boot menu)?     */
useNTable = ( buffer[LOC_GWR] == (char)0x3A );

/* Get IDE Drive info */
if (sw_ide) {
	while (inportb(0x1F7) != 0x50) ; /* Wait for controller not busy */

	/* Get first/second drive */
	outportb(0x1F6, (device == 0 ? 0xA0 : 0xB0));

	/* Get drive info data */
	outportb(0x1F7, 0xEC);         

	/* Wait for data ready */
	while (inportb(0x1F7) != 0x58) ;

	/* Read "sector" */
	for (i = 0; i < 256; i++) dd[i] = inport(0x1F0);

	if (sw_details) {
printf("Model Number ---------------------> %s\n", getascii(dd, 27, 46));
/* 
printf("Serial Number --------------------> %s\n", getascii(dd, 10, 19));
*/
printf("Controller Revision Number -------> %s\n", getascii(dd, 23, 26));
printf("Able to do Double Word Transfer --> %6s\n",
	(dd[48] == 0 ? "No" : "Yes"));
printf("Controller type ------------------>   %04X\n", dd[20]);
printf("Controller buffer size (bytes) ---> %6u\n", dd[21] * 512);
printf("Number of ECC bytes transferred --> %6u\n", dd[22]);
printf("Number of sectors per interrupt --> %6u\n\n", dd[47]);
	} /* end of the "ide details" block */

	printf("IDE  reports %d cylinders, %d heads (tracks) and"
		" %d sectors/cylinder for a\n", dd[1], dd[3], dd[6]) ;
	printf("     total (unformatted) capacity of %ld bytes.\n",
		(long) dd[1] * (long) dd[3] * (long) dd[6] * 512L) ;
	if ((!sw_bios) && (!sw_details)) printf("\n") ;
} /*  end of the "ide" block */

/* Display BIOS disk data */
if (sw_bios) {
	printf("BIOS reports %d cylinders, %d heads (tracks) and"
		" %d sectors/cylinder for a\n", dk.cyl, dk.head, dk.sect);
	printf("     total (unformatted) capacity of %ld bytes.\n",
 		(long) dk.cyl * (long) dk.head * (long) dk.sect * 512L) ;
	if (!sw_ide) printf("\n") ;
}

if ((sw_ide && sw_bios) || sw_details) {
printf("               [Press \"q\" to quit or any other key to continue]") ;
		chr = getche() ;
printf("\r                                                                 \n");
		if ((chr == 'q')||(chr == 'Q')) exit(0) ;
}

/* Scan the four partitions */
for (i = 0; i < 4; i++) {
	pp = (struct part *) &buffer[LOC_PT + i * 16];

	if (pp->active) {
		if (pp->active != 0x80)
printf("\nWarning: Partition %d is active, with the illegal activity byte %d\n",
	i+1, pp->active);
		sw_active[i] = TRUE ;
	}
	else sw_active[i] = FALSE ;

	/* physical beginning c,h,s */
	pbc = (pp->b_cyl & 0xff) | ((pp->b_sect << 2) & 0x300) ;
	pbh = pp->b_head;
	pbs = pp->b_sect & 0x3F;

	/* physical ending c,h,s */
	pec = (pp->e_cyl & 0xff) | ((pp->e_sect << 2) & 0x300) ;
	peh = pp->e_head;
	pes = pp->e_sect & 0x3F;

	/* compute logical beginning */
	lsbeg = pp->lsBeg;
	long2chs(lsbeg, &lg, &dk) ;

	/* compute logical ending */
	lslen = pp->lsLen;
	/* keep beginning <= end ... */
	if (lslen > 0) long2chs(lsbeg+lslen-1, &le, &dk) ;
	else long2chs(lsbeg, &le, &dk) ;

	if (useNTable) {
		prt_nam[i] = &buffer[LOC_NT + i * NT_ENTRY_SIZE ];
		type_code[i] = 0 ;
	}
	else {
		prt_nam[i] = nameID((unsigned int) pp->sysid);
		type_code[i] = (int) pp->sysid ;
	}

	cyl_bgn[i] = pbc ;
	cyl_lst[i] = le.cyl ;
	sect_str[i] = lsbeg ;
	sect_lng[i] = lslen ;
	head_bgn[i] = pbh ;
	head_end[i] = peh ;
	sect_bgn[i] = pbs ;
	sect_end[i] = pes ;

	/* That's all, for an empty partition. */
	if (pp->sysid == 0) continue;

	/* Now do some consistency checks...  */

	/* Same physical / logical beginning? */
	if (pbc != lg.cyl || pbh != lg.head || pbs != lg.sect ) {
printf("\nWarning: For partition %d\n", i+1);
printf("Physical beginning = %d cyl., %d head, %d sector\n", pbc, pbh, pbs);
printf("Logical beginning  = %d cyl., %d head, %d sector\n\n",
		lg.cyl, lg.head, lg.sect);
	}
	/* Same physical / logical ending? */
	if (pec != le.cyl || peh != le.head || pes != le.sect ) {
printf("\nWarning: For partition %d\n", i+1);
printf("Physical ending = %d cyl., %d head, %d sector\n", pec, peh, pes);
printf("Logical ending  = %d cyl., %d head, %d sector\n\n",
		le.cyl, le.head, le.sect);
	}

	/* Beginning on cylinder boundary? */
	if (pbc == 0) { /* exception: start on head 1 */
		if (pbh != 1 || pbs != 1) {
printf("\nWarning: Partition %d does not start on head 1.\n", i+1);
printf("Physical beginning = %d cyl., %d head, %d sector\n", pbc, pbh, pbs);
printf("         should be = %d cyl.,  1 head,  1 sector\n\n", pbc) ;
		}
	}
	else { /* not on cyl 0 */
		if (pbh != 0 || pbs != 1) {
printf("\nWarning: Partition %d does not start on head 0.\n", i+1);
printf("Physical beginning = %d cyl., %d head, %d sector\n", pbc, pbh, pbs);
printf("         should be = %d cyl.,  0 head,  1 sector\n\n", pbc) ;
     		}
   	}

	/* Ending on cylinder boundary? */
	if (peh != (dk.head-1) || pes != dk.sect) {
printf("\nWarning: Partition %d does not end on a cylinder boundary.\n", i+1);
printf("Physical ending = %d cyl., %d head, %d sector\n", pec, peh, pes);
printf("      should be = %d cyl., %d head, %d sector\n\n",
		pec,dk.head-1, dk.sect);
	}

} /* end of partition "for" loop */

/* showboot begins here */
sw_printf(fancy1);
sw_printf(fancy2);
else printf(plain1);
sw_printf(fancy3);
else printf(plain2);
sw_printf(fancy4);

if (sw_fancy) output_string = fancy5 ;
else output_string = plain3 ;

for (i = 0; i < 4; ++i) {
	if (sw_active[i]) active = "YES" ;
	else active = " NO";

	printf(output_string, prt_nam[i], type_code[i], active,
                 head_bgn[i], cyl_bgn[i], sect_bgn[i],
                 head_end[i], cyl_lst[i], sect_end[i],
                 sect_str[i], sect_lng[i]);

	if ((i < 3) && sw_fancy) printf(fancy6);
}
sw_printf(fancy7);
printf("\n\"Part\" has ended normally.  If you are interested in more ") ;
printf("information about\nthis program then type:  part -h \n");
return(0) ;
} /* --- end of the "main" routine. --- */

void long2chs(unsigned long ls, struct disk_param *lg, struct disk_param *dk)
{
int spc ;

spc = dk->head * dk->sect ;
lg->cyl = (int)(ls / spc) ;
ls = ls % spc;
lg->head = (int)(ls / dk->sect) ;
lg->sect = (int)(ls % dk->sect + 1) ;	/* sectors count from 1 */
} /* -- end of the "long2chs" subroutine -- */

char *nameID(unsigned int input_code)
{
struct intString {
	unsigned int code ;
	char *strg;
} *is ;
struct intString sysCodes[44] = {
	{ 0x01, "DOS-12  :12-bit FAT" },
	{ 0x02, "XENIX   :root" },
	{ 0x03, "XENIX   :usr" },
	{ 0x04, "DOS-16  :16-bit FAT" },
	{ 0x05, "DOSext  :DOS 3.3 extended volume" },
	{ 0x06, "DOSbig  :DOS 4.0 large volume" },
	{ 0x07, "OS/2    :OS/2 (or QNX or Adv. UNIX...)" },
	{ 0x08, "AIX     :file system" },
	{ 0x09, "AIXbt   :boot partition" },
	{ 0x0a, "BootMg  :OS/2 Boot Manager" },
	
	{ 0x10, "OPUS    :?" },
	{ 0x11, "DOS     :DOS seen from OS/2" },
	{ 0x17, "HPFS    :OS/2 High Performance File System" },
	{ 0x40, "VENIX   :Venix 80286" },
	{ 0x51, "NOVEL  :?" },
	{ 0x52, "CPM     :?" },
	{ 0x63, "UNIX    :System V/386" },
	{ 0x64, "NOVEL  :?" },
	{ 0x75, "PC/IX   :?" },
	{ 0x80, "Minix   :Minix (ver. 1.4a and earlier)" },
	{ 0x81, "Minix   :Minix (ver. 1.4b and later)" },
	{ 0x93, "Ameba  :Amoeba file system" },
	{ 0x94, "Ameba  :Amoeba bad block table?" },
	{ 0xA5,	"386BSD  :?" },
	{ 0xDB,	"C.DOS   :Concurrent DOS" },

	/* { 0xF2, "DOS-2nd :DOS 3.3+ second partition" }, */
	/* { 0xFF, "BAD-TRK :Bad track table?" }, */

	/* Make sure this is last! */
	{    0, "Empty " }
};

is = sysCodes;
while (is->code) {
	if (is->code == input_code) return(is->strg);
	is++;
}
if (!input_code) return(is->strg);
return("Unknwn");
} /* --- end of the "nameID" function --- */

int getGeometry(int dev, struct disk_param *pnt)
{
union REGS regs;
struct SREGS sregs;
  
regs.h.ah = 8;		/* get param.	*/
regs.h.dl = dev | 0x80;
  
int86x(0x13,&regs,&regs,&sregs);
  
/* Are that many drives responding? */
if ((regs.h.dl <= dev)||(regs.x.cflag)) return(1) ;
pnt->cyl = ((((int) regs.h.cl << 2) & 0x300) | regs.h.ch) + 2;
pnt->head = regs.h.dh + 1;
pnt->sect = regs.h.cl & 0x3F;
return(0) ;
} /* --- end of the function "getGeometry" --- */

int getBBlk(int dev, char *buf)
{	/* BIOS absolute disk read */
union REGS regs;
struct SREGS sregs;
  
segread(&sregs);	/* get ds */
sregs.es = sregs.ds;	/* buffer address */
regs.x.bx = (int) buf;
  
regs.h.ah = 2;		/* read		*/
regs.h.al = 1;		/* sector count	*/
regs.h.ch = 0;		/* track	*/
regs.h.cl = 1;		/* start sector	*/
regs.h.dh = 0;		/* head		*/
regs.h.dl = dev | 0x80;	/* drive	*/
  
int86x(0x13,&regs,&regs,&sregs);
if (regs.x.cflag) {
	printf("Function getBBlk found device %d not valid.\n", dev);
	return(-1);
}
return(SECSIZE);
} /* --- end of the "getBBlk" function --- */

void bugs(void)
/***************************************************************/
/*                                                             */
/*          (c) Copyright 1993 by Gary A. Allen, Jr.           */
/*            Program written by Gary A. Allen, Jr.            */
/*             Version:  Mk 1.0     24 October 1993            */
/*                                                             */
/***************************************************************/
{
printf("!!!! If confused, type:  part -h \n");
printf("!!!! --- Program ABORTED --- \n");
exit(0) ;
} /* --- end of the "bugs" subroutine --- */

void help(void) 
/*****************************************************/
/*                                                   */
/*                    Help Routine                   */
/*                                                   */
/*      (c) Copyright 1993 by Gary A. Allen, Jr.     */
/*        Program written by Gary A. Allen, Jr.      */
/*        Version:  Mk 1.0    24 October 1993        */
/*                                                   */
/*****************************************************/
{
printf("The following command line switches are recognized:\n");
printf("    -?  or -H    =    You typed this to get this output.\n");
switch_list() ;
exit(0);
} /* ---- end of the "help" subroutine ---- */

void description(void)
/***************************************************************/
/*                                                             */
/*          (c) Copyright 1993 by Gary A. Allen, Jr.           */
/*            Program written by Gary A. Allen, Jr.            */
/*             Version:  Mk 1.0     24 October 1993            */
/*                                                             */
/***************************************************************/
{
char chr ;

printf("          "
	"You are free to use, copy and distribute \"Part\" provided:\n") ;
printf("          "
	"       NO FEE IS CHARGED FOR USE, COPYING OR DISTRIBUTION.\n") ;
printf("          "
	"       THIS PROGRAM IS FOR PRIVATE, NONCOMMERICAL USE ONLY.\n") ;
printf("          "
	"       THE PROGRAM MAY NOT BE MODIFIED IN ANY WAY.\n\n") ;
printf("          "
	"Some code used by this program was derived from:\n") ;
printf("          "
	"       Pfdisk, Version 1.2.1 by Gordon W. Ross, Aug. 1990\n") ;
printf("          "
	"            and later modified by S. Lubkin  Oct. 1991\n") ;
printf("          "
	"       Dug_ide, Version 1.0 by Doug Merrett, 12 Jan 1993\n") ;

/* keep the screen from scrolling */
printf("               [Press \"q\" to quit or any other key to continue]") ;
chr = getche() ;
printf("\r                                                                 \n");
if ((chr == 'q')||(chr == 'Q')) exit(0) ;

printf("         "
	"DISCLAIMER: \"Part\" is offered on an as-is-basis without  any\n") ;
printf("         "
	"warranty to the  correct  functioning  or  fitness  for  any\n") ;
printf("         "
	"specific purpose.  To the  extent  permitted  by  applicable\n") ;
printf("         "
	"law,  the  author  disclaims  all  warranties,  expressed or\n") ;
printf("         "
	"implied, including but not limited to, any implied  warranty\n") ;
printf("         "
	"of merchantability or  fitness  for  a  particular  purpose.\n") ;
printf("         "
	"While effort has been made to ensure that  this  program  is\n") ;
printf("         "
	"accurate and correct, the author shall  not  be  liable  for\n") ;
printf("         "
	"damages arising out of the use of or inability to  use  this\n") ;
printf("         "
	"product, including but not limited to, loss of profit, data,\n") ;
printf("         "
	"or  use  of  this  software,  or  special,  incidental,   or\n") ;
printf("         "
	"consequential damages or other similar claims, even  if  the\n") ;
printf("         "
	"author has been specifically advised of the  possibility  of\n") ;
printf("         "
	"such  damages.  Some states do not allow  the  exclusion  of\n") ;
printf("         "
	"incidental or consequential damages.  The  author  prohibits\n") ;
printf("         "
	"the use of this program in such states.\n") ;

/* keep the screen from scrolling */
printf("               [Press \"q\" to quit or any other key to continue]") ;
chr = getche() ;
printf("\r                                                                 \n");
if ((chr == 'q')||(chr == 'Q')) exit(0) ;

printf("This program is strictly \"read-only\" and should never modify"
	"  the   partition\n") ;
printf("table or write to your  hard  disk.   You  can  safely  experiment"
	"  with  the\n") ; 
printf("executable, using any combination of switches without danger of"
	" damaging  the\n") ; 
printf("data on your hard disk.  The IDE data might be spurious if the hard"
	" disk does\n") ; 
printf("not have an IDE controller, i.e. it's a SCSI or ESDI.  If \"Part\""
	" encounters a\n") ; 
printf("corrupted hard disk then it might issue warnings.  If this should"
	" happen then\n") ; 
printf("you are strongly  advised  to  backup  all  data  on  the  disk  and"
	"  attempt\n") ; 
printf("restoration of the partition table before you reboot.\n\n") ;

printf("When corresponding please state which version of \"Part\" you are ") ;
printf("using. \n") ;
printf("Questions and complaints about this program should be sent to:\n\n") ;
printf("          E-mail address:     gary@brolga.cc.uq.oz.au\n") ;
printf("          Postal address:     Gary A. Allen, Jr. \n") ;
printf("                              P.O. Box 13\n") ;
printf("                              St. Lucia, Queensland  4067\n") ;
printf("		 	 	            Australia\n") ;
exit (0) ; 
} /* --- end of the "description" subroutine --- */

char *getascii(unsigned int in_data[], int off_start, int off_end)
{
register int i ;
char *pnt ;
static char ret_val[255];

pnt = ret_val ;

for (i = off_start; i <= off_end; i++) {
	*(pnt++) = (char) (in_data[i] / 256);  /* Get High byte */
	*(pnt++) = (char) (in_data[i] % 256);  /* Get Low byte */
}
*pnt = '\0';  /* Make sure it ends in a NULL character */

return(ret_val);
} /* --- end of the subroutine "getascii" --- */

void cmd_switch(char cmd, int i_point, char *argv[])
/*****************************************************/
/*                                                   */
/*         --- Command line Switch Parser ---        */
/*                                                   */
/*      (c) Copyright 1993 by Gary A. Allen, Jr.     */
/*        Program written by Gary A. Allen, Jr.      */
/*           Version:  Mk 1.1   24 October 1993      */
/*                                                   */
/*****************************************************/
{
void switch_list(void), description(void) ; 

switch (cmd) {
	case '\0':
	case -1:
		sw_null = TRUE ;
		return ;

	/* Get BIOS hard disk configuration data */
	case 'b':
	case 'B':
		sw_bios = TRUE ;
		return ;

	/* Select the disk drive to be examined */
	case 'd':
	case 'D':
		sw_number = TRUE ;
		device = atoi(argv[i_point+1]) ;
		return ;

	/* Get IDE hard disk configuration data */
	case 'I':
		sw_details = TRUE ;
	case 'i':
		sw_ide = TRUE ;
		return ;

	case 'x':
	case 'X':
		sw_fancy = FALSE ;
		return ;

	case 'z':
	case 'Z':
		description() ;

	/* Help option */
	case '?':
	case 'h':
	case 'H':
		sw_help = TRUE ;
		return ;

	case ' ':
	case '-':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
		return ;
	default:
printf("Command line switch -%c is unknown.  The following command\n",cmd) ;
printf("line switches are recognized:\n");
printf("    -?  or -H    =    Explains how to use this program.\n");
switch_list() ;
printf("\n                  *** Program PART aborted *** \n") ;
					exit(0) ;
}
} /* --- end of the cmd_switch subroutine --- */

void switch_list(void) 
/*****************************************************/
/*                                                   */
/*          --- Command line Switch List ---         */
/*                                                   */
/*      (c) Copyright 1993 by Gary A. Allen, Jr.     */
/*        Program written by Gary A. Allen, Jr.      */
/*           Version:  Mk 1.3   3 October 1993       */
/*                                                   */
/*****************************************************/
{
/*
char chr ;
*/

printf("    -b     -B    =    Show BIOS data for the hard disk(s)\n") ;
printf("                      specified.\n") ;
printf("    -d #   -D #  =    Select a specific hard drive to be examined\n") ;
printf("                      where \"# = 0\" is the master hard disk.\n") ;
printf("    -i           =    Show IDE data for total number of cylinders,\n") ;
printf("                      heads and number of sectors/track (cylinder)\n");
printf("           -I    =    Show detailed data about the IDE controller\n") ;
printf("                      along with total number of cylinders, etc.\n") ;
printf("    -x     -X    =    No fancy display format. Output becomes less\n");
printf("                      readable but is plain ASCII and will not\n") ;
printf("                      confuse other programs or strange terminals.\n") ;
printf("    -z     -Z    =    Describe this program, make legal disclamer\n") ;
printf("                      and mention any known bugs.\n") ;

/* keep the screen from scrolling */
/*
printf("               [Press \"q\" to quit or any other key to continue]") ;
chr = getche() ;
printf("\r                                                                 \n");
if ((chr == 'q')||(chr == 'Q')) exit(0) ;
*/
} /* --- end of the switch_list subroutine --- */
