// main program for clean

// include files
#include <bios.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <alloc.h>
#include <string.h>
#include "cleaner.h"  // structure definitions

// This is open source code - help yourself 

// declarations
void	gpdinit(uchar disk);
void	gbdinit(uchar disk);
int		get_key(void);
void	highliteon(int col,int row,char *string);
void	highliteoff(int col,int row,char *string);
int		read_sec( uchar far *buffer, ulong sectornumber, int type);
int		write_sec( uchar far *buffer, ulong sectornumber, int type);
void	clean_root(void);
void	clean_dir(uint cluster, char* name);
int 	getselection( int num_items, int lengthitems, int column, int *listpos,
					  char *listnames);
void	calc_cluster_sectors( uint cluster, ulong *first_sector, ulong *last_sector );
int		rd_multi(uchar far *buffer, ulong sectornumber, int type, int numsecs);
int		wt_multi(uchar far *buffer, ulong sectornumber, int type, int numsecs);
void	cln_free(void);
void	cln_ulge(void);
void	cln_ulg2(uint cluster);
void	clean_file(uint cluster,ulong file_size);

// structures
uchar	sector_buffer[512];
struct 	boot_disk_record hdb;
struct 	hdpartition hdp;
struct 	diskinfo_t mydisk;
struct 	hdpart_entry apart;
uint    partition_data_is_valid;
uchar 	current_drive;
uchar 	current_partition;
uint	dircount;
ulong	filecount;
uchar	far* big_bufzero;
uchar	far* big_bufaa;
uchar	far* big_buf55;

// program files
#include "function.cpp"
#include "getpartd.cpp"
#include "getbootd.cpp"
#include "cln_root.cpp"
#include "cln_dir.cpp"
#include "readsec.cpp"
#include "writesec.cpp"
#include "rd_multi.cpp"
#include "wt_multi.cpp"
#include "cln_free.cpp"
#include "cln_ulge.cpp"
#include "cln_ulg2.cpp"
#include "cln_file.cpp"
#include "chk_fats.cpp"
#include "winmang.cpp"

void main(void)
	{
	ulong	j;
	textbackground(BLUE);
	textcolor(WHITE);
	clrscr();
	gotoxy(30,9);
	cprintf("%s","D I S K   C L E A N");
	gotoxy(34,12);
	cprintf("%s","Version 1.0");
	gotoxy(33,15);
	cprintf("%s","Copyright 1999");
	gotoxy(34,16);
	cprintf("%s","W.S. Johnson");
	gotoxy(29,18);
	cprintf("%s","Press Any Key To Start");
	getch();

	current_drive = 0x0080;
	gpdinit((uchar)current_drive);
	gbdinit((uchar)current_drive);

	check_fats();

	big_bufzero = (uchar far*)farcalloc( (ulong)hdb.sectors_cluster*(ulong)hdb.bytes_sector, sizeof(uchar) );
	if( big_bufzero == NULL )
		{
		cprintf("\n\rFailed to allocate big_bufzero in cmain");
		getch();
		exit(0);
		}

	big_bufaa = (uchar far*)farcalloc( (ulong)hdb.sectors_cluster*(ulong)hdb.bytes_sector, sizeof(uchar) );
	if( big_bufaa == NULL )
		{
		cprintf("\n\rFailed to allocate big_bufaa in cmain");
		getch();
		exit(0);
		}

	big_buf55 = (uchar far*)farcalloc( (ulong)hdb.sectors_cluster*(ulong)hdb.bytes_sector, sizeof(uchar) );
	if( big_buf55 == NULL )
		{
		cprintf("\n\rFailed to allocate big_buf55 in cmain");
		getch();
		exit(0);
		}

	j = 0L;
	while( j < (ulong)hdb.sectors_cluster*(ulong)hdb.bytes_sector )
		{
		*(big_bufzero+(uint)j) = 0x00;
		*(big_bufaa+(uint)j)   = 0xaa;
		*(big_buf55+(uint)j)   = 0x55;
		j++;
		}

	set_main_window();

	farfree(big_bufzero);
	farfree(big_bufaa);
	farfree(big_buf55);

	textbackground(BLACK);
	textcolor(LIGHTGRAY);
	window(1,1,80,25);
	clrscr();
	gotoxy(1,1);
	}


