#ident "$Id: ctctrl.c,v 1.1 1992/01/15 01:15:30 chris Exp $"

/*
 *
 * Rev. 1.0  Very first revision for ix386 - 1989/12/18
 * $Log: ctctrl.c,v $
 * Revision 1.1  1992/01/15  01:15:30  chris
 * Initial revision
 *
 *
 *
 * chris@alderan.sdata.de
 */

#include <stdio.h>
#include <time.h>
#include <string.h>
#include <errno.h>


#define DWORD unsigned long

#include "aspi.h"
#include "scsi.h"
#include "scsierr.h"

extern int adapter_id;
extern int scsi_tape_id;
extern int lun_id;
#define TARGET adapter_id, scsi_tape_id, lun_id


extern char *getenv();
extern void aspiinit();
extern char *optarg;


static char *ctctrl_id = "$Id: ctctrl.c,v 1.1 1992/01/15 01:15:30 chris Exp $";

char *
index (s, c)
	char *s;
	int c;
{
	return (strchr (s, c));
}

void
bcopy (s1, s2, n)
	char *s1, *s2;
	int n;
{
	(void) memcpy (s2, s1, n);
}


void usage(cmd)
char *cmd;
{
    fprintf(stderr,"%s: tape control for SCSI stramer using ASPI\n",cmd);
    fprintf(stderr,"usage: %s [options]\n",cmd);
    fprintf(stderr,"Options:   -e     -  erase entire tape\n");
    fprintf(stderr,"           -t     -  retention tape\n");
    fprintf(stderr,"           -r     -  reset tape device\n");
    fprintf(stderr,"           -w     -  rewind tape (DEFAULT)\n");
    fprintf(stderr,"           -p [n] -  position tape to file [n]\n");
    fprintf(stderr,"                     n = 0 , position to logical end-of-tape (LEOT)\n");
    fprintf(stderr,"                     n < 0 , position relative to LEOT\n");
    fprintf(stderr,"           -q     -  quiet mode  -- don't ask questions\n");
}


int main(argc,argv)
int argc;
char **argv;
{
    char c, *cmd, *dev;
    int  eflag,tflag,rflag,wflag,pflag,qflag,pos;

    cmd = argv[0];
    eflag = tflag = rflag = wflag = pflag = qflag = pos = 0;

    while ( (c=getopt(argc,argv,"etrwp:?q")) != -1 )
	switch ( c )  {
	    case 'e':
		eflag = 1;
		break;
	    case 't':
		tflag = 1;
		break;
	    case 'r':
		rflag = 1;
		break;
	    case 'w':
		wflag = 1;
		break;
	    case 'q':
		qflag = 1;
		break;
	    case 'p':
		pflag = 1;
		if ( optarg )  pos = atoi(optarg);
		break;
	    case '?':
		usage(cmd);
                exit(-1);
	}

    if ( ! (eflag||tflag||rflag||wflag||pflag) ) wflag = 1;  /* default ! */

    if ( rflag )  eflag = tflag = wflag = pflag = 0;

    /* Our aspi - open() */
    aspiinit();

    if ( eflag )  {
	if ( ! qflag )  {
            printf("ARE YOU SURE YOU WANT TO ERASE THE TAPE (Y/N) ? ");
	    fflush(stdout);
	    c = getchar();
	    if ( (c!='y') && (c!='Y') )  {
		fprintf(stderr,"%s: operation canceled\n",cmd);
		exit(0);
	    }
	}
	pflag = 0;
    }

    if ( rflag )  {
      clock_t clk;
      int i;

      if ( SCSIResetDevice(TARGET) )  {
        ( void ) fprintf(stderr,"Error resetting Tape\n");
        exit(-1);
      }
      clk = clock();
      clk += ( clock_t ) 3 * CLK_TCK;
      while ( clock() < clk ) ;       /* delay three seconds */

      while ( (i=SCSIRewind(TARGET, 0, 0)) == E$UnitAttention )  ;
      if ( i )  {
        ( void ) fprintf(stderr,"Error rewinding Tape\n");
        exit(-1);
      }

    }

    if ( tflag )  {  /* retension tape */ 
        if ( SCSIRewind(TARGET, 0, 0) )  {
            ( void ) fprintf(stderr,"Error rewinding Tape\n");
            exit(-1);
	}
        if ( ! qflag ) printf("retention tape .. ");
	fflush(stdout);
        if ( SCSILoad(TARGET, 0, 1, 1, 0, 0) )  {
            ( void ) fprintf(stderr,"Error retention Tape\n");
            ( void ) SCSIRewind(TARGET, 0, 0 );
            exit(-1);

        }

        if ( SCSILoad(TARGET, 0, 0, 0, 0, 0) )  {
            ( void ) fprintf(stderr,"Error unloading Tape\n");
            exit(-1);
	}

    }

    if ( wflag )  {
	if ( ! qflag ) printf("rewinding tape .. ");
	fflush(stdout);
        if ( SCSIRewind(TARGET, 0, 0) ) {
            ( void ) fprintf(stderr,"Error rewinding Tape\n");
            exit(-1);
	}
	if ( ! qflag ) printf("[OK]\n");
    }

    if ( eflag )  {
        if ( SCSILoad(TARGET, 0, 1, 0, 0, 0) )  {
            ( void ) fprintf(stderr,"Error loading Tape\n");
            ( void ) SCSIRewind(TARGET, 0, 0 );
            exit(-1);
	}
	if ( ! qflag )  printf("eraseing tape .. ");
	fflush(stdout);

        if ( SCSIErase(TARGET, 0, 1, 0) )  {
            ( void ) fprintf(stderr,"Error eraseing Tape\n");
            ( void ) SCSIRewind(TARGET, 0, 0 );
            exit(-1);
	}

	if ( ! qflag ) printf("[OK]\n");

        if ( SCSILoad(TARGET, 0, 0, 0, 0, 0) ) {
            ( void ) fprintf(stderr,"Error unloading Tape\n");
            exit(-1);
	}

    }

    if ( pflag )  {
        if ( SCSIRewind(TARGET, 0, 0) ) {
            ( void ) fprintf(stderr,"Error rewinding Tape\n");
            exit(-1);
	}

	if ( pos > 0 )  {
	    if ( ! qflag ) printf("seeking to tapefile #%d .. ",pos);
            fflush(stdout);
            if ( pos > 1 )  {
              if ( SCSISpace(TARGET, 1, ( long ) pos - 1l, 0) )   {
                ( void ) fprintf(stderr,"Error positioning Tape\n");
                exit(-1);
              }
            }
	    if ( ! qflag ) printf("[OK]\n");
	} else  if ( pos == 0 ) {
	    if ( ! qflag ) printf("seeking to End of Tape ");
	    fflush(stdout);
            pos = 1;
            while ( !SCSISpace(TARGET, 1, 1l, 0) ) {
              ++pos;
              if ( ! qflag ) putchar('.');
              fflush(stdout);
	    }
	    if ( ! qflag ) printf(" next tapefile is #%d [OK]\n",pos);
	} else if ( pos < 0 )  {
	    int p;

	    if ( ! qflag ) printf("seeking to file EOT%d ",pos);
	    fflush(stdout);

            p = 1;
            while ( !SCSISpace(TARGET, 1, 1l, 0) )  {
                ++p;
		if ( ! qflag ) putchar('.');
		fflush(stdout);
	    }
            if ( SCSIRewind(TARGET, 0, 0) ) {
              ( void ) fprintf(stderr,"Error rewinding Tape\n");
              exit(-1);
            }
	    p += pos;
	    if ( p < 1 ) p = 1;
	    if ( ! qflag ) printf(" tapefile #%d .. ",p);
	    fflush(stdout);
            if ( p > 1 )  {
              if ( SCSISpace(TARGET, 1, ( long ) p - 1l, 0) )   {
                ( void ) fprintf(stderr,"Error positioning Tape\n");
                exit(-1);
              }
            }

	    if ( ! qflag ) printf("[OK]\n");
	}
    }
    return pflag ? pos-1 : 0;
}
