#ident "$Id: aspi.h,v 1.3 1991/05/11 13:07:36 chris Exp $"

/*
 $Log: aspi.h,v $
 * Revision 1.3  1991/05/11  13:07:36  chris
 * Add the _srbgeneric structure
 *
 * Revision 1.2  1991/05/02  21:21:16  chris
 * bug fix in the "rdwr" CCB
 *
 * Revision 1.1  1991/03/04  01:21:34  chris
 * Initial revision
 *
 */

static char *aspi_h_id = "$Id: aspi.h,v 1.3 1991/05/11 13:07:36 chris Exp $";

/*
 * structures and typedefs for aspi.c
 */

#pragma pack(1)

struct _srbhead {
  unsigned char cmd;
  unsigned char status;
  unsigned char adapter;
  unsigned char flags;
  DWORD reserved;
} ;

struct _srbinquiry {
  struct _srbhead h;
  unsigned char adapters;
  unsigned char target_id;
  char manager_id[16];
  char adapter_id[16];
  unsigned char parameters[16];
} ;

struct _srbgettyp {
  struct _srbhead h;
  unsigned char target_id;
  unsigned char lun;
  unsigned typ;
} ;

struct _srbreset {
  struct _srbhead h;
  unsigned char target_id;
  unsigned char lun;
  unsigned char reserved[14];
  unsigned char adapter_status;
  unsigned char target_status;
  unsigned int post_off;
  unsigned int post_seg;
  unsigned char workspace[34];
} ;

struct _ccb6  {                 /* common ccb for 6 byte commands */
  unsigned cmd : 8;
  unsigned flag0 : 1;
  unsigned flag1 : 1;
  unsigned flag2 : 1;
  unsigned flag3 : 1;
  unsigned flag4 : 1;
  unsigned lun : 3;
  unsigned adr_1 : 8;
  unsigned adr_0 : 8;
  unsigned len : 8;
  unsigned control : 8;
  unsigned char sense[14];
} ;

struct _ccb10 {                 /* common ccb for 10 byte commands */
  unsigned cmd : 8;
  unsigned flag0 : 1;
  unsigned flag1 : 1;
  unsigned flag2 : 1;
  unsigned flag3 : 1;
  unsigned flag4 : 1;
  unsigned lun : 3;
  unsigned adr_3 : 8;
  unsigned adr_2 : 8;
  unsigned adr_1 : 8;
  unsigned adr_0 : 8;
  unsigned _reserved1 : 8;
  unsigned len_1 : 8;
  unsigned len_0 : 8;
  unsigned control : 8;
  unsigned char sense[14];
} ;

struct _fmt  {                  /* used for the format unit command */
  unsigned cmd : 8;
  unsigned list_fmt : 3;
  unsigned cmplist : 1;
  unsigned fmtdata : 1;
  unsigned lun : 3;
  unsigned vendor : 8;
  unsigned i1 : 8;
  unsigned i0 : 8;
  unsigned control : 8;
  unsigned char sense[14];
} ;

struct _inq  {                  /* used for the scsi inquiry command */
  unsigned cmd : 8;
  unsigned _reserved1 : 5;
  unsigned lun : 3;
  unsigned _reserved2 : 7;
  unsigned evpd : 1;
  unsigned vpd : 8;
  unsigned len : 8;
  unsigned control : 8;
  unsigned char sense[14];
} ;

struct _stp  {                 /* used for the start/stop unit command */
  unsigned cmd : 8;
  unsigned immed : 1;
  unsigned _reserved1 : 4;
  unsigned lun : 3;
  unsigned _reserved2 : 8;
  unsigned _reserved3 : 8;
  unsigned start : 1;
  unsigned eject : 1;
  unsigned _reserved4 : 6;
  unsigned control : 8;
  unsigned char sense[14];
} ;

struct _rem  {                 /* used for the allow medium removal command */
  unsigned cmd : 8;
  unsigned _reserved1 : 5;
  unsigned lun : 3;
  unsigned _reserved2 : 8;
  unsigned _reserved3 : 8;
  unsigned prevent : 1;
  unsigned _reserved4 : 7;
  unsigned control : 8;
  unsigned char sense[14];
} ;

struct _ld  {                /* used for the load/unload command */
  unsigned cmd : 8;
  unsigned immediate : 1;
  unsigned _reserved1 : 4;
  unsigned lun : 3;
  unsigned _reserved2 : 8;
  unsigned _reserved3 : 8;
  unsigned load : 1;
  unsigned retention : 1;
  unsigned eot : 1;
  unsigned _reserved4 : 5;
  unsigned control : 8;
  unsigned char sense[14];
} ;

struct _rdwr  {              /* used for sequencial read/write command */
  unsigned cmd : 8;
  unsigned fixed : 1;
  unsigned sili : 1;
  unsigned _reserved1 : 3;
  unsigned lun : 3;
  unsigned len_2 : 8;
  unsigned len_1 : 8;
  unsigned len_0 : 8;
  unsigned control : 8;
  unsigned char sense[14];
} ;

struct _spc  {               /* used for the space command */
  unsigned cmd : 8;
  unsigned code : 3;
  unsigned _reserved1 : 2;
  unsigned lun : 3;
  unsigned cnt2 : 8;
  unsigned cnt1 : 8;
  unsigned cnt0 : 8;
  unsigned control : 8;
  unsigned sense[14];
} ;

union _ccb  {
  struct _ccb6 c6;
  struct _ccb10 c1;
  struct _fmt fmt;
  struct _inq inq;
  struct _stp stp;
  struct _rem rem;
  struct _ld ld;
  struct _rdwr rdwr;
  struct _spc spc;
} ;

struct _srbio  {
  struct _srbhead h;
  unsigned char target_id;
  unsigned char lun;
  DWORD alloc_len;
  unsigned char sense_len;
  unsigned int  buf_off;
  unsigned int  buf_seg;
  unsigned int  link_off;
  unsigned int  link_seg;
  unsigned char cdb_len;
  unsigned char adapter_status;
  unsigned char target_status;
  unsigned int  post_off;
  unsigned int  post_seg;
  unsigned char workspace[34];
  union _ccb ccb;
} ;

struct _srbgeneric {
  struct _srbhead h;
  unsigned char target_id;
  unsigned char lun;
  DWORD alloc_len;
  unsigned char sense_len;
  unsigned int  buf_off;
  unsigned int  buf_seg;
  unsigned int  link_off;
  unsigned int  link_seg;
  unsigned char cdb_len;
  unsigned char adapter_status;
  unsigned char target_status;
  unsigned int  post_off;
  unsigned int  post_seg;
  unsigned char workspace[34];
} ;
