echo off
cls
echo.
echo.
echo           SAMPLE2.BAT
echo.
echo.

rem
rem
rem     This batch file demonstrates how a batch file can be used
rem     to perform TAPE commands. With this batch file, commands
rem     that are required for advanced backup operations are demonstrated,
rem     including:
rem 
rem         Tape retensioning
rem         Appended backups
rem         Volume names and search labels assigned to each backup
rem         Errorlevel checking
rem
rem     This batch file will perform a selective backup of the drive or
rem     drives specified as the parameter in the command line.  For example, 
rem     if the following is entered from the DOS command line:
rem
rem         SAMPLE2 C: D:
rem
rem     then complete selective backups of drives C: and D: will be performed.
rem     Also, the batch file will record a log of the tape operations and 
rem     their results in the file TAPELOG.
rem
rem     This file uses certain DOS batch file commands, such as replaceable
rem     parameters and IF statements.  Refer to your DOS Reference Manual
rem     for more on batch files and batch file commands.
rem
rem     This file will also use the UTL and SBK tape commands and some of 
rem     their parameters.  Refer to the Mountain FileSafe TAPE Software User's
rem     Guide for more on these commands.
rem

rem
rem     First, we need to check to see if the user entered any drive
rem     identifiers from the DOS command line.  If not, then we will go 
rem     to a section that will display the usage instructions.
rem

if "%1"=="" goto usage

rem     Okay, so let's start with the backup of the first specified drive.
rem     First, before we start the first backup, let's retension the tape.
rem
rem     NOTE: The retension command is not necessary for the 1200 
rem     series drives and is therefore an unavailable option.

echo.                                                              >TAPELOG
echo Retensioning tapes.                                          >>TAPELOG
echo.                                                             >>TAPELOG


TAPE UTL T

rem     Next, let's backup the first specified drive. We're using the
rem     following parameters to the SBK (Selective Backup) command:
rem
rem         %1          - The parameter that contains the drive designator.
rem
rem         \/S         = Backup all files starting at root and 
rem                       include all subdirectories.
rem
rem         /V          = After backup, read files from tape and disk, 
rem                       and verify them.
rem
rem         /C+         = Do not pause for the Overwrite warning. Also, 
rem                       continue after certain file errors are encountered.
rem
rem                       Any files that cannot be opened or read will be 
rem                       skipped and noted within SKIPLIST.TXT.
rem
rem         /P-S-I-R    = Disable prompting for system files (S), hidden or
rem                       invisible files (I), and read-only files (R).
rem     
rem         /NDrive-%1  = Assign a name to the backup volume. The name
rem                       is "Drive-" followed by the drive designator.
rem                       For example, "Drive-C:".
rem     
rem         /LDrive-%1  = Assign a unique label for volume searching. The 
rem                       label is "Drive-" followed by the drive designator.
rem                       For example, "Drive-C:".
rem

echo.                                                             >>TAPELOG
echo Backing up drive %1.                                         >>TAPELOG
echo Volume label = Drive-%1                                      >>TAPELOG
echo.                                                             >>TAPELOG

TAPE SBK %1\/S /V /C+ /P-S-I-R /N Drive-%1 /L Drive-%1

rem
rem     Next, let's check the result of the tape operation.  If an error
rem     occurred, then an errorlevel will be set and can be queried from this
rem     batch file.
rem

if errorlevel 5 goto error5
if errorlevel 4 goto error4
if errorlevel 3 goto error3
if errorlevel 2 goto error2
if errorlevel 1 goto error1

:next
rem
rem     Next, let's backup all of the other drives specified on the DOS
rem     command line.  First, check to see if there are any other drives
rem     entered.  If nothing is left to back up, then we will exit.
rem

shift
if "%1" == "" goto end

rem     Okay, so we've got another drive to backup.  So, we'll back up this
rem     drive in the same way that we did before.  However, we will perform
rem     an appended backup and will use the /A parameter to do this.
rem

echo.                                                             >>TAPELOG
echo Backing up drive %1.                                         >>TAPELOG
echo Volume label = Drive-%1                                      >>TAPELOG
echo.                                                             >>TAPELOG

TAPE SBK %1\/S /V /C+ /P-S-I-R /A /N Drive-%1 /L Drive-%1

if errorlevel 5 goto error5
if errorlevel 4 goto error4
if errorlevel 3 goto error3
if errorlevel 2 goto error2
if errorlevel 1 goto error1
goto next

:error1
echo No files found to backup.                                    >>TAPELOG
goto next

:error2
echo Some files have not been backed up due to file sharing       >>TAPELOG
echo conflicts.  The following is the list of files that          >>TAPELOG
echo have been skipped.                                           >>TAPELOG
echo.                                                             >>TAPELOG
TYPE %1\SKIPLIST.TXT                                              >>TAPELOG
echo.                                                             >>TAPELOG
echo Backing up files that have been modified since last backup.  >>TAPELOG

TAPE SBK %1\/S /V /C+ /P-S-I-R /A /M /NDrive-%1 (Modified Files) /LDrive-%1 (Modified)
if errorlevel 5 goto error5
if errorlevel 4 goto error4
if errorlevel 3 goto error3
if errorlevel 2 goto mod_error
if errorlevel 1 goto error1
goto next

:mod_error
echo Some files still cannot be backed up due to file sharing     >>TAPELOG
echo conflicts.  The following is the list of files that          >>TAPELOG
echo have been skipped.                                           >>TAPELOG
echo.                                                             >>TAPELOG
TYPE %1\SKIPLIST.TXT                                              >>TAPELOG
echo.                                                             >>TAPELOG
goto next

:error3
echo Tape command terminated by user.                             >>TAPELOG
goto end

:error4
echo Tape command terminated due to internal error.               >>TAPELOG
goto end

:error5
echo Trouble creating SKIPLIST.TXT or TAPE_DTE.DAT.              >>TAPELOG
echo Some files have been skipped.                               >>TAPELOG
goto next

:usage
echo   Usage: SAMPLE2 d:   
echo          where d: is the identifier of the drive that will be
echo          backed up. More than one drive can be specified for backup.
echo.
echo    Example:    SAMPLE2 C: D: X:
echo.
echo.

:end

