%title 'An ix86 disassembler by me, (c) 1998 Henrik Nebrin'

;This module assumes only EAX,ECX and EDX may be changed during
;a call to the high level language compiler output.

        ideal
        p386
        largestack
        nowarn  brk

op1isfirst      equ     1               ;defined if opcode.op1 ofs = 0000h

ifdef Clib
is32            equ     1
        include 'C.inc'
else
_wordsize       equ     4
        include 'proc32.inc'
endif
        include '__dislib.inc'
        include 'dislib.inc'

signed          equ     0001h           ;eax is a signed number
showsign        equ     0002h           ;always show '+' or '-'
bighex          equ     0004h           ;big hex characters (A-F) (ntoa:proc)

macro   checkoperand
ifdef Clib
        call    near ptr dis_checkoperand
else
        call    (dis_input_t ptr __dis_gs:esi).checkoperand
endif
endm    checkoperand

ifdef Clib
        extrn   ___dis:procptr
else
        extrn   ntoa:procptr
endif

        startcode
ifdef Clib
        ;
        ;   dis_checkoperand:near
        ;
        ;   check an operand
        ;
        ;   input: __dis_gs:esi dis_input_t struc
        ;          __dis_gs:ebx dis_operand_t struc
        ;          _es:edi string
        ;   output: cf=1=nothing changed
        ;           cf=0=printed something in the string and advanced it
        ;   registers: cf=1=none,cf=0=di
        ;
proc    dis_checkoperand near
        push    eax ecx edx
if @datasize
        push    es edi
        mov     eax,esp
        push    ss eax gs ebx gs esi
        call    (dis_input_t ptr __dis_gs:esi).checkoperand
        add     esp,00000018h
        pop     edi ecx
else
  ifdef stackfar
    err
  endif
        push    edi esp ebx esi
        call    (dis_input_t ptr __dis_gs:esi).checkoperand
        pop     ecx edx ecx edi
endif
        cmp     eax,00000001h
@@666:
        pop     edx ecx eax
        retn
endp    dis_checkoperand

        ;
        ;   ntoa:proc
        ;
        ;   convert a number to ascii
        ;
        ;   input: eax  number to convert to ascii
        ;          ecx  minimum # of digits to print
        ;          bl   flags (see equates)
        ;          bh   base (10b=binary,10o=octal,10d=decimal,10h=hex)
        ;          es:edi string to convert it to
        ;   output: es:edi string with number in (zero terminated)
        ;           eax zero
        ;           ecx # of digits the string has (incl. '+' or '-')
        ;   registers: eax,ecx
        ;
proc    ntoa near
        public  ntoa
        call    near ptr __ntoa
        mov     byte ptr _es:[edi+ecx],00h
        retn
endp    ntoa

        ;
        ;   __ntoa:proc
        ;
        ;   convert a number to ascii
        ;
        ;   input: eax  number to convert to ascii
        ;          ecx  minimum # of digits to print
        ;          bl   flags (see equates)
        ;          bh   base (10b=binary,10o=octal,10d=decimal,10h=hex)
        ;          es:edi string to convert it to
        ;   output: es:edi string with number in (NOT zero terminated!!!)
        ;           eax zero
        ;           ecx # of digits the string has (incl. '+' or '-')
        ;   registers: eax,ecx
        ;
proc    __ntoa near
if @datasize
        push    ds
endif
        push    edx ebp esi edi
if @datasize
        push    es
        pop     ds
        assume  ds:nothing
endif
        test    bl,signed
        jz      short @@10
        test    eax,eax
        jns     short @@10
        neg     eax
        mov     byte ptr ds:[edi],'-'
        jmp     short @@incedi
@@10:
        test    bl,showsign
        jz      short @@20
        mov     byte ptr ds:[edi],'+'
@@incedi:
        inc     edi
@@20:
        test    ecx,ecx
        jnz     short @@30
        inc     ecx
@@30:
        xor     esi,esi
        movzx   ebp,bh
@@pushloop:
        xor     edx,edx
        div     ebp
        push    edx
        inc     esi
        test    eax,eax
        jnz     short @@pushloop

        mov     edx,esi
        mov     ebp,ecx
        sub     ecx,esi
        jbe     short @@40
        mov     edx,ebp
        mov     al,'0'
        rep stosb
@@40:
        mov     ecx,edx
        mov     dl,'a'-('0'+10)
        mov     dh,'0'
        test    bl,bighex
        jz      short @@no
        mov     dl,'A'-('0'+10)
@@no:
@@poploop:
        pop     eax
        add     al,dh
        cmp     al,'9'
        jbe     short @@50
        add     al,dl
@@50:
        mov     [edi],al
        inc     edi
        dec     esi
        jg      short @@poploop
@@666:
        pop     edi esi ebp edx
        mov     al,[edi]
        cmp     al,'-'
        je      short @@60
        cmp     al,'+'
        jne     short @@70
@@60:
        inc     ecx
@@70:
        xor     eax,eax
if @datasize
        pop     ds
        assume  ds:@data
endif
        retn
        assume  ds:@data
endp    __ntoa

proc    _dis_printinstruction procptr
        public  _dis_printinstruction
        arg     dis_input:dataptr,deststring:dataptr
        push    ebp
        mov     ebp,esp
        jmp     short _dis_jmphere
endp    _dis_printinstruction
endif

        ;
        ;   dis:proc
        ;
        ;   disassemble one instruction and print it in a string (reentrant)
        ;
        ;   input: __dis_gs:esi dis_input_t struc
        ;          _es:edi string to print the finished result
        ;   output: cf=1=error
        ;           cf=0=ok
        ;   registers: none
        ;
proc    __ret procptr
ifdef Clib
        xor     eax,eax
        pop     ebp
endif
        ret
endp    __ret
ifdef Clib
proc    _dis procptr
        public  _dis
else
proc    dis procptr
endif
        assume  es:nothing,cs:@code,ss:@stack,ds:@data,fs:nothing,gs:nothing
ifdef Clib
        arg     dis_input:dataptr,deststring:dataptr
        push    ebp
        mov     ebp,esp
  if @datasize
        push    dword ptr dis_input+4 dword ptr dis_input
  else
        push    dis_input
  endif
        call    ___dis
  if @datasize
        pop     ecx
  endif
        pop     ecx
        test    eax,eax
        jz      short __ret
_dis_jmphere:
        push    ebx esi edi
  if @datasize
        push    es gs
        lgs     esi,fword ptr dis_input  ;tasm bug: dataptr is 48-bits
        les     edi,fword ptr deststring ; in a 32-bit segment
        local   savedebx:dword,savedesi:dword,savededi:dword,\
                savedes:dword,savedgs:dword,\
                op1ptr:dword,op2ptr:dword,op3ptr:dword=localsize
  else
        mov     esi,dis_input
        mov     edi,deststring
        local   savedebx:dword,savedesi:dword,savededi:dword,\
                op1ptr:dword,op2ptr:dword,op3ptr:dword=localsize
  endif
        cld
else
        call    __dis
        jc      short __ret
label   dis_printinstruction procptr
        local   deststring:dword,op1ptr:dword,op2ptr:dword,op3ptr:dword=localsize
        pushad
        mov     ebp,esp
        push    edi
endif
ifdef op1isfirst
        push    esi
else
        lea     eax,(dis_input_t ptr __dis_gs:esi).__dis_input.opcode.op1
        push    eax
endif
        lea     eax,(dis_input_t ptr __dis_gs:esi).__dis_input.opcode.op2
        push    eax
        lea     eax,(dis_input_t ptr __dis_gs:esi).__dis_input.opcode.op3
        push    eax

        cmp     (dis_input_t ptr __dis_gs:esi).__dis_input.opcode.prefixes,00h
        je      short @@skipprefixes
        mov     cl,20h
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_attsyntax
        jz      short @@noitisnt
        mov     cl,';'
@@noitisnt:
macro   p x,y
        local   @@10
        testflag (dis_input_t ptr __dis_gs:esi).__dis_input.opcode.prefixes,x
        jz      short @@10
        mov     ebx,offset y
        call    near ptr copyopname
        mov     al,cl                   ;;" "=intel,";"=at&t
        stosb
@@10:
endm    p
        p       __dis_lockprefix,@lock
        p       __dis_repprefix,@rep
        p       __dis_repnzprefix,@repne
purge   p
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_tabafterrep
        jz      short @@notabafterrep
        test    (dis_input_t ptr __dis_gs:esi).__dis_input.opcode.prefixes,__dis_repprefix or __dis_repnzprefix
        jz      short @@notabafterrep
        dec     edi                     ;the space we printed
        call    near ptr @@printtabspaces
@@notabafterrep:
@@skipprefixes:
        movzx   eax,byte ptr (dis_input_t ptr __dis_gs:esi).__dis_input.opcode.opcodeid
        movzx   ebx,byte ptr (dis_input_t ptr __dis_gs:esi+01h).__dis_input.opcode.opcodeid
        mov     ecx,offset opcodeidsatt
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_attsyntax
        jnz     short @@att1
        mov     ecx,offset opcodeids
@@att1:
        mov     ebx,[ecx+ebx*4]
        mov     ebx,[ebx+eax*4]
        call    near ptr copyopname
        ;All fields in opcode are undefined if noperands=00h!!! Check it first
        movzx   ecx,(dis_input_t ptr __dis_gs:esi).__dis_input.opcode.noperands
ifdef Clib
        jecxz   @@666
else
        jecxz   @@666
endif
        testflag (dis_input_t ptr __dis_gs:esi).__dis_input.opcode.flags,do_dontprintops
ifdef Clib
        jnz     @@666
else
        jnz     short @@666             ;mostly for string instr. + xlat
endif
        push    ecx
        call    near ptr @@printtabspaces
        pop     ecx
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_attsyntax
        jz      short @@notatt
        cmp     (dis_input_t ptr __dis_gs:esi).__dis_input.opcode.opcodeword,opid_opnames1+00C8h
        je      short @@notatt          ;enter instruction is not reversed
        cmp     (dis_input_t ptr __dis_gs:esi).__dis_input.opcode.opcodeid,opid_db
        je      short @@notatt          ;if it's "db XX,XX,XX"
        cmp     ecx,0002h
        jb      short @@notatt
        ja      short @@three
@@two:
ifdef op1isfirst
        mov     op2ptr,esi
else
        lea     eax,(dis_input_t ptr __dis_gs:esi).__dis_input.opcode.op1
        mov     op2ptr,eax
endif
        lea     eax,(dis_input_t ptr __dis_gs:esi).__dis_input.opcode.op2
        jmp     short @@movop1ptrax
@@three:
ifdef op1isfirst
        mov     op3ptr,esi
else
        lea     eax,(dis_input_t ptr __dis_gs:esi).__dis_input.opcode.op1
        mov     op3ptr,eax
endif
        lea     eax,(dis_input_t ptr __dis_gs:esi).__dis_input.opcode.op3
@@movop1ptrax:
        mov     op1ptr,eax
@@notatt:
        lea     ebx,op1ptr
        jmp     short @@starthere
@@operandsloop:
        call    near ptr printcomma
@@starthere:
        push    ecx ebx
ifdef stackfar
        segss
endif
        mov     ebx,[ebx]
        push    ebx
        mov     ebx,(dis_operand_t ptr __dis_gs:ebx).flags
        and     ebx,dop_typemask
        mov     eax,offset operandcallatt
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_attsyntax
        jnz     short @@attyes
        mov     eax,offset operandcall
@@attyes:
        mov     eax,[eax+ebx*4]
        pop     ebx
        call    eax
        pop     ebx ecx
        sub     ebx,00000004h
        loop    @@operandsloop
@@666:
ifdef Clib
        xor     eax,eax
else
        xor     al,al
endif
        stosb
ifdef Clib
        inc     eax
  if @datasize
        mov     es,savedes      ;might need to put a "word ptr" here
        mov     gs,savedgs      ; if the assembler complains
  endif
        mov     ebx,savedebx
        mov     esi,savedesi
        mov     edi,savededi
        leaved
else
        mov     esp,ebp
        popad
endif
@@retn:
        ret

        ;
        ;   @@printtabspaces:near
        ;
        ;   print spaces in deststring (at least one space)
        ;
        ;   input: __dis_gs:esi dis_input_t struc
        ;          es:edi >= deststring (offset)
        ;   output: es:edi after the last spaces printed
        ;   registers: eax,ecx,edi
        ;
@@printtabspaces:
        mov     ecx,edi
        xor     eax,eax
        sub     ecx,dword ptr deststring
        mov     al,(dis_input_t ptr __dis_gs:esi).tabsize
        sub     eax,ecx
        ja      short @@lok
        xor     eax,eax
        inc     eax
@@lok:
        xchg    ecx,eax
        mov     al,20h
        rep stosb
printtabspacesretn:
        retn
ifdef Clib
endp    _dis
else
endp    dis
endif

        ;
        ;   printcomma:near
        ;
        ;   print a comma and a space if necessary
        ;
        ;   input: __dis_gs:esi dis_input_t struc
        ;          es:edi string
        ;   output: es:edi after the comma (and space if we printed it)
        ;   registers: al,edi
        ;
proc    printcomma near
        mov     al,','
        stosb
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_commaspace
        jz      short @@666
        mov     al,' '
        stosb
@@666:
        retn
endp    printcomma

        ;
        ;   convertdop_sizeequ:near
        ;
        ;   convert a dop_sizebyte/word/dword equate to something in ch
        ;
        ;   input: al   euqate (00h=byte,01h=word or 02h=dword)
        ;   output: ch  01h=byte/02h=word/04h=dword
        ;   registers: ch
        ;
proc    convertdop_sizeequ near
        ;NOTE: Assumes byte=0,word=1,dword=2 !!!!!
        mov     ch,al
        and     ch,03h
        add     ch,ch
        jnz     short @@666
        inc     ch
@@666:
        retn
endp    convertdop_sizeequ

        ;
        ;   dis_regatt:near
        ;
        ;   print a register (at&t syntax)
        ;
        ;   input: __dis_gs:esi dis_input_t struc
        ;          __dis_gs:ebx dis_operand_t struc
        ;          es:edi string
        ;   output: es:edi after the stuff we printed
        ;   registers:
        ;
proc    dis_regatt near
        call    near ptr checkindirectcalljmp
        jmp     short dis_regcontinue
endp    dis_regatt

        ;
        ;   dis_reg:near
        ;
        ;   print a register
        ;
        ;   input: __dis_gs:esi dis_input_t struc
        ;          __dis_gs:ebx dis_operand_t struc
        ;          es:edi string
        ;   output: es:edi after the stuff we printed in it
        ;   registers:
        ;
proc    dis_reg near
        call    near ptr printsmallorlarge
dis_regcontinue:
        checkoperand
        jnc     short printregisterretn
dis_regprintregister:
        mov     al,(dis_operand_t ptr __dis_gs:ebx).ops.reg.register
endp    dis_reg

        ;
        ;   printregister:near
        ;
        ;   print a register name
        ;
        ;   input: __dis_gs:esi dis_input_t struc
        ;          al   register name equate (dr_ax/dr_ecx/dr_etc)
        ;          es:edi string to print it in
        ;   output: es:edi after the register name we just printed in it
        ;   registers: eax,edi
        ;
proc    printregister near
        push    ebx
        movzx   ebx,al
        mov     eax,offset regsatt
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_attsyntax
        jnz     short @@10
        mov     eax,offset regs
@@10:
        mov     ebx,[eax+ebx*4]
        call    near ptr copyregstring
        pop     ebx
printregisterretn:
        retn
endp    printregister

        ;
        ;   dis_farofs:near
        ;
        ;   print a far ptr seg:ofs
        ;
        ;   input: __dis_gs:esi dis_input_t struc
        ;          __dis_gs:ebx dis_operand_t struc
        ;          es:edi string
        ;   output: es:edi after the stuff we printed in it
        ;   registers:
        ;
proc    dis_farofs near
        call    near ptr printsmallorlarge
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_farptr
        jz      short @@10
        push    ebx
        mov     ebx,offset @far
        call    near ptr copyptrstringandspaceandprintptr
        pop     ebx
@@10:
        checkoperand
        jnc     short printregisterretn
        movzx   eax,(dis_operand_t ptr __dis_gs:ebx).ops.farptr.seg
        mov     ch,02h
        push    ebx
        call    near ptr xorblblprintnumber
        pop     ebx
        mov     al,':'
        stosb
        jmp     short dis_nearofs_printofs
endp    dis_farofs

        ;
        ;   dis_farofsatt:near
        ;
        ;   print a far ptr seg:ofs (at&t syntax)
        ;
        ;   input: __dis_gs:esi dis_input_t struc
        ;          __dis_gs:ebx dis_operand_t struc
        ;          es:edi string
        ;   output: es:edi after the stuff we printed in it
        ;   registers:
        ;
proc    dis_farofsatt near
        checkoperand
        jnc     short printregisterretn
        mov     al,'$'
        stosb
        movzx   eax,(dis_operand_t ptr __dis_gs:ebx).ops.farptr.seg
        mov     ch,02h
        push    ebx
        call    near ptr xorblblprintnumber
        pop     ebx
        call    near ptr printcomma
        jmp     short dis_nearofs_printofsatt
endp    dis_farofsatt

        ;
        ;   dis_nearofsatt:near
        ;
        ;   print a near offset (at&t syntax)
        ;
        ;   input: __dis_gs:esi dis_input_t struc
        ;          __dis_gs:ebx dis_operand_t struc
        ;          es:edi string
        ;   output: es:edi after the stuff we printed in it
        ;   registers:
        ;
proc    dis_nearofsatt near
        checkoperand
        jnc     short dis_nearofsretn
dis_nearofs_printofsatt:
        mov     al,'$'
        stosb
        jmp     short dis_nearofs_printofs
endp    dis_nearofsatt

        ;
        ;   dis_nearofs:near
        ;
        ;   print a near offset
        ;
        ;   input: __dis_gs:esi dis_input_t struc
        ;          __dis_gs:ebx dis_operand_t struc
        ;          es:edi string
        ;   output: es:edi after the stuff we printed in it
        ;   registers:
        ;
proc    dis_nearofs near
        call    near ptr printsmallorlarge
        testflag (dis_operand_t ptr __dis_gs:ebx).ops.nearptr.__flags,dn_short
        jz      short @@notshort
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_noshort
        jnz     short @@10
        movzx   eax,(dis_input_t ptr __dis_gs:esi).__dis_input.opcode.opcodeword
        cmp     eax,000000E0h
        jb      short @@not
        cmp     eax,000000E3h
        jbe     short @@10
@@not:
        push    ebx
        mov     ebx,offset @short
        call    near ptr copyptrstringandspace
        pop     ebx
        jmp     short @@10
@@notshort:
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_nearptr
        jz      short @@10
        push    ebx
        mov     ebx,offset @near
        call    near ptr copyptrstringandspaceandprintptr
        pop     ebx
@@10:
        checkoperand
        jnc     short dis_nearofsretn
dis_nearofs_printofs:
        mov     eax,(dis_operand_t ptr __dis_gs:ebx).ops.nearptr.ofs
        mov     ch,02h
        cmp     (dis_operand_t ptr __dis_gs:ebx).size,dop_sizeword
        je      short xorblblprintnumber
        mov     ch,04h
xorblblprintnumber:
        xor     bl,bl
        call    near ptr printnumber
dis_nearofsretn:
        retn
endp    dis_nearofs

        ;
        ;   dis_imm:near
        ;
        ;   print an immediate value operand
        ;
        ;   input: __dis_gs:esi dis_input_t struc
        ;          __dis_gs:ebx dis_operand_t struc
        ;          es:edi string
        ;   output: es:edi after the stuff we printed in it
        ;   registers:
        ;
proc    dis_imm near
        call    near ptr printsmallorlarge
dis_immcheckoperand:
        checkoperand
        jnc     short dis_nearofsretn
        mov     al,(dis_operand_t ptr __dis_gs:ebx).size
        call    near ptr convertdop_sizeequ
        mov     eax,(dis_operand_t ptr __dis_gs:ebx).ops.imm.immediate
        jmp     short xorblblprintnumber
endp    dis_imm

        ;
        ;   dis_immatt:near
        ;
        ;   print an immediate value operand (at&t syntax)
        ;
        ;   input: __dis_gs:esi dis_input_t struc
        ;          __dis_gs:ebx dis_operand_t struc
        ;          es:edi string
        ;   output: es:edi after the stuff we printed in it
        ;   registers:
        ;
proc    dis_immatt near
        mov     al,'$'
        stosb
        jmp     short dis_immcheckoperand
endp    dis_immatt

        ;
        ;   checkindirectcalljmp:near
        ;
        ;   check if the instruction is a call/jmp reg/mem
        ;
        ;   input: __dis_gs:esi dis_input_t struc
        ;          __dis_gs:ebx dis_operand_t struc
        ;          es:edi string
        ;   output: es:edi after the * we printed
        ;   registers: eax,edi
        ;
proc    checkindirectcalljmp near
        mov     ax,(dis_input_t ptr __dis_gs:esi).__dis_input.opcode.opcodeid
        cmp     ah,opid_grp5 shr 8
        jne     short @@666
        cmp     al,02h
        jb      short @@666
        cmp     al,05h
        ja      short @@666
        mov     al,'*'
        stosb
@@666:
        retn
endp    checkindirectcalljmp

        ;
        ;   dis_mematt:near
        ;
        ;   print a memory operand (at&t syntax)
        ;
        ;   input: __dis_gs:esi dis_input_t struc
        ;          __dis_gs:ebx dis_operand_t struc
        ;          es:edi string
        ;   output: es:edi after the stuff we printed in it
        ;   registers:
        ;
proc    dis_mematt near
        call    near ptr checkindirectcalljmp
        call    near ptr printsegoverrides
        testflag (dis_operand_t ptr __dis_gs:ebx).ops.mem.__flags,dm_hasbase or dm_hasindex or dm_hasscale
        jz      dis_memonlydisplacement
        testflag (dis_operand_t ptr __dis_gs:ebx).ops.mem.__flags,dm_hasdispl
        jz      short @@nodispl
        checkoperand
        jnc     short @@nodispl
        call    near ptr printdisplacement
@@nodispl:
        mov     al,'('
        call    near ptr @@printbracket
        testflag (dis_operand_t ptr __dis_gs:ebx).ops.mem.__flags,dm_hasbase
        jz      short @@nobase
        call    near ptr printbaseregister
@@nobase:
        testflag (dis_operand_t ptr __dis_gs:ebx).ops.mem.__flags,dm_hasindex
        jz      short @@noscale
        call    near ptr printcomma
        call    near ptr printindexregister
@@noindex:
        testflag (dis_operand_t ptr __dis_gs:ebx).ops.mem.__flags,dm_hasscale
        jz      short @@noscale
        mov     cl,(dis_operand_t ptr __dis_gs:ebx).ops.mem.scale
        test    cl,cl
        jnz     short @@scalene0
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_usescale1
        jz      short @@noscale
@@scalene0:
        call    near ptr printcomma
        mov     al,01h
        shl     al,cl
        xor     al,30h
        stosb
@@noscale:
@@printlastbracket:
        mov     al,')'
@@printbracket:
        testflag (dis_operand_t ptr __dis_gs:esi).flags,df_nobracketsmem
        jnz     short @@retn
        stosb
@@retn:
        retn
endp    dis_mematt

        ;
        ;   printbaseregister:near
        ;
        ;   print a memory base register
        ;
        ;   input: __dis_gs:esi dis_input_t struc
        ;          __dis_gs:ebx dis_operand_t struc
        ;          es:edi string
        ;   output: es:edi after the last character
        ;   registers:
        ;
proc    printbaseregister near
        mov     al,(dis_operand_t ptr __dis_gs:ebx).ops.mem.baseindex
        and     al,0Fh
        jmp     printregister
endp    printbaseregister

        ;
        ;   printindexregister:near
        ;
        ;   print a memory index register
        ;
        ;   input: __dis_gs:esi dis_input_t struc
        ;          __dis_gs:ebx dis_operand_t struc
        ;          es:edi string
        ;   output: es:edi after the last character
        ;   registers:
        ;
proc    printindexregister near
        mov     al,(dis_operand_t ptr __dis_gs:ebx).ops.mem.baseindex
        shr     al,04h
        jmp     printregister
endp    printindexregister

        ;
        ;   printsegoverrides?:near
        ;
        ;   should we print segment overrides?
        ;
        ;   input: __dis_gs:esi dis_input_t struc
        ;          __dis_gs:ebx dis_operand_t struc
        ;   output: cf=1=No
        ;           cf=0=Yes=al[2:0]=segment override equate (dm_segXX)
        ;   registers: al
        ;
proc    printsegoverrides? near
        mov     al,(dis_operand_t ptr __dis_gs:ebx).ops.mem.segoverride
        testflag (dis_operand_t ptr __dis_gs:ebx).ops.mem.__flags,dm_segoverride
        jnz     short @@666
        shr     al,04h
        testflag (dis_operand_t ptr __dis_gs:ebx).ops.mem.__flags,dm_hasbase or dm_hasindex or dm_hasscale
        jz      short @@10              ;if it's only a displacement
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_memsegoverride
        jmp     short @@20
@@10:
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_dsdispl
@@20:
        jz      short @@cmc
@@666:
        retn
@@cmc:
        cmc
        retn
endp    printsegoverrides?

        ;
        ;   printsegoverrides:near
        ;
        ;   print segment overrides
        ;
        ;   input: __dis_gs:esi dis_input_t struc
        ;          __dis_gs:ebx dis_operand_t struc
        ;          es:edi string
        ;   output: es:edi after the last character we printed
        ;   registers: eax,edi
        ;
proc    printsegoverrides near
        call    near ptr printsegoverrides?
        jc      short printsegoverridesretn
        and     eax,00000007h
        push    ebx
        mov     ebx,[eax*4+segregs]
        call    near ptr copyregstring
        pop     ebx
        mov     al,':'
        stosb
printsegoverridesretn:
        retn
endp    printsegoverrides

        ;
        ;   printdisplacement:near
        ;
        ;   print a displacement
        ;
        ;   input: __dis_gs:esi dis_input_t struc
        ;          __dis_gs:ebx dis_operand_t struc
        ;          es:edi string
        ;   output: es:edi after the displacement printed
        ;   registers: eax,ecx,edi
        ;
proc    printdisplacement near
        mov     al,(dis_operand_t ptr __dis_gs:ebx).ops.mem.__flags
        call    near ptr convertdop_sizeequ
        and     al,03h
        cmp     al,dop_sizedword
        mov     eax,(dis_operand_t ptr __dis_gs:ebx).ops.mem.displ
        je      short @@dontsignextend
        cwde
@@dontsignextend:
        test    eax,eax
        jnz     short @@notzero
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_nozerodispl
        jnz     short @@666
@@notzero:
        push    ebx
        mov     bl,signed or showsign
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_attsyntax
        jz      short @@notatt
        mov     bl,signed
@@notatt:
        call    near ptr printnumber
        pop     ebx
@@666:
        retn
endp    printdisplacement

        ;
        ;   dis_mem:near
        ;
        ;   print a memory operand
        ;
        ;   input: __dis_gs:esi dis_input_t struc
        ;          __dis_gs:ebx dis_operand_t struc
        ;          es:edi string
        ;   output: es:edi after the stuff we printed in it
        ;   registers:
        ;
proc    dis_mem near
        testflag (dis_operand_t ptr __dis_gs:ebx).ops.mem.__flags,dm_hasbase or dm_hasindex or dm_hasscale
        jnz     short @@10              ;jmp if it's not just a displacement
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_nobracketsdispl
        jmp     short @@jnzshortnobrackets
@@10:
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_nobracketsmem
@@jnzshortnobrackets:
        jnz     @@nobrackets
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_seginsidebrack
        setnz   al
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_ptrinsidebrack
        jz      short @@20
        add     al,02h
@@20:
        cmp     al,01h
        jb      short @@alzero
        je      short @@alone
        cmp     al,02h
        je      short @@altwo

@@althree:      ;al=3=  push    [word ptr small es:mem]
        mov     al,'['
        stosb
        call    near ptr @@printptrstring
        call    near ptr printsmallorlarge
        call    near ptr printsegoverrides
        jmp     short @@printmemandendbracket

@@alzero:       ;al=0=  push    word ptr es:[small mem]
        call    near ptr @@printptrstring
        call    near ptr printsegoverrides
        ;Tasm (v3.20) starts to assemble the wrong code now...
        ;Let's hope tasm32 doesn't...
        mov     al,'['  ;AND AL,9Dh (249D)
        stosb           ;INC ESI (46)
        call    near ptr printsmallorlarge ;ETC...
        jmp     short @@printmemandendbracket

@@alone:        ;al=1=  push    word ptr [small es:mem]
        call    near ptr @@printptrstring
        mov     al,'['
        stosb
        call    near ptr printsmallorlarge
        call    near ptr printsegoverrides
        jmp     short @@printmemandendbracket

@@altwo:        ;al=2=  push    es:[word ptr small mem]
        call    near ptr printsegoverrides
        mov     al,'['
        stosb
        call    near ptr @@printptrstring
        call    near ptr printsmallorlarge
@@printmemandendbracket:
        call    near ptr @@dismem_printmemory
        mov     al,']'
        stosb
@@__retn:
        retn
@@dismem_printmemory_onlydispl:
dis_memonlydisplacement:
        checkoperand
        jnc     short @@__retn
        mov     al,(dis_operand_t ptr __dis_gs:ebx).ops.mem.__flags
        call    near ptr convertdop_sizeequ
        mov     eax,(dis_operand_t ptr __dis_gs:ebx).ops.mem.displ
        jmp     xorblblprintnumber
@@nobrackets:
        ;print: push    word ptr small es:mem
        call    near ptr @@printptrstring
        call    near ptr printsmallorlarge
        call    near ptr printsegoverrides
@@dismem_printmemory:
        testflag (dis_operand_t ptr __dis_gs:ebx).ops.mem.__flags,dm_hasbase or dm_hasindex or dm_hasscale
        jz      short @@dismem_printmemory_onlydispl
        testflag (dis_operand_t ptr __dis_gs:ebx).ops.mem.__flags,dm_hasbase
        jz      short @@dismem_printmemory_nobase
        call    near ptr printbaseregister
        testflag (dis_operand_t ptr __dis_gs:ebx).ops.mem.__flags,dm_hasindex
        jz      short @@dismem_printmemory_noindex
        mov     al,'+'
        stosb
@@dismem_printmemory_nobase:
        testflag (dis_operand_t ptr __dis_gs:ebx).ops.mem.__flags,dm_hasindex
        jz      short @@dismem_printmemory_noindex
        call    near ptr printindexregister
@@dismem_printmemory_noindex:
        testflag (dis_operand_t ptr __dis_gs:ebx).ops.mem.__flags,dm_hasscale
        jz      short @@dismem_printmemory_noscale
        mov     cl,(dis_operand_t ptr __dis_gs:ebx).ops.mem.scale
        test    cl,cl
        jnz     short @@scalene0
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_usescale1
        jz      short @@dismem_printmemory_noscale
@@scalene0:
        mov     ah,01h
        shl     ah,cl
        mov     al,'*'
        xor     ah,'0'
        stosw
@@dismem_printmemory_noscale:
        testflag (dis_operand_t ptr __dis_gs:ebx).ops.mem.__flags,dm_hasdispl
        jz      short @@dismemretn
        mov     al,'+'
        stosb
        checkoperand
        jnc     short @@dismemretn
        dec     edi
        jmp     printdisplacement
@@dismemretn:
        retn

@@printptrstring:
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_nomemsize
        jnz     short @@dismemretn
        testflag (dis_input_t ptr __dis_gs:esi).__dis_input.opcode.flags,do_showmemsize
        jnz     short printptrstring
        testflag (dis_input_t ptr __dis_gs:esi).__dis_input.opcode.flags,do_dontshowmemsize
        jnz     short @@dismemretn
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_showsizemem
        jnz     short printptrstring
        testflag (dis_input_t ptr __dis_gs:esi).__dis_input.opcode.flags,do_hassegreg
        jz      short @@printptrstring10
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_showsegmemsize
        jnz     short printptrstring
        mov     cl,(dis_input_t ptr __dis_gs:esi).__dis_input.codesize
        cmp     (dis_input_t ptr __dis_gs:esi).__dis_input.opcode.opsize,cl ;66h?
        jne     short printptrstring    ;yes
@@printptrstring10:
        testflag (dis_input_t ptr __dis_gs:esi).__dis_input.opcode.flags,do_hasreg
        jnz     short @@dismemretn
printptrstring:
        push    ebx
        movzx   ebx,(dis_operand_t ptr __dis_gs:ebx).size
        mov     ebx,[ebx*4+sizestrings]
        call    near ptr copyptrstringandspaceandprintptr
        pop     ebx
        retn
endp    dis_mem

copyptrstringandspaceandprintptr:
        call    near ptr copyptrstringandspace

        ;
        ;   printptrandspace:near
        ;
        ;   print 'ptr '
        ;
        ;   input: es:edi string
        ;          __dis_gs:esi dis_input_t struc
        ;   output: es:edi after the space
        ;   registers: eax,ebx,edi
        ;
proc    printptrandspace near
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_noptr
        jnz     short @@666
        mov     ebx,offset @ptr
copyptrstringandspace:
        call    near ptr copyptrstring
printspace:
        mov     al,20h
        stosb
@@666:
        retn
endp    printptrandspace

        ;
        ;   printsmallorlarge:near
        ;
        ;   print small or large in a string
        ;
        ;   input: __dis_gs:ebx dis_operand_t struc
        ;          es:edi string
        ;   output: es:edi after the stuff we printed
        ;   registers: al,edi
        ;
proc    printsmallorlarge near
        push    ebx
        mov     al,byte ptr (dis_operand_t ptr __dis_gs:ebx).flags
        test    al,dop_small
        mov     ebx,offset @small
        jnz     short @@10
        test    al,dop_large
        jz      short @@666
        mov     ebx,offset @large
@@10:
        call    near ptr copyptrstringandspace
@@666:
        pop     ebx
        retn
endp    printsmallorlarge

        ;
        ;   copyregstring:near
        ;
        ;   copy a register string 'eax','ecx','es',etc
        ;
        ;   input: ds:ebx source string
        ;          es:edi dest string
        ;   output: es:edi advanced past the last character
        ;           al  zero
        ;   registers: eax,ebx,edi
        ;
proc    copyregstring near
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_attsyntax
        jz      short @@notatt
        mov     al,'%'
        stosb
@@notatt:
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_uppercasereg
        jmp     short copystring
endp    copyregstring

        ;
        ;   copyptrstring:near
        ;
        ;   copy a 'byte','word','ptr',etc string
        ;
        ;   input: ds:ebx source string
        ;          es:edi dest string
        ;   output: es:edi advanced past the last character
        ;           al  zero
        ;   registers: eax,ebx,edi
        ;
proc    copyptrstring near
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_uppercaseptr
        jmp     short copystring
endp    copyptrstring

        ;
        ;   copyopname:near
        ;
        ;   copy the mnemonic name to a string (might uppercase it)
        ;
        ;   input: ds:ebx name of the mnemonic
        ;          es:edi string to put the result
        ;   output: es:edi advanced past the last character (might be uppercased)
        ;           al  zero
        ;   registers: eax,ebx,edi
        ;
proc    copyopname near
        assume  es:nothing,cs:@code,ss:@stack,ds:@data,fs:nothing,gs:nothing
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_attsyntax
        jnz     short copyopnameatt
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_uppercasemnemonic
endp    copyopname

        ;
        ;   copystring:near
        ;
        ;   copy a string and uppercase it if zf=0
        ;
        ;   input: ds:ebx source string
        ;          es:edi dest string
        ;          zf=1=don't change the string (AND it with FF)
        ;          zf=0=change the string (AND it with NOT 20h)
        ;   output: es:edi advanced past the last character
        ;           al  zero
        ;   registers: eax,ebx,edi
        ;
proc    copystring near
        assume  es:nothing,cs:@code,ss:@stack,ds:nothing,fs:nothing,gs:nothing
        mov     ah,0FFh
        jz      short @@loop
        mov     ah,not 20h
@@loop:
        mov     al,[ebx]
        inc     ebx
        cmp     al,'a'
        jb      short @@10
        ;There're only characters or ascii numbers in the strings. '9' < 'a'
;        cmp     al,'z'
;        ja      short @@10
        and     al,ah
@@10:
        stosb
        test    al,al
        jnz     short @@loop
        dec     edi
        retn
endp    copystring

        ;
        ;   copyopnameatt:near
        ;
        ;   copy the mnemonic name to a string (might uppercase it) (at&t)
        ;
        ;   input: ds:ebx name of the mnemonic
        ;          es:edi string to put the result
        ;   output: es:edi advanced past the last character (might be uppercased)
        ;           al  zero
        ;   registers: eax,ebx,edi
        ;
proc    copyopnameatt near
attsizebyte     equ     01h             ;Add a 'b'
attsizeworddword equ    02h             ;Add a 'w' or 'l' (depends on opsize)
attdontshowsizeworddword equ 03h        ;attsizeworddword if 66h prefix
attshowsizeworddword equ 04h            ;attsizeworddword (always a 'w' or 'l')
attstringsize   equ     05h             ;all strings (b/w/l always)
attmaxspecial   equ     05h
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_uppercasemnemonic
        mov     ah,0FFh
        jz      short @@loop
        mov     ah,not 20h
@@loop:
        mov     al,[ebx]
        inc     ebx
        cmp     al,attmaxspecial
        jbe     short @@checkit
@@printchar:
        cmp     al,'a'
        jb      short @@10
        ;There're only characters or ascii numbers in the strings. '9' < 'a'
;        cmp     al,'z'
;        ja      short @@10
        and     al,ah
@@10:
        stosb
        test    al,al
        jnz     short @@loop
        dec     edi
        retn
@@checkit:
        cmp     al,attsizebyte
        je      short @@attsizebyte
        cmp     al,attsizeworddword
        je      short @@attsizeworddword
        cmp     al,attdontshowsizeworddword
        je      short @@attdontshowsizeworddword
        cmp     al,attshowsizeworddword
        je      short @@attshowsizeworddword
        cmp     al,attstringsize
        jne     short @@printchar
@@attstringsize:
        call    near ptr @@getstringchar
        jmp     short @@printchar
@@attshowsizeworddword:
        call    near ptr @@worl
        jmp     short @@printchar
@@attdontshowsizeworddword:     ;print 'w' or 'l' if no 66h prefix
        testflag (dis_input_t ptr __dis_gs:esi).__dis_input.opcode.prefixes,__dis_opprefix
        jz      short @@loop
@@attsizeworddword:             ;print 'w' or 'l' (depending on operand size)
        call    near ptr @@worl
@@printchar?:
        testflag (dis_input_t ptr __dis_gs:esi).__dis_input.opcode.flags,do_showmemsize
        jnz     short @@printchar       ;shrb %cl,(%esp) (or similar)
        testflag (dis_input_t ptr __dis_gs:esi).__dis_input.opcode.flags,do_dontshowmemsize
        jnz     short @@loop
        testflag (dis_input_t ptr __dis_gs:esi).__dis_input.opcode.flags,do_hasreg
        jz      short @@printchar
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_noopnamesizeatt
        jz      short @@printchar
        jmp     short @@loop
@@attsizebyte:                  ;print 'b'
        mov     al,'b'
        jmp     short @@printchar?
@@worl:
        mov     al,'w'
        cmp     (dis_input_t ptr __dis_gs:esi).__dis_input.opcode.opsize,10h
        je      short @@worl666
        mov     al,'l'
@@worl666:
        retn
@@getstringchar:
        mov     al,byte ptr (dis_input_t ptr __dis_gs:esi).__dis_input.opcode.op1.flags
        and     al,dop_typemask
if dop_mem ne 0
        cmp     al,dop_mem
endif
        mov     al,(dis_input_t ptr __dis_gs:esi).__dis_input.opcode.op1.size
        je      short @@getstringchar10
        mov     al,(dis_input_t ptr __dis_gs:esi).__dis_input.opcode.op2.size
@@getstringchar10:
        cmp     al,01h
        mov     al,'b'
        jb      short @@getstringchar666
        mov     al,'w'
        je      short @@getstringchar666
        mov     al,'l'
@@getstringchar666:
        retn
endp    copyopnameatt

        ;
        ;   dis_changenumberbase:procptr
        ;
        ;   change the number base
        ;
        ;   input: __dis_gs:esi dis_input_t struc
        ;          bh   new number base (02h-FFh)
        ;   output: none
        ;   registers: none
        ;
ifdef Clib
proc    _dis_changenumberbase procptr
        public  _dis_changenumberbase
else
proc    dis_changenumberbase procptr
endif
ifdef Clib
        arg     dis_input:dataptr,nbase:byte:2
        push    ebp
        mov     ebp,esp
        push    ebx esi
  if @datasize
        push    gs
        lgs     esi,fword ptr dis_input ;tasm bug again: 48-bit pointer!!!
  else
        mov     esi,dis_input
  endif
        mov     bh,nbase
endif
        mov     (dis_input_t ptr __dis_gs:esi).numberbase,bh
ifndef Clib
        push    eax edx
endif
        or      eax,0FFFFFFFFh
        call    near ptr getmaxdigits
        mov     (dis_input_t ptr __dis_gs:esi).maxdigitsdword,al
        or      ax,0FFFFh
        call    near ptr getmaxdigits
        mov     (dis_input_t ptr __dis_gs:esi).maxdigitsword,al
        or      al,0FFh
        call    near ptr getmaxdigits
        mov     (dis_input_t ptr __dis_gs:esi).maxdigitsbyte,al
ifdef Clib
  if @datasize
        pop     gs
  endif
        pop     esi ebx ebp
else
        pop     edx eax
endif
        ret
ifdef Clib
endp    _dis_changenumberbase
else
endp    dis_changenumberbase
endif

        ;
        ;   getmaxdigits:near
        ;
        ;   get max # of digits in an unsigned number base in a byte/word/dword
        ;
        ;   input: eax  FFh=byte,FFFFh=word,FFFFFFFFh=dword
        ;          bh   number base
        ;   output: eax max # of digits
        ;           edx msd (in=eax=1234h,out=edx=1h)
        ;   registers: eax,edx
        ;
proc    getmaxdigits near
        push    ecx ebx
        xor     ecx,ecx
        movzx   ebx,bh
@@loop:
        xor     edx,edx
        div     ebx
        inc     ecx
        test    eax,eax
        jnz     short @@loop
        xchg    ecx,eax
        pop     ebx ecx
        retn
endp    getmaxdigits

        ;
        ;   printnumber:near
        ;
        ;   print a number in a string
        ;
        ;   input: eax  # to convert to ascii (sign/zero extended)
        ;          ch   type of number to print (byte=1,word=2,dword=4)
        ;          bl   flags (for ntoa:proc) (bighex shouldn't be set!)
        ;          _es:edi string
        ;   output: edi asciiz string (after the number we printed)
        ;   registers: eax,ecx,edx,ebx
        ;
proc    printnumber near
        assume  es:@data,cs:@code,ss:@stack,ds:@data,fs:nothing,gs:nothing
        mov     bh,(dis_input_t ptr __dis_gs:esi).numberbase
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_fewdigits
        jz      short @@15
        push    eax
        test    bl,signed
        jz      short @@12
        test    eax,eax
        jns     short @@12
        neg     eax
@@12:
        call    near ptr getmaxdigits
        xchg    ecx,eax
        pop     eax
        jmp     short @@20
@@15:
        mov     cl,(dis_input_t ptr __dis_gs:esi).maxdigitsbyte
        cmp     ch,02h
        jb      short @@20
        mov     cl,(dis_input_t ptr __dis_gs:esi).maxdigitsword
        je      short @@20
        mov     cl,(dis_input_t ptr __dis_gs:esi).maxdigitsdword
@@20:
        movzx   ecx,cl                  ;ecx=# of digits to print in es:di
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_msd0always
        jnz     short @@yesmsd0
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_msd0
        jz      short @@nomsd0
        test    bl,signed
        jnz     short @@nomsd0          ;a signed # can't have a char as msd
        push    eax                     ; (it can if base is much > 10h...)
        call    near ptr getmaxdigits
        cmp     al,cl
        pop     eax
        jne     short @@nomsd0
        cmp     edx,00000009h           ;is msd a digit-character?
        jbe     short @@nomsd0
@@yesmsd0:
        inc     ecx
@@nomsd0:
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_lowercasedigitchar
        jnz     short @@40
        or      bl,bighex
@@40:
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_Cnumbers
        jz      short @@50
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_usebasechar
        jz      short @@50
        test    bl,signed or showsign
        jz      short @@Cnothing
        mov     dl,'+'
        mov     dh,'-'
        test    bl,showsign
        jnz     short @@Cshowsign
        xor     dl,dl                   ;mov     dx,'-' shl 8
@@Cshowsign:
        test    eax,eax
        jns     short @@Cok
        neg     eax
        mov     dl,dh
@@Cok:
        test    dl,dl
        jz      short @@maskit
        mov     _es:[edi],dl
        inc     edi
@@maskit:
        and     bl,not (signed or showsign)
@@Cnothing:
        push    eax
        mov     al,'x'
        call    near ptr @@getbasechar
        jc      short @@dontstosb
        mov     ah,al
        mov     al,'0'
        stosb
        cmp     bh,10o
        je      short @@dontstosb
        mov     al,ah
        stosb
@@dontstosb:
        pop     eax
@@50:
        push    eax
        call    ntoa
        pop     eax
        add     edi,ecx
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_usebasechar
        jnz     short @@usebasechar
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_attsyntax
        jnz     short @@666
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_basecharifneeded
        jz      short @@666
        cmp     bh,0Ah                  ;base must be > 10 or it can't be a char
        jbe     short @@666
        push    ebx
        test    bl,signed
        movzx   ebx,bh
        jz      short @@42
        cdq
        idiv    ebx
        test    edx,edx
        jns     short @@45
        neg     edx
        jmp     short @@45
@@42:
        xor     edx,edx
        div     ebx
@@45:
        xchg    edx,eax
        pop     ebx
        cmp     al,0Bh
        je      short @@usebasechar
        cmp     al,0Dh
        jne     short @@666
@@usebasechar:
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_Cnumbers
        jnz     short @@666
        mov     al,'h'
        call    near ptr @@getbasechar
        jc      short @@666
        xor     ah,ah
        mov     _es:[edi],ax
        inc     edi
@@666:
        retn
@@getbasechar:
        cmp     bh,10h
        je      short @@yes
        mov     al,'d'
        cmp     bh,10d
        je      short @@yes
        mov     al,(dis_input_t ptr __dis_gs:esi).octalbasechar
        cmp     bh,10o
        je      short @@yes
        cmp     bh,10b
        jne     short @@no
        mov     al,'b'
@@yes:
        testflag (dis_input_t ptr __dis_gs:esi).flags,df_uppercasebasechar
        jz      short @@yes10
        and     al,not 20h
@@yes10:
        retn
@@no:
        stc
        retn
endp    printnumber
        endcode

        startconst
        align   dword
label   opnames1 dword
  dd    @add,@add,@add,@add,@add,@add,@push,@pop                ;00
  dd    @or,@or,@or,@or,@or,@or,@push,@db                       ;08
  dd    @adc,@adc,@adc,@adc,@adc,@adc,@push,@pop                ;10
  dd    @sbb,@sbb,@sbb,@sbb,@sbb,@sbb,@push,@pop                ;18
  dd    @and,@and,@and,@and,@and,@and,@seges,@daa               ;20
  dd    @sub,@sub,@sub,@sub,@sub,@sub,@segcs,@das               ;28
  dd    @xor,@xor,@xor,@xor,@xor,@xor,@segss,@aaa               ;30
  dd    @cmp,@cmp,@cmp,@cmp,@cmp,@cmp,@segds,@aas               ;38
  dd    @inc,@inc,@inc,@inc,@inc,@inc,@inc,@inc                 ;40
  dd    @dec,@dec,@dec,@dec,@dec,@dec,@dec,@dec                 ;48
  dd    @push,@push,@push,@push,@push,@push,@push,@push         ;50
  dd    @pop,@pop,@pop,@pop,@pop,@pop,@pop,@pop                 ;58
  dd    @pusha,@popa,@bound,@arpl,@segfs,@seggs,@db,@db         ;60
  dd    @push,@imul,@push,@imul,@insb,@insw,@outsb,@outsw       ;68
  dd    @jo,@jno,@jb,@jae,@je,@jne,@jbe,@ja                     ;70
  dd    @js,@jns,@jp,@jnp,@jl,@jge,@jle,@jg                     ;78
  dd    @db,@db,@db,@db,@test,@test,@xchg,@xchg                 ;80
  dd    @mov,@mov,@mov,@mov,@mov,@lea,@mov,@pop                 ;88
  dd    @nop,@xchg,@xchg,@xchg,@xchg,@xchg,@xchg,@xchg          ;90
  dd    @cbw,@cwd,@call,@wait,@pushf,@popf,@sahf,@lahf          ;98
  dd    @mov,@mov,@mov,@mov,@movsb,@movsw,@cmpsb,@cmpsw         ;A0
  dd    @test,@test,@stosb,@stosw,@lodsb,@lodsw,@scasb,@scasw   ;A8
  dd    @mov,@mov,@mov,@mov,@mov,@mov,@mov,@mov                 ;B0
  dd    @mov,@mov,@mov,@mov,@mov,@mov,@mov,@mov                 ;B8
  dd    @db,@db,@retn,@retn,@les,@lds,@mov,@mov                 ;C0
  dd    @enter,@leave,@retf,@retf,@int,@int,@into,@iret         ;C8
  dd    @db,@db,@db,@db,@aam,@aad,@salc,@xlatb                  ;D0
  dd    @db,@db,@db,@db,@db,@db,@db,@db                         ;D8
  dd    @loopne,@loope,@loop,@jcxz,@in,@in,@out,@out            ;E0
  dd    @call,@jmp,@jmp,@jmp,@in,@in,@out,@out                  ;E8
  dd    @lock,@int01,@repne,@rep,@hlt,@cmc,@db,@db              ;F0
  dd    @clc,@stc,@cli,@sti,@cld,@std,@db,@db                   ;F8
label   opnames2 dword
  dd    @db,@db,@lar,@lsl,@loadall,@loadall,@clts,@loadall      ;00
  dd    @invd,@wbinvd,@db,@ud2,@db,@db,@db,@db                  ;08
  dd    @umov,@umov,@umov,@umov,@db,@db,@db,@db                 ;10
  dd    @db,@db,@db,@db,@db,@db,@db,@db                         ;18
  dd    @mov,@mov,@mov,@mov,@mov,@db,@mov,@db                   ;20
  dd    @db,@db,@db,@db,@db,@db,@db,@db                         ;28
  dd    @wrmsr,@rdtsc,@rdmsr,@rdpmc,@sysenter,@sysexit,@db,@db  ;30
  dd    @db,@db,@db,@db,@db,@db,@db,@db                         ;38
  dd    @cmovo,@cmovno,@cmovb,@cmovae,@cmove,@cmovne,@cmovbe,@cmova ;40
  dd    @cmovs,@cmovns,@cmovp,@cmovnp,@cmovl,@cmovge,@cmovle,@cmovg ;48
  dd    @db,@db,@db,@db,@db,@db,@db,@db                         ;50
  dd    @db,@db,@db,@db,@db,@db,@db,@db                         ;58
  dd    @punpcklbw,@punpcklwd,@punpckldq,@packsswb,@pcmpgtb,@pcmpgtw,@pcmpgtd,@packuswb ;60
  dd    @punpckhbw,@punpckhwd,@punpckhdq,@packssdw,@db,@db,@movd,@movq ;68
  dd    @db,@db,@db,@db,@pcmpeqb,@pcmpeqw,@pcmpeqd,@emms        ;70
  dd    @db,@db,@db,@db,@db,@db,@movd,@movq                     ;78
  dd    @jo,@jno,@jb,@jae,@je,@jne,@jbe,@ja                     ;80
  dd    @js,@jns,@jp,@jnp,@jl,@jge,@jle,@jg                     ;88
  dd    @seto,@setno,@setb,@setae,@sete,@setne,@setbe,@seta     ;90
  dd    @sets,@setns,@setp,@setnp,@setl,@setge,@setle,@setg     ;98
  dd    @push,@pop,@cpuid,@bt,@shld,@shld,@db,@db               ;A0
  dd    @push,@pop,@rsm,@bts,@shrd,@shrd,@db,@imul              ;A8
  dd    @cmpxchg,@cmpxchg,@lss,@btr,@lfs,@lgs,@movzx,@movzx     ;B0
  dd    @db,@ud,@db,@btc,@bsf,@bsr,@movsx,@movsx                ;B8
  dd    @xadd,@xadd,@db,@db,@db,@db,@db,@db                     ;C0
  dd    @bswap,@bswap,@bswap,@bswap,@bswap,@bswap,@bswap,@bswap ;C8
  dd    @db,@psrlw,@psrld,@psrlq,@db,@pmullw,@db,@db            ;D0
  dd    @psubusb,@psubusw,@db,@pand,@paddusb,@paddusw,@db,@pandn;D8
  dd    @db,@psraw,@psrad,@db,@db,@pmulhw,@db,@db               ;E0
  dd    @psubsb,@psubsw,@db,@por,@paddsb,@paddsw,@db,@pxor      ;E8
  dd    @db,@psllw,@pslld,@psllq,@db,@pmaddwd,@db,@db           ;F0
  dd    @psubb,@psubw,@psubd,@db,@paddb,@paddw,@paddd,@db       ;F8
label   amdk3dopcodes dword
  dd    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;00
  dd    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@pi2fd,@k3d?,@k3d?        ;08
  dd    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;10
  dd    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@pf2id,@k3d?,@k3d?        ;18
  dd    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;20
  dd    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;28
  dd    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;30
  dd    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;38
  dd    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;40
  dd    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;48
  dd    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;50
  dd    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;58
  dd    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;60
  dd    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;68
  dd    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;70
  dd    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;78
  dd    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;80
  dd    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;88
  dd    @pfcmpge,@k3d?,@k3d?,@k3d?,@pfmin,@k3d?,@pfrcp,@pfrsqrt ;90
  dd    @k3d?,@k3d?,@pfsub,@k3d?,@k3d?,@k3d?,@pfadd,@k3d?       ;98
  dd    @pfcmpgt,@k3d?,@k3d?,@k3d?,@pfmax,@k3d?,@pfrcpit1,@pfrsqit1 ;A0
  dd    @k3d?,@k3d?,@pfsubr,@k3d?,@k3d?,@k3d?,@pfacc,@k3d?      ;A8
  dd    @pfcmpeq,@k3d?,@k3d?,@k3d?,@pfmul,@k3d?,@pfrcpit2,@pmulhrw ;B0
  dd    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@pavgusb      ;B8
  dd    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;C0
  dd    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;C8
  dd    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;D0
  dd    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;D8
  dd    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;E0
  dd    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;E8
  dd    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;F0
  dd    @k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?,@k3d?         ;F8
label   grp1EvIv dword
label   grp1EbIbB dword
label   grp1EvIb dword
grp1EbIbA       dd      @add,@or,@adc,@sbb,@and,@sub,@xor,@cmp
label   grp2EvIb dword
label   grp2Eb1 dword
label   grp2Ev1 dword
label   grp2EbCL dword
label   grp2EvCL dword
grp2EbIb        dd      @rol,@ror,@rcl,@rcr,@shl,@shr,@shl,@sar
label   grp3Ev dword
grp3Eb          dd      @test,@test,@not,@neg,@mul,@imul,@div,@idiv
grp4            dd      @inc,@dec,@db,@db,@db,@db,@db,@db
grp5            dd      @inc,@dec,@call,@call,@jmp,@jmp,@push,@db
grp6            dd      @sldt,@str,@lldt,@ltr,@verr,@verw,@db,@db
grp7            dd      @sgdt,@sidt,@lgdt,@lidt,@smsw,@db,@lmsw,@invlpg
grp8            dd      @db,@db,@db,@db,@bt,@bts,@btr,@btc
grp9            dd      @db,@cmpxchg8b,@db,@db,@db,@db,@db,@db
grpA0F71        dd      @db,@db,@psrlw,@db,@psraw,@db,@psllw,@db
grpA0F72        dd      @db,@db,@psrld,@db,@psrad,@db,@pslld,@db
grpA0F73        dd      @db,@db,@psrlq,@db,@db,@db,@psllq,@db
label   grpBatt dword
grpB            dd      @fxsave,@fxrstor,@db,@db,@db,@db,@db,@db
label   special dword
  dd    @db
  dd    @enterd
  dd    @enterw
  dd    @enter
  dd    @sgdtd
  dd    @sgdtw
  dd    @sgdt
  dd    @sidtd
  dd    @sidtw
  dd    @sidt
  dd    @lgdtd
  dd    @lgdtw
  dd    @lgdt
  dd    @lidtd
  dd    @lidtw
  dd    @lidt
  dd    @loopdne
  dd    @loopwne
  dd    @loopne
  dd    @loopde
  dd    @loopwe
  dd    @loope
  dd    @loopd
  dd    @loopw
  dd    @loop
  dd    @jcxz
  dd    @jecxz
  dd    @cbw
  dd    @cwde
  dd    @cwd
  dd    @cdq
  dd    @pushad
  dd    @pushaw
  dd    @pusha
  dd    @popad
  dd    @popaw
  dd    @popa
  dd    @pushfd
  dd    @pushfw
  dd    @pushf
  dd    @popfd
  dd    @popfw
  dd    @popf
  dd    @leaved
  dd    @leavew
  dd    @leave
  dd    @iretd
  dd    @iretw
  dd    @iret
  dd    @retnd
  dd    @retnw
  dd    @retn
  dd    @retfd
  dd    @retfw
  dd    @retf
  dd    @xlat
  dd    @xlatb
  dd    @ins
  dd    @insb
  dd    @insw
  dd    @insd
  dd    @outs
  dd    @outsb
  dd    @outsw
  dd    @outsd
  dd    @scas
  dd    @scasb
  dd    @scasw
  dd    @scasd
  dd    @stos
  dd    @stosb
  dd    @stosw
  dd    @stosd
  dd    @lods
  dd    @lodsb
  dd    @lodsw
  dd    @lodsd
  dd    @cmps
  dd    @cmpsb
  dd    @cmpsw
  dd    @cmpsd
  dd    @movs
  dd    @movsb
  dd    @movsw
  dd    @movsd
  dd    @esc
  dd    @xchg
label   floatDCreg dword
floatD8reg      dd      @fadd,@fmul,@fcom,@fcomp,@fsub,@fsubr,@fdiv,@fdivr
floatD9reg      dd      @fld,@esc,@fst,@fstp,@fldenv,@fldcw,@fnstenv,@fnstcw
label   floatDEreg dword
label   floatDEregatt dword
floatDAreg      dd      @fiadd,@fimul,@ficom,@ficomp,@fisub,@fisubr,@fidiv,@fidivr
floatDBreg      dd      @fild,@esc,@fist,@fistp,@esc,@fld,@esc,@fstp
floatDDreg      dd      @fld,@esc,@fst,@fstp,@frstor,@esc,@fnsave,@fnstsw
floatDFreg      dd      @fild,@esc,@fist,@fistp,@fbld,@fild,@fbstp,@fistp
label   floatD8 dword
  dd    @fadd,@fadd,@fadd,@fadd,@fadd,@fadd,@fadd,@fadd                 ;C0
  dd    @fmul,@fmul,@fmul,@fmul,@fmul,@fmul,@fmul,@fmul                 ;C8
  dd    @fcom,@fcom,@fcom,@fcom,@fcom,@fcom,@fcom,@fcom                 ;D0
  dd    @fcomp,@fcomp,@fcomp,@fcomp,@fcomp,@fcomp,@fcomp,@fcomp         ;D8
  dd    @fsub,@fsub,@fsub,@fsub,@fsub,@fsub,@fsub,@fsub                 ;E0
  dd    @fsubr,@fsubr,@fsubr,@fsubr,@fsubr,@fsubr,@fsubr,@fsubr         ;E8
  dd    @fdiv,@fdiv,@fdiv,@fdiv,@fdiv,@fdiv,@fdiv,@fdiv                 ;F0
  dd    @fdivr,@fdivr,@fdivr,@fdivr,@fdivr,@fdivr,@fdivr,@fdivr         ;F8
label   floatD9 dword
  dd    @fld,@fld,@fld,@fld,@fld,@fld,@fld,@fld                         ;C0
  dd    @fxch,@fxch,@fxch,@fxch,@fxch,@fxch,@fxch,@fxch                 ;C8
  dd    @fnop,@esc,@esc,@esc,@esc,@esc,@esc,@esc                        ;D0
  dd    @fstp1,@fstp1,@fstp1,@fstp1,@fstp1,@fstp1,@fstp1,@fstp1         ;D8
  dd    @fchs,@fabs,@esc,@esc,@ftst,@fxam,@esc,@esc                     ;E0
  dd    @fld1,@fldl2t,@fldl2e,@fldpi,@fldlg2,@fldln2,@fldz,@esc         ;E8
  dd    @f2xm1,@fyl2x,@fptan,@fpatan,@fxtract,@fprem1,@fdecstp,@fincstp ;F0
  dd    @fprem,@fyl2xp1,@fsqrt,@fsincos,@frndint,@fscale,@fsin,@fcos    ;F8
label   floatDA dword
  dd    @fcmovb,@fcmovb,@fcmovb,@fcmovb,@fcmovb,@fcmovb,@fcmovb,@fcmovb ;C0
  dd    @fcmove,@fcmove,@fcmove,@fcmove,@fcmove,@fcmove,@fcmove,@fcmove ;C8
  dd    @fcmovbe,@fcmovbe,@fcmovbe,@fcmovbe,@fcmovbe,@fcmovbe,@fcmovbe,@fcmovbe ;D0
  dd    @fcmovu,@fcmovu,@fcmovu,@fcmovu,@fcmovu,@fcmovu,@fcmovu,@fcmovu ;D8
  dd    @esc,@esc,@esc,@esc,@esc,@esc,@esc,@esc                         ;E0
  dd    @esc,@fucompp,@esc,@esc,@esc,@esc,@esc,@esc                     ;E8
  dd    @esc,@esc,@esc,@esc,@esc,@esc,@esc,@esc                         ;F0
  dd    @esc,@esc,@esc,@esc,@esc,@esc,@esc,@esc                         ;F8
label   floatDB dword
  dd    @fcmovnb,@fcmovnb,@fcmovnb,@fcmovnb,@fcmovnb,@fcmovnb,@fcmovnb,@fcmovnb ;C0
  dd    @fcmovne,@fcmovne,@fcmovne,@fcmovne,@fcmovne,@fcmovne,@fcmovne,@fcmovne ;C8
  dd    @fcmovnbe,@fcmovnbe,@fcmovnbe,@fcmovnbe,@fcmovnbe,@fcmovnbe,@fcmovnbe,@fcmovnbe ;D0
  dd    @fcmovnu,@fcmovnu,@fcmovnu,@fcmovnu,@fcmovnu,@fcmovnu,@fcmovnu,@fcmovnu ;D8
  dd    @fneni,@fndisi,@fnclex,@fninit,@fnsetpm,@fnrstpm,@esc,@esc      ;E0
  dd    @fucomi,@fucomi,@fucomi,@fucomi,@fucomi,@fucomi,@fucomi,@fucomi ;E8
  dd    @fcomi,@fcomi,@fcomi,@fcomi,@fcomi,@fcomi,@fcomi,@fcomi         ;F0
  dd    @esc,@esc,@esc,@esc,@esc,@esc,@esc,@esc                         ;F8
label   floatDC dword
  dd    @fadd,@fadd,@fadd,@fadd,@fadd,@fadd,@fadd,@fadd                 ;C0
  dd    @fmul,@fmul,@fmul,@fmul,@fmul,@fmul,@fmul,@fmul                 ;C8
  dd    @fcom2,@fcom2,@fcom2,@fcom2,@fcom2,@fcom2,@fcom2,@fcom2         ;D0
  dd    @fcomp3,@fcomp3,@fcomp3,@fcomp3,@fcomp3,@fcomp3,@fcomp3,@fcomp3 ;D8
  dd    @fsub,@fsub,@fsub,@fsub,@fsub,@fsub,@fsub,@fsub                 ;E0
  dd    @fsubr,@fsubr,@fsubr,@fsubr,@fsubr,@fsubr,@fsubr,@fsubr         ;E8
  dd    @fdiv,@fdiv,@fdiv,@fdiv,@fdiv,@fdiv,@fdiv,@fdiv                 ;F0
  dd    @fdivr,@fdivr,@fdivr,@fdivr,@fdivr,@fdivr,@fdivr,@fdivr         ;F8
label   floatDD dword
  dd    @ffree,@ffree,@ffree,@ffree,@ffree,@ffree,@ffree,@ffree         ;C0
  dd    @fxch4,@fxch4,@fxch4,@fxch4,@fxch4,@fxch4,@fxch4,@fxch4         ;C8
  dd    @fst,@fst,@fst,@fst,@fst,@fst,@fst,@fst                         ;D0
  dd    @fstp,@fstp,@fstp,@fstp,@fstp,@fstp,@fstp,@fstp                 ;D8
  dd    @fucom,@fucom,@fucom,@fucom,@fucom,@fucom,@fucom,@fucom         ;E0
  dd    @fucomp,@fucomp,@fucomp,@fucomp,@fucomp,@fucomp,@fucomp,@fucomp ;E8
  dd    @esc,@esc,@esc,@esc,@esc,@esc,@esc,@esc                         ;F0
  dd    @esc,@esc,@esc,@esc,@esc,@esc,@esc,@esc                         ;F8
label   floatDE dword
  dd    @faddp,@faddp,@faddp,@faddp,@faddp,@faddp,@faddp,@faddp         ;C0
  dd    @fmulp,@fmulp,@fmulp,@fmulp,@fmulp,@fmulp,@fmulp,@fmulp         ;C8
  dd    @fcomp5,@fcomp5,@fcomp5,@fcomp5,@fcomp5,@fcomp5,@fcomp5,@fcomp5 ;D0
  dd    @esc,@fcompp,@esc,@esc,@esc,@esc,@esc,@esc                      ;D8
  dd    @fsubrp,@fsubrp,@fsubrp,@fsubrp,@fsubrp,@fsubrp,@fsubrp,@fsubrp ;E0
  dd    @fsubp,@fsubp,@fsubp,@fsubp,@fsubp,@fsubp,@fsubp,@fsubp         ;E8
  dd    @fdivrp,@fdivrp,@fdivrp,@fdivrp,@fdivrp,@fdivrp,@fdivrp,@fdivrp ;F0
  dd    @fdivp,@fdivp,@fdivp,@fdivp,@fdivp,@fdivp,@fdivp,@fdivp         ;F8
label   floatDF dword
  dd    @fpreep,@fpreep,@fpreep,@fpreep,@fpreep,@fpreep,@fpreep,@fpreep ;C0
  dd    @fxch7,@fxch7,@fxch7,@fxch7,@fxch7,@fxch7,@fxch7,@fxch7         ;C8
  dd    @fstp8,@fstp8,@fstp8,@fstp8,@fstp8,@fstp8,@fstp8,@fstp8         ;D0
  dd    @fstp9,@fstp9,@fstp9,@fstp9,@fstp9,@fstp9,@fstp9,@fstp9         ;D8
  dd    @fnstsw,@fnstdw,@fnstsg,@esc,@esc,@esc,@esc,@esc                ;E0
  dd    @fucomip,@fucomip,@fucomip,@fucomip,@fucomip,@fucomip,@fucomip,@fucomip ;E8
  dd    @fcomip,@fcomip,@fcomip,@fcomip,@fcomip,@fcomip,@fcomip,@fcomip ;F0
  dd    @esc,@esc,@esc,@esc,@esc,@esc,@esc,@esc                         ;F8
label   opnames1att dword
  dd    @addb,@addv,@addb,@addv,@addb,@addv,@pushv,@popv        ;00
  dd    @orb,@orv,@orb,@orv,@orb,@orv,@pushv,@dbatt             ;08
  dd    @adcb,@adcv,@adcb,@adcv,@adcb,@adcv,@pushv,@popv        ;10
  dd    @sbbb,@sbbv,@sbbb,@sbbv,@sbbb,@sbbv,@pushv,@popv        ;18
  dd    @andb,@andv,@andb,@andv,@andb,@andv,@es,@daa            ;20
  dd    @subb,@subv,@subb,@subv,@subb,@subv,@cs,@das            ;28
  dd    @xorb,@xorv,@xorb,@xorv,@xorb,@xorv,@ss,@aaa            ;30
  dd    @cmpb,@cmpv,@cmpb,@cmpv,@cmpb,@cmpv,@ds,@aas            ;38
  dd    @incv,@incv,@incv,@incv,@incv,@incv,@incv,@incv         ;40
  dd    @decv,@decv,@decv,@decv,@decv,@decv,@decv,@decv         ;48
  dd    @pushv,@pushv,@pushv,@pushv,@pushv,@pushv,@pushv,@pushv ;50
  dd    @popv,@popv,@popv,@popv,@popv,@popv,@popv,@popv         ;58
  dd    @pusha,@popa,@boundv,@arplv,@fs,@gs,@dbatt,@dbatt       ;60
  dd    @pushv,@imulv,@pushv,@imulv,@insb,@insw,@outsb,@outsw   ;68
  dd    @jov,@jnov,@jbv,@jaev,@jev,@jnev,@jbev,@jav             ;70
  dd    @jsv,@jnsv,@jpv,@jnpv,@jlv,@jgev,@jlev,@jgv             ;78
  dd    @dbatt,@dbatt,@dbatt,@dbatt,@testb,@testv,@xchgb,@xchgv ;80
  dd    @movb,@movv,@movb,@movv,@movv,@leav,@movv,@popv         ;88
  dd    @nop,@xchgv,@xchgv,@xchgv,@xchgv,@xchgv,@xchgv,@xchgv   ;90
  dd    @cbw,@cwd,@lcallv,@wait,@pushf,@popf,@sahf,@lahf        ;98
  dd    @movb,@movv,@movb,@movv,@movsb,@movsw,@cmpsb,@cmpsw     ;A0
  dd    @testb,@testv,@stosb,@stosw,@lodsb,@lodsw,@scasb,@scasw ;A8
  dd    @movb,@movb,@movb,@movb,@movb,@movb,@movb,@movb         ;B0
  dd    @movv,@movv,@movv,@movv,@movv,@movv,@movv,@movv         ;B8
  dd    @dbatt,@dbatt,@ret,@ret,@lesv,@ldsv,@movb,@movv         ;C0
  dd    @enter,@leave,@lret,@lret,@int,@int,@into,@iret         ;C8
  dd    @dbatt,@dbatt,@dbatt,@dbatt,@aam,@aad,@salc,@xlatb      ;D0
  dd    @dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt ;D8
  dd    @loopne,@loope,@loop,@jcxz,@inb,@inv,@outb,@outv        ;E0
  dd    @callv,@jmpv,@ljmpv,@jmpv,@inb,@inv,@outb,@outv         ;E8
  dd    @lock,@int01,@repne,@rep,@hlt,@cmc,@dbatt,@dbatt        ;F0
  dd    @clc,@stc,@cli,@sti,@cld,@std,@dbatt,@dbatt             ;F8
label   opnames2att dword
  dd    @dbatt,@dbatt,@larv,@lslv,@loadall,@loadall,@clts,@loadall      ;00
  dd    @invd,@wbinvd,@dbatt,@ud2,@dbatt,@dbatt,@dbatt,@dbatt           ;08
  dd    @umovb,@umovv,@umovb,@umovv,@dbatt,@dbatt,@dbatt,@dbatt         ;10
  dd    @dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt         ;18
  dd    @movl,@movl,@movl,@movl,@movl,@dbatt,@movl,@dbatt               ;20
  dd    @dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt         ;28
  dd    @wrmsr,@rdtsc,@rdmsr,@rdpmc,@sysenter,@sysexit,@dbatt,@dbatt    ;30
  dd    @dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt         ;38
  dd    @cmovo,@cmovno,@cmovb,@cmovae,@cmove,@cmovne,@cmovbe,@cmova     ;40
  dd    @cmovs,@cmovns,@cmovp,@cmovnp,@cmovl,@cmovge,@cmovle,@cmovg     ;48
  dd    @dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt         ;50
  dd    @dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt         ;58
  dd    @punpcklbw,@punpcklwd,@punpckldq,@packsswb,@pcmpgtb,@pcmpgtw,@pcmpgtd,@packuswb ;60
  dd    @punpckhbw,@punpckhwd,@punpckhdq,@packssdw,@dbatt,@dbatt,@movd,@movq ;68
  dd    @dbatt,@dbatt,@dbatt,@dbatt,@pcmpeqb,@pcmpeqw,@pcmpeqd,@emms    ;70
  dd    @dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@movd,@movq           ;78
  dd    @jov,@jnov,@jbv,@jaev,@jev,@jnev,@jbev,@jav                     ;80
  dd    @jsv,@jnsv,@jpv,@jnpv,@jlv,@jgev,@jlev,@jgv                     ;88
  dd    @seto,@setno,@setb,@setae,@sete,@setne,@setbe,@seta             ;90
  dd    @sets,@setns,@setp,@setnp,@setl,@setge,@setle,@setg             ;98
  dd    @pushv,@popv,@cpuid,@btv,@shldv,@shldv,@dbatt,@dbatt            ;A0
  dd    @pushv,@popv,@rsm,@btsv,@shrdv,@shrdv,@dbatt,@imulv             ;A8
  dd    @cmpxchgb,@cmpxchgv,@lssv,@btrv,@lfsv,@lgsv,@movzbv,@movzwv     ;B0
  dd    @dbatt,@ud,@dbatt,@btcv,@bsfv,@bsrv,@movsbv,@movswv             ;B8
  dd    @xaddb,@xaddv,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt         ;C0
  dd    @bswapv,@bswapv,@bswapv,@bswapv,@bswapv,@bswapv,@bswapv,@bswapv ;C8
  dd    @dbatt,@psrlw,@psrld,@psrlq,@dbatt,@pmullw,@dbatt,@dbatt        ;D0
  dd    @psubusb,@psubusw,@dbatt,@pand,@paddusb,@paddusw,@dbatt,@pandn  ;D8 *
  dd    @dbatt,@psraw,@psrad,@dbatt,@dbatt,@pmulhw,@dbatt,@dbatt        ;E0
  dd    @psubsb,@psubsw,@dbatt,@por,@paddsb,@paddsw,@dbatt,@pxor        ;E8
  dd    @dbatt,@psllw,@pslld,@psllq,@dbatt,@pmaddwd,@dbatt,@dbatt       ;F0
  dd    @psubb,@psubw,@psubd,@dbatt,@paddb,@paddw,@paddd,@dbatt         ;F8
label   amdspecial dword
  dd    @syscall
  dd    @sysret
  dd    @ud
label   amdk3dspecial dword
  dd    @prefetch
  dd    @prefetchw
  dd    @prefetch
  dd    @prefetch
  dd    @prefetch
  dd    @prefetch
  dd    @prefetch
  dd    @prefetch
  dd    @femms
label   cyrixspecial dword
  dd    @svdc
  dd    @rsdc
  dd    @svldt
  dd    @rsldt
  dd    @svts
  dd    @rsts
  dd    @rdshr
  dd    @wrshr
  dd    @smint
  dd    @paveb
  dd    @paddsiw
  dd    @pmagw
  dd    @pdistib
  dd    @psubsiw
  dd    @pmvzb
  dd    @pmulhrw
  dd    @pmvnzb
  dd    @pmvlzb
  dd    @pmvgezb
  dd    @pmulhriw
  dd    @pmachriw
label   grp1EbIbBatt dword
grp1EbIbAatt    dd      @addb,@orb,@adcb,@sbbb,@andb,@subb,@xorb,@cmpb
label   grp1EvIbatt dword
grp1EvIvatt     dd      @addv,@orv,@adcv,@sbbv,@andv,@subv,@xorv,@cmpv
label   grp2EbCLatt dword
label   grp2Eb1att dword
grp2EbIbatt     dd      @rolb,@rorb,@rclb,@rcrb,@shlb,@shrb,@shlb,@sarb
label   grp2EvCLatt dword
label   grp2Ev1att dword
grp2EvIbatt     dd      @rolv,@rorv,@rclv,@rcrv,@shlv,@shrv,@shlv,@sarv
grp3Ebatt       dd      @testb,@testb,@notb,@negb,@mulb,@imulb,@divb,@idivb
grp3Evatt       dd      @testv,@testv,@notv,@negv,@mulv,@imulv,@divv,@idivv
grp4att         dd      @incb,@decb,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt
grp5att         dd      @incv,@decv,@callv,@lcallv,@jmpv,@ljmpv,@pushv,@dbatt
grp6att         dd      @sldt,@str,@lldt,@ltr,@verrv,@verwv,@dbatt,@dbatt
grp7att         dd      @sgdt,@sidt,@lgdt,@lidt,@smswv,@dbatt,@lmswv,@invlpg
grp8att         dd      @dbatt,@dbatt,@dbatt,@dbatt,@btv,@btsv,@btrv,@btcv
grp9att         dd      @dbatt,@cmpxchg8b,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt,@dbatt
grpA0F71att     dd      @dbatt,@dbatt,@psrlw,@dbatt,@psraw,@dbatt,@psllw,@dbatt
grpA0F72att     dd      @dbatt,@dbatt,@psrld,@dbatt,@psrad,@dbatt,@pslld,@dbatt
grpA0F73att     dd      @dbatt,@dbatt,@psrlq,@dbatt,@dbatt,@dbatt,@psllq,@dbatt
label   specialatt dword
  dd    @dbatt
  dd    @enterl
  dd    @enterw
  dd    @enter
  dd    @sgdtl
  dd    @sgdtw
  dd    @sgdt
  dd    @sidtl
  dd    @sidtw
  dd    @sidt
  dd    @lgdtl
  dd    @lgdtw
  dd    @lgdt
  dd    @lidtl
  dd    @lidtw
  dd    @lidt
  dd    @looplnev
  dd    @loopwnev
  dd    @loopnev
  dd    @looplev
  dd    @loopwev
  dd    @loopev
  dd    @looplv
  dd    @loopwv
  dd    @loopv
  dd    @jcxzv
  dd    @jecxzv
  dd    @cbtw
  dd    @cwtl
  dd    @cwtd
  dd    @cltd
  dd    @pushal
  dd    @pushaw
  dd    @pusha
  dd    @popal
  dd    @popaw
  dd    @popa
  dd    @pushfl
  dd    @pushfw
  dd    @pushf
  dd    @popfl
  dd    @popfw
  dd    @popf
  dd    @leavel
  dd    @leavew
  dd    @leave
  dd    @iretl
  dd    @iretw
  dd    @iret
  dd    @retl
  dd    @retw
  dd    @ret
  dd    @lretl
  dd    @lretw
  dd    @lret
  dd    @xlat
  dd    @xlatb
  dd    @insatt
  dd    @insatt
  dd    @insatt
  dd    @insatt
  dd    @outsatt
  dd    @outsatt
  dd    @outsatt
  dd    @outsatt
  dd    @scasatt
  dd    @scasatt
  dd    @scasatt
  dd    @scasatt
  dd    @stosatt
  dd    @stosatt
  dd    @stosatt
  dd    @stosatt
  dd    @lodsatt
  dd    @lodsatt
  dd    @lodsatt
  dd    @lodsatt
  dd    @cmpsatt
  dd    @cmpsatt
  dd    @cmpsatt
  dd    @cmpsatt
  dd    @movsatt
  dd    @movsatt
  dd    @movsatt
  dd    @movsatt
  dd    @esc
floatD8regatt   dd      @fadds,@fmuls,@fcoms,@fcomps,@fsubs,@fsubrs,@fdivs,@fdivrs
floatD9regatt   dd      @flds,@esc,@fsts,@fstps,@fldenv,@fldcw,@fnstenv,@fnstcw
floatDAregatt   dd      @fiaddl,@fimull,@ficoml,@ficompl,@fisubl,@fisubrl,@fidivl,@fidivrl
floatDBregatt   dd      @fildl,@esc,@fistl,@fistpl,@esc,@fldt,@esc,@fstpt
floatDCregatt   dd      @faddl,@fmull,@fcoml,@fcompl,@fsubl,@fsubrl,@fdivl,@fdivrl
floatDDregatt   dd      @fldl,@esc,@fstl,@fstpl,@frstor,@esc,@fnsave,@fnstsw
floatDFregatt   dd      @fild,@esc,@fist,@fistp,@fbld,@fildll,@fbstp,@fistpll

opcodeids       dd      opnames1,opnames2,\
                        grp1EbIbA,grp1EvIv,grp1EbIbB,grp1EvIb,\
                        grp2EbIb,grp2EvIb,grp2Eb1,grp2Ev1,\
                        grp2EbCL,grp2EvCL,grp3Eb,grp3Ev,\
                        grp4,grp5,grp6,grp7,grp8,\
                        grp9,grpA0F71,grpA0F72,grpA0F73,\
                        grpB,\
                        special,\
                        floatD8reg,floatD9reg,\
                        floatDAreg,floatDBreg,\
                        floatDCreg,floatDDreg,\
                        floatDEreg,floatDFreg,\
                        floatD8,floatD9,\
                        floatDA,floatDB,\
                        floatDC,floatDD,\
                        floatDE,floatDF,\
                        amdk3dopcodes,amdk3dspecial,amdspecial,\
                        cyrixspecial

opcodeidsatt    dd      opnames1att,opnames2att,\
                        grp1EbIbAatt,grp1EvIvatt,grp1EbIbBatt,grp1EvIbatt,\
                        grp2EbIbatt,grp2EvIbatt,grp2Eb1att,grp2Ev1att,\
                        grp2EbCLatt,grp2EvCLatt,grp3Ebatt,grp3Evatt,\
                        grp4att,grp5att,grp6att,grp7att,grp8att,\
                        grp9att,grpA0F71att,grpA0F72att,grpA0F73att,\
                        grpBatt,\
                        specialatt,\
                        floatD8regatt,floatD9regatt,\
                        floatDAregatt,floatDBregatt,\
                        floatDCregatt,floatDDregatt,\
                        floatDEregatt,floatDFregatt,\
                        floatD8,floatD9,\
                        floatDA,floatDB,\
                        floatDC,floatDD,\
                        floatDE,floatDF,\
                        amdk3dopcodes,amdk3dspecial,amdspecial,\
                        cyrixspecial

operandcall     dd      dis_mem,dis_imm,dis_reg,dis_nearofs,dis_farofs
operandcallatt  dd      dis_mematt,dis_immatt,dis_regatt,dis_nearofsatt,dis_farofsatt

label   regs dword
  dd    @eax,@ecx,@edx,@ebx,@esp,@ebp,@esi,@edi
  dd    @ax,@cx,@dx,@bx,@sp,@bp,@si,@di
  dd    @al,@cl,@dl,@bl,@ah,@ch,@dh,@bh
label   segregs dword
  dd    @es,@cs,@ss,@ds,@fs,@gs,@?1,@?2
  dd    @cr0,@cr1,@cr2,@cr3,@cr4,@cr5,@cr6,@cr7
  dd    @dr0,@dr1,@dr2,@dr3,@dr4,@dr5,@dr6,@dr7
  dd    @tr0,@tr1,@tr2,@tr3,@tr4,@tr5,@tr6,@tr7
  dd    @mm0,@mm1,@mm2,@mm3,@mm4,@mm5,@mm6,@mm7
  dd    @st0,@st1,@st2,@st3,@st4,@st5,@st6,@st7
  dd    @st

label   regsatt dword
  dd    @eax,@ecx,@edx,@ebx,@esp,@ebp,@esi,@edi
  dd    @ax,@cx,@dx,@bx,@sp,@bp,@si,@di
  dd    @al,@cl,@dl,@bl,@ah,@ch,@dh,@bh
  dd    @es,@cs,@ss,@ds,@fs,@gs,@?1,@?2
  dd    @cr0,@cr1,@cr2,@cr3,@cr4,@cr5,@cr6,@cr7
  dd    @db0,@db1,@db2,@db3,@db4,@db5,@db6,@db7
  dd    @tr0,@tr1,@tr2,@tr3,@tr4,@tr5,@tr6,@tr7
  dd    @mm0,@mm1,@mm2,@mm3,@mm4,@mm5,@mm6,@mm7
  dd    @st0,@st1,@st2,@st3,@st4,@st5,@st6,@st7
  dd    @st

;from dis_operand_t.size equates
label   sizestrings dword
  dd    @byte,@word,@dword,@pword
  dd    @qword,@tbyte,@word,@dword
  dd    @dword,@fword,@word,@dword

macro   op n
@&n&    db      '&n&',0
endm    op
macro   op2 n
@&n&    db      '&n&',0
@&n&d   db      '&n&d',0
@&n&w   db      '&n&w',0
endm    op2
op      aaa
op      aad
op      aam
op      aas
op      adc
op      add
op      and
op      arpl
op      bound
op      bsf
op      bsr
op      bswap
op      bt
op      btc
op      btr
op      bts
op      call
op      cbw
op      cdq
op      clc
op      cld
op      cli
op      clts
op      cmc
op      cmp
op      cmps
op      cmpsb
op      cmpsd
op      cmpsw
op      cmpxchg
op      cmpxchg8b
op      cpuid
op      cwd
op      cwde
op      daa
op      das
op      dec
op      div
op2     enter
op      esc
op      f2xm1
op      fabs
op      fadd
op      faddp
op      fiadd
op      fbld
op      fbstp
op      fchs
op      fnclex
op      fneni
op      fndisi
op      fnsetpm
op      fcom
op      fcomp
op      fcompp
op      fcos
op      fdecstp
op      fdiv
op      fdivp
op      fidiv
op      fdivr
op      fdivrp
op      fidivr
op      ffree
op      ficom
op      ficomp
op      fild
op      fincstp
op      fninit
op      fist
op      fistp
op      fld
op      fld1
op      fldl2t
op      fldl2e
op      fldpi
op      fldlg2
op      fldln2
op      fldz
op      fldcw
op      fldenv
op      fmul
op      fmulp
op      fimul
op      fnop
op      fpatan
op      fprem
op      fprem1
op      fptan
op      frndint
op      frstor
op      fnsave
op      fscale
op      fsin
op      fsincos
op      fsqrt
op      fst
op      fstp
op      fnstcw
op      fnstenv
op      fnstsw
op      fsub
op      fsubp
op      fisub
op      fsubr
op      fsubrp
op      fisubr
op      ftst
op      fucom
op      fucomp
op      fucompp
op      fxam
op      fxch
op      fxtract
op      fyl2x
op      fyl2xp1
op      hlt
op      idiv
op      imul
op      in
op      inc
op      ins
op      insb
op      insw
op      insd
op      int
op      int01
op      into
op      invd
op      invlpg
op2     iret
op      jcxz
op      jecxz
op      jo
op      jno
op      jb
op      jae
op      je
op      jne
op      jbe
op      ja
op      js
op      jns
op      jp
op      jnp
op      jl
op      jge
op      jle
op      jg
op      jmp
op      lahf
op      lar
op      lds
op      lea
op2     leave
op      les
op      lfs
op2     lgdt
op      lgs
op      lldt
op2     lidt
op      lmsw
op      loadall
op      lock
op      lods
op      lodsb
op      lodsd
op      lodsw
op      loop
op      loopd
op      loopw
op      loope
op      loopde
op      loopwe
op      loopne
op      loopdne
op      loopwne
op      lsl
op      lss
op      ltr
op      mov
op      movs
op      movsb
op      movsd
op      movsw
op      movsx
op      movzx
op      mul
op      neg
op      nop
op      not
op      or
op      out
op      outs
op      outsb
op      outsd
op      outsw
op      pop
op2     popa
op2     popf
op      push
op2     pusha
op2     pushf
op      rcl
op      rcr
op      rdmsr
op      rdtsc
op      rep
op      repne
op2     retn
op2     retf
op      rol
op      ror
op      rsm
op      sahf
op      salc
op      sar
op      sbb
op      scas
op      scasb
op      scasd
op      scasw
op      seges
op      segcs
op      segss
op      segds
op      segfs
op      seggs
op      seto
op      setno
op      setb
op      setae
op      sete
op      setne
op      setbe
op      seta
op      sets
op      setns
op      setp
op      setnp
op      setl
op      setge
op      setle
op      setg
op2     sgdt
op      shl
op      shr
op      shld
op      shrd
op2     sidt
op      sldt
op      smsw
op      stc
op      std
op      sti
op      stos
op      stosb
op      stosd
op      stosw
op      str
op      sub
op      sysenter
op      sysexit
op      test
op      ud2
op      verr
op      verw
op      wait
op      wbinvd
op      wrmsr
op      xadd
op      xchg
op      xlat
op      xlatb
op      xor

op      psrlw
op      psraw
op      psllw
op      psrld
op      psrad
op      pslld
op      psrlq
op      psllq
op      umov
op      rdpmc
op      cmovo
op      cmovs
op      punpcklbw
op      punpckhbw
op      pcmpeqb
op      movd
op      pmullw
op      psubusb
op      pmulhw
op      psubsb
op      pmaddwd
op      psubb
op      cmovno
op      cmovns
op      punpcklwd
op      punpckhwd
op      pcmpeqw
op      movq
op      psubusw
op      psubsw
op      psubw
op      cmovb
op      cmovp
op      punpckldq
op      punpckhdq
op      pcmpeqd
op      pand
op      por
op      psubd
op      cmovae
op      cmovnp
op      packsswb
op      packssdw
op      emms
op      paddusb
op      paddsb
op      paddb
op      cmove
op      cmovl
op      pcmpgtb
op      paddusw
op      paddsw
op      paddw
op      cmovne
op      cmovge
op      pcmpgtw
op      pandn
op      pxor
op      paddd
op      cmovbe
op      cmovle
op      pcmpgtd
op      cmova
op      cmovg
op      packuswb

op      fstp1
op      fcmovb
op      fcmove
op      fcmovbe
op      fcmovu
op      fcmovnb
op      fcmovne
op      fcmovnbe
op      fcmovnu
op      fnrstpm
op      fucomi
op      fcomi
op      fcom2
op      fcomp3
op      fxch4
op      fcomp5
op      ffreep
op      fxch7
op      fstp8
op      fstp9
op      fnstdw
op      fnstsg
op      fucomip
op      fcomip
op      fpreep

;AMD K3D instruction mnemonics
op      k3d?            ;invalid or not known K3D instruction
op      pfcmpge
op      pfmin
op      pfrcp
op      pfrsqrt
op      pfcmpgt
op      pfmax
op      pfrcpit1
op      pfrsqit1
op      pfcmpeq
op      pfmul
op      pfrcpit2
op      pmulhrw
op      pi2fd
op      pf2id
op      pfsub
op      pfadd
op      pfsubr
op      pfacc
op      pavgusb
op      syscall
op      sysret
op      ud
op      prefetch
op      prefetchw
op      femms

;Cyrix instruction mnemonics
op      svdc
op      rsdc
op      svldt
op      rsldt
op      svts
op      rsts
op      rdshr
op      wrshr
op      smint
op      paveb
op      paddsiw
op      pmagw
op      pdistib
op      psubsiw
op      pmvzb
;op      pmulhrw
op      pmvnzb
op      pmvlzb
op      pmvgezb
op      pmulhriw
op      pmachriw

op      fxsave
op      fxrstor

macro   att n
@&n&    db      '&n&',0
endm    att
macro   att2 n
@&n&v   db      '&n&',attdontshowsizeworddword,0
endm    att2

macro   attb n
@&n&b   db      '&n&',attsizebyte,0
endm    attb
macro   attv n
@&n&v   db      '&n&',attsizeworddword,0
endm    attv
macro   attbv n
  attb  n
  attv  n
endm    attbv
macro   atts n
@&n&att db      '&n&',attstringsize,0
endm    atts

attbv   adc
attbv   add
attbv   and
att2    arpl
attv    bound
attv    bsf
attv    bsr
attv    bswap
attv    bt
attv    btc
attv    btr
attv    bts
att2    call
att2    lcall
attbv   cmp
attbv   cmpxchg
attbv   dec
attbv   div
attbv   idiv
attbv   imul
attbv   in
attbv   inc
att2    iret
att2    jcxz
att2    jecxz
att2    jo
att2    jno
att2    jb
att2    jae
att2    je
att2    jne
att2    jbe
att2    ja
att2    js
att2    jns
att2    jp
att2    jnp
att2    jl
att2    jge
att2    jle
att2    jg
att2    jmp
att2    ljmp
attv    lar
attv    lds
attv    lea
attv    les
attv    lfs
attv    lgs
att2    lmsw
attv    lsl
attv    lss
attv    ltr
attbv   mov
@movsbv db      'movsb',attshowsizeworddword,0
@movswv db      'movsw',attshowsizeworddword,0
@movzbv db      'movzb',attshowsizeworddword,0
@movzwv db      'movzw',attshowsizeworddword,0
attbv   mul
attbv   neg
attbv   not
attbv   or
attbv   out
attv    pop
attv    push
attbv   rcl
attbv   rcr
attbv   rol
attbv   ror
attbv   sar
attbv   sbb
attbv   shl
attbv   shr
attbv   shld
attbv   shrd
att2    smsw
attbv   sub
attbv   test
att2    verr
att2    verw
attbv   xadd
attbv   xchg
attbv   xor

att     enterl
att     sgdtl
att     sidtl
att     lgdtl
att     lidtl
att2    looplne
att2    loopwne
att2    loopne
att2    loople
att2    loopwe
att2    loope
att2    loopl
att2    loopw
att2    loop
att     pushal
att     popal
att     pushfl
att     popfl
att     leavel
att     iretl
atts    ins
atts    outs
atts    scas
atts    stos
atts    lods
atts    cmps
atts    movs
att     ret
att     retw
att     retl
att     lret
att     lretw
att     lretl
att     cbtw
att     cwtl
att     cwtd
att     cltd
att     movl

op      fadds
op      fmuls
op      fcoms
op      fcomps
op      fsubs
op      fsubrs
op      fdivs
op      fdivrs
op      flds
op      fsts
op      fstps
op      fiaddl
op      fimull
op      ficoml
op      ficompl
op      fisubl
op      fisubrl
op      fidivl
op      fidivrl
op      fildl
op      fistl
op      fistpl
op      fldt
op      fstpt
op      faddl
op      fmull
op      fcoml
op      fcompl
op      fsubl
op      fsubrl
op      fdivl
op      fdivrl
op      fldl
op      fstl
op      fstpl
op      fildll
op      fistpll

attbv   umov

op      db
op      small
op      large
op      byte
op      word
op      dword
op      fword
op      pword
op      qword
op      tbyte
op      short
op      near
op      far
op      ptr
@dbatt  db      '.byte',0

op      al
op      cl
op      dl
op      bl
op      ah
op      ch
op      dh
op      bh
op      ax
op      cx
op      dx
op      bx
op      sp
op      bp
op      si
op      di
op      eax
op      ecx
op      edx
op      ebx
op      esp
op      ebp
op      esi
op      edi
op      es
op      cs
op      ss
op      ds
op      fs
op      gs
op      ?1
op      ?2
@cr0    db      'cr0',0
@cr1    db      'cr1',0
@cr2    db      'cr2',0
@cr3    db      'cr3',0
@cr4    db      'cr4',0
@cr5    db      'cr5',0
@cr6    db      'cr6',0
@cr7    db      'cr7',0
@dr0    db      'dr0',0
@dr1    db      'dr1',0
@dr2    db      'dr2',0
@dr3    db      'dr3',0
@dr4    db      'dr4',0
@dr5    db      'dr5',0
@dr6    db      'dr6',0
@dr7    db      'dr7',0
@db0    db      'db0',0
@db1    db      'db1',0
@db2    db      'db2',0
@db3    db      'db3',0
@db4    db      'db4',0
@db5    db      'db5',0
@db6    db      'db6',0
@db7    db      'db7',0
@tr0    db      'tr0',0
@tr1    db      'tr1',0
@tr2    db      'tr2',0
@tr3    db      'tr3',0
@tr4    db      'tr4',0
@tr5    db      'tr5',0
@tr6    db      'tr6',0
@tr7    db      'tr7',0
@mm0    db      'mm0',0
@mm1    db      'mm1',0
@mm2    db      'mm2',0
@mm3    db      'mm3',0
@mm4    db      'mm4',0
@mm5    db      'mm5',0
@mm6    db      'mm6',0
@mm7    db      'mm7',0
@st0    db      'st(0)',0
@st1    db      'st(1)',0
@st2    db      'st(2)',0
@st3    db      'st(3)',0
@st4    db      'st(4)',0
@st5    db      'st(5)',0
@st6    db      'st(6)',0
@st7    db      'st(7)',0
op      st
purge   op
        endconst
        end
