program locate;
{$M 16384,0,0}
uses dos,crt;

var db,ini,output,con:text;
    currdir,parstr,dbhome,s,drive,out,home,value,tmp,lastdriv,outfile,header,sizestr:string;
    c:char;
    pause,par,sstrcount,ptrd,ptra,ptrs,ptrt,compare:byte;
    i,j,k,warn,dirs:integer;
    compact,firstentry,all,update,comma,whole,less,createmode,verbose,quiet,size,sizechk:boolean;
    date,time,fileout,dopause,fileonly,key:boolean;
    stamp:datetime;
    total,stampdat,recsize,sizeval,count:longint;
    stampbit:word;
    cache,outcache:array[1..16384] of char;
    sstrings:array[1..10] of string;

procedure helper; assembler;
asm
jmp @st
@txt:
DB 13,10,' >>> unix-like LOCATE v1.10 <<<   (c) 1997 Coyot [coyot@pinknet.cz]  (english)',13,10
DB '* Quick Reference *',13,10
DB 9,'/h<path>',9,'Path to LOCATE.DAT, if not in the same dir as LOCATE',13,10
DB 9,'/q',9,'quiet, no output to console except warnings and end report',13,10
DB 9,'/u',9,'database update - some options will be ignored - see DOC',13,10
DB 9,'/c',9,'activates database creation mode',13,10
DB 'Database creation mode switches:',13,10
DB 9,'/v',9,'verbose, reports directory names and final statistic',13,10
DB 9,'/dXYZ',9,'explicit drives for search specification',13,10
DB 9,'/p+|-',9,'create compact database - substituted dirnames',13,10
DB 9,'/s+|-',9,'Do (or not) add filesize to database  [+-ynYN, default is off]',13,10
DB 9,'/a+|-',9,9,9,'date',13,10
DB 9,'/t+|-',9,9,9,'time',13,10
DB 'Find mode (default) switches:',13,10
DB 9,'/s,a,t',9,'affect amount of output about found files',13,10
DB 9,'/d',9,'drive search restrictions',13,10
DB 9,'/w',9,'wholewords search',13,10
DB 9,'/m',9,'comma delimited format of output file',13,10
DB 9,'/pnn',9,'pause every nn lines of output',13,10
DB 9,'/o[out]',9,'write output to file, /o writes to default outfile from the INI',13,10
DB 9,'/f',9,'look for searchstring in filename only',13,10
DB 9,'/n[]#',9,'filesize search',13,10
DB '    Default settings from the INI used if these switches are not present.',13,10,'$'
@st:  push ds; push cs; pop ds; lea dx,@txt; mov ah,9; int 21h; pop ds
end;

procedure help;
begin
helper;
halt(1);
end;

procedure diskalarm;
begin
writeln(con,#13#10'Detected I/O error. Probably disk full?');
writeln(con,'Deleting temporary files...');
close(db);
erase(db);
if fileout then begin
  close(output);
  erase(output);
end;
halt(7);
end;

procedure nodb;
begin
  writeln(con,#13#10'Database file ',home+'LOCATE.DAT not found.');
  writeln(con,'Please verify that LOCATE files are together in one directory');
  writeln(con,'and a database file has already been created.');
  halt(3);
end;

procedure gets(var s:string);
begin
readln(db,s);
if not compact then exit;
j:=pos('*',s);
if j<>0 then  {Replace * with current dir string}
  begin
    delete(s,j,1);
    insert(currdir,s,j);
  end
else {zjistit novy directory string a zapsat do currdir}
begin
  currdir:=copy(s,ptrd,length(s)-ptrd+1);
  j:=length(currdir);
  while not (currdir[j]='\') do dec(j);
  delete(currdir,j,length(currdir)-j+1);
end;
end;

procedure varinit;
begin
assign(con,'');
rewrite(con);
compare:=4;
warn:=1024;
currdir:='';
parstr:='';
dbhome:='';
s:='';
drive:='';
out:='';
home:='';
value:='';
tmp:='';
lastdriv:='';
outfile:='';
header:='';
sizestr:='';
pause:=0;
par:=0;
total:=0;
count:=0;
sstrcount:=0;
ptrd:=0;
ptra:=0;
ptrs:=0;
ptrt:=0;
i:=0;
j:=0;
k:=0;
dirs:=0;
compact:=false;
firstentry:=false;
all:=false;
update:=false;
comma:=false;
whole:=false;
less:=false;
createmode:=false;
verbose:=false;
quiet:=false;
size:=false;
sizechk:=false;
date:=false;
time:=false;
fileout:=false;
dopause:=false;
fileonly:=false;
key:=false;
end;

procedure chkdrive(var drive:string);
var dirinfo:searchrec;
begin
if drive<>'ALL' then
  begin
  for i:=1 to length(s) do begin
    if (pos(drive[i],drive)<>i) then drive[i]:=' '
    end;
  while pos(' ',drive)<>0 do delete(drive,pos(' ',drive),1);
  end
  else
  begin
    drive:='';
    lastdriv:=getenv('LASTDRIVE');
    if lastdriv='' then lastdriv:='Z';
    for i:= ord('C') to ord(lastdriv[1]) do
    drive:=drive+chr(i);
  end;
{Now we'll check all the drives selected}
for i:=1 to length(drive) do
  begin
    FindFirst(drive[i]+':\*.*', AnyFile, DirInfo);
    if (Doserror<>0) and (DosError<>18) then
    begin
       writeln(con,'Couldn''t access drive ',drive[i],':');
       writeln(con,'Will skip scanning that drive.');
       drive[i]:=' ';
    end;
  end; {for cycle}
while pos(' ',drive)<>0 do delete(drive,pos(' ',drive),1);
end;

procedure str0(x:longint;var s:string);
begin
str(x,s);
while not (length(s)=2)
do s:='0'+s;
end;

procedure valpar(var result:boolean;s:string);
begin
 result:=true;
 s:=s+' ';
 if (s[2]='-') or(s[2]='n') or (s[2]='N') then result:=false;
end;

procedure updatedb;
begin
date:=false;
time:=false;
size:=false;
compact:=false;
readln(db,header);
if (header[2])='P' then compact:=true;
if (pos('Options',header)=0) or (pos('Drives',header)=0) then exit;
j:=pos('Options',header);
drive:=copy(header,10,(j-11));
if pos('date',header)<>0 then date:=true;
if pos('size',header)<>0 then size:=true;
if pos('time',header)<>0 then time:=true;
end;

procedure sizecheck(var sizeval:longint;var compare:byte;s:string);
begin
delete(s,1,1);
compare:=3;
if s[1]='-' then compare:=0;
if s[1]='=' then compare:=1;
if s[1]='+' then compare:=2;
if compare<3 then delete(s,1,1);
if compare=3 then compare:=1;
val(s,sizeval,j);
if j=0 then sizechk:=true
else begin
  writeln(con,#13#10'Invalid argument of /n parameter!');
  halt(8);
  end;
end;

procedure cinit;
var sign:byte;
begin
while not eof(ini) do begin
  readln(ini,s);
  if not (s[1]='#') then begin
  for i := 1 to Length(s) do
  s[i] := UpCase(s[i]);
  while pos(' ',s)<>0  do delete(s,pos(' ',s),1);
  sign:=pos('=',s);
  value:=copy(s,sign+1,(length(s)-sign));
  s:=copy(s,1,sign-1);
  if s='CDATE' then if (Value='YES') or (Value='1') then date:=true;
  if s='CSIZE' then if (Value='YES') or (Value='1') then size:=true;
  if s='UPDATE' then if (Value='YES') or (Value='1') then update:=true;
  if s='CTIME' then if (Value='YES') or (Value='1') then time:=true; 
  if s='DRIVES' then drive:=value else if drive='' then drive:='ALL';
  if s='VERBOSITY' then begin
                        if (value='0') then quiet:=true;
                        if (value='2') then verbose:=true;
                        end;
  if s='WARN' then val(value,warn,j);
  if s='DBHOME' then dbhome:=value;
  if s='COMPACT' then if (Value='YES') or (Value='1') then compact:=true;
  end;
end;
for i:=1 to length(parstr) do begin
  s:='';
  while not (parstr[i]=' ') do begin
    s:=s+parstr[i];
    inc(i);
  end;
{Tady nekontroluju, je-li prvni znak / nebo -, protoze byt musi, v create modu
nejsou zadne parametry bez nej...}
  delete(s,1,1);
  case s[1] of
      'T': valpar(time,s);
      'S': valpar(size,s);
      'A': valpar(date,s);
      'P': valpar(compact,s);
      'D': if length(s)>1 then drive:=copy(s,2,length(s)-1);
      'Q': quiet:=true;
      'U': update:=true;
      'V': begin
             if quiet then quiet:=false;
             verbose:=true;
           end;
      'H': begin
             delete(s,1,1);
             dbhome:=s;
           end;
  end {of case}
end; {of for cycle}
createmode:=true;
if dbhome='' then assign(db,home+'locate.dat')
else begin
  if dbhome[length(dbhome)]<>'\' then dbhome:=dbhome+'\';
  assign(db,dbhome+'locate.dat');
  end;
{$I-}
settextbuf(db,cache);
if not update then rewrite(db)
else begin
  reset(db);
  if ioresult<>0 then nodb;
  updatedb;
  rewrite(db);
  {$I+}
  end;
if IOResult <>0 then begin
  writeln(con,#13#10'Couldn''t open database file for writing!');
  writeln(con,'Please make sure that LOCATE is placed on a writable drive and');
  writeln(con,'there is enough space on that drive.');
  halt(4);
end;
end;

procedure finit;
var sign:byte;
begin
while not eof(ini) do begin
  readln(ini,s);
  if not (s[1]='#') then begin
  for i := 1 to Length(s) do
  s[i] := UpCase(s[i]);
  while pos(' ',s)<>0 do delete(s,pos(' ',s),1);
  sign:=pos('=',s);
  value:=copy(s,sign+1,(length(s)-sign));
  s:=copy(s,1,sign-1);
  if s='FDATE' then if (Value='YES') or (Value='1') then date:=true;
  if s='FSIZE' then if (Value='YES') or (Value='1') then size:=true;
  if s='FTIME' then if (Value='YES') or (Value='1') then time:=true;
  if s='FILENAMEONLY' then if (Value='YES') or (Value='1') then fileonly:=true;
  if s='PAUSE' then val(value,pause,j);
  if s='OUTFILE' then outfile:=value;
  if s='FILEOUTPUT' then if (Value='YES') or (Value='1') then fileout:=true;
  if s='FDRIVES' then drive:=value else if drive='' then drive:='ALL';
  if s='QUIET' then if (Value='YES') or (Value='1') then quiet:=true;
  if s='WHOLEWORDS' then if (Value='YES') or (Value='1') then whole:=true;
  if s='COMMADELIMITED' then if (Value='YES') or (Value='1') then comma:=true;
  if s='DBHOME' then dbhome:=value;
  end;
end;
for i:=1 to length(parstr) do begin
  s:='';
  while not (parstr[i]=' ') do begin
    s:=s+parstr[i];
    inc(i);
  end;
  if (s[1]='/') or (s[1]='-') then begin
    delete(s,1,1); {Neni rychlejsi a mensi pouzit copy (s,1,length(s)-1)?}
    case s[1] of
      'T': valpar(time,s);
      'S': valpar(size,s);
      'A': valpar(date,s);
      'W': valpar(whole,s);
      'M': valpar(comma,s);
      'D': if length(s)>1 then drive:=copy(s,2,length(s)-1);
      'Q': quiet:=true;
      'P': begin
             delete(s,1,1);
             if s='' then s:='23';
             val(s,pause,j);
           end;
      'O': begin
             fileout:=true;
             delete(s,1,1);
             if s<>'' then outfile:=s;
           end;
      'H': begin
             delete(s,1,1);
             dbhome:=s;
           end;
      'F': valpar(fileonly,s);
      'N': sizecheck(sizeval,compare,s);
    end {of case}
  end
  else begin
    inc(sstrcount);
    sstrings[sstrcount]:=s;
    if s='*' then all:=true;
  end;
end; {of for cycle}{Check for files and required params follows}
if dbhome='' then assign(db,home+'locate.dat')
else begin
  if dbhome[length(dbhome)]<>'\' then dbhome:=dbhome+'\';
  assign(db,dbhome+'locate.dat');
  end;
settextbuf(db,cache);
{$I-}
reset(db);
{$I+}
if IOResult<>0 then nodb;
if sstrcount<1 then begin
  writeln(con,#13#10'In find mode, you must specify a search string!');
  halt(6);
  end;
if fileout then begin
  assign(output,outfile);
  {$I-}
  rewrite(output);
  {$I+}
  if IOResult <>0 then begin
    writeln(con,#13#10'Couldn''t open output file. Check the filename again');
    writeln(con,'or disable file output mode.');
    halt(5);
    end;
  settextbuf(output,outcache);
  end;
if pause>0 then dopause:=true;
end;

procedure startup;
begin
createmode:=false;
home:=ParamStr(0);
par:=paramcount;
if par=0 then help;
tmp:=paramstr(1);
if (((tmp[1]='/') or (tmp[1]='-')) and (upcase(tmp[2])='h')) or (pos('?',tmp)<>0)  then help;
repeat delete (home,length(home),1);
       {Newim, jak nejak snadneji a rychleji zjistit adresarovou cast par0
          aniz bych predpokladal, ze si user neprejmenuje locate.exe na neco jineho
          s jinou delkou jmena.}
until home[length(home)]='\';
assign(ini,home+'locate.ini');
{$I-}
reset(ini);
{$I+}
if IOResult <>0 then begin
  writeln(con,#13#10'Configuration file ',home+'LOCATE.INI not found.');
  writeln(con,'Please copy the .INI from the original distribution');
  writeln(con,'to the directory you have placed LOCATE.EXE in.');
  halt(2);
  end;
{Tady udelame string na vsechny parametry}
for i:=1 to par do begin
  s:=paramstr(i);
  for j:=1 to length(s) do parstr:=parstr+upcase(s[j]);
  parstr:=parstr+' ';
  end;
tmp:=paramstr(1);
if ((tmp[1]='/') or (tmp[1]='-')) and ((upcase(tmp[2])='C') or (upcase(tmp[2])='U')) then cinit
else finit;
end;

procedure browse(var s:string);
var dirinfo:searchrec;
begin
firstentry:=true;
inc(dirs);
if not quiet and not verbose then write(con,'.');
if not quiet and verbose then writeln(con,'Current directory is ',s);
FindFirst(s+'\*.*', AnyFile, DirInfo);
if DosError<>0 then exit;
repeat
if DirInfo.name[1]='.' then
else
    if (dirinfo.attr and directory<>0) then begin
      s:=s+'\'+DirInfo.Name;
      browse(s);
    s:=copy(s,1,(length(s)-length(dirinfo.name)-1));
    end
    else
    if (dirinfo.attr and VolumeID=0) then
    begin
      if compact and not firstentry then out:='*\'+dirinfo.name
      else
      begin {Prvni soubor v adresari musi dostat cestu}
        out:=s+'\'+dirinfo.name;
        firstentry:=false;
      end;
      if (date or time) then begin
        stampdat:=dirinfo.time;
        unpacktime(stampdat,stamp);
        with stamp do
        begin
          tmp:='';
          if time then begin
            str0(sec,value);
            tmp:=value+'  '+tmp;
            str0(min,value);
            tmp:=value+':'+tmp;
            str0(hour,value);
            tmp:=value+':'+tmp;
          end;
          if date then begin
            str0(day,value);
            tmp:=value+'  '+tmp;
            str0(month,value);
            tmp:=value+'-'+tmp;
            str(year,value);
            tmp:=value+'-'+tmp;
          end;
        end; {konec with}
      out:=tmp+out;
      end;
      if size then begin
        str(dirinfo.size,value);
        while not (length(value)=9) do value:=' '+value;
        out:=value+'  '+out;
      end;
      writeln(db,out);
      inc(count);
    end;
findnext(dirinfo);
until DosError <>0;
if IOresult<>0 then diskalarm;
firstentry:=true;
end;

procedure writestr(value:string);
begin
if comma then
  begin
  tmp:='';
  if size then tmp:=tmp+copy(value,ptrs,9)+',';
  if time then tmp:=tmp+'"'+copy(value,ptrt,8)+'",';
  if date then tmp:=tmp+'"'+copy(value,ptra,10)+'",';
  delete(value,1,ptrd-1);
  tmp:=tmp+'"'+value+'"';
  end;
writeln(output,tmp);
end;

procedure filter(s:string);
begin
if pos(s[ptrd],drive)=0 then exit;
value:=s;
if sizechk then begin
  tmp:=copy(s,ptrs,9);
  while (tmp[1]=' ') do delete(tmp,1,1);
  val(tmp,recsize,j);
  case compare of
    0: if sizeval <= recsize then exit;
    1: if sizeval <> recsize then exit;
    2: if sizeval >= recsize then exit;
  end;
end;
tmp:='';
if size then tmp:=tmp+copy(s,ptrs,11);
if time then tmp:=tmp+copy(s,ptrt,10);
if date then tmp:=tmp+copy(s,ptra,12);
delete(s,1,ptrd-1);
tmp:=tmp+s;
if not quiet then begin
  writeln(con,tmp);
  inc(count);
  if count=pause then begin
    total:=total+count;
    count:=0;
    writeln(con,'---More---');
    repeat c:=readkey;
    until c<>'_';
    c:='_'
    end;
  end;
if fileout then writestr(value);
tmp:='';
end;

procedure filesearch;
begin
  if whole then
  while not eof(db) do
  begin
    repeat gets(s);
    until (pos(s[ptrd],drive)<>0) or eof(db);
    tmp:=s;
    while(pos('\',tmp)>0) do delete(tmp,1,pos('\',tmp));
    if pos('.',tmp)<>0 then delete(tmp,pos('.',tmp),(length(tmp)-pos('.',tmp)+1));
    for i:=1 to sstrcount do begin
      if sstrings[i]=tmp then filter(s);
    end;
  end
  else
  while not eof(db) do
  begin
    repeat gets(s);
    until (pos(s[ptrd],drive)<>0) or eof(db);
    tmp:=s;
    while(pos('\',tmp)>0) do delete(tmp,1,pos('\',tmp));
    for i:=1 to sstrcount do begin
      if pos(sstrings[i],tmp)<>0 then filter(s);
    end;
  end;
end;

procedure search;
begin
  if whole then
  while not eof(db) do
  begin
    repeat gets(s);
    until (pos(s[ptrd],drive)<>0) or eof(db); {Pousti dal jen zaznamy z drivu, ktere chci prohledavat}
    tmp:=s;
    for i:=1 to sstrcount do begin
      repeat
      j:=pos(sstrings[i],tmp);
      if j<>0 then
      begin
        par:=length(sstrings[i]);
        if length(tmp)=par then filter(s);
        if (tmp[j-1]='\') and ((tmp[j+par]='\') or (tmp[j+par]='.') or (length(s)=j+par-1)) then filter(s)
        else begin
        k:=pos('\',tmp);
        if k>0 then delete(tmp,1,pos('\',tmp))
        else tmp:='';
        end;
      end;
      until j=0;
    end;
  end
  else
  while not eof(db) do
  begin
    repeat gets(s);
    until (pos(s[ptrd],drive)<>0) or eof(db);
    for i:=1 to sstrcount do begin
      if pos(sstrings[i],s)<>0 then filter(s);
    end;
  end;
end;

begin
{$I-}
varinit;
startup;
close(ini);
if createmode then begin
  chkdrive(drive);
  tmp:='#T';
  if compact then tmp:='#P';
  tmp:=tmp+'Drives:'+drive+' Options:';
  if size then tmp:=tmp+' size';
  if date then tmp:=tmp+' date';
  if time then tmp:=tmp+' time';
  writeln(db,tmp);
  for i:=1 to length(drive) do
  begin
    s:=drive[i]+':';
    browse(s);
  end;
  if verbose then writeln(con,'Finished processing. Found ',count,' files in ',dirs,' directories.');
  if not quiet then begin
    writeln(con,#13#10'All OK, closing new database.');
    end;
  close(db);
  end
else begin
  ptra:=1;
  ptrs:=1;
  ptrt:=1;
  ptrd:=1;
  readln(db,header);
  if (header[2]='P') then compact:=true;
  if pos('size',header)=0 then size:=false;
  if (pos('size',header)=0) and sizechk then begin
    writeln(con,#13#10'Database must be created with /s+ or CSIZE=YES in INI file');
    writeln(con,'in order to use filesize searchstrings.');
    halt(9);
    end;
  if pos('date',header)=0 then date:=false;
  if pos('time',header)=0 then time:=false;
  j:=pos('Options',header);
  s:=copy(header,10,(j-11));
  if drive='ALL' then drive:=s
  else begin
    for i:=1 to length(drive) do
    if pos(drive[i],s)=0 then drive[i]:=' ';
    while pos(' ',drive)<>0 do delete(drive,pos(' ',drive),1); {Search drives restricted}
    end;
  ptrd:=1;
  if pos('time',header)<>0 then begin
    ptrt:=1;
    ptrd:=ptrd+10;
    end;
  if pos('date',header)<>0 then
    begin
    ptra:=1;
    ptrt:=ptrt+12;
    ptrd:=ptrd+12;
    end;
  if pos('size',header)<>0 then
    begin
    ptrs:=1;
    ptrt:=ptrt+11;
    ptra:=ptra+11;
    ptrd:=ptrd+11;
    end;
  {Main search engine call}
  if not all then begin
    if fileonly then filesearch
    else search;
    end
  else begin {* as searchstring}
    repeat gets(s);
    filter(s);
    until eof(db);
  end;
  if total=0 then total:=count
  else total:=total+count;
  if total<>1 then writeln(con,total,' matches found')
  else writeln(con,'1 match found');
  close(db);
  close(con);
  if fileout then close(output);
  end;
end.
