{
  DirTotal lister v1.4 by Jaakko Kauramki (c) 1997-2000

  Comments, questions? Send them to jok@iobox.com

NEW:

  1.4   New command-line option "/s[bytes]" to force allocation unit size.
        Useful for Fat32 drives (don't know how to detect them easily!)
        If somebody knows a good, convenient way, mail me!
        Also added some bug-fixes.. [8.5.2000]
  1.3   A brand new update for a long, LONG time
        Support for BIG total sizes (over 2147483647 bytes..)
        But 'coz I'm lazy, I don't care making support for FILES over
        that size  [4.4.2000]
  1.21  *Very* little changes in screen output
  1.2   Win95 long file name support
  1.1   Support for file names (-f)
  1.0   Initial release

}
{$M 30000,128000,655360}
uses dos;

type
    plistrec=^listrec;
    listrec=record
                  name:string;
                  prev:plistrec;
                  next:plistrec;
                  end;

    statrec=record
                  count:longint; {how many files - ought to be enough!}
                  size:longint;  {total size }
                  size_bil:longint; {billions..}
                  allocsize:longint; {total allocated size}
                  allocsize_bil:longint {billions..}
                  end;

  lfn_TSearchRec = record
    attr : longint;
    creation : comp;
    lastaccess : comp;
    lastmodification : comp;
    highfilesize : longint;
    lowfilesize : longint;
    reserved : comp;
    name : array[0..259] of char;
    shortname : array[0..13] of char;
    handle : word;
  end;

const
  faReadOnly      =  $01;
  faHidden        =  $02;
  faSysFile       =  $04;
  faVolumeID      =  $08;
  faDirectory     =  $10;
  faArchive       =  $20;
  faAnyFile       =  $3F;

  _BILLION        =  1000000000;

FUNCTION DetectWin :BOOLEAN;  ASSEMBLER;
                {  Routine to determine if Windows is currently running }
ASM
  Mov AX,$4680                          {  Win 3.x Standard check       }
  Int $2F                               {  Call Int 2F                  }
  Cmp AX,0                              {  IF AX = 0 Win in real mode   }
  JNE @EnhancedCheck                    {  If not check for enhanced mode}
  Mov AL,1                              {  Set Result to true           }
  Jmp @Exit                             {  Go to end of routine         }
@EnhancedCheck:                         {  Else check for enhanced mode }
  Mov AX,$1600                          {  Win 3.x Enhanced check       }
  Int $2F                               {  Call Int 2F                  }
  Cmp AL,0                              {  Check returned value         }
  Je @False                             {  If not one of the below it   }
  Cmp AL,$80                            {  is NOT installed             }
  Je @False
  Mov AL,1                              {  Nope it must BE INSTALLED    }
  Jmp @Exit
@False:
  Mov AL,0                              {  Set Result to False          }
@Exit:
END;{Win3X}

FUNCTION WinVer :WORD;  ASSEMBLER;
                {  Returns a word containing the version of Win Running }
                {  Should only be used after checking for Win installed }
                {  Or value returned will be meaning less               }
ASM
  Mov AX,$1600                     {    Enhanced mode check             }
  Int $2F                          {    Call Int 2F                     }
END;{WinVer}

function lfn_findfirst(filespec:string;attr:word;var S:lfn_TSearchRec):integer;
begin
  filespec := filespec + #0;
  S.attr := attr;
  asm
    push ds
    push ss
    pop ds
    lea dx,filespec+1
    les di,S
    mov ax,$714e
    mov cx,attr
    mov si,0
    int $21
    les di,S
    mov word ptr es:[di+lfn_TSearchRec.handle], ax
    jc @1
    xor ax,ax
  @1:
    mov @result,ax
    pop ds
  end;
end;


function lfn_FindNext(var S:lfn_TSearchRec):integer;
begin
  asm
    mov ax,$714f
    mov si,0
    les di,S
    mov bx,word ptr es:[di+lfn_TSearchRec.Handle]
    int $21
    jc @1
    xor ax,ax
  @1:
    mov @result,ax
  end;
end;

function lfn_FindClose(var S:lfn_TSearchRec):integer;
begin
  asm
    mov ax,$71a1
    les di,S
    mov bx,word ptr es:[di+lfn_TSearchRec.Handle]
    int $21
    jc @1
    xor ax,ax
  @1:
    mov @result,ax
  end;
end;

function chr2str(ch:pointer):string;
var c_str:string;
    i:integer;
begin;
  c_str:='';
  i:=0;
  while (mem[seg(ch^):ofs(ch^)+i]<>0) do begin
    c_str:=c_str+chr(mem[seg(ch^):ofs(ch^)+i]);
    inc(i);
  end;

  chr2str:=c_str;
end;

function clean_lfn_dir(dir:string):string;
var dir1,dir2,orig_dir,shortname:string;
    i,j,k:word;
    lfn_dirinfo:lfn_tsearchrec;
begin

    orig_dir:=dir;
    dir2:=dir;
    i:=0;
    while pos('\',dir2)>0 do begin
      dir2:=copy(dir2,pos('\',dir2)+1,ord(dir2[0]));
      inc(i);
    end;
    k:=i; {'\' -merkkien mr}
    dir1:=copy(orig_dir,1,pos('\',orig_dir));
    dir2:=copy(orig_dir,pos('\',orig_dir)+1,ord(orig_dir[0]));
    if k>1 then dir2:=copy(dir2,1,pos('\',dir2)-1);

    if dir1<>'' then
      repeat
        lfn_findfirst(dir1+dir2,anyfile,lfn_dirinfo);
        if lfn_dirinfo.shortname[0]<>#0 then
          shortname:=chr2str(addr(lfn_dirinfo.shortname))
        else
          shortname:=chr2str(addr(lfn_dirinfo.name));
        lfn_findclose(lfn_dirinfo);
        dir2:=shortname;
        dir1:=dir1+shortname+'\';
        dec(i);
        dir2:=orig_dir;
        if i>0 then begin
          for j:=1 to (k-i+1) do begin
            dir2:=copy(dir2,pos('\',dir2)+1,ord(dir2[0]));
            if dir2[ord(dir2[0])]='\' then
              dir2[0]:=chr(ord(dir2[0]));
          end;
          dir2:=dir2+'\';
          dir2:=copy(dir2,1,pos('\',dir2)-1);
        end;
      until i=0
    else dir1:=orig_dir;

  if dir1[ord(dir1[0])]='\' then dir1[0]:=chr(ord(dir1[0])-1);
  clean_lfn_dir:=dir1;
end;

var
   _allocsize:word;

   head,tail,prev,curr:plistrec;
   list:listrec;

   win95:boolean;


function stringcomp(s1,s2:string):integer;
{strcomp tavallisille stringeille, vaatii strings-unitin}
var i:word;
    comp_pos,comp_len:word;
    comp_ok:boolean;
begin
{  for i:=1 to ord(s1[0]) do
    p1[i-1]:=(s1[i]);
  p1[ord(s1[0])]:=chr(0);
  for i:=1 to ord(s2[0]) do
    p2[i-1]:=(s2[i]);
  p1[ord(s1[0])]:=chr(0);
  stringcomp:=strcomp(p1,p2);}
  if ord(s1[0])>ord(s2[0]) then comp_len:=ord(s2[0]) else comp_len:=ord(s1[0]);

  comp_ok:=false; comp_pos:=0;

  while not comp_ok do begin
    if comp_pos=comp_len then
      if ord(s1[0])=ord(s2[0]) then begin
        stringcomp:=0;
        comp_ok:=true;
      end else if ord(s1[0])<ord(s2[0]) then begin
        stringcomp:=-1;
        comp_ok:=true;
      end else begin
        stringcomp:=1;
        comp_ok:=true;
      end;
    inc(comp_pos);
    if not comp_ok then
      if upcase(s1[comp_pos])>upcase(s2[comp_pos]) then begin
        stringcomp:=1;
        comp_ok:=true;
      end else if upcase(s1[comp_pos])<upcase(s2[comp_pos]) then begin
        stringcomp:=-1;
        comp_ok:=true;
      end;
  end;
end;


function cleanupnum(num,num_bil:longint):string;
{muuttaa luvut siistimpn muotoon, esim. 12345678 -> 12 345 678}
var decstr:string;
    num2:longint;
    p:word;

begin
  num2:=num;
  decstr:='';
  p:=0;

  repeat
   decstr:=chr(ord('0')+abs(num2 mod 10))+decstr;
   num2:=num2 div 10;
   inc(p);
   if p mod 3=0 then decstr:=' '+decstr;
  until num2=0;

  if num_bil>0 then begin
    if p<9 then
      repeat
       decstr:=chr(ord('0'))+decstr;
       inc(p);
       if p mod 3=0 then decstr:=' '+decstr;
      until p=9;

    num2:=num_bil;

    p:=0;
    repeat
     decstr:=chr(ord('0')+abs(num2 mod 10))+decstr;
     num2:=num2 div 10;
     inc(p);
     if p mod 3=0 then decstr:=' '+decstr;
    until num2=0;
  end;

{  if num<0 then decstr:='-'+decstr;}
{ decstr:='';
  str(num2,decstr);}
  cleanupnum:=decstr;
end;




procedure initlist;
begin
     head:=nil;
     tail:=nil;
     prev:=nil;
     curr:=nil;
end;

procedure addlist(str:string);
begin
  if memavail<sizeof(listrec) then exit;
  getmem(curr,sizeof(listrec));
  if(head=nil) then begin
    curr^.name:=str;
    curr^.next:=nil;
    head:=curr;
    tail:=curr;
  end else begin
    prev:=tail;
    curr^.name:=str;
    prev^.next:=curr;
    curr^.next:=nil;
    curr^.prev:=prev;
    tail:=curr;
  end;
end;

procedure showlist;
begin
  curr:=head;
  while curr<>nil do begin
    writeln(curr^.name);
    curr:=curr^.next;
  end;
end;

procedure deletelist;
begin
  while head<>nil do begin
    curr:=head^.next;
    freemem(head,sizeof(listrec));
    head:=curr;
{    head^.prev:=nil;}
  end;
(*  repeat
    curr:=head^.next;
    freemem(head,sizeof(listrec));
    head:=curr;
 until head=nil;*)
end;

procedure sortlist;
procedure swapnodes(a,b:plistrec);
var s:string;
begin
  s:=a^.name;
  a^.name:=b^.name;
  b^.name:=s;
end;

var curr1,curr2:plistrec;
    isgreater:integer;
begin
  curr1:=head;
  if curr1=nil then exit;
  while (curr1^.next<>nil) do  begin
    curr2:=head;
    while (curr2^.next<>nil) do begin
      isgreater:=stringcomp(curr2^.name,curr2^.next^.name);
      if isgreater>0 then swapnodes(curr2,curr2^.next);
      curr2:=curr2^.next;
    end;
    curr1:=curr1^.next;
  end;
end;

function allocsize(size:longint):longint;
begin
  if size mod _allocsize=0 then
    allocsize:=size
  else
    allocsize:=size-size mod _allocsize+_allocsize;
end;

procedure subdirtotal(subdirname,filespec:string;var subtotal:statrec);
var r1,r2:statrec;
    s_r:searchrec;
begin
  fillchar(r1,sizeof(r1),0);
  fillchar(r2,sizeof(r2),0);
  findfirst(subdirname+'\*.*',anyfile-volumeid,s_r);
  while doserror=0 do begin
    if s_r.attr and directory<>0 then
      if (s_r.name<>'.') and (s_r.name<>'..') then begin
        subdirtotal(subdirname+'\'+s_r.name,filespec,r2);
        inc(r1.size,r2.size);
        if r1.size>=_BILLION then begin
          inc(r1.size_bil);
          dec(r1.size,_BILLION);
        end;
        inc(r1.allocsize,r2.allocsize);
        if r1.allocsize>=_BILLION then begin
          inc(r1.allocsize_bil);
          dec(r1.allocsize,_BILLION);
        end;
        inc(r1.count,r2.count);
      end;
    findnext(s_r);
  end;
  findfirst(subdirname+'\'+filespec,anyfile-volumeid-directory,s_r);
  while doserror=0 do begin
    inc(r1.size,s_r.size);
    if r1.size>=_BILLION then begin
      inc(r1.size_bil);
      dec(r1.size,_BILLION);
    end;
    inc(r1.allocsize,allocsize(s_r.size));
    if r1.allocsize>=_BILLION then begin
      inc(r1.allocsize_bil);
      dec(r1.allocsize,_BILLION);
    end;
    inc(r1.count);
    findnext(s_r);
  end;
  subtotal:=r1;
end;

var drv_char:char;
    drive,maindir,maindir2,maindir3,maindir4:string;
    dirinfo:searchrec;
    lfn_dirinfo:lfn_Tsearchrec;
    total,current,current_dir,subdir:statrec;
    params:word;
    i,j,k:word;
    current_param,f_spec,shortname,alloc_s:string;
    alloc_code:integer;
    no_total,only_total,show_alloc,allocsize_specified:boolean;

procedure printstatistics(name:string;stat:statrec);
begin
  write(name,'':13-ord(name[0]),' : ',cleanupnum(stat.size,stat.size_bil):14,' bytes in ',
        cleanupnum(stat.count,0):6,' files ');
  if show_alloc then writeln('(',cleanupnum(stat.allocsize,stat.allocsize_bil):14,' allocated)') else writeln;
end;

procedure lfn_printstatistics(name:string;stat:statrec);
var p_name:string;
begin
  p_name:=name;
  if ord(p_name[0])>19 then begin
    p_name[0]:=chr(19);
    p_name[19]:=#16;
  end;
  write(p_name,'':19-ord(p_name[0]),':',cleanupnum(stat.size,stat.size_bil):13,' bytes in ',
        cleanupnum(stat.count,0):6,' files ');
  if show_alloc then writeln(cleanupnum(stat.allocsize,stat.allocsize_bil):13,' allocated') else writeln;
end;


begin
  params:=paramcount;
  only_total:=false; no_total:=false; show_alloc:=true; f_spec:='*.*'; maindir:='.';
  allocsize_specified:=false;
  i:=0;
  if DetectWin then
    if lo(WinVer)=4 then {onko windows95 taustalla}
      win95:=true
    else
      win95:=false;
  while params>0 do begin
    inc(i);
    current_param:=paramstr(i);
    if current_param[1]='"' then
      if (current_param[ord(current_param[0])]<>'"') and (params>1) then
        repeat
          if i<paramcount then begin
            current_param:=current_param+' '+paramstr(i+1);
            dec(params);
            inc(i);
          end;
        until (current_param[ord(current_param[0])]='"') or (i>=paramcount);
    if (current_param[1]='-') or (current_param[1]='/') then begin
       dec(params);
       case upcase(current_param[2]) of
            '?':begin
                     writeln('DirTotal v1.4 by Jaakko Kauramki (c) 1997-2000');
                     writeln('Displays total size of dir + subdirs');
                     writeln('   /n        Don''t display totals');
                     writeln('   /t        Only total');
                     writeln('   /a        Don''t display allocated size');
                     writeln('   /nolfn    Disable long filenames (win95)');
                     writeln('   /f[files] List only specified files');
                     writeln('   /s[bytes] Specify allocation unit size in bytes');
                     writeln('             Use "/s4096" for Fat32 drives');
                     writeln('             Note: allocation unit size has to be a multiply of 512');
                     writeln('             (512, 1024, 2048, 4096, ...)');
                     writeln('   /?        Display help text (this! =)');
                     halt(1);
                end;

            'N':begin
                  if upcase(current_param[3])<>'O' then
                    no_total:=true
                  else
                    if upcase(current_param[4])='L' then
                      if upcase(current_param[5])='F' then
                        if upcase(current_param[6])='N' then
                          win95:=false;
                end;
            'T':only_total:=true;
            'A':show_alloc:=false;
            'F':f_spec:=copy(current_param,3,ord(current_param[0])-2);
            'S':begin
                  allocsize_specified:=true;
                  alloc_s:=copy(current_param,3,ord(current_param[0])-2);
                  val(alloc_s,_allocsize,alloc_code);
                  if alloc_code<>0 then begin
                    writeln('invalid allocation unit size ',alloc_s);
                    halt(3);
                  end;
                end;
       else begin
                 writeln('invalid option ',current_param);
                 writeln('use dt -? for help');
                 halt(2);
            end;
       end;
    end else begin
      maindir:=current_param;
      dec(params);
    end;
  end;


  if maindir='.' then begin
    asm
      push ds
      mov al,0
      mov ah,19h
      int 21h
      add al,'A'
      pop ds
      mov drv_char,al
    end;
  end else begin
{ottaa lainausmerkit pois tiedostonimest (win95)}
{    if win95 then begin}
      if maindir[ord(maindir[0])]='"' then maindir[0]:=chr(ord(maindir[0])-1);
      if maindir[1]='"' then maindir:=copy(maindir,2,ord(maindir[0])-1);
{    end;}
{repii viimeisen '\':n pois}
    if maindir[ord(maindir[0])]='\' then maindir[0]:=chr(ord(maindir[0])-1);
    if maindir[2]<>':' then begin {parametrin EI asema+hakemisto}
      asm
         push ds
         mov al,0
         mov ah,19h
         int 21h
         add al,'A'
         pop ds
         mov drv_char,al
      end;
      drive:=drv_char+':\';
    end else begin
      drv_char:=upcase(maindir[1]);
      drive:=drv_char+':\';
    end;
  end;

  if allocsize_specified=false then begin
    asm
       push ds
       mov al,0
       mov ah,1ch
       mov dl,drv_char
       sub dl,'A'
       inc dl
       int 21h
       mov ah,0
       mul cx
       pop ds
       mov _allocsize,ax
    end;
  end;

  if _allocsize=0 then begin
    writeln('*NOTE* Problem with allocation unit size of 0');
    writeln('Using allocation unit size of 4096..');
    _allocsize:=4096;
  end;

{quick'n'dirty fat32-tunnistus.. jos fat32, _allocsize 4096}
{  if IsFat32Drive(drv_char) then _allocsize:=4096;}



{muuttaa maindir:n pitkt tiedostonimet lyhyiksi}
  if maindir<>'.' then
    if win95 then
      maindir:=clean_lfn_dir(maindir);

  initlist;
  fillchar(total,sizeof(total),0);
  if win95 then begin
    lfn_findfirst(maindir+'\*.*',anyfile-volumeid,lfn_dirinfo);
    while doserror=0 do begin
      if lfn_dirinfo.attr and directory<>0 then
        if (chr2str(addr(lfn_dirinfo.name))<>'.') and (chr2str(addr(lfn_dirinfo.name))<>'..') then
          addlist(chr2str(addr(lfn_dirinfo.name)));
      doserror:=lfn_findnext(lfn_dirinfo)
    end;
    lfn_findclose(lfn_dirinfo);
  end else begin
    findfirst(maindir+'\*.*',anyfile-volumeid,dirinfo);
    while doserror=0 do begin
      if dirinfo.attr and directory<>0 then
        if (dirinfo.name<>'.') and (dirinfo.name<>'..') then
          addlist(dirinfo.name);
      findnext(dirinfo);
    end;
  end;

{maindir:st lytyvt tiedostot}
  findfirst(maindir+'\'+f_spec,anyfile-volumeid-directory,dirinfo);
  while doserror=0 do begin
    inc(total.size,dirinfo.size);
    if total.size>=_BILLION then begin
      inc(total.size_bil);
      dec(total.size,_BILLION);
    end;
    inc(total.allocsize,allocsize(dirinfo.size));
    if total.allocsize>=_BILLION then begin
      inc(total.allocsize_bil);
      dec(total.allocsize,_BILLION);
    end;
    inc(total.count);
    findnext(dirinfo);
  end;

  current_dir:=total; {thn menness saadut tiedot}
  sortlist; {hakemistot aakkosjrjestykseen}

  curr:=head;
  while curr<>nil do begin
    fillchar(subdir,sizeof(subdir),0);
    if win95 then begin
      lfn_findfirst(maindir+'\'+curr^.name,anyfile,lfn_dirinfo);
      if lfn_dirinfo.shortname[0]<>#0 then
        shortname:=chr2str(addr(lfn_dirinfo.shortname))
      else
        shortname:=chr2str(addr(lfn_dirinfo.name));
      subdirtotal(maindir+'\'+shortname,f_spec,subdir);
      lfn_findclose(lfn_dirinfo);
      if only_total=false then lfn_printstatistics(curr^.name,subdir);
    end else begin
      subdirtotal(maindir+'\'+curr^.name,f_spec,subdir);
      if only_total=false then printstatistics(curr^.name,subdir);
    end;
    inc(total.size,subdir.size);
    inc(total.size_bil,subdir.size_bil);
    if total.size>=_BILLION then begin
      inc(total.size_bil);
      dec(total.size,_BILLION);
    end;
    inc(total.allocsize,subdir.allocsize);
    inc(total.allocsize_bil,subdir.allocsize_bil);
    if total.allocsize>=_BILLION then begin
      inc(total.allocsize_bil);
      dec(total.allocsize,_BILLION);
    end;
    inc(total.count,subdir.count);
    curr:=curr^.next;
  end;
  if only_total=false then
    if win95 then
      lfn_printstatistics('.',current_dir)
    else
      printstatistics('.',current_dir);
  deletelist;

  if no_total=false then begin
    if only_total=false then begin
      write('----------------------------------------------------');
      if show_alloc=true then writeln('---------------------------') else writeln;
    end;
    if win95 then
      lfn_printstatistics('Total',total)
    else
      printstatistics('Total',total);
  end;
{  writeln('Filespec: ',f_spec);}
end.
