
typedef struct
{
   char far *title;           /*  Structure object for creating a window  */
   long title_len;
   long ysize;
   long xsize;
   long sysmem;
   long stack;
   long task_stat;
   long jmp_addr;
} PARMS;

typedef struct
{
   long size;
   void far *addr;
} READ_REC;

#define  OBJECT   void far

#define  WINDOW            0           /*  Used to identify object we're  */
#define  MY_WINDOW         1                              /*  talking to  */
#define  MAILBOX           2
#define  MY_MAILBOX        3
#define  KEYBOARD          4
#define  MY_KEYBOARD       5
#define  OBJECTQ           6
#define  MY_OBJECTQ        7

#define  MAKE_WINDOW       8                  /*  Used in dv_createobj()  */
#define  MAKE_MAILBOX      9
#define  MAKE_KEYBOARD     10
#define  MAKE_TIMER        11
#define  MAKE_POINTER      15
#define  MAKE_PANEL        16

#define  IS_WINDOW         8           /*  Used to identify return value  */
#define  IS_MAILBOX        9                      /*  from  dv_objtype()  */
#define  IS_KEYBOARD       10
#define  IS_TIMER          11
#define  IS_POINTER        15
#define  IS_PANEL          16

#define  GENERIC           0               /*  Generic handle identifier  */

#define  OFF               0
#define  ON               ! OFF

#define  AVAILABLE_MEM     1        /*  Used to get 1 of 3 memory values  */
#define  LARGEST_MEM       2
#define  TOTAL_MEM         3

#define  KMOUSE_STAT       0
#define  KMOUSE_ON         1           /*  Keyboard mouse flags, returns  */
#define  KMOUSE_OFF        2
#define  IS_REALMOUSE      0
#define  IS_KMOUSE         1

#define  OFF_HCURRENT      0        /*  Used as flags for dv_offsetwin()  */
#define  OFF_HCENTER       1
#define  OFF_HLEFT         2
#define  OFF_HRIGHT        3
#define  OFF_VCURRENT      0
#define  OFF_VCENTER       4
#define  OFF_VTOP          8
#define  OFF_VBOTTOM       12

void far * far dv_gethandle( int type, void far *handle );
void far * far dv_createobj( int type, PARMS far *parms );
void far * far dv_newwindow( int ysize, int xsize, void far *handle );
void far *dv_loadpif( char *fname );
void far dv_freeobj( int type, void far *handle );
void far dv_writewindow( char far *string, int len, void far *handle );
void far dv_redraw( void far *handle );
void dv_visible( int flag, void far *handle );
void dv_color( int color, void far *handle );
void dv_cls( void far *handle );
void dv_poswindow( int ypos, int xpos, void far *handle );
void dv_setcursorpos( int ypos, int xpos, void far *handle );
void far dv_setpointerpos( int ypos, int xpos, void far *pointer );
void dv_resize( int ysize, int xsize, void far *handle );
void dv_border( int flag, void far *handle );
void dv_rename( char *name, void far *handle );
void far dv_putswindow( char far *str, int len, void far *handle );
void dv_attach( int flag, void far *handle );
void dv_offsetwin( void far *parent, void far *child, int flags,
		   int yoff, int xoff );
void dv_hmove( int flag, void far *handle );
void dv_vmove( int flag, void far *handle );
void dv_hsize( int flag, void far *handle );
void dv_vsize( int flag, void far *handle );
void dv_hscroll( int flag, void far *handle );
void dv_vscroll( int flag, void far *handle );

void dv_letclose( int flag, void far *handle );
void dv_lethide( int flag, void far *handle );
void dv_letquit( int flag, void far *handle );
void dv_letopen( int flag, void far *handle );
void dv_letswitch( int flag, void far *handle );
void dv_letdvmenu( int flag, void far *handle );

int dv_getwindowypos( void far *handle );
int dv_getwindowxpos( void far *handle );
int dv_getwindowysize( void far *handle );
int dv_getwindowxsize( void far *handle );
int dv_getcursorypos( void far *handle );
int dv_getcursorxpos( void far *handle );
int dv_getcolor( void far *handle );
int dv_getvideomode( void far *handle );

int dv_isvisible( void far *handle );
int dv_isframed( void far *handle );

int dv_appnum( void );

int dv_installed( void );

unsigned dv_common( int flag );
unsigned dv_conventional( int flag );
unsigned dv_expanded( int flag );

int dv_objtype( void far *object );
int dv_isobj( void far *object );
void far *dv_locate( int ypos, int xpos, void far *start );

void dv_pause( void );
void dv_critical( void );
void dv_criticend( void );

void dv_sound( unsigned freq, unsigned duration );

int dv_kmouse( int flag );


int far dv_objsize( int type, void far *handle );
void far dv_openobj( int type, void far *handle1, char far *pname,
		     void far *handle2 );
void far dv_seticon( int icon_ch, void far *handle );
void far dv_read( void far *handle, READ_REC far *rec );
int far dv_status( void far *handle );
void dv_ptrstat( int *ypos, int *xpos, int *button, void far *pointer );

void far *dv_alloc( unsigned bytes );
void dv_free( void far *mem );
void dv_pushkey( int chr, int scan );
void dv_extensions( void );
void dv_justify( int flag );
unsigned dv_apilevel( int major, int minor );
char far *dv_virscrn( void far *handle );
int far dv_erase( void far *handle );

void dv_setminsize( int ysize, int xsize, void far *handle );
void dv_setmaxsize( int ysize, int xsize, void far *handle );

