;************************************************************************
;*									*
;*	DV-GLUE		DESQview and DESQview/X Function Library	*
;*			(c) Copyright 1992 Ralf Brown			*
;*			All Rights Reserved.				*
;*									*
;*	File FLDBUILD.ASM	Build a field table definition stream	*
;*									*
;************************************************************************
;LastEdit: 12/20/92

	INCLUDE API.INC
	MIN_VERSION 2,00

	Header@

;========================================================================

CSeg@

;------------------------------------------------------------------------

PubProc@ DVFLD_BUILD_HEADER,__PASCAL__
@num_flds = word ptr [bp+SendOverhead+6]
@scrn_type = word ptr [bp+SendOverhead+4]
@curr_attr = word ptr [bp+SendOverhead+2]
@sel_attr = word ptr [bp+SendOverhead]
	@EnterSend
	push	si
	mov	ax,@num_flds
	mov	bx,size FT_ENTRY+5
	mul	bx
	add	ax,size FT_HEADER+6
	mov	si,ax			; remember length of stream
	add	ax,4			; add stream header
	ALLOC_MEM			; allocate AX bytes
	mov	di,ax
IF LDATA
	mov	es,dx
	or	ax,dx
ELSE
	push	ds
	pop	es
	or	ax,ax
ENDIF
	jz	build_header_done
	push	di
	cld
	mov	ax,001Bh		; this is a window stream
	stosw
	mov	ax,si			; AX <- stream length
	stosw
	mov	ax,10E5h		; force field table entries to be 8 bytes
	stosw
	mov	al,0FFh
	mov	ah,byte ptr @num_flds
	stosw
	mov	al,byte ptr @scrn_type
	stosb
	xor	ax,ax
	stosw
	mov	al,byte ptr @curr_attr
	mov	ah,byte ptr @sel_attr
	stosw
	mov	ax,@num_flds
	mov	bx,size FT_ENTRY
	mul	bx
	add	di,ax			; skip field table entries
	xor	cx,cx			; COUNT = 0
build_header_loop:
	inc	cx
	mov	al,0F0h			; clear field to blanks
	mov	ah,cl
	stosw
	mov	al,0F2h			; set color of field
	stosw
	mov	al,byte ptr @curr_attr
	stosb
	cmp	cx,@num_flds
	jb	build_header_loop
	mov	ax,01F4h		; move cursor to first field
	stosw
	mov	al,0FEh			; WS_FLDRESET
	stosb
	pop	ax			; get back offset of stream
IF LDATA
	mov	dx,es
ENDIF
build_header_done:
	pop	si
	@ExitSend 8
EndProc@ DVFLD_BUILD_HEADER,__PASCAL__

;------------------------------------------------------------------------

PubProc@ DVFLD_BUILD_ENTRY,__PASCAL__
@stream = DPTR_ [bp+20+cPtrSize]
@field = word ptr [bp+18+cPtrSize]
@ulrow = word ptr [bp+16+cPtrSize]
@ulcol = word ptr [bp+14+cPtrSize]
@lrrow = word ptr [bp+12+cPtrSize]
@lrcol = word ptr [bp+10+cPtrSize]
@type = word ptr [bp+8+cPtrSize]
@modifier = word ptr [bp+6+cPtrSize]
@color = word ptr [bp+4+cPtrSize]
@key2 = word ptr [bp+2+cPtrSize]
	push	bp
	mov	bp,sp
	push	es
	push	di
	LES_	di,@stream
IF LDATA eq 0
	push	ds
	pop	es
ENDIF
	add	di,7			; skip stream header and opcode
	mov	ax,@field
	cmp	ax,1
	jb	build_entry_done
	cmp	al,ES_[di+1]
	ja	build_entry_done
	dec	ax			; AX <- field-1
	mov	bx,size FT_ENTRY
	mul	bx
	add	ax,size FT_HEADER
	add	di,ax			; skip to appropriate field entry
	cld				; ensure proper direction for string store
	mov	al,byte ptr @ulrow
	mov	ah,byte ptr @ulcol
	stosw
	mov	al,byte ptr @lrrow
	mov	ah,byte ptr @lrcol
	stosw
	mov	al,byte ptr @type
	mov	ah,byte ptr @modifier
	stosw
	mov	al,byte ptr @color
	mov	ah,byte ptr @key2
	stosw
build_entry_done:
	pop	di
	pop	es
	pop	bp
	ret	18+dPtrSize
EndProc@ DVFLD_BUILD_ENTRY,__PASCAL__

;------------------------------------------------------------------------

PubProc@ DVFLD_BUILD_COLOR,__PASCAL__
@stream = DPTR_ [bp+6+cPtrSize]
@field = word ptr [bp+4+cPtrSize]
@attr = word ptr [bp+2+cPtrSize]
	push	bp
	mov	bp,sp
	push	es
	push	di
	LES_	di,@stream
IF LDATA eq 0
	push	ds
	pop	es
ENDIF
	add	di,7			; skip stream header and opcode
	mov	cx,@field
	cmp	cx,1
	jb	build_color_done
	mov	al,ES_[di+1]
	cmp	cl,al
	ja	build_color_done
	mov	ah,size FT_ENTRY
	mul	ah
	add	ax,size FT_ENTRY
	add	di,ax
	mov	al,5
	mul	cl			; 5*field
	dec	ax			; 5*field-1
	add	di,ax
	mov	ES_[di],al		; set attr to which field is set by strm
build_color_done:
	pop	di
	pop	es
	pop	bp
	ret	4+dPtrSize
EndProc@ DVFLD_BUILD_COLOR,__PASCAL__

;------------------------------------------------------------------------

PubProc@ DVFLD_BUILD_CURSOR,__PASCAL__
@stream = DPTR_ [bp+4+cPtrSize]
@field = word ptr [bp+2+cPtrSize]
	push	bp
	mov	bp,sp
	push	es
	push	di
	LES_	di,@stream
IF LDATA eq 0
	push	ds
	pop	es
ENDIF
	mov	ax,@field
	cmp	ax,1
	jb	build_cursor_done
	cmp	al,ES_[di+8]
	ja	build_cursor_done
	mov	bx,ES_[di+2]		; get stream size
	add	bx,4 - 2		; next-to-last byte of stream
	mov	ES_[di+bx],al		; set fld to which stream positions cursor
build_cursor_done:
	pop	bp
	ret	2+dPtrSize
EndProc@ DVFLD_BUILD_CURSOR,__PASCAL__

;------------------------------------------------------------------------

CSegEnd@

	END
