/****************************************************************
*
*  Name:          HELLO
*
*  Function:      display "hello world" in the task window
*
*  Shows how to:  1. write a "minimal" DESQview-specific program.
*                 2. initialize and disable the C interfaces.
*                 3. detect DESQview's presence.
*                 4. enable DESQview extensions.
*                 5. write to the default task window.
*
****************************************************************/

#include <stdio.h>
#include "dvapi.h"

/* minimum API version required */
#define required 0x201

/* actual API version */
int  version;


/**********************************************************************
*  main  -  check for DESQview present and enable required extensions.
***********************************************************************/

main () {
  /* initialize C interfaces and get API version number */
  version = api_init();

  /* if DESQview is not running or version is too low, display a message */ 
  if (version < required) {
    printf ("This program requires DESQview version %d.02%d or later.\n",
             required/256,required%256);
    }

  /* tell DESQview what extensions to enable */
  else {
    api_level (required);

    /* extend greetings */
    win_printf (win_me(),"hello world\n");
    }

  /* disable C interfaces and return from program */
  api_exit();
  }

















