(* ******************************************************************** *)
(* HexCom - Load a HEX (Hex dump file) and makes it a COM file.         *)
(* Author - Victor Lee , Queen's University, Kingston, Ontario, CANADA  *)
(*                       Network id -  VIC at QUCDN                     *)
(* Date   - 1986 Feb 12                                                 *)
(* Note :   See ComHex to convert  COM file into HEX file.              *)
(* ******************************************************************** *)
Program HexCom ;
type  blocks = array [1..128] of char ;
      S2 = string[2] ;
 var
    i : byte ;
    ComName,HexName : string[14] ;
    FN    : string[8] ;
    REC   : string[64] ;
    abyte : byte ;
    Afile : file of byte ;
    Bfile : Text ;
   count,Rcount : integer ;
label  exit ;

 function HexNum(char1,char2:char) : byte ;
 var Hi,Low :byte ;
      tempbyte : byte ;
    begin (* hex *)
    Hi := ord(char1) ;
    Low := ord(char2);
    If Hi > $40 then Hi := Hi + 9 ;
    Hi := Hi shl 4 ;
    If Low> $40 then Low:= Low + 9 ;
    Low := Low and $0F ;
    hexNum := Hi + Low ;
    end;

    Begin (* Com Load *)
    Writeln('Enter Name of HEX File to Load into COM file ');
    Readln(FN);
    ComName := FN + '.COM' ;
    HexName := FN + '.HEX' ;
    Assign (Afile,ComName);
    Assign (Bfile,HexName);
    Reset(Bfile);
    Rewrite(Afile);
    count := 0 ;
    Rcount := 0 ;
    Writeln('Converting File: ',HexName,' file size =',FileSize(Afile));
    Write(' 64 byte record makes 32 bytes .  Record count = ');
    While Not Eof(Bfile) Do
      Begin (* read  a record *)
      Readln(Bfile,Rec) ;
      writeln('rec=',Rec);
      i := 1 ;
      While i < length(Rec) do
         Begin (* load file *)
         abyte := HexNum(Rec[i],Rec[i+1]) ;
         i := i + 2 ;
         write(Afile,abyte);
         count := count + 1 ;
         End;
      Rcount := Rcount + 1 ;
      Write(RCount ,'  ');
      End ; (* read a record  *)
  exit :
   Close(Afile) ;
   Writeln('Number of 64 byte records read =',Rcount +1);
   Writeln('New file ',ComName,' created.  File size is ',count);
   End. (* Com Load *)
