/* -*- Mode: C -*- */
/* PTree.cc - PTree implementation code
 * Created by Robert Heller on Thu Feb 27 20:34:01 1992
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Common Class library implementation code
 * ------------------------------------------------------------------
 * Modification History:
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 * 
 * Copyright (c) 1991,1992 by Robert heller (D/B/A Deepwoods Software)
 *        All Rights Reserved
 * 
 */

#include <PTree.h>
#ifdef MYSTORAGE
int Node::numblocks;	// current number of allocated blocks
Node* Node::blocks[maxblocks]; // allocated nodes
Node* Node::freelist;	// linked list of available nodes

int Tree::numblocks;	// current number of allocated blocks
Tree* Tree::blocks[maxblocks]; // allocated trees
Tree* Tree::freelist;	// linked list of available trees
#endif
// default prototypical tree and node
Tree defTree;
Node defNode;

#ifdef MYSTORAGE
// Helper function to allocate an additional block of 100 Nodes
void Node::moreblocks ()
{
	// Have we run out of blocks?
	if (numblocks < maxblocks) {
		// if not...  bump block counter
		int iblock = numblocks++;
		// snarf some memory
		Node* p = blocks[iblock] = (Node*) new char[sizeof(Node)*blocksize];
		// build linked list.  value field doubles as next pointer.
		for (int ic = 1; ic < blocksize; ic++) {
			p->value._string = (char*) (p+1);
			p++;
		}
		// point last tail at current freelist
		p->value._string = (char*) freelist;
		// and set freelist head to first Node in fresh block
		freelist = blocks[iblock];
	}
}
			
// Helper function to allocate an additional block of 100 Trees
void Tree::moreblocks ()
{
	// Have we run out of blocks?
	if (numblocks < maxblocks) {
		// if not...  bump block counter
		int iblock = numblocks++;
		// snarf some memory
		Tree* p = blocks[iblock] = (Tree*) new char[sizeof(Tree)*blocksize];
		// build linked list.  left field doubles as next pointer.
		for (int ic = 1; ic < blocksize; ic++) {
			p->left = (Node*) (p+1);
			p++;
		}
		// point last tail at current freelist
		p->left = (Node*) freelist;
		// and set freelist head to first Tree in fresh block
		freelist = blocks[iblock];
	}
}
			
// overloaded new operator for Nodes
void* Node::operator new (long bytes)
{
	// if freelist is empty, get more memory
	if (defNode.freelist == 0) defNode.moreblocks();
	// if freelist is still empty, return null
	if (defNode.freelist == 0) return(0);
	// get pointer to head of list
	Node* newcard = defNode.freelist;
	// set freelist to next card in the list
	defNode.freelist = (Node*) newcard->value._string;
	// unlink new card from the list
	newcard->value._string = 0;
	// retun new card
	return(newcard);
}

// overloaded delete operator for Nodes
void Node::operator delete(void* vptr)
{
	// convert pointer to a Node*
	Node* ptr = (Node*) vptr;
	// if a null pointer, just return
	if (ptr == 0) return;
	// has this Node already be freed?
	for (Node* p = defNode.freelist; p != 0; p = (Node*) p->value._string) {
		if (p == ptr) return;	// if so, don't free it again
	}
	// link onto head of free list
	ptr->value._string = (char*) defNode.freelist;
	defNode.freelist = ptr;
}


// overloaded new operator for Trees
void* Tree::operator new (long bytes)
{
	// if freelist is empty, get more memory
	if (defTree.freelist == 0) defTree.moreblocks();
	// if freelist is still empty, return null
	if (defTree.freelist == 0) return(0);
	// get pointer to head of list
	Tree* newtree = defTree.freelist;
	// set freelist to next Tree in the list
	defTree.freelist = (Tree*) newtree->left;
	// unlink new Tree from the list
	newtree->left = 0;
	// retun new Tree
	return(newtree);
}

// overloaded delete operator for Trees
void Tree::operator delete(void* vptr)
{
	// convert pointer to a Tree*
	Tree* ptr = (Tree*) vptr;
	// if a null pointer, just return
	if (ptr == 0) return;
	// has this Tree already be freed?
	for (Tree* p = defTree.freelist; p != 0; p = (Tree*) p->left) {
		if (p == ptr) return;	// if so, don't free it again
	}
	// link onto head of free list
	ptr->left = (Node*) defTree.freelist;
	defTree.freelist = ptr;
}
#endif



