/* -*- Mode: C -*- */
/* ListStuff.cc - List stuff
 * Created by Robert Heller on Mon Jan 20 00:19:54 1992
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Edit a Librarian Card Catalog file
 * ------------------------------------------------------------------
 * Modification History:
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 * 
 * Copyright (c) 1991,1992 by Robert heller (D/B/A Deepwoods Software)
 *        All Rights Reserved
 * 
 */

#include <iostream.h>
#include <vBTree.h>
#include <ctype.h>
#ifdef MESSYDOS
#include <CardRec.h>
#include <ListRec.h>
#else
#include <CardRecord.h>
#include <ListRecord.h>
#endif
#include <Terminal.h>
#ifdef MESSYDOS
#include <CmdScren.h>
#include <LLScrPmt.h>
#else
#include <CommandScreen.h>
#include <LLScrollPrompt.h>
#endif
#include "EditDefs.h"
#include "EditGlob.h"
#if defined(unix) || defined(MESSYDOS)
#include <stdio.h>
#endif

const Margin = 256;

extern int EditCard1(const Key inkey);

int ListCards()
{
	CoreItem item;
	Key searchkey;
	static char title[80], line[LineLength];
	Term->PromptLine(18,0,"Search prefix: ",searchkey,KeySize);
	sprintf(title,"Ids matching %s",searchkey);
	LLScrollPrompt IdList(title,3,0,80,15,20);
	LineList* llist = (LineList*) 0;
	LineList** ptr = &llist;
	LineList* prev = (LineList*) 0;
	if (Tree->SearchId(searchkey,&item)) {
		do {
			int fill;
			char* p = line;
			strcpy(p,item.key);
			fill = KeySize - strlen(item.key);
			p += strlen(item.key);
			while (fill-- > 0) *p++ = ' ';
			*p++ = ' ';
			{
				CardRecord crec(&item.data);
				strcpy(p,crec->title);
				p += strlen(crec->title);
			}
			*p++ = 0;
			LineList* newline = new LineList(line,0,prev);
			*ptr = newline;
			prev = newline;
			ptr = &newline->nextline;
			//cerr << "*** line = '" << line << "'\n";
		} while (Tree->SearchIdAgain(&item));
		if (llist != (LineList*) 0) {
			if (IdList.Scroll(llist,"Card to edit (RETURN for more, q to exit):",title,KeySize) > 0) 
				EditCard1(title);
			FreeLineList(llist);
		}
		return(-1);
	} else {
		Term->Message("No ids found");
		return(1);
	}
}

int ListCardsFromList(char* title,ListRecord& list)
{
	CoreItem item;
	static Key newkey;
	static char line[LineLength];
	LLScrollPrompt IdList(title,3,0,80,15,20);
	LineList* llist = (LineList*) 0;
	LineList** ptr = &llist;
	LineList* prev = (LineList*) 0;
	int numids = list.ElementCount();
	for (int i = 0; i < numids; i++) {
		if (Tree->SearchId(list[i],&item) && strlen(list[i]) == strlen(item.key)) {
			int fill;
			char* p = line;
			strcpy(p,item.key);
			fill = KeySize - strlen(item.key);
			p += strlen(item.key);
			while (fill-- > 0) *p++ = ' ';
			*p++ = ' ';
			{
				CardRecord crec(&item.data);
				strcpy(p,crec->title);
				p += strlen(crec->title);
			}
			*p++ = 0;
			LineList* newline = new LineList(line,0,prev);
			*ptr = newline;
			prev = newline;
			ptr = &newline->nextline;
		}
	}
	if (llist != (LineList*) 0) {
		if (IdList.Scroll(llist,"Card to edit (RETURN for more, q to exit):",title,KeySize) > 0) 
			EditCard1(title);
		FreeLineList(llist);
	}
	return(-1);
}

int ListTitles()
{
	CoreItem item;
	Key searchkey;
	static char title[80],header[80],line[LineLength];
	Term->PromptLine(18,0,"Search prefix: ",searchkey,KeySize);
	sprintf(title,"Titles matching %s",searchkey);
	LLScrollPrompt TitleList(title,3,0,80,15,20);
	LineList* llist = (LineList*) 0;
	LineList** ptr = &llist;
	LineList* prev = (LineList*) 0;
	int i;
	int refnum = 0;
	if (Tree->SearchTitle(searchkey,&item)) {
		do {
			refnum++;
			sprintf(line,"%3d: %s",refnum,item.key);
			LineList* newline = new LineList(line,0,prev);
			*ptr = newline;
			prev = newline;
			ptr = &newline->nextline;
		} while (Tree->SearchTitleAgain(&item));
		if (llist != (LineList*) 0) {
			if (refnum == 1) {
				if (Tree->SearchTitle(llist->thisline+5,&item)) {
					sprintf(header,"Ids for title %s",item.key);
					ListRecord rec(&item.data);
					if (rec.ElementCount() == 1) EditCard1(rec[0]);
					else if (rec.ElementCount() > 1)
						ListCardsFromList(header,rec);
				}
			} else if (TitleList.Scroll(llist,"Ref#, RETURN for more, q to exit:",title,KeySize) > 0) {
				refnum = atoi(title);
				for (i = 1,prev = llist;
				     prev != (LineList*)0 && i < refnum;
				     prev = prev->nextline,i++) ;
				if (i == refnum) {
					if (Tree->SearchTitle(prev->thisline+5,&item)) {
						sprintf(header,"Ids for title %s",item.key);
						ListRecord rec(&item.data);
						if (rec.ElementCount() == 1) EditCard1(rec[0]);
						else if (rec.ElementCount() > 1)
							ListCardsFromList(header,rec);
					}
				} else Term->Message("Bad reference number");
			}
			FreeLineList(llist);
		}
		return(-1);
	} else {
		Term->Message("No titles found");
		return(1);
	}
}

int ListAuthors()
{
	CoreItem item;
	Key searchkey;
	static char title[80],header[80],line[LineLength];
	Term->PromptLine(18,0,"Search prefix: ",searchkey,KeySize);
	sprintf(title,"Authors matching %s",searchkey);
	LLScrollPrompt AuthorList(title,3,0,80,15,20);
	LineList* llist = (LineList*) 0;
	LineList** ptr = &llist;
	LineList* prev = (LineList*) 0;
	int refnum = 0;
	int i;
	if (Tree->SearchAuthor(searchkey,&item)) {
		do {
			refnum++;
			sprintf(line,"%3d: %s",refnum,item.key);
			LineList* newline = new LineList(line,0,prev);
			*ptr = newline;
			prev = newline;
			ptr = &newline->nextline;
		} while (Tree->SearchAuthorAgain(&item));
		if (llist != (LineList*) 0) {
			if (refnum == 1) {
				if (Tree->SearchAuthor(llist->thisline+5,&item)) {
					sprintf(header,"Ids for author %s",item.key);
					ListRecord rec(&item.data);
					if (rec.ElementCount() == 1) EditCard1(rec[0]);
					else if (rec.ElementCount() > 1)
						ListCardsFromList(header,rec);
				}
			} else if (AuthorList.Scroll(llist,"Ref#, RETURN for more, q to exit:",title,KeySize) > 0) {
				refnum = atoi(title);
				for (i = 1,prev = llist;
				     prev != (LineList*)0 && i < refnum;
				     prev = prev->nextline,i++) ;
				if (i == refnum) {
					if (Tree->SearchAuthor(prev->thisline+5,&item)) {
						sprintf(header,"Ids for author %s",item.key);
						ListRecord rec(&item.data);
						if (rec.ElementCount() == 1) EditCard1(rec[0]);
						else if (rec.ElementCount() > 1)
							ListCardsFromList(header,rec);
					}
				} else Term->Message("Bad reference number");
			}
			FreeLineList(llist);
		}
		return(-1);
	} else {
		Term->Message("No authors found");
		return(1);
	}
}

int ListSubjects()
{
	CoreItem item;
	Key searchkey;
	static char title[80],header[80],line[LineLength];
	Term->PromptLine(18,0,"Search prefix: ",searchkey,KeySize);
	sprintf(title,"Subjects matching %s",searchkey);
	LLScrollPrompt SubjectList(title,3,0,80,15,20);
	LineList* llist = (LineList*) 0;
	LineList** ptr = &llist;
	LineList* prev = (LineList*) 0;
	int refnum = 0;
	int i;
	if (Tree->SearchSubj(searchkey,&item)) {
		do {
			refnum++;
			sprintf(line,"%3d: %s",refnum,item.key);
			LineList* newline = new LineList(line,0,prev);
			*ptr = newline;
			prev = newline;
			ptr = &newline->nextline;
		} while (Tree->SearchSubjAgain(&item));
		if (llist != (LineList*) 0) {
			if (refnum == 1) {
				if (Tree->SearchSubj(llist->thisline+5,&item)) {
					sprintf(header,"Ids for subject %s",item.key);
					ListRecord rec(&item.data);
					if (rec.ElementCount() == 1) EditCard1(rec[0]);
					else if (rec.ElementCount() > 1)
						ListCardsFromList(header,rec);
				}
			} else if (SubjectList.Scroll(llist,"Ref#, RETURN for more, q to exit:",title,KeySize) > 0) {
				refnum = atoi(title);
				for (i = 1,prev = llist;
				     prev != (LineList*)0 && i < refnum;
				     prev = prev->nextline,i++) ;
				if (i == refnum) {
					if (Tree->SearchSubj(prev->thisline+5,&item)) {
						sprintf(header,"Ids for subject %s",item.key);
						ListRecord rec(&item.data);
						if (rec.ElementCount() == 1) EditCard1(rec[0]);
						else if (rec.ElementCount() > 1)
							ListCardsFromList(header,rec);
					}
				} else Term->Message("Bad reference number");
			}
			FreeLineList(llist);
		}
		return(-1);
	} else {
		Term->Message("No subjects found");
		return(1);
	}
}




