/* -*- Mode: C -*- */
/* EditLibr.cc - Librarian Card Catalog editor
 * Created by Robert Heller on Tue Dec 10 19:37:26 1991
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Edit a Librarian Card Catalog file
 * ------------------------------------------------------------------
 * Modification History:
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 * 
 * Copyright (c) 1991,1992 by Robert heller (D/B/A Deepwoods Software)
 *        All Rights Reserved
 * 
 */

#include <iostream.h>
#include <vBTree.h>
#include <ctype.h>
#ifdef MESSYDOS
#include <CardRec.h>
#include <ListRec.h>
#else
#include <CardRecord.h>
#include <ListRecord.h>
#endif
#include <Terminal.h>
#ifdef MESSYDOS
#include <CmdScren.h>
#else
#include <CommandScreen.h>
#endif
#define VERSION "V1.1"
#include "EditLibr.h"
#define MAIN
#include "EditDefs.h"
#include "EditGlob.h"

static int Quit()
{
	return 0;
}

static int SpawnShell()
{
	static char* shellargs[] = {
		ShellCommand,
		0
	};
	int status = Term->forkprog(shellargs);
	if (status < 0) return(1);
	else return(-1);
}

int EditCard();
int DeleteCard();
int DeleteByAuthor();
int DeleteByTitle();
int DeleteBySubj();
int ListCards();
int ListTitles();
int ListAuthors();
int ListSubjects();

 
static CommandDescr Main[] = {
	{ "Quit", Quit, 0 },
	{ "Edit a Card", EditCard, 0 },
	{ "Delete a Card", DeleteCard, 0 },
	{ "Delete by Author", DeleteByAuthor, 0 },
	{ "Delete by Title", DeleteByTitle, 0 },
	{ "Delete by Subject", DeleteBySubj, 0 },
	{ "List Cards", ListCards, 0 },
	{ "List Titles", ListTitles, 0 },
	{ "List Authors", ListAuthors, 0 },
	{ "List Subjects", ListSubjects, 0 },
	{ "Spawn Shell", SpawnShell, 0}
};

const NumCommands = sizeof(Main) / sizeof(CommandDescr);

main(int argc,char** argv)
{
	static EditLibr args(argc,argv);
	OpenMode omode = ReadWrite;
	if (args.minpages_passed) omode = (OpenMode)(ReadWrite|Create);
	vBTree tree(args.editfile,omode,args.minpages);
	if (tree.OpenStat() == failure) {
		int error = errno;
		cerr << "Could not open " << args.editfile << ": "
		     << strerror(error) << "\n";
		exit(error);
	}
	Terminal term;
	Term = &term;
	static CommandScreen mainScreen("Main Command Menu",NumCommands,Main);
	Tree = &tree;

	char* p = getenv("SHELL");
	if (p == 0) strcpy(ShellCommand,DEFAULTSHELL);
	else strcpy(ShellCommand,p);

	mainScreen.RunScreen();
}



