/* 
 * 
 * ------------------------------------------------------------------
 * Home Libarian 1.1 by Deepwoods Software
 * ------------------------------------------------------------------
 * cgi.cc - CGI Class methods
 * Created by Robert Heller on Sat Mar  2 10:37:25 1996
 * ------------------------------------------------------------------
 * Modification History: 
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Home Librarian Database -- a program for maintaining a database
 *                                for a home library
 *     Copyright (C) 1991-1996  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

#include <cgi.h>
#include <iostream.h>
#include <stdlib.h>
#include <string.h>

CGI::Entry* CGI::getpair()
{
	if (current == NULL || *current == '\0') return NULL;
	Entry *result = new Entry;
	char *start = current;
	while (*current && *current != '&') current++;
	char *equal = start;
	while (equal < current && *equal != '=') equal++;
	int nlen = (equal - start) + 1, vlen = (current - equal) + 1;
	char *ntemp = new char[nlen], *vtemp = new char[vlen];
	char *p1,*p2;
	for (p1 = ntemp,p2 = start;p2 < equal;p1++,p2++) *p1 = *p2;
	*p1 = '\0';
	for (p1 = vtemp,p2 = equal+1;p2 < current;p1++,p2++) *p1 = *p2;
	*p1 = '\0';
	result->name = (String) ntemp; delete ntemp;
	result->value = (String) vtemp; delete vtemp;
	plustospace(result->name); unescape_url(result->name);
	plustospace(result->value); unescape_url(result->value);
	result->next = NULL;
	if (*current == '&') current++;
	return(result);
}

void CGI::unescape_url(String &url)
{
	char *u = (char *) url;
	register int x,y;
	for(x=0,y=0;u[y];++x,++y) 
	{
		if((u[x] = u[y]) == '%')
		{
			u[x] = x2c(&u[y+1]);
			y+=2;
		}
	}
	u[x] = '\0';
	url = (String) u;
}

void CGI::plustospace(String &string)
{
	register int x;
	char *str = (char *) string;
	for(x=0;str[x];x++) if(str[x] == '+') str[x] = ' ';
	string = (String) str;
}

char CGI::x2c(const char *what)
{
	register char digit;

	digit = (what[0] >= 'A' ? ((what[0] & 0xdf) - 'A')+10 : (what[0] - '0'));
	digit *= 16;
	digit += (what[1] >= 'A' ? ((what[1] & 0xdf) - 'A')+10 : (what[1] - '0'));
	return(digit);
}

CGI::CGI()
{
	static const char *envvars[] = {
		"SERVER_SOFTWARE",
		"SERVER_NAME",
		"GATEWAY_INTERFACE",
		"SERVER_PROTOCOL",
		"SERVER_PORT",
		"PATH_INFO",
		"PATH_TRANSLATED",
		"SCRIPT_NAME",
		"REMOTE_HOST",
		"REMOTE_ADDR",
		"REMOTE_USER",
		"AUTH_TYPE",
		"HTTP_ACCEPT",
	};
	entries = NULL;
	rawdata = NULL;
	current = NULL;

	char *req_method = getenv("REQUEST_METHOD");
	if (strcmp(req_method,"GET") == 0)
	{
		char *query = getenv("QUERY_STRING");
		if (query == NULL) query = "";
		rawdata = new char[strlen(query)+1];
		strcpy(rawdata,query);
		current = rawdata;
	} else if (strcmp(req_method,"POST") == 0)
	{
		if(strcmp(getenv("CONTENT_TYPE"),"application/x-www-form-urlencoded") != 0)
		{
			cout << "Content-type: text/html\n\n";
			cout << "This script can only be used to decode form results. \n";
			cout << "The type you used is " << getenv("CONTENT_TYPE") << "\n";
			exit(1);
		}
		int plen = atoi(getenv("CONTENT_LENGTH"));
		rawdata = new char[plen+1];
		memset(rawdata,0,plen+1);
		cin.read(rawdata,plen);
		current = rawdata;
	} else
	{
		cout << "Content-type: text/html\n\n";
		cout << "This script can only be used to handle REQUEST_METHODs of GET or POST\n";
		cout << "The REQUEST_METHOD you used is " << req_method << "\n";
		exit(1);
	}
	Entry *newent;
	int ienvs = sizeof(envvars) / sizeof(envvars[0]);
	for (int i = 0; i < ienvs; i++)
	{
		newent = new Entry;
		newent->name = (String) envvars[i];
		newent->value = (String) getenv(envvars[i]);
		newent->next = entries;
		entries = newent;
	}
	while ((newent = getpair()) != NULL)
	{
		newent->next = entries;
		entries = newent;
	}
}

CGI::~CGI()
{
	Entry *p,*n;
	for (p = entries;p != NULL; p = n)
	{
		n = p->next;
		delete p;
	}
	if (rawdata != NULL) delete rawdata;
}

String CGI::GetVal(const String n) const
{
	for (Entry *p = entries;p != NULL; p = p->next)
	{
		if (n == p->name) return(p->value);
	}
	return "";
}

void CGI::PrintAll() const
{
	cout << "Content-type: text/html\n\n";
	cout << "<pre>\n";
	for (Entry *p = entries;p != NULL;p = p->next)
	{
		cout << p->name << "\t= " << p->value << "\n";
	}
	cout << "</pre>\n";
}
