{

  Copyright 1995 by Salvatore Besso, mc8505@mclink.it

  This software is freeware.

  You are free to modify the source code for your personal use and to
  redistribute this software only if you leave the copyright notices
  unmodified everywhere in the code, also in the comments.

  In case of problems contact me via e-mail at address:

  mc8505@mclink.it

}

program DbSource;

{ Creates Pascal source code of Paradox 4 tables structure and }
{ indexes directly from table }

{
  Errorlevels returned:

  1  = File error (not found or other DOS error)
  2  = Paradox Engine error
  99 = Command line parameter wrong or missing
}

{
  Note: Unfortunately there is no way to determine if a secondary index
  is maintained or not, so pxIncSecondary is always used
}

{$V-}

uses
  Dos,
  Objects,
  PXEngine,OOPxEng;

const

  Ver = '1.01';

  Engine  : PEngine   = NIL;
  Database: PDataBase = NIL;

  Path: PathStr = '';

  PXEPrimary   = 100;
  PXEComposite = 101;

type

  PExtendedFieldDesc = ^TExtendedFieldDesc;
  TExtendedFieldDesc = object (TObject)
    FldNum    : FieldNumber;
    FldName   : String[MaxNameLen];
    FldType   : pxFieldType;
    FldSubType: pxFieldSubType;
    FldLen    : Integer;
    CaseSens  : Boolean;
    FldArray  : FieldNumberArray;
  end;

  PExtFieldCollection = ^TExtFieldCollection;
  TExtFieldCollection = object (TSortedCollection)
    function Compare (Key1,Key2: Pointer): Integer; virtual;
  end;

  PItemCollection = ^TItemCollection;
  TItemCollection = object (TCollection)
    procedure FreeItem (Item: Pointer); virtual;
  end;

var
  IntColl,ImpColl: PItemCollection;

{ TExtFieldCollection }

function TExtFieldCollection.Compare (Key1,Key2: Pointer): Integer;

var
  FD1: PExtendedFieldDesc absolute Key1;
  FD2: PExtendedFieldDesc absolute Key2;

begin
  if FD1^.FldNum < FD2^.FldNum then
    Compare := -1
  else if FD1^.FldNum = FD2^.FldNum then
    Compare := 0
  else Compare := 1
end;

{ TItemCollection }

procedure TItemCollection.FreeItem (Item: Pointer);

begin
  DisposeStr (Item)
end;

procedure ReleaseEngine;

begin
  if Database <> NIL then Dispose (Database,Done);
  if Engine <> NIL then Dispose (Engine,Done)
end;

procedure ShutDown (Code: RetCode);

begin
  WriteLn (#7#13#10'Paradox Engine Database Framework:');
  WriteLn (Engine^.GetErrorMessage (Code));
  Dispose (IntColl,Done);
  Dispose (ImpColl,Done);
  ReleaseEngine;
  Halt (2)
end;

procedure OpenEngine;

begin
  Engine := New (PEngine,defInit (pxLocal));
  if Engine^.LastError <> PXSuccess then
    ShutDown (Engine^.LastError);
  Database := New (PDataBase,Init (Engine));
  if Database^.LastError <> PXSuccess then
    ShutDown (Database^.LastError)
end;

procedure BuildTableStructure;

var
  Dir            : DirStr;
  Name           : NameStr;
  Ext            : ExtStr;
  SR             : SearchRec;
  TableDescriptor: PTableDesc;
  S              : String;
  Cur            : PCursor;
  Coll           : PStringCollection;
  FldColl        : PExtFieldCollection;

procedure WriteStruc (P: PFieldDesc); far;

var
  S,T     : String;
  I       : Integer;
  Len,Size: LongInt;

begin
  ImpColl^.Insert (NewStr ('  FieldDesc := New (PFieldDesc,Init);'));
  ImpColl^.Insert (NewStr ('  with FieldDesc^ do'#13#10'  begin'));
  Str (P^.FldNum:0,T);
  ImpColl^.Insert (NewStr ('    FldNum := ' + T + ';'));
  T := P^.FldName;
  S := '';
  repeat
    I := Pos ('''',T);
    if I > 0 then
    begin
      S := S + Copy (T,1,I) + '''';
      Delete (T,1,I)
    end
  until I = 0;
  S := S + T;
  ImpColl^.Insert (NewStr ('    FldName := ''' + S + ''';'));
  S := '    FldType := ';
  case P^.FldType of
    fldChar  : S := S + 'fldChar';
    fldShort : S := S + 'fldShort';
    fldDate  : S := S + 'fldDate';
    fldDouble: S := S + 'fldDouble';
    fldBlob  : S := S + 'fldBlob'
  end;
  if (P^.FldType = fldChar) or (P^.FldType = fldDouble)
  or (P^.FldType = fldBlob) then
  begin
    S := S + ';' + #13#10;
    if (P^.FldType = fldDouble) or (P^.FldType = fldBlob) then
    begin
      S := S + '    FldSubType := ';
      case P^.FldSubType of
        fldStNone   : S := S + 'fldStNone';
        fldStMoney  : S := S + 'fldStMoney';
        fldStMemo   : S := S + 'fldStMemo';
        fldStBinary : S := S + 'fldStBinary';
        fldStFmtMemo: S := S + 'fldStFmtMemo';
        fldStOleObj : S := S + 'fldStOleObj';
        fldStGraphic: S := S + 'fldStGraphic'
      end;
      if P^.FldType = fldBlob then S := S + ';' + #13#10
    end;
    if (P^.FldType = fldChar) or (P^.FldType = fldBlob) then
    begin
      Str (P^.FldLen:0,T);
      S := S + '    FldLen := ' + T
    end
  end;
  ImpColl^.Insert (NewStr (S));
  ImpColl^.Insert (NewStr ('  end;'));
  ImpColl^.Insert (NewStr ('  TableDesc^.Insert (FieldDesc);'#13#10))
end;

function GetKeyFiles (TblName: PathStr): PStringCollection;

var
  P   : PStringCollection;
  Dir : DirStr;
  Name: NameStr;
  Ext : ExtStr;
  SR  : SearchRec;

begin
  P := New (PStringCollection,Init (10,10));
  FSplit (TblName,Dir,Name,Ext);
  FindFirst (Dir + Name + '.PX',AnyFile,SR);
  if DosError = 0 then
  begin
    P^.Insert (NewStr (Dir + SR.Name));
    FindFirst (Dir + Name + '.X??',AnyFile,SR);
    while DosError = 0 do
    begin
      P^.Insert (NewStr (Dir + SR.Name));
      FindNext (SR)
    end
  end;
  if P^.Count = 0 then
  begin
    Dispose (P,Done);
    P := NIL
  end;
  GetKeyFiles := P
end;

procedure DoBuild (P: PString); far;

var
  FD  : PExtendedFieldDesc;
  Mode: Integer;

begin
  FD := New (PExtendedFieldDesc,Init);
  PXKeyQuery (P^,FD^.FldName,FD^.FldLen,Mode,FieldHandleArray (FD^.FldArray),
    FD^.FldNum);
  if FD^.FldNum = 0 then
  begin
    FD^.FldName := '';
    Byte (FD^.FldType) := PXEPrimary;
    FD^.FldLen := Database^.GetNumPFields (P^)
  end
  else begin
    if FD^.FldNum < 256 then
    begin
      Cur^.GenericRec^.GetFieldType (FD^.FldNum,FD^.FldType,FD^.FldSubType,
        FD^.FldLen);
      FD^.FldLen := 1
    end
    else Byte (FD^.FldType) := PXEComposite;
    FD^.CaseSens := Mode = 0
  end;
  FldColl^.Insert (FD)
end;

procedure WriteIndexSource (FD: PExtendedFieldDesc); far;

var
  S,T: String;
  I  : Integer;
  U  : String[5];

begin
  if Byte (FD^.FldType) = PXEPrimary then
  begin
    Str (FD^.FldLen:0,S);
    ImpColl^.Insert (NewStr ('  Database^.CreatePIndex (P,' + S + ');'));
    ImpColl^.Insert (NewStr ('  if Database^.LastError <> PXSuccess then'));
    if FldColl^.IndexOf (FD) < FldColl^.Count - 1 then
      ImpColl^.Insert (NewStr ('  begin'));
    S := '    Create' + Name + 'Indexes := Database^.LastError';
    if FldColl^.IndexOf (FD) < FldColl^.Count - 1 then S := S + ';';
    ImpColl^.Insert (NewStr (S));
    if FldColl^.IndexOf (FD) < FldColl^.Count - 1 then
    begin
      ImpColl^.Insert (NewStr ('    Exit'));
      ImpColl^.Insert (NewStr ('  end;'#13#10))
    end
  end
  else if (FD^.FldLen = 1) and FD^.CaseSens then
  begin
    Str (FD^.FldNum:0,S);
    ImpColl^.Insert (NewStr ('  Database^.CreateSIndex (P,' + S +
      ',pxIncSecondary);'));
    ImpColl^.Insert (NewStr ('  if Database^.LastError <> PXSuccess then'));
    if FldColl^.IndexOf (FD) < FldColl^.Count - 1 then
      ImpColl^.Insert (NewStr ('  begin'));
    S := '    Create' + Name + 'Indexes := Database^.LastError';
    if FldColl^.IndexOf (FD) < FldColl^.Count - 1 then S := S + ';';
    ImpColl^.Insert (NewStr (S));
    if FldColl^.IndexOf (FD) < FldColl^.Count - 1 then
    begin
      ImpColl^.Insert (NewStr ('    Exit'));
      ImpColl^.Insert (NewStr ('  end;'#13#10))
    end
  end
  else begin
    for I := 1 to FD^.FldLen do
    begin
      Str (I:0,S);
      Str (FD^.FldArray[I]:0,U);
      ImpColl^.Insert (NewStr ('  CompArray[' + S + '] := ' + U + ';'))
    end;
    Str (FD^.FldLen:0,S);
    if FD^.CaseSens then U := 'True' else U := 'False';
    ImpColl^.Insert (NewStr ('  Database^.DefineCompoundKey (P,' + S +
      ',CompArray,''' + FD^.FldName + ''',' + U + ',FldNo);'));
    S := '  if Database^.LastError <> PXSuccess then'#13#10'  begin'#13#10 +
      '    Create' + Name + 'Indexes := Database^.LastError;'#13#10 +
      '    Exit'#13#10'  end;';
    ImpColl^.Insert (NewStr (S));
    S := '  Database^.CreateSIndex (P,FldNo,pxIncSecondary);';
    ImpColl^.Insert (NewStr (S));
    ImpColl^.Insert (NewStr ('  if Database^.LastError <> PXSuccess then'));
    if FldColl^.IndexOf (FD) < FldColl^.Count - 1 then
      ImpColl^.Insert (NewStr ('  begin'));
    S := '    Create' + Name + 'Indexes := Database^.LastError';
    if FldColl^.IndexOf (FD) < FldColl^.Count - 1 then S := S + ';';
    ImpColl^.Insert (NewStr (S));
    if FldColl^.IndexOf (FD) < FldColl^.Count - 1 then
    begin
      ImpColl^.Insert (NewStr ('    Exit'));
      ImpColl^.Insert (NewStr ('  end;'#13#10))
    end
  end
end;

begin { BuildTableStructure }
  FSplit (FExpand (Path),Dir,Name,Ext);
  if Name = '' then Name := '*';
  Ext := '.DB';
  FindFirst (Dir + Name + Ext,Archive,SR);
  if DosError > 0 then
  begin
    WriteLn (#7#13#10'File not found or file error');
    Dispose (IntColl,Done);
    Dispose (ImpColl,Done);
    ReleaseEngine;
    Halt (1)
  end;
  while DosError = 0 do
  begin
    Name := Copy (SR.Name,1,Pos ('.',SR.Name) - 1);
    TableDescriptor := Database^.GetDescVector (Dir + Name);
    if Database^.LastError <> PXSuccess then
      ShutDown (Database^.LastError);
    S := 'function Create' + Name + 'Table (Path: PathStr): RetCode;';
    IntColl^.Insert (NewStr (S));
    ImpColl^.Insert (NewStr (S + #13#10));
    ImpColl^.Insert (NewStr ('begin'));
    ImpColl^.Insert (NewStr ('  Create' + Name +
      'Table := PXSuccess;'#13#10));
    ImpColl^.Insert (NewStr ('  TableDesc := New (PTableDesc,Init (10,2));' +
      #13#10));
    TableDescriptor^.ForEach (@WriteStruc);
    ImpColl^.Insert (NewStr ('  P := Path + ''' + Name + ''';'));
    ImpColl^.Insert (NewStr ('  Database^.CreateTable (P,TableDesc);'));
    ImpColl^.Insert (NewStr ('  if Database^.LastError <> PXSuccess then'));
    ImpColl^.Insert (NewStr ('    Create' + Name +
      'Table := Database^.LastError;'#13#10));
    ImpColl^.Insert (NewStr ('  Dispose (TableDesc,Done)'));
    ImpColl^.Insert (NewStr ('end;'#13#10));
    Dispose (TableDescriptor,Done);
    Coll := GetKeyFiles (Dir + Name);
    { if there are indexes, we proceed to write their source code }
    if Coll <> NIL then
    begin
      { we need the table to be open to collect all indexes' informations }
      Cur := New (PCursor,InitAndOpen (Database,Dir + Name,0,True));
      if Cur^.LastError <> PXSuccess then ShutDown (Cur^.LastError);
      FldColl := New (PExtFieldCollection,Init (Coll^.Count,0));
      { now we build the collection containing }
      { indexes' informations for this table   }
      Coll^.ForEach (@DoBuild);
      Dispose (Coll,Done);
      Dispose (Cur,Done);
      S := 'function Create' + Name + 'Indexes (Path: PathStr): RetCode;';
      IntColl^.Insert (NewStr (S));
      ImpColl^.Insert (NewStr (S + #13#10));
      ImpColl^.Insert (NewStr ('begin'));
      ImpColl^.Insert (NewStr ('  Create' + Name +
        'Indexes := PXSuccess;'#13#10));
      ImpColl^.Insert (NewStr ('  P := Path + ''' + Name + ''';'#13#10));

      FldColl^.ForEach (@WriteIndexSource);
      Dispose (FldColl,Done);
      ImpColl^.Insert (NewStr ('end;'#13#10))
    end;
    FindNext (SR)
  end
end;

procedure WriteSource;

var
  Txt: Text;

procedure WriteLines (P: PString); far;

begin
  WriteLn (Txt,P^)
end;

begin
  Assign (Txt,'DBSTRUC.PAS');
  Rewrite (Txt);
  IntColl^.ForEach (@WriteLines);
  ImpColl^.ForEach (@WriteLines);
  Close (Txt);
end;

procedure Usage;

begin
  WriteLn ('Usage: DbSource [d:\path\]tablename[.DB]'#13#10 +
    '                (wildcards are OK)'#13#10);
  Halt (99)
end;

begin { Main }
  Write ('DbSource ' + Ver + ' - ');
  WriteLn ('Creates Pascal source code of Paradox 4 tables structure');
  Write ('and indexes directly from table - by Salvatore Besso, ');
  WriteLn ('mc8505@mclink.it'#13#10);
  if ParamCount <> 1 then Usage;
  Path := ParamStr (1);
  IntColl := New (PItemCollection,Init (10,2));
  ImpColl := New (PItemCollection,Init (10,2));
  OpenEngine;
  IntColl^.Insert (NewStr ('unit DbStruc;'#13#10));
  IntColl^.Insert (NewStr ('{ Database variable of type PDatabase must }'));
  IntColl^.Insert (NewStr ('{ be already declared and initialized }'#13#10));
  IntColl^.Insert (NewStr ('interface'#13#10));
  IntColl^.Insert (NewStr ('uses'));
  IntColl^.Insert (NewStr ('  Dos,'));
  IntColl^.Insert (NewStr ('  Objects,'));
  IntColl^.Insert (NewStr ('  PXEngine,OOPxEng;'#13#10));
  IntColl^.Insert (NewStr ('var'));
  IntColl^.Insert (NewStr ('  TableDesc: PTableDesc;'));
  IntColl^.Insert (NewStr ('  FieldDesc: PFieldDesc;'));
  IntColl^.Insert (NewStr ('  P        : PathStr;'));
  IntColl^.Insert (NewStr ('  CompArray: FieldNumberArray;'));
  IntColl^.Insert (NewStr ('  FldNo    : FieldNumber;'#13#10));
  ImpColl^.Insert (NewStr (#13#10'implementation'#13#10));
  BuildTableStructure;
  ImpColl^.Insert (NewStr ('end.'));
  WriteSource;
  Dispose (IntColl,Done);
  Dispose (ImpColl,Done);
  ReleaseEngine
end.
