




























                   DAILY SOLAR GEOPHYSICAL DATA BROADCAST PROCESSOR

                           DATABASE MANAGER - USERS MANUAL







                                     Version 1.02









                                (c) Copyright 1992 by

                            The Solar Terrestrial Dispatch














                                  Table Of Contents







          Introduction  . . . . . . . . . . . . . . . . . . . . . . . .   1

          Registering this Software . . . . . . . . . . . . . . . . . .   2

          The BCAST Configuration File  . . . . . . . . . . . . . . . .   3

          The BCAST Environment Variable  . . . . . . . . . . . . . . .   3

          Processing Data Sets  . . . . . . . . . . . . . . . . . . . .   3

          Displaying Data Sets On-Screen  . . . . . . . . . . . . . . .   6

          The Archive and Analysis Menu . . . . . . . . . . . . . . . .   7
               Saving Loaded Data Sets to the Database  . . . . . . . .   7
               Loading a Dataset from the Database  . . . . . . . . . .   8
               The Graphical Analysis Options . . . . . . . . . . . . .   9
               Generating an Activity Summary Report  . . . . . . . . .  11
               Generating a Standard SGDB File & Modifying Records  . .  11
               Dumping Data Sets to an ASCII File . . . . . . . . . . .  12
               Deleting Data Sets from the Database . . . . . . . . . .  13
               Returning to the Main Menu . . . . . . . . . . . . . . .  13

          Exiting BCAST and Returning to DOS  . . . . . . . . . . . . .  13

          The Batch Processing Feature of BCAST . . . . . . . . . . . .  14

          Alternate Methods of Executing BCAST  . . . . . . . . . . . .  15

          Defragmenting the BCAST Database  . . . . . . . . . . . . . .  15






                                                                          1

          Introduction

               The Solar Terrestrial  Dispatch (STD)  has been providing  a
          comprehensive  set  of  daily solar  geophysical  indices  to the
          public in  the  form of  a  product  known as  the  "Daily  Solar
          Geophysical  Data  Broadcast"  (SGDB).    The  data  and  indices
          contained in the SGDB are very  valuable to persons interested in
          ionospheric   radio   communications,  solar   activity,  auroral
          activity, and  related geophysical and  even atmospheric  events.
          The  data  sets  are  being  used  by research  institutions  and
          astronomical organizations around the world.

               The  service of  providing these  daily data  sets began  on
          September  4,  1991.   The Solar  Terrestrial Dispatch  has since
          developed an extensive and contiguous base of data.

               Such a large  base of  data is  more useful when  it can  be
          archived  and studied over time.   To satisfy  this need, the STD
          developed this software  package to automatically extract  all of
          the relevant data from the daily SGDB reports and archive them to
          disk for analysis and study.  This  software is known as "BCAST",
          the  Solar  Geophysical  Data BroadCAST  Processor  and  Database
          Manager.    Included  with  this  software package  are  numerous
          utility programs, including a powerful utility which will exploit
          the  graphics capabilities of systems that have VGA graphics (see
          KGRAPH.MAN for details).

               BCAST  provides  complete  archive and  database  management
          facilities in  a user-friendly  and easily  operated environment.
          It will  automatically maintain  a fully  sorted  archive of  the
          datasets for instant recall or graphical  analysis.  It will also
          produce detailed summaries of the datasets in laymans terms which
          may be printed out and distributed, or filed away.

               BCAST also includes  a powerful full-screen  mass-processing
          feature to automatically  archive large  numbers of SGDB  reports
          easily and painlessly.

               Extensive and complete monthly archives  of all SGDB reports
          are available from the STD, through the STD BBS, or via anonymous
          FTP for those who are connected to the larger electronic networks
          such as the  Internet.  Each of the monthly archives may be batch
          processed or selectively processed using BCAST.

               The STD also supplies extensive  documentation to help those
          who  are less familiar,  understand the significance  of the data
          contained in the daily SGDB reports.  The document "Understanding
          Solar  Terrestrial Reports"  comes in  two-parts and is  a superb
          introductory text for those  who want to know more  regarding the
          relations  between  solar  activity  and Earth-based  terrestrial
          activity.  These documents  are also available from the  STD BBS,
          or through anonymous FTP.






                                                                          2


               The STD BBS is accessible 24 hours a day, 7 days a week, and
          provides  alerts, warnings,  and  forecasts  regarding solar  and
          geophysical  phenomena.    The  phone  number is:  403  756-3008.
          Operation is presently  permitted at  either 300,  1200, or  2400
          baud.

               The database generated  and maintained by BCAST will let you
          analyze and study the cyclical behaviour  of such things as solar
          activity,  geomagnetic  activity,  and ionospheric  disturbances.
          You may  also be able  to anticipate the future  behaviour of the
          indices.    This is  invaluable to  those  who, for  example, are
          interested  in  predicting  when  radio  communications  will  be
          optimum, or when auroral activity may  again be observed, or when
          the next group of hot solar regions is due to rotate into view.


          Registering this Software

               This version (1.02) of BCAST was released in late July, 1992
          and represents a substantial improvement over  previous versions.
          The software was originally  released in late 1991 and  has since
          proven very reliable.

               We  have expended a  considerable amount of  time to provide
          and  maintain  this   software,  not  to  mention  the  time  and
          considerable resources which  are devoted to providing  the daily
          services on which this software is dependent.

               In order to  help recover some of the costs involved, we are
          requesting all those who make use of this software to register it
          with  us.   By  doing  so, all  of the  features,  functions, and
          utilities associated with this software package will be available
          without limitation.   Moreover, those who are registered  with us
          will  be  entitled  to  free  software upgrades  and  substantial
          discounts on future software releases.

               To register this software, read the information contained in
          the file "REGISTER.DOC".  Then, simply print out and fill out the
          registration form  included in the file and send  it to us at the
          following address with your registration payment enclosed:

                              Solar Terrestrial Dispatch
                              P.O. Box 357
                              Stirling, Alberta, Canada
                              T0K 2E0

          We  will  return   your  unique  registration  I.D.   and  simple
          instructions  for  making  your  copy of  the  BCAST  software  a
          registered  and   fully-functional  copy.     Consult   the  file
          "REGISTER.DOC" for more information.






                                                                          3


          The BCAST Configuration File

               Version   1.01  of  BCAST  supported  a  configuration  file
          intended to permit the definition of defaults for BCAST.  Version
          1.02  of  BCAST  has expanded  on  this  idea  by permitting  the
          selection  of defaults  for a  number of features.   Most  of the
          acronyms supported in  this version are designed to customize the
          operation  of  the utility  program,  KGRAPH (a  powerful utility
          designed to display  detailed geomagnetic data on  systems having
          VGA displays).

               The configuration  (or initialization) file  is "BCAST.INI".
          This is an editable text file.  All of the available acronyms are
          defined in  this file.   New users  of this software  package are
          encouraged to read  through the BCAST.INI initialization  file to
          become familiar with the defaults which may be set.


          The BCAST Environment Variable

               By setting the DOS environment  variable "BCAST" to point to
          the path containing the BCAST initialization file (BCAST.INI) and
          the  BCAST database file (DATASETS.DAT), you  are able to execute
          BCAST or any of the accompanying  utilities from any directory on
          your system.

               To accomplish this,  change your  AUTOEXEC.BAT file so  that
          the BCAST environment variable is appropriately set each time you
          boot  your  computer.     For  example,  if  the  BCAST.INI   and
          DATASETS.DAT files are  located at: "C:\BCAST", you  would simply
          insert the line:  "SET BCAST=C:\BCAST" in your  AUTOEXEC.BAT file
          and  reboot  your computer.    Thereafter,  you will  be  able to
          execute BCAST.EXE  or  any of  the  other utility  programs  from
          anywhere on your system.

               Please remember that in  order for DOS to find  the programs
          such as BCAST.EXE,  or KGRAPH.EXE, you  must also make sure  that
          your "PATH"  environment variable  is adjusted  to  point to  the
          location of these executable programs.

               Setting the "BCAST" environment variable simply  permits the
          BCAST  software to locate and use the initialization and database
          files, which are critical to the operation of the BCAST software.


          Processing Data Sets

               This section of  BCAST was completely rewritten  for version
          1.01 in order to enhance and  simplify the processing of datasets
          by  BCAST.   It provides  a powerful interface  and will  let you
          selectively process any  number of SGDB reports for  inclusion in






                                                                          4

          the database or for viewing on-screen.

               To process data sets from the main menu of BCAST, select the
          "Process Datasets" option.  A screen  will appear showing you the
          names  of  the files  BCAST identified  using the  MASK parameter
          defined in the configuration file.

          (The "MASK" acronym is defined in the file "BCAST.INI" and simply
          tells BCAST where to look for all of the processable textual SGDB
          reports.   You  can force  BCAST  to look  for these  files  in a
          specific location  on your computers hard disk  (or floppy drive)
          by defining the  "MASK" acronym in  the BCAST.INI file.   Consult
          the "BCAST.INI" file for more information.)

               If no files  match the given  MASK, the statement "No  Files
          Selected" will appear on the bottom of the screen.  If  files are
          found which  do match  the given  MASK, their  filenames will  be
          displayed and sorted  from left to right, and top to bottom.  One
          screen can display up to 72 files at a time.  If BCAST identifies
          more  than  72 files,  it  will  display the  remaining  files on
          additional screens after you have finished processing the desired
          files from the current screen.

               To select  a file for processing, use the arrow keys to move
          the screen cursor over the file you wish to process.   Then press
          the SPACE-BAR.  The first file you  select in this manner will be
          identified on-screen by  the appearance  of red "#01:"  preceding
          the filename.  The second file you select will be  prepended with
          a red "#02:" and so on.  You can select up to 72 files to process
          on-screen  in this  manner.   Each will be  numbered accordingly.
          The numbers identify the order the files will be processed.

               You can deselect a file for  processing by moving the cursor
          over  the file  and pressing  the  SPACE-BAR.   If that  file was
          previously selected to  be processed, it  will be deselected  and
          the  entire  ordering   sequence  will   be  updated  to   remain
          contiguous.

               After  you  have finished  selecting  the files  to process,
          press  ENTER.   BCAST  will process  all  of the  files  you have
          selected in the  order you selected  them.  If  any of the  files
          being processed are corrupt, BCAST will replace its corresponding
          number with "BAD:" so you can identify those files which may need
          to  be repaired  or  replaced.   If  all  goes well,  BCAST  will
          continue processing the files until  all selected files have been
          processed.

               After  all of  the  files have  been  processed, BCAST  will
          display the next screenful of  files matching the MASK parameter.
          After all  of the  files  have been  selected (ex.  when no  more
          screens of file  names are displayed),  BCAST will return you  to
          the main menu.






                                                                          5


               Please note that registered copies of BCAST will attempt  to
          archive  all  selected  files  to  the  database.    During  this
          procedure, some files may process faster than others.  The reason
          for this is due  to the fact that BCAST maintains  a fully sorted
          database.   When it  attempts  to archive  a new  dataset to  the
          database, it re-sorts the database.  Therefore, if you process an
          SGDB report that has  a date near the end of  the database, BCAST
          will process it relatively quickly since very little sorting will
          need to be  done.  On the  other hand, if  you process a  dataset
          that has  an old date,  BCAST may need  to re-sort  a significant
          fraction of the  database.  The speed with which BCAST is able to
          process files into  the sorted database  will also depend on  the
          size  of the  database.   It is  therefore to  your  advantage to
          select files which are already in a roughly sorted sequence.

               BCAST will not overwrite or add  datasets to the database if
          they already exist.  If you  happen to select and process a  file
          which  is already contained  in your database,  BCAST will simply
          skip  over  that  file  and  assume  that  it  has  already  been
          processed.  It  will not change the contents of the record in the
          database file.

               Unregistered copies of BCAST will not attempt to archive the
          selected files to  the database.  Instead,  unregistered software
          will only  load the selected files  for on-screen review.   It is
          important to remember  that in  both registered and  unregistered
          versions  of BCAST,  the last file  loaded will  be the  only one
          resident in memory for reviewing on-screen.

               An additional feature which can  be accessed while selecting
          files  to  be  processed,  is  the  ability to  change  the  MASK
          parameter.   At the bottom  left-hand corner of  the screen  is a
          "Mask=" statement.   The current value  of the MASK parameter  is
          printed in this area.  If the length of the MASK parameter is too
          large to be fully  printed on-screen, it will be truncated at the
          appropriate location  and a  ~ symbol  will be  appended.   The ~
          symbol informs you  that truncation was  performed, and that  the
          entire MASK parameter cannot be printed on-screen.

               To change the  MASK parameter  while selecting files,  press
          the "M" key  (for Mask).  A cursor will  immediately appear after
          the  "Mask="  statement.   Simply  type  in your  new  path using
          whatever drive,  directory, and/or wildcard  information that  is
          necessary.  When  finished, press  ENTER and the  screen will  be
          redrawn with the files that match the new MASK parameter.

               Changing the MASK string  from within BCAST does not  affect
          the value of the MASK given  in the configuration file BCAST.INI.
          Modifying the MASK value from within BCAST is only temporary.  As
          soon as you re-run BCAST, the MASK will once again be loaded with
          the value given in the configuration file.  If no MASK command is






                                                                          6

          given within the configuration file, the default  string used for
          the MASK is "*.dly".

               You  may  exit the  file  selection  screen at  any  time by
          pressing the ESCape key.  This will immediately return you to the
          main menu, even if files were selected to be processed.


          Displaying Data Sets On-Screen

               After a SGDB dataset has been  loaded from disk into memory,
          you may  choose to  display the  data on-screen  in a  friendlier
          format.    The  second  main menu  function,  "Review  Data  Set"
          provides you with this capability. 
           
               This feature automatically decodes the various acronyms used
          in the textual SGDB reports and displays their meanings on-screen
          in laymans terms.  It provides screenful upon screenful of useful
          information regarding the  dataset by  interpreting the  contents
          and explaining or displaying them. 
           
               The first and possibly second screens displayed by BCAST are
          summaries of the  warnings and  alerts which were  active at  the
          time the  SGDB data  set was  compiled at  the Solar  Terrestrial
          Dispatch.  These warnings  and alerts which are displayed  do not
          go into  any significant detail.   In  fact, this section  of the
          SGDB report is  the only  section which is  not copied  verbosely
          into the computer during  the processing phase.  In  other words,
          the  details of each warning and/or alert are not processed.  The
          reason  for this  is to keep  the BCAST  database file down  to a
          minimal size.   The smaller  each BCAST database  record is,  the
          more information you will  be able to store in a  given amount of
          disk space.   If all  of the  possible details  of every  various
          warning and alert  were processed, each database record  would be
          much larger than needed,  more difficult to process and  would be
          wasteful  with  disk  space.   All  that  is  really required  is
          knowledge of the  basic warnings and  alerts which are in  effect
          during each day.  The details of the warnings or alerts aren't as
          important.  If the  details are important, you are  encouraged to
          obtain  one  of  the  extensive  monthly  summaries  of  activity
          produced by the Solar Terrestrial Dispatch,  as made available on
          our computer BBS system and through anonymous FTP.
           
               The screens following  the warnings and alerts  summarize in
          great detail  the data  which was  loaded from  the textual  SGDB
          report.  All of the various indices are listed.  Many of them are
          interpreted for you so you can better understand their meaning. 
           
               This  feature  may  be  executed   by  those  who  have  not
          registered the BCAST software package with us. 






                                                                          7


          The Archive and Analysis Menu

               The third  function of  the BCAST  main menu  represents the
          heart of BCAST:   the archive and analysis features.   This is an
          extensive  menu  containing  all of  the  functions  necessary to
          maintain  the   database,  archive  new  data  to disk,  generate
          reports, and graphically analyze the data in the database. 
           
               In order to encourage payment for this program, this section
          of BCAST may be viewed but cannot  be used by those who have  not
          registered their copy  of BCAST with us.  In order to develop and
          maintain your own database of records,  you will need to purchase
          your copy of the  program by sending a cheque or  money order for
          $35.00 in either Canadian or U.S.  funds to the Solar Terrestrial
          Dispatch (consult the file "REGISTER.DOC" for more  information).
          After your unique  registration number has  been returned to  you
          with the  simple instructions  for making  your copy  of BCAST  a
          registered copy, you  will be able to access and use this section
          of BCAST at your leisure. 


          Saving Loaded Data Sets to the Database

               BCAST  expects  to  find  its  database  file  in  the  same
          directory as the BCAST initialization file (BCAST.INI) and with a
          filename of "DATASETS.DAT".   This file is  created automatically
          when you  first  start processing  the  daily SGDB  reports  with
          BCAST.  If the  environment variable "BCAST" is not  used and you
          execute BCAST in  a directory where  this database file does  not
          exist, BCAST will not use the database.  This behavior allows you
          to maintain separate databases in different  directories.  To use
          a specific database, simply move to the directory  containing the
          database and  execute BCAST.   If  you are  only maintaining  one
          database, it is  usually most convenient  to set the  environment
          variable "BCAST"  to the  path of  your BCAST.INI  and associated
          files (textual SGDB data  files may be located elsewhere,  as was
          described earlier).

               Before this option can be executed, a dataset must be loaded
          into memory.   After you have loaded  a dataset into  memory, you
          may archive (save) that dataset to  your database file using this
          option  of  the Archive  Menu.   To  execute this  option, simply
          select  the "Save Data Set" option  in the Archive Menu using the
          Up and Down arrow keys.  Alternatively, you may select this  menu
          item by pressing  the corresponding  letter associated with  that
          menu choice.
           
               Before writing the new data set  to the database file, BCAST
          checks to  make sure that no other  records in the database match
          the one you are attempting  to archive.  If it finds a  record in
          the database with the same date as the dataset you are attempting






                                                                          8

          to  archive, a warning  is displayed  on-screen giving  you three
          options.   You may overwrite the record, which is useful when you
          need to  correct or modify  a record in  your database.   You may
          skip the record,  which will force BCAST to write  the dataset to
          the database.  In this  case, nothing is overwritten.  New  space
          within the database  is created for  the dataset you are  saving.
          If this  option is  chosen, there  will  be two  records in  your
          database with identical  dates.  The  last option lets you  abort
          the save procedure  altogether.   In this case,  the database  is
          left unchanged.  Nothing is written to the database. 
           
               When  BCAST  saves   datasets  to  the  database   file,  it
          automatically archives the dataset fully sorted with the existing
          records in  the database.   It  sorts the  database according  to
          dates.   For this  reason, records  which are  archived near  the
          "front" of the database (ex.  a dataset which has a date  earlier
          than  anything  presently  existing in  the  database)  will take
          longer to save to  disk than a dataset which has  a date close to
          the present date.  The  sorting process occurs sequentially  from
          the  lowest to  the  highest dates.   That  is,  a dataset  dated
          January 1, 1992  would appear BEFORE  a dataset dated January  2,
          1992.  Conversely,  a dataset dated  December 31, 1991 (note  the
          year) would appear  BEFORE the  datasets dated January  1 and  2,
          1992 in the database file. 
           
               This automatic sorting feature  significantly simplifies and
          speeds up many of the functions available with BCAST. 
           
               If the dataset is successfully archived to the database,  an
          "operation successful" message is  displayed on your screen.   If
          an error  occurs, you  may be  returned to  DOS depending  on the
          severity  of the error.  All disk errors result in  a Fatal Error
          message which immediately returns  you to the DOS prompt  with an
          explanation. 


          Loading a Dataset from the Database

               This option loads a dataset which you previously archived to
          the database.  Using  this option, you can examine  (via the main
          menu option "Review Data Sets") the  conditions and indices which
          were observed for any date contained in your database file. 
           
               You are simply prompted for the date of the dataset you wish
          to  load  from the  database.    After specifying  a  date, BCAST
          searches  through  the  database  until  it finds  the  requested
          dataset.  If the date you specify  is either invalid or cannot be
          found in the database,  an error message is displayed  which then
          returns you to the Archive Menu. 
           
               This option has a secondary effect  which may not be clearly
          apparent  at first.  When BCAST graphically analyzes the datasets






                                                                          9

          in the database file, it  always attempts to graphically  display
          the various datasets  with respect to  the date of the  currently
          loaded dataset. In other words, all  graphs or charts produced by
          BCAST  will be displayed  so that the  LAST line of  the graph or
          chart is the graph line  of the dataset which you have  currently
          loaded in memory.  If you  do not have a specific dataset  loaded
          in memory, all graphs  are produced with the last  dataset of the
          database (ex. the  most recently  archived dataset) displayed  as
          the last graph line on the screen. 

               To better  explain this feature, let's assume  that you have
          200  datasets  archived  to   your  database  and  you  wish   to
          graphically analyze them.   Since BCAST can only fit  70 datasets
          on-screen at one time, it is necessary to select a portion of the
          200 datasets to graphically analyze.   One way to achieve this is
          by loading datasets for specific dates into memory.  If a dataset
          is  loaded  into memory,  the  date of  that  dataset is  used to
          determine  which  portion  of  the  200 datasets  to  graphically
          display on-screen.   For  example, if  the 200  datasets in  your
          database were sequentially dated from January 1, 1992 to July 19,
          1992 (200 consecutive days), and you loaded a dataset into memory
          which  was dated  March 11,  1992, BCAST  would only  graphically
          analyze the datasets  from January 1, 1992 to  March 11, 1992 (70
          days).  The  dataset for March 11,  1992 would be the  last graph
          line  displayed  on-screen.     Similarly,   if  you  wanted   to
          graphically display  the last  70 datasets  on-screen, you  would
          load the dataset  which was dated July 19, 1992 into memory.  All
          graphical charts produced by BCAST follow this procedure.

               Alternatively, you can  use the PageUp, PageDown,  Home, and
          End  keys  on your  keyboard to  move  around the  database while
          viewing  the  graphs or  charts.   This  is explained  in greater
          detail below.


          The Graphical Analysis Options

               BCAST provides a  set of  valuable graphical analysis  tools
          which will  help you  better analyze  the  cyclical behaviour  or
          other parameters of the datasets in your database. 

               Almost all of the data contained  in the SGDB reports can be
          graphically analyzed using BCAST.   The only items which  are not
          analyzed by BCAST.EXE  are the  Boulder and Planetary  K-indices.
          Additional software to  graphically display the K-index  data has
          been included as utility programs (ex. KGRAPH.EXE, AVG.EXE).

               To  analyze a  specific  set  of  data,  simply  select  the
          appropriate  option from  the Archive  Menu and  press ENTER,  or
          press  the  corresponding  letter  associated  with  the  desired
          function.
           






                                                                         10

               BCAST produces two  types of  graphical charts depending  on
          what type of  data you are analyzing.   Linear data, such  as the
          10.7 cm solar radio  flux or the geomagnetic data, use the linear
          graphical functions.   Other datasets such as  the proton fluence
          or x-ray statistics  are analyzed  and graphed using  logarithmic
          graphical charts.  This significantly improves the detail  of the
          graphs. 
           
               There are several important functions  which can be executed
          while graphs of datasets  are displayed on-screen.  The  first is
          the ability  to move through  the graph, line by  line, using the
          left and right arrow keys.   As you use the arrow keys,  each new
          graph line you move to is highlighted.  Using the left arrow keys
          moves the  highlighted area  to the  left.   The right arrow  key
          moves the highlighted  area to the right.  In  addition, the date
          of  the  highlighted  graph  line  as  well as  the  exact  value
          producing that line  is displayed  at the bottom  of the  screen.
          This lets you examine each line of the graph in detail.

               Version  1.01  of BCAST  also  permits examination  of other
          parts of the database while viewing graphical images.  The PAGEUP
          and PAGEDOWN keys shift the graphs being viewed by  the number of
          days  defined  in  the BCAST.INI  configuration  file  (under the
          GRAPHSTEP command).  The default is 35 days, which results in the
          graphs shifting  half of a screen left or  right each time one of
          these keys is pressed.  This value  can be changed as you wish by
          editing the BCAST.INI  initialization file.  You  can force BCAST
          to move to  the beginning of  the database by  pressing the  HOME
          key.  You  can also  display the  last 70 days  contained in  the
          database by pressing the END key.
           
               Another  useful  function  which  can  be executed  while  a
          graphical  chart  is  displayed,  is  the  ability  to  save  the
          currently displayed graph to a text ASCII file on disk.   After a
          graph has been  saved to disk, you can print it  out on a printer
          or transfer them electronically to other locations.
           
               To invoke  this disk saving function, simply  press "S" (for
          "S"ave) while  any graphical chart  is displayed on-screen.   The
          screen will immediately be converted to ASCII format and saved to
          disk under the file name "GRAPH.TXT".   Each time you press  "S",
          the  graphical  chart  displayed  on-screen  is APPENDED  to  (or
          written to the end of) the GRAPH.TXT file.  This lets you compile
          an extensive set  of graphs simply by graphically analyzing those
          datasets  you need  and pressing  the  "S" key.   After  you have
          finished and  exited the BCAST program to the DOS prompt, you may
          display  the GRAPH.TXT  file, edit it  using your  favourite word
          processor, print  it out, transfer  it elsewhere, or  do whatever
          you see fit to do with it. 
           
               To continue  to view other  datasets, press  ENTER when  you
          have finished viewing a  specific graphical chart.  To  abort the






                                                                         11

          procedure and return to the archive menu, press the ESCape key. 


          Generating an Activity Summary Report

               This  option  of  the Archive  Menu  analyzes  the currently
          loaded  dataset  and   writes  a  summary  report  to   the  file
          "SUMMARY.TXT" on  disk.   All of  the indices  contained in  that
          dataset are written to the file,  along with the various warnings
          and  alerts which were  in effect,  etc.   This report-generation
          feature is most useful when data from  the SGDB reports are to be
          distributed throughout an  organization, or transferred to  other
          locations through e-mail  or modem.   This is also an  invaluable
          tool for producing  hard-copy summaries of  the dataset you  have
          loaded  in  memory.    It  may then  be  filed  away  for  future
          reference. 
           
               If the file  "SUMMARY.TXT" already  exists when you  execute
          this function, the contents of the  file will NOT be overwritten.
          All information is  appended to the  SUMMARY.TXT file.  You  will
          therefore be able to  store multiple summaries in a  single file,
          if so desired. 

               The  summary  file   is  created  in  the   current  working
          directory, not in the directory where the BCAST files are stored.


          Generating a Standard SGDB File & Modifying Records

               BCAST  has  the   ability  to  recreate  a   standard  Solar
          Geophysical Data  Broadcast format  file.   This is  an important
          function if you  need to modify  certain indices  or values of  a
          specific dataset in your archive. 
           
               To  use  this feature,  you must  have  a dataset  loaded in
          memory (either using the  first option of the Main  Menu [Process
          Data Set], or the second option of the Archive Menu [Load  a Data
          Set]).   After a  dataset has been loaded  in memory, a precisely
          formatted SGDB file can be created using this function. 
           
               Why would  you need  to create a  standard SGDB file  in the
          first  place?  There  are a number  of reasons.  You  may need to
          transfer a specific dataset you have in  your archive to a friend
          who is missing that  particular dataset.  You could  transfer the
          SUMMARY.TXT file, although this file is not in the correct format
          to be  processed by others using BCAST.  Using this function, you
          can recreate a copy of the SGDB  for any dataset in your archive,
          which  may then  be shared  with others  who are  using BCAST  to
          archive and analyze data.  
           
               One of the primary reasons for requiring this function is to
          permit  the  easy  modification  of  specific  datasets  in  your






                                                                         12

          database.  For example, lets assume that one of your datasets  in
          your database is corrupt.  Lets say  that one of your datasets in
          your database has  a bad value for  the 10.7 cm solar  radio flux
          and you  need to  correct it.   All you need  to do is  load that
          dataset into memory using  the second option of the  Archive Menu
          (Load a Data  Set), and generate  a standard SGDB  file for  that
          dataset.   The incorrect 10.7  cm solar radio  flux value will be
          written  to  the SGDB.TXT  file.    Simply exit  BCAST,  edit the
          SGDB.TXT file  to correct  the 10.7  cm solar  radio flux  value.
          Then  reload  BCAST,  reprocess  the SGDB.TXT  file  so  that the
          corrected dataset  is reloaded  into memory  (using the  "Process
          Data  Set"  option of  the  Main  Menu), and  save  the corrected
          dataset to  your database using the "Save Data Set" option of the
          Archive  Menu.    BCAST  will  detect the  corrupted  dataset  by
          realizing that the  dataset you have  loaded into memory has  the
          same date as the bad dataset  in your archive.  It will  then ask
          whether or not you want to overwrite the dataset.   By responding
          so  that  BCAST   overwrites  the  incorrect  dataset,   you  can
          effectively correct the bad solar flux value in your database.  
           
               This procedure can be  carried out for any of the  values in
          your database.   It is a quick  and easy method of  modifying any
          dataset  in  your  archive.   To  summarize,  simply extract  the
          dataset you  need to  correct to  a standard SGDB  file, edit  it
          using a word processor, reprocess it using BCAST and resave it to
          your  database  file  using  the  "O"verwrite option  which  will
          appear.
           
               When  you  produce an  SGDB-formatted  file using  this menu
          option,  BCAST will  not  overwrite  any  existing  data  in  the
          SGDB.TXT file if  it already exists  when you attempt to  produce
          the standard SGDB  file.  All  data is  appended to the  SGDB.TXT
          file.  You may therefore create multiple SGDB reports in a single
          file, if desired.  However, note that only the first SGDB  report
          in the file will be accepted and processed by BCAST.


          Dumping Data Sets to an ASCII File

               This powerful function lets you  dump the entire contents of
          your database to a text ASCII  file with the name "DATASETS.TXT".
          Use this function with  caution, since very large text  files can
          be created in the process.  
           
               During this procedure, BCAST runs through your database file
          multiple times, extracting each of the datasets from the database
          and saving them  to the  DATASETS.TXT file.   The resulting  text
          file is a  well-ordered, fully sorted, textual  representation of
          every set of data in your database.  
           
               This feature becomes particularly important when you need to
          analyze the data  externally using  something like a  statistical






                                                                         13

          computer program, a data plotter, or  a spreadsheet.  Also, since
          the data is dumped  in a pure ASCII format, you can edit the text
          file and extract only the information you require.

               Note that the  utility program "FIELDS" will  custom-extract
          almost any  piece of data in your  database file.  This  may be a
          more efficient method to use to  extract only certain portions of
          the database file.   Consult the  FIELDS manual (FIELDS.MAN)  for
          more information.


          Deleting Data Sets from the Database

               The  only  other  function  required  to   provide  complete
          management control  over your database  is a  method of  deleting
          datasets from your database.  That is the purpose of this Archive
          Menu function.  
           
               To  delete  a  specific dataset  from  your  archive, simply
          select this function.  BCAST will prompt  you for the date of the
          dataset to delete.   After typing in the date, BCAST  will search
          through the database  until it  finds a dataset  with a  matching
          date.  It will  then request confirmation to delete  the dataset.
          If you respond affirmatively, BCAST will delete the  dataset from
          your database.  If  you do not confirm deletion, BCAST will abort
          the procedure and leave your database untouched.  

               It  is  important  to  note that  after  you  have confirmed
          deletion, BCAST will delete ALL datasets with dates matching  the
          one you supplied,  not only  the one which  BCAST first  detects.
          Therefore, using this command you can delete accidental redundant
          datasets from your database (as can  occur if you explicitly save
          a dataset to your archive which already exists).


          Returning to the Main Menu

               You can return from the Archive Menu to the main menu at any
          time by either pressing the ESCape  key, or selecting the "Return
          to the  Main Menu" option.   When running  BCAST, the ESCape  key
          serves as the "abort" key.  It  will abort almost any process and
          return you to a menu. 


          Exiting BCAST and Returning to DOS

               To exit BCAST  and return to  the DOS prompt, either  select
          the "Exit Program"  command of the Main Menu or  press the ESCape
          key  at the Main  Menu prompt.  Either  method will terminate the
          program and return you to the DOS prompt. 






                                                                         14

          The Batch Processing Feature of BCAST

               BCAST  provides  a batch  processing  function which  can be
          invoked at  the command line.   This function  will automatically
          process large numbers  of SGDB report  files and archive them  to
          your  database.   All  SGDB files  processed  in this  manner are
          automatically and accurately saved to your database fully sorted.

               The  addition  of  the  full-screen  processing  feature  to
          version  1.01  of BCAST  (at the  "Process  Data Sets"  main menu
          option) makes this  feature less attractive as  a mass-processing
          function.  However, it is still a valuable feature for those  who
          want  to  process  datasets  directly  from the  command-line  as
          opposed  to  manually  selecting  the  files from  a  full-screen
          display.
           
               To  execute this command, simply  run BCAST with the command
          line parameter "-b" (or "-B", it  is not case sensitive) followed
          by the name(s)  of the files you  want to process and  archive to
          your database.  Wildcards in the filenames are permitted.  
           
               For  example,  to   create  (or  update)  a   database  file
          containing every SGDB  report in  your current directory,  simply
          type: "BCAST -B *.DLY" (excluding the parenthesis, of course) and
          press  ENTER.    BCAST will  automatically  begin  processing and
          archiving every file  containing the extension  ".DLY".  As  each
          file is processed,  its name  is displayed on-screen  so you  can
          monitor the progress of the processing.  It does not matter which
          order  you specify  files to be  processed.   BCAST automatically
          sorts the database so that all  added datasets are placed in  the
          proper position in the  archive.  Selecting the files  to process
          in a roughly preformatted  sequence will speed up  the processing
          phase.

               During  the  batch processing  phase,  if BCAST  attempts to
          process a dataset which  already exists in your  archive (ex.   a
          dataset with  the  same date),  BCAST  discards the  dataset  and
          processes  the next file.   You may therefore  process a group of
          files without needing  to worry  about accidentally processing  a
          duplicate dataset.  BCAST will not  batch process a dataset which
          already exist in your database.
           
               After all of the files have  been processed, BCAST loads and
          displays the title page, followed by the Main Menu, etc.

               Please note  that  the last  file processed  will reside  in
          memory while BCAST  executes.   As a result,  if you  graphically
          analyze  your  database  after  executing  the  batch  processing
          feature, the graphical charts will  be displayed according to the
          date  of  the last  dataset processed.    Consult the  section on
          "Loading  a Data  Set  from the  Database"  for more  information
          regarding this feature.  






                                                                         15


               This feature is only available to those who have  registered
          their copy of BCAST with us  (consult the file "REGISTER.DOC" for
          more information regarding registration procedures).  


          Alternate Methods of Executing BCAST

               You can  run BCAST and  load a  textual SGDB dataset  at the
          same time by executing BCAST  with an extra parameter  specifying
          the name of the file to load.  For example,  to execute BCAST and
          automatically  read in  the file  "SGDB.TXT" so that  the dataset
          contained in that file is loaded  in memory, simply execute BCAST
          using the  command: "BCAST  SGDB.TXT".   This will  run BCAST  as
          usual, but  will force it  to load in  the data contained  in the
          file  SGDB.TXT before the  main menu appears.   This may speed up
          the procedure for processing and analyzing the data set since you
          will not need to manually select the file using the "Process Data
          Sets" option of the main menu.

               Please note that  the dataset loaded  in this manner is  NOT
          archived to your  database.  It is  simply loaded in memory.   If
          you want to  archive the dataset to your  database, you will need
          to either  include the "-B"  (batch processing) parameter  on the
          command line or use  the "Process Data Sets"  option of the  main
          menu.
           
               This function may be used on unregistered copies of BCAST.


          Defragmenting the BCAST Database

               After the BCAST  database file (DATASETS.DAT) has  been used
          for some time, it may become  fragmented.  Fragmentation of files
          occurs when parts of the file are  stored over wide areas of your
          hard or floppy drive.  The speed with which BCAST is able to work
          with  the  database  will  slow  down  as  the  database  becomes
          fragmented.  The amount of work required by hard drives will also
          increase, since it  will need  to read sections  of the  database
          from widely spaced areas on your hard disk.

               A fragmented  database file is  not a critical  or dangerous
          condition.  It is simply an unnecessary and inefficient condition
          that can be easily remedied.

               To  defragment  the database  file,  execute the  batch file
          "DEFRAG.BAT" that has been included with version 1.02 of BCAST.
          Execute this batch file from within the directory where the BCAST
          database file (DATASETS.DAT) resides.  Type: "defrag" at your DOS
          command prompt.   This is a  quick and simple  way to  defragment
          your database  file and should  be done approximately  once every
          couple of months to maintain an efficient and fast database.