/*
 * Hash tables, conflicts are resolved by making each entry in the table
 * a linked list; if multiple sybols use the same hash they are just linked
 * together
 */

#include <string.h>
#include <stdio.h>
#include <memory.h>
#include "hash.h"


/*
 * Compute hash for use in internal hash tables.
 * Librarian uses a different hash algorithm and a different table
 * structure, see libs.c for details
 */
static unsigned int ComputeHash(char *string,int size)
{
  unsigned int len = strlen(string), rv;
  char *pe = len + string;
  const unsigned char blank = ' ';

  rv = len | blank;
  while(len--) {
    unsigned char cback = (*--pe) | blank;
    rv = ROTR(rv,2) ^ cback;
  }
  return(rv % size);
}
/*
 * Add an entry to the hash table.  Return previous entry if it exists
 */
HASHREC *AddHash(HASHREC **table, HASHREC *item)
{
	int size = *(((unsigned int *)table)-1);
  int index = ComputeHash(item->key,size);
  HASHREC **p;

  item->link = 0;

  if (*(p = &table[index])) {
    HASHREC *q = *p,*r = *p;
    while (q) {
			r = q;
      if (!strcmp(r->key,item->key))
				return(r);
			q = q->link;
		}
		r->link = item;
  }
  else
    *p = item;
  return(0);
}
/*
 * Find something in the hash table
 */
HASHREC **LookupHash(HASHREC **table, char *key)
{
	int size = *(((unsigned int *)table)-1);
  unsigned int index = ComputeHash(key,size);
  HASHREC **p;

  if (*(p = &table[index])) {
    HASHREC *q= *p;
    while (q) {
      if (!strcmp(q->key, key))
				return(p);
			p = *p;
			q=q->link;
		}
	}
	return(0);
}
/*
 * Create a hash table
 */
HASHREC **CreateHashTable(int size)
{
  unsigned int * rv = (unsigned int *)malloc(size * sizeof(HASHREC *) + sizeof(unsigned int));
	*rv++ = size;
  memset(rv,0,size * sizeof(HASHREC *));
  return((HASHREC **)rv);
}
/* 
 * Delete a hash table
 */
void RemoveHashTable(HASHREC ** t)
{
  free(((unsigned int *)t)-1);
}