// written by Ivo Bosticky, 17-7-94
// 8-10-94 - extended to play flc files

#ifndef flilib_h
#define flilib_h

#define fli_magic	0xAF11
#define flc_magic	0xaf12
#define prefix_id       0xf100
#define frame_magic	0xF1Fa

// fli file header
struct fli_header
	{
	unsigned long size;
	unsigned int magic;
	int	frames;
	int	width;
	int	height;
	int	depth;
	int	flags;
	int	speed;
	long	next;
	long	frit;
	char	reserved[102];
	};

// flc file header
struct flc_header
	{
	unsigned long size;
	unsigned int magic;
	int	frames;
	int	width;
	int	height;
	int	depth;
	int	flags;
	long	speed;
	char	reserved0[2];
	long	created;
	char	creator[4];
	long	updated;
	char	updater[4];
	int	aspectx;
	int	aspecty;
	char	reserved1[38];
	long	oframe1;
	long	oframe2;
	char	reserved[40];
	};

// my own fli header
struct	fli
	{
	int	frames;
	int	width;
	int	height;
	int	speed;
	int	current;
	long    crntoff;
	int	handle;
	};

/* description of a fli structure
Any of these variables can be used directly, by fliptr->variable where fliptr
is the pointer returned by the load_fli function.

To go to the first frame execute the following code:
	fliptr->current=0;
	fliptr->crntoff=(long)sizeof(fli);
(this only works if all of the fli was loaded into the ram)

The data can only be used if the fli was loaded with the RAM or possibly
the AUTO option.

Handle is equal to 0 if all of the fli was loaded into the ram.

byte offset	size	name	meaning
0		2	frames	Number of frames in fly, a maximum of 4000
2		2	width	Screen width (320)
4		2	height	Screen height (200)
6		2	speed	Number of video ticks between frames
8		2	current Current frame (=0 initilly)
10		4       crntoff	offset from begining to current frame (=14 initially)
14		2	handle  handle of the file if playing from disk
16		?	data	data for the frames (only if handle>1)
*/

struct	frame_header
	{
	unsigned long	size;
	unsigned int magic;
	int	chunks;
	char    expand[8];
	};

struct	chunk_header
	{
	unsigned long size;
	int	type;
	};

#define FLI_COLOR256	4
#define FLI_SS2		7
#define	FLI_COLOR	11
#define FLI_LC		12
#define FLI_BLACK	13
#define FLI_BRUN	15
#define FLI_COPY	16
#define FLI_PSTAMP	18

extern unsigned char * fli_pal;
// an array of 256*3 bytes which represent the 256 color indexes on
// rgb displays

extern int              fli_use_pal;
// if this flag is set to 1, the color palette fli_pal is not
// used by the flilib player (this is the default) and the fli
// player sends the colors to the vga port using BIOS
// if it is set to 0, the user has to use allocate fli_pal buffer
// and has to set the correct colors himself.

enum fli_source { RAM,DISK,AUTO };
// RAM forces load_fli to load the entire fli to memory and play it from ram
// DISK forces play from disk, (uses from 128 bytes up to just over 64Kb of ram)
// AUTO first tries to load file into memory then tries the disk option

fli *	load_fli(char *filename,fli_source playtype);
// returns pointer to the fli in memory
// or returns NULL if it didn't find the file or out of memory
// the file can be either a fli or flc


int	play_frame(fli *fliptr,char *dest,int sizex);
// plays a single frame and if it is the last frame, automatically
// sets the current and crntoff to the first frame
// fliptr is the pointer that load_fli returns
// dest is the memory buffer to play into, can be the screen of mode 0x13
// sizex is the width of the memory buffer (320)

void	close_fli(fli *fliptr);
// closes the handle used if playing from DISK
// frees up all the memory used by the fli


#endif //flilib_H
