//                         tstintvl.cc
//                                 -- by William T. Wyatt
//  This demonstration program exercises a few of the "interval arithmetic"
//  super_precision capabilities.

//              Copyright (c) 1997 William T. Wyatt, Jr.

#include "supintvl.cc"

int main ( int narg, char * args)
{
	super_interval :: setup ( 25, 10);	// 25 digits, decimal base

	super_interval a(0,1), b, c;
	super_precision sa;

	b = 1;
	cout << "a="; a.super_dump ();
	cout << "b="; b.super_dump ();
	c = a + b;
	cout << "c=a+b="; c.super_dump ();
	c = a - b;
	cout << "c=a-b="; c.super_dump ();
	c = a * b;
	cout << "c=a*b="; c.super_dump ();
	c = a / b;
	cout << "c=a/b="; c.super_dump ();
	c = pow ( a, 15);
	cout << "a^15="; c.super_dump ();

	int32 i;
	i = ( a == b);
	cout << "a==b = " << i << endl;
	i = ( a != b);
	cout << "a!=b = " << i << endl;
	i = ( a == a);
	cout << "a==a = " << i << endl;
	i = ( a != a);
	cout << "a!=a = " << i << endl;
	i = ( b == 1);
	cout << "b==1 = " << i << endl;
	i = ( b != 1);
	cout << "b!=1 = " << i << endl;
	i = ( 1 == b);
	cout << "1==b = " << i << endl;
	i = ( 1 != b);
	cout << "1!=b = " << i << endl;

	c = interval (1,1);
	a = exp ( c);
	cout << setprecision (25) << "exp(1,1)=" << a << endl;
	a = log ( a);
	cout << "log()=" << a << endl;
	a = sin ( c);
	cout << "sin(1,1)=" << a << endl;
	b = cos ( c);
	cout << "cos(1,1)=" << b << endl;
	a = pow(a,2) + b*b;
	cout << "sin^2 + cos^2 =" << a << endl;

	cout << "ptrs allocated=" << super_precision_pool_ptr::
			disclose_pool_allocation_count () << endl;
}
