//                          piq.cc
//                                 -- by William T. Wyatt
//  This demonstration program uses one of the Borwein-Borwein algorithms
//  to calculate pi.  This one has quintic convergence.

//              Copyright (c) 1997 William T. Wyatt, Jr.

#include "super.cc"

int main ( int narg, char * args)
{
	int i, j;

	cout << "Enter number of digits:";
	cin >> i;
	super_precision :: setup ( i, 10);
	super_precision x, z, y;
	super_precision s = 5 * ( sqrt ( (super_precision) 5) - 2);
	super_precision a = ((super_precision) 1) / 2, pival = pi ();

	for ( int n = 0; n < 14; n++)
	{
		// The algorithm is
		// x = 5 / s - 1;
		// z = ( x - 1)^2 + 7;
		// z = nthrt ( x * ( z + sqrt ( z^2 - 4 * x^3)) / 2, 5)
		// a = a * s^2 - 5^n * ( ( s^2 - 5) / 2 +
		//                   sqrt ( s * ( s^2 - 2 * s + 5)));
		// s = 25 / ( s * ( z + x / z + 1)^2);
		// And repeat.  The pi estimate is 1/a.

		// Let's write it with little effort to make it more efficient.
		x = 5 / s - 1;
		z = pow ( x - 1, 2) + 7;
		z = nthrt ( x * ( z + sqrt ( z * z - 4 * pow ( x, 3))) / 2, 5);
		y = s * s;
		a *= y;
		y = ( y - 5) / 2 + sqrt ( s * ( y - 2 * s + 5));
		for ( j = 0; j < n; j++)
		{
			y *= 5;
		}
		a -= y;
		s = 25 / ( s * pow ( z + x / z + 1, 2));

		cout << "pi=" << setprecision (500) << pival << endl;
		x = 1 / a;	// Calculate pi from a=1/pi.
		cout << "x =" << x << endl;

		for ( j = 0; j < i; j++)
		{
			if ( pival.get_digit ( j) != x.get_digit ( j)) break;
		}
		cout << "x and pi agree to " << j << " digits." << endl;

		cout << "Go again? (1=yes, 0=no)";
		cin >> j;
		if ( !j) break;
	}
	return 0;
}
