//--------------------------------------------------------------------------
//
//      EXAMPLE6.CPP: example for DOS multithreading library.
//      Copyright (c) J.English 1993.
//      Author's address: je@unix.brighton.ac.uk
//
//      Permission is granted to use copy and distribute the
//      information contained in this file provided that this
//      copyright notice is retained intact and that any software
//      or other document incorporating this file or parts thereof
//      makes the source code for the library of which this file
//      is a part freely available.
//
//--------------------------------------------------------------------------
//
//      This example is identical to the previous one, except that
//      it uses a monitor to protect against re-entrant DOS and BIOS
//      calls.  Note that we don't want DOS calls to be made while
//      we're inside the monitor, so "DOSlock" and "DOSunlock" are
//      used instead of "lock" and "unlock".
//
//--------------------------------------------------------------------------

#include <stdio.h>
#include <bios.h>
#include "threads.h"
#include "buffers.h"

BoundedBuffer<char> buffer (20);        // a buffer of 20 characters

class BIOSmonitor : public DOSMonitor
{
  public:
    char get ();
};

char BIOSmonitor::get ()
{
    DOSlock ();
    char c = bioskey(0) & 0xFF;
    DOSunlock ();
    return c;
}

BIOSmonitor bios;

class Example6a : public DOSThread
{
  public:
    Example6a ()            { }
    ~Example6a ();

  protected:
    virtual void main ();
};

void Example6a::main ()
{
    char c;
    for (;;)
    {   if (!buffer.get (c))
            return;
        putchar (c);
    }
}

Example6a::~Example6a ()
{
    wait ();
    fputs ("\nEnd of thread A\n", stdout);
}

class Example6b : public DOSThread
{
  public:
    Example6b ()            { }
    ~Example6b ();

  protected:
    virtual void main ();
};

void Example6b::main ()
{
    char c;
    for (;;)
    {   if (!buffer.get (c))
            return;
        putchar ('*');
    }
}

Example6b::~Example6b ()
{
    wait ();
    fputs ("\nEnd of thread B\n", stdout);
}

void main ()
{
    Example6a A;
    Example6b B;

    if (A.run ())
        puts ("Thread A started");
    if (B.run ())
        puts ("Thread B started");

    puts ("Press ESC to terminate");

    char c;
    for (;;)
    {   c = bios.get ();
        if (c == 0x1B)
        {   buffer.close ();
            puts ("\nTerminating...");
            break;
        }
        else
            buffer.put (c);
    }
}
