#include "sbar.h"
#include <dos.h>

ScrollBar::ScrollBar(loc p, ORIENT type, int l,
    int tot, int pg_size, int cur, int pat)
    {
    act = 0;
    pos = p;
    page_size = pg_size;
    direction = type;
    pattern = pat;
    len = l;
    current = cur;
//    if(tot < len)
//        tot = len;
    total_len = tot;
    e1 = new Element(loc(0, 0), NO_ELEMENT, BUTTON_BORDER, pattern);
    e2 = new Element(loc(0, 0), NO_ELEMENT, BUTTON_BORDER, pattern);
    }
////////////////////////////
int ScrollBar::get_screen_pos(int meter_len)
    {
    int l = (int)(((long)current * 10000 / (total_len - 1))
                   * (meter_len - 1 - !direction) / 10000);
    return l;
    }
////////////////////////////
void ScrollBar::meter_show(loc m, int meter_len, ORIENT direction,
    int p, int pattern)
    {
    Meter meter;
    meter.show(m, meter_len, direction, p, pattern, NO_BORDER);
    }
////////////////////////////
void ScrollBar::show()
    {
    int meter_len;
    loc m;
    if(direction == HORIZ)                        // Horizontal
        {
        if(len < 6)
            return;
        e1->set_rect(rect(pos, pos + loc(2, 1)));
        e2->set_rect(rect(pos.X + len - 2, pos.Y, pos.X + len, pos.Y + 1));
        m = loc(pos.X + 2, pos.Y);
        meter_len = len - 4;
        e1->set_type(LEFT_ELEMENT);
        e2->set_type(RIGHT_ELEMENT);
        }
    else             // Vertical
        {
        if(len < 3)
            return;
        e1->set_rect(rect(pos, pos + loc(2, 1)));
        e2->set_rect(rect(pos.X, pos.Y + len - 1, pos.X + 2, pos.Y + len));
        m = loc(pos.X, pos.Y + 1);
        meter_len = len - 2;
        e1->set_type(UP_ELEMENT);
        e2->set_type(DN_ELEMENT);
        }
    int p = get_screen_pos(meter_len);

    meter_show(m, meter_len, direction, p, pattern);

//    if(!act)
        {
	e1->show();
        e2->show();
        }
    act = 1;
    }
////////////////////////////
rect ScrollBar::bound()
    {
    loc corner = !direction ? loc(pos.X + len, pos.Y + 1)
                           : loc(pos.X + 2, pos.Y + len);
    return screenRect(rect(pos, corner));
    }
////////////////////////////
void ScrollBar::repose(rect new_coord)
    {
    act = 0;
    pos = new_coord.origin;
    if(direction == HORIZ)
        len = new_coord.width();
    else
        len = new_coord.height();
    }
////////////////////////////
int ScrollBar::mouse_in(loc where)
    {
    if(e1->mouse_in(where))
        return 1;
    if(e2->mouse_in(where))
        return 2;
    if(bound().contains(where))
        {
        int meter_len;
        if(direction == HORIZ)
            meter_len = len - 4;
        else
            meter_len = len - 2;
        int p = get_screen_pos(meter_len) + (!direction ? pos.X : pos.Y);
        if(direction == HORIZ)
            {
            p = screenXL(p);
            if(p < where.X)
                return 4;
            else
                return 3;
            }
        p = screenYT(p);
        if(p < where.Y)
            return 4;
        else
            return 3;

        }
    return 0;
    }
////////////////////////////
void ScrollBar::decrease()
    {
    global_i[0] = direction == HORIZ ? AC_HOME : AC_PG_UP;
    current = current - page_size > 0 ? current - page_size
                                      : 0;
    ::delay(200);
    show();
    }
/////////////////////////
void ScrollBar::increase()
    {
    global_i[0] = direction == HORIZ ? AC_END : AC_PG_DN;
    current = current + page_size < total_len
                ? current + page_size : total_len;
    ::delay(200);
    show();
    }
////////////////////////////
void ScrollBar::exe(int)
    {
    if(!act)
        return;
    while(1)
	{
	mouseShowCursor();
	get_event();       // Defined in ADDEVENT.H, ADDEVENT.CPP
	mouseHideCursor();
	if(e.what == MOUSEEVENT)    // it was mouse
	    {
            switch(mouse_in(e.where()))
                {
                case 1:             // e1 pressed.
		    e1->press();
		    ::delay(200);
		    e1->release();
                    e1->unhilite();
		    global_i[0] = direction == HORIZ ? AC_LEFT : AC_UP;
                    current = current > 0 ? current - 1 : 0;
                    show();
                    break;
                case 2:             // e2 pressed.
		    e2->press();
		    ::delay(200);
		    e2->release();
                    e2->unhilite();
		    global_i[0] = direction == HORIZ ? AC_RIGHT : AC_DOWN;
                    current = current < total_len ? current + 1 : total_len;
                    show();
		    break;
                case 3:
                    decrease();
                    global_i[0] = action_type;
                    global_num = current + 1;
                    return;
                case 4:
                    increase();
                    global_i[0] = action_type;
                    global_num = current + 1;
                    return;
                default:             // Outside.
                    global_i[0] = 0;
                    break;
                }
	    global_num = current;
	    return;
	    }
	else
	    {
	    switch(e.key)
		{
                case EVENT_F10:
		    mouseShowCursor();
		    global_i[0] = 0;
                    global_num = current + 1;
		    return;
		case EVENT_F1: return;
		case EVENT_ESC:
		case EVENT_TAB:
		case EVENT_F6:
		case EVENT_ALT_F3:
		case EVENT_ALT_F4:
		case EVENT_ALT_TAB:
                case EVENT_RETURN:
		    mouseShowCursor();
		    global_i[0] = action_type;
                    global_num = current + 1;
		    return;
                case EVENT_LEFT:
                case EVENT_UP:
                    global_i[0] = direction == HORIZ ? AC_LEFT : AC_UP;
                    current = current > 0 ? current - 1 : 0;
                    show();
                    break;
                case EVENT_RIGHT:
                case EVENT_DN:
		    global_i[0] = direction == HORIZ ? AC_RIGHT : AC_DOWN;
                    current = current < total_len ? current + 1 : total_len;
                    show();
                    break;
		case EVENT_F2:
		default:
		    break;                   // return;
		}
            global_num = current;
	    }
	 }

    }
////////////////////////////
/*
void main()
    {
    if(!init_KNOW_HOW())
        return;
    setfillstyle(SOLID_FILL, pColorSet->colors.BAK_COLOR);
    bar(0, 0, getmaxx(), getmaxy());

    ScrollBar s(loc(10, 10), HORIZ, 40, 100, 10, 50, 16);
    s.show();
    ScrollBar s1(loc(60, 5), VERT, 15, 100, 10, 40, 16);
    s1.show();

    s.exe();
    s1.exe();

    close_KNOW_HOW();
    closegraph();
    }
*/