/*   REMEMBER.H  Class wich can remember area under rectangle
     and then restore it     */

#ifndef __REMEMBER
#define __REMEMBER

#include <geom.h>
#include <graphics.h>
#include <alloc.h>


class Remember     // remembers area under frame or pixels width
    {
    protected:
	void* image1;    // sides of rectangle are stored here
	void* image2;
	void* image3;
	void* image4;

    public:
	Remember() { image1 = image2 = image3 = image4 = NULL; }
	~Remember()
	    {
	    delete image4;
	    delete image3;
	    delete image2;
	    delete image1;
	    }
	void getimage(rect where, int pixels);
	void putimage(rect where, int pixels, int put);
	void rem()
	    {
	    delete image4;
	    delete image3;     // clear
	    delete image2;
	    delete image1;
	    image1 = image2 = image3 = image4 = NULL;
	    }
    };

#endif __REMEMBER