#include <math.h>
#include <alloc.h>
#include "paint.h"


Stack::Stack()
    {
    used = 0;
    total = R_STEP;
    if((list = (RInfo*)malloc(R_STEP * sizeof(RInfo))) == NULL)
	kh_error_code = KH_MEMORY_ERROR;
    }
//////////////
Stack::~Stack()
    {
    delete list;
    }
/////////////
void Stack::push(RInfo* r)
    {
    if(total < used)
	list = (RInfo*)realloc(list,
			   (total += R_STEP) * sizeof(RInfo));
    list[used].center = r->center;
    list[used].angle = r->angle;
    used++;
    }
////////////
void Stack::pop()
    {
    if(total - used > 2 * R_STEP)
	list = (RInfo*)realloc(list,
	    (total -= R_STEP) * sizeof(RInfo));
    used--;
    }
////////////
void Stack::flash()
    {
    used = 0;
    list = (RInfo*)realloc(list, (total = R_STEP) * sizeof(RInfo));
    }

/////////////////////////////////////////////////
/////////////////////////////////////////////////
Paint::Paint() : BGI_Font(), Trigonometry()
    {
    zoom = loc(100, 100); add_zoom = loc(100, 100);
    lt = add_scroll = loc(0, 0); fill = OFF; center = loc(0, 0);
    alpha = 0; kh_error_code = KH_SUCCESS; R_STACK = OFF;
    r_stack = new Stack(); mirror = 0;
    }
//////////////////////////
void Paint::rotate(loc c, int a)
    {
    center = c;
    alpha = a;
    if(R_STACK == ON)
	{
	RInfo r;
	r.center = c;
	r.angle = a;
	r_stack->push(&r);
	}
    }
/////////////
loc Paint::rot(int x, int y)
    {
    int cx = center.X;
    int a = alpha;
    if(mirror > 0)
	{
	cx = mirror + mirror - cx;
	a = -a;
	}
    int x1;
    x1 = cx + (long)(x - cx) * cos(a) / 1000
	+ (long)(y - center.Y) * sin(a) / 1000;
    y = center.Y - (long)(x - cx) * sin(a) / 1000
	+ (long)(y - center.Y) * cos(a) / 1000;

    return loc(x1, y);
    }
/////////////////////////
loc Paint::transform(int x, int y)
    {
    if(mirror > 0)
	x = mirror + mirror - x;
    loc from(x, y);
    if(R_STACK == OFF)
	from = rot(x, y);
    else
	for(int i = 0; i < r_stack->used; i++)
	    {
	    alpha = r_stack->list[i].angle;
	    center = r_stack->list[i].center;
	    from = rot(from.X, from.Y);
	    }
    loc l = lt - add_scroll;

    return loc((long)(from.X + l.X) * zoom.X / 100,
	       (long)(from.Y + l.Y) * zoom.Y / 100);
    }
////////////////////
