#include <stdlib.h>
#include "khpxtab.h"
#include "editl.h"
#include "image_p.h"

#define min(x,y) (x>y)?y:x
#define max(x,y) (x<y)?y:x


KH_PX_Table::KH_PX_Table(rect coordinates,   // Screen cells
	       char* tabName,                // Table name
	       char* fName,                  // File for swapping
	       char* h,                      // Header text
	       int s,                        // Shadow, pixels
	       BORDERS b_type,               // Border type
	       BORDERS hdr_b_type,           // Border around header
	       int res,                      // Resize status
	       int hdr_pat,                  // Attention! No window pattern.

// Use last 3 arguments for creating new table.
	       int fNo,            // Number of fields in table
	       char** fields,      // Fields names array
	       char** types)       // Fields types array

	    : KH_AbstractTable(coordinates, fName, h, s,
	       /*col*/ -1, /*wid*/ NULL, /*colNum*/ NULL,
	       b_type, hdr_b_type, res, /*pat*/ 0, hdr_pat),
	   KH_PXTable(tabName, /*idx*/ 0, fNo, fields, types)
    {
    nColumns = getColumnNumber();
    colNumbers = new int[nFlds + 1];
    for(int i = 0; i < nFlds; i++)
	colNumbers[i] = i;
    iColWidth = new int[nFlds + 1];
    for(xCurs = 0; xCurs < nFlds; xCurs++)
	{
	iColWidth[xCurs] = getFieldMaxWidth();
	}
    xCurs = 0;
    }
///////////////////////////
int KH_PX_Table::getFieldMaxWidth()
    {
    int w;
    char type[46];
    pxErr = PXRecGet(tblHandle, recHandle);
    pxErr = PXFldType(tblHandle, colNumbers[xCurs] + 1, 26, type);
    switch(type[0])
	{
	case '$':
	case 'N': w = 10; break;
	case 'S': w = 5; break;
	case 'D': w = 12; break;
	case 'A': w = atoi(type + 1) + 2; break;
	default: w = 5; break;
	}
    return w;
    }
///////////////////////////
long KH_PX_Table::RecordNumber()
    {
    return nRecords;
    }
//////////////////////////////
int KH_PX_Table::getColumnNumber()
    {
    return nFlds;          // Number of fields in record
    }
//////////////////////////////
void KH_PX_Table::getFieldName(char* name, int n)
    {
    pxErr = PXFldName(tblHandle, n, 26, name);
    }
//////////////////////////////
void KH_PX_Table::showField(int sx, int x, int y, int flag, int )
    {
    pxErr = PXRecGoto(tblHandle, y + 1);
    pxErr = PXRecGet(tblHandle, recHandle);
    setFld(x + 1);
    char buf[255];
    if(TranslateField(buf) != KH_BLOB)
	{
	rect r = user_screen();
	int endx = r.corner.X < r.origin.X + screenXL(sx + iColWidth[x] - 1)
	    ? r.corner.X : r.origin.X + screenXL(sx + iColWidth[x] - 1);
	setviewport(r.origin.X + screenXL(sx + 1),
		    r.origin.Y,
		    endx, r.corner.Y, 1);

	if(flag)
	    bar(2, screenYT(y - yStart + 1) + 2,
		endx - 2, screenYT(y - yStart + 2) - 2);
	setcolor(BLACK);
	settextjustify(LEFT_TEXT, CENTER_TEXT);
	outtextxy(0, screenYT(y - yStart + 1) + pScreenSet->cell_height / 2,
	    buf);
	setviewport(0, 0, getmaxx(), getmaxy(), 1);
	}
    }
//////////////////////////////
int KH_PX_Table::check_type(int type, char* string)
    {
    if(type == KH_ALL)
	return 1;
    char** endptr;
    if((type & KH_NUMBER) || (type & KH_MONEY))
	{
	strtod(string, endptr);
	if(*endptr - string != strlen(string))
	    return 0;
	return 1;
	}
    if(type & KH_STRING)
	{
	return 1;
	}
    if(type & KH_DATE)
	{
	char buf[20];
	strcpy(buf, string);
	buf[2] = '\0';
	int dd = atoi(buf);
	buf[5] = '\0';
	int mm = atoi(buf + 3);
	int yy = atoi(buf + 6);
	TDATE td;

	if((pxErr = PXDateEncode(mm, dd, yy, &td)) == PXSUCCESS)
	    return 1;
	return 0;
	}
    if(type & KH_SHORT)
	{
	if(strtod(string, endptr) == (short)atoi(string))
	    if(*endptr - string == strlen(string))
		return 1;
	return 0;
	}

    if(type & KH_BLOB)
	return 1;
    return 0;
    }
//////////////////////////
void KH_PX_Table::editField()
    {
    pxErr = PXRecGoto(tblHandle, yCurs + 1);
    pxErr = PXRecGet(tblHandle, recHandle);
    setFld(colNumbers[xCurs] + 1);
    char buf[255];
    int type;
    rect r = user_screen();

    if((type = TranslateField(buf)) != KH_BLOB)
	{
	setviewport(r.origin.X, r.origin.Y, getmaxx(), getmaxy(), 1);
	EditLine* editl
	    = new EditLine(loc(0, 0),
	          min(iColWidth[colNumbers[xCurs]], rectangle.width() - 3),
		  getFieldMaxWidth() - 2, BUTTON_BORDER, 0, 1);
	editl->put_string(buf);
	editl->show();
	do {
	     editl->exe();
	   } while(!check_type(type, global[global_num]));

	strcpy(buf, global[global_num]);
	delete editl;

	setviewport(0, 0, getmaxx(), getmaxy(), 1);

	r.origin.Y += pScreenSet->cell_height;
	line_table(r);
	KH_PXFLD f(buf);
	switch(type)
	    {
	    case KH_NUMBER:
	    case KH_MONEY:
		f.type = KH_NUMBER;
		f.n = strtod(buf, NULL);
		break;
	    case KH_STRING:
		break;
	    case KH_DATE:
		buf[2] = '\0';
		int dd = atoi(buf);
		buf[5] = '\0';
		int mm = atoi(buf + 3);
		int yy = atoi(buf + 6);
		TDATE td;
		pxErr = PXDateEncode(mm, dd, yy, &td);
		f.type = KH_DATE;
		f.date = td;
		break;
	    case KH_SHORT:
		f.type = KH_SHORT;
		f.sh = atoi(buf);
		break;
	    default:         // BLOB put operations are supplied in ASK MANAGER
		break;
	    }
	putField(&f);
	pxErr = PXRecUpdate(tblHandle, recHandle);

	}
    setfillstyle(SOLID_FILL, WHITE);

    showField(xPos, colNumbers[xCurs], yCurs, 1, getFieldType(colNumbers[xCurs], yCurs));
    mouseShowCursor();
    }
//////////////////////////////
int KH_PX_Table::searchField(int ask)
    {
    int ret = 0;
    pxErr = PXRecGoto(tblHandle, yCurs + 1);
    pxErr = PXRecGet(tblHandle, recHandle);
    setFld(colNumbers[xCurs] + 1);

    char buf[255];
    int type;
    rect r = user_screen();

    if((type = TranslateField(buf)) != KH_BLOB)
	{
	pxErr = PXRecBufEmpty(recHandle);
	if(ask)
	    {
	    setviewport(r.origin.X, r.origin.Y, getmaxx(), getmaxy(), 1);
	    EditLine* editl
		= new EditLine(loc(0, 0),
                  min(iColWidth[colNumbers[xCurs]], rectangle.width() - 3),
		  getFieldMaxWidth() - 2, BUTTON_BORDER, 0, 1);
	    editl->put_string(buf);
	    editl->show();
	    do {
		 editl->exe();
	       } while(!check_type(type, global[global_num]));

	    setviewport(0, 0, getmaxx(), getmaxy(), 1);

	    r.origin.Y += pScreenSet->cell_height;
	    line_table(r);

	    strcpy(buf, global[global_num]);
	    delete editl;
	    mouseShowCursor();
	    }
	KH_PXFLD f(buf);
	switch(type)
	    {
	    case KH_NUMBER:
	    case KH_MONEY:
		f.type = KH_NUMBER;
		f.n = strtod(buf, NULL);
		break;
	    case KH_STRING:
		break;
	    case KH_DATE:
		buf[2] = '\0';
		int dd = atoi(buf);
		buf[5] = '\0';
		int mm = atoi(buf + 3);
		int yy = atoi(buf + 6);
		TDATE td;
		pxErr = PXDateEncode(mm, dd, yy, &td);
		f.type = KH_DATE;
		f.date = td;
		break;
	    case KH_SHORT:
		f.type = KH_SHORT;
		f.sh = atoi(buf);
		break;
	    default:         // BLOB
		break;
	    }
	putField(&f);
	if((pxErr = PXSrchFld(tblHandle, recHandle, fldHandle, SEARCHNEXT))
	    == PXSUCCESS)
	    {
	    pxErr = PXRecNum(tblHandle, &(RECORDNUMBER)yCurs);
	    yCurs--;
	    yStart = yCurs;
	    yPos = 0;
	    ret = 1;
	    }
	}
    setfillstyle(SOLID_FILL, WHITE);

    return ret;
    }
//////////////////////////////
void KH_PX_Table::saveTable()
    {
    pxErr = PXSave();
    }
//////////////////////////////
void KH_PX_Table::insRecord()
    {
    pxErr = PXRecGoto(tblHandle, yCurs + 1);
    pxErr = PXRecBufEmpty(recHandle);
    if(yCurs == nRecords - 1)
	pxErr = PXRecAppend(tblHandle, recHandle);
    else
	pxErr = PXRecInsert(tblHandle, recHandle);
    if(pxErr == PXSUCCESS)
	nRecords++;
    }
//////////////////////////////
void KH_PX_Table::delRecord()
    {
    pxErr = PXRecGoto(tblHandle, yCurs + 1);
    if(yCurs != nRecords - 1 && (pxErr = PXRecDelete(tblHandle)) == PXSUCCESS)
	nRecords--;
    }
//////////////////////////////
void KH_PX_Table::touch(int )
    {
    delete global[0];
    global[0] = strdup(KH_PXTable::fileName);
    global_num = nFlds;
    char buf[255];
    for(int i = 1; i <= global_num; i++)
        {
        setFld(i);
        delete global[i];
        global_i[i] = TranslateField(buf);
        global[i] = strdup(buf);
	}
    delete global[global_num + 1];
    global[global_num + 1] = strdup("KHPXTAB");
    }
//////////////////////////////
/*
void main()
    {
    if(!init_KNOW_HOW())
	return;
    if(PXInit() != PXSUCCESS)
	return;

    setfillstyle(SOLID_FILL, pColorSet->colors.BAK_COLOR);
    bar(0, 0, getmaxx(), getmaxy());

    KH_PX_Table w(rect(20, 2, 78, 24), "demo.db", "window.pcy",
	"",
	//" KNOW-HOW 4.x",
	3, SHOW_BORDER,
	NO_BORDER, //SHOW_BORDER,
	0, 19);

    w.show_window();
    w.exe();
    w.hide();

    PXExit();
    close_KNOW_HOW();
    closegraph();
    }
*/