#include "graf.h"

void Graf::show(int* x, int* y, int numpoints, int x0, int y0, int no)
    {
    int bar_no = 0;
    for(int num = 0; num < no; num++)
	if(line_type == BAR_GRAF || line_type == BAR_3D_GRAF)
	    bar_no++;
    int i;
    drawTool->setcolor(attr);
    drawTool->setlinestyle(SOLID_LINE, 1, 1);

    switch(line_type)
	{
	case LINE_GRAF:
	    drawTool->moveto(x0 + x[0], y0 - y[0]);
	    for(i = 0; i < numpoints; i++)
		drawTool->lineto(x0 + x[i], y0 - y[i]);
	    break;
	case MARKER_GRAF:
	    drawTool->moveto(x0 + x[0], y0 - y[0]);
	    for(i = 0; i < numpoints; i++)
		show_marker(marker_type, loc(x0 + x[i], y0 - y[i]),
					     attr, size);
	    break;
	case COMBINED_GRAF:
	    drawTool->moveto(x0 + x[0], y0 - y[0]);
	    for(i = 0; i < numpoints; i++)
		drawTool->lineto(x0 + x[i], y0 - y[i]);

	    drawTool->moveto(x0 + x[0], y0 - y[0]);
	    for(i = 0; i < numpoints; i++)
		show_marker(marker_type, loc(x0 + x[i], y0 - y[i]),
					     attr, size);
	    break;

	case BAR_GRAF:
	    drawTool->setfillstyle(fill, bak);
	    for(i = 0; i < numpoints; i++)
		{
		int st, en;
		st = x0 + x[i] + size * bar_no;
		en = x0 + x[i] + size + size * bar_no;
		st = st < 0 ? 0 : st;

		drawTool->bar3d(st, y0 - y[i], en, y0, 0, ON);
		}
		break;
	case BAR_3D_GRAF:
	    setfillstyle(fill, bak);
	    for(i = 0; i < numpoints; i++)
		{
		int st, en;
		st = x0 + x[i] + size * bar_no;
		en = x0 + x[i] + size + size * bar_no;
		st = st < 0 ? 0 : st;

		drawTool->bar3d(st, y0 - y[i], en, y0, size / 2, ON);
		}
	    break;
	case STACKED_BAR_GRAF:
	    drawTool->setfillstyle(fill, bak);
	    for(i = 0; i < numpoints; i++)
		{
		int st, en, flag;
		if(0 != y[4 * i + 2])
		    {
		    st = x0 + x[i] - size;
		    en = x0 + x[i];
		    flag = 0;
		    }
		else
		    {
		    st = x0 + x[i];
		    en = x0 + x[i] + size;
		    flag = 1;
		    }
		st = st < 0 ? 0 : st;

		if(!flag)
		    drawTool->bar3d(st, y0 - y[4 * i + 2],
			en, y0 - y[4 * i], size / 2, OFF);
		else
		    drawTool->bar3d(st, y0 - y[4 * i + 3],
			en, y0 - y[4 * i + 1], size / 2, ON);
		}
	    break;

	}
    }
/////////////////////////////
void Graf::show_marker(int type, loc pos, int attr, int size)
    {
    drawTool->setcolor(attr);
    drawTool->setfillstyle(SOLID_FILL, attr);
    switch(type)
	{
	case BAR:
	    int points[] = { pos.X - size, pos.Y - size,
			     pos.X + size, pos.Y - size,
			     pos.X + size, pos.Y + size,
			     pos.X - size, pos.Y + size,
			     pos.X - size, pos.Y - size };
	    drawTool->fillpoly(4, points);
	    break;
	case CIRCLE:
	    int points9[] = { pos.X - size, pos.Y,
			     pos.X - size/2, pos.Y - size,
			     pos.X + size/2, pos.Y - size,
			     pos.X + size, pos.Y,
			     pos.X + size/2, pos.Y + size,
			     pos.X - size/2, pos.Y + size,
			     pos.X - size, pos.Y };
	    drawTool->fillpoly(7, points9);
	    break;
	case TRIANGLE:
	    int points7[] = { pos.X - size, pos.Y + size,
			     pos.X + size, pos.Y + size,
			     pos.X, pos.Y - size,
			     pos.X - size, pos.Y + size };
	    drawTool->fillpoly(4, points7);
	    break;
	case STAR5:
	    int points1[] = { pos.X - 2 * size / 3, pos.Y + size,
			      pos.X, pos.Y + size / 3,
			      pos.X + 2 * size / 3, pos.Y + size,
			      pos.X + size / 2, pos.Y + size / 4,
			      pos.X + size, pos.Y - size / 3,
			      pos.X + size / 3, pos.Y - size / 3,
			      pos.X, pos.Y - size,
			      pos.X - size / 3, pos.Y - size / 3,
			      pos.X - size, pos.Y - size / 3,
			      pos.X - size / 2, pos.Y + size / 4,
			      pos.X - 2 * size / 3, pos.Y + size
			      };
	    drawTool->fillpoly(11, points1);
	    break;
	case STAR6:
	    int points2[] = { pos.X, pos.Y - size,
			      pos.X + size / 2, pos.Y - size / 2,
			      pos.X + size, pos.Y - size / 2,
			      pos.X + 3 * size / 4, pos.Y,
			      pos.X + size, pos.Y + size / 2,
			      pos.X + size / 2, pos.Y + size / 2,
			      pos.X, pos.Y + size,
			      pos.X - size / 2, pos.Y + size / 2,
			      pos.X - size, pos.Y + size / 2,
			      pos.X - 3 * size / 4, pos.Y,
			      pos.X - size, pos.Y - size / 2,
			      pos.X - size / 2, pos.Y - size / 2,
			      pos.X, pos.Y - size };
	    drawTool->fillpoly(13, points2);
	    break;
	case NONE:
	    drawTool->putpixel(pos.X, pos.Y);
	    break;
	case CROSS:
	    int points8[] = { pos.X - size/2, pos.Y - size,
			     pos.X + size/2, pos.Y - size,
			     pos.X + size/2, pos.Y + size,
			     pos.X - size/2, pos.Y + size,
			     pos.X - size/2, pos.Y - size };
	    drawTool->fillpoly(5, points8);
	    int points10[] = { pos.X - size, pos.Y - size/2,
			     pos.X + size, pos.Y - size/2,
			     pos.X + size, pos.Y + size/2,
			     pos.X - size, pos.Y + size/2,
			     pos.X - size, pos.Y - size/2 };
	    drawTool->fillpoly(5, points10);
	    break;
	case X_CROSS:
	    int points3[] = { pos.X, pos.Y - size / 2,
			      pos.X + size / 2, pos.Y - size,
			      pos.X + size, pos.Y - size / 2,
			      pos.X + size / 2, pos.Y,
			      pos.X + size, pos.Y + size / 2,
			      pos.X + size / 2, pos.Y + size,
			      pos.X, pos.Y + size / 2,
			      pos.X - size / 2, pos.Y + size,
			      pos.X - size, pos.Y + size / 2,
			      pos.X - size / 2, pos.Y,
			      pos.X - size, pos.Y - size / 2,
			      pos.X - size / 2, pos.Y - size,
			      pos.X, pos.Y - size / 2 };
	    drawTool->fillpoly(13, points3);
	    break;

	case DIAMOND:
	    int points4[] = { pos.X, pos.Y - size,
			      pos.X + size, pos.Y,
			      pos.X, pos.Y + size,
			      pos.X - size, pos.Y,
			      pos.X, pos.Y - size };
	    drawTool->fillpoly(5, points4);
	    break;
	case TRIANGLE2:
	    int points5[] = { pos.X - size, pos.Y + size,
			     pos.X + size, pos.Y + size,
			     pos.X, pos.Y - size,
			     pos.X - size, pos.Y + size };
	    drawTool->drawpoly(4, points5);
	    break;
	case BAR2:
	    drawTool->rectangle(pos.X - size, pos.Y - size, pos.X + size, pos.Y + size);
	    break;
	case CIRCLE2:
	    int points11[] = { pos.X - size, pos.Y,
			     pos.X - size/2, pos.Y - size,
			     pos.X + size/2, pos.Y - size,
			     pos.X + size, pos.Y,
			     pos.X + size/2, pos.Y + size,
			     pos.X - size/2, pos.Y + size,
			     pos.X - size, pos.Y };
	    drawTool->drawpoly(7, points11);
	    break;
	default:
	    break;
	}
    }

/*
void main()
    {
    int gdriver = DETECT, gmode;
    initgraph(&gdriver, &gmode, "");

    drawTool = new KH_Paint();   // See KHPAINT.H
    Graf g;
    g.show_marker(BAR, loc(20, 100), YELLOW, 8);
    g.show_marker(CIRCLE, loc(40, 100), YELLOW, 8);
    g.show_marker(TRIANGLE, loc(60, 100), YELLOW, 8);
    g.show_marker(STAR5, loc(80, 100), YELLOW, 8);
    g.show_marker(NONE, loc(100, 100), YELLOW, 8);
    g.show_marker(STAR6, loc(120, 100), YELLOW, 8);
    g.show_marker(CROSS, loc(140, 100), YELLOW, 8);
    g.show_marker(X_CROSS, loc(160, 100), YELLOW, 8);
    g.show_marker(DIAMOND, loc(180, 100), YELLOW, 8);
    g.show_marker(TRIANGLE2, loc(200, 100), YELLOW, 8);
    g.show_marker(BAR2, loc(220, 100), YELLOW, 8);
    g.show_marker(CIRCLE2, loc(240, 100), YELLOW, 8);
    delete drawTool;

    closegraph();
    }
*/

/*
void main()
    {
    int gdriver = DETECT, gmode;
    initgraph(&gdriver, &gmode, "");

    drawTool = new KH_Paint();   // See KHPAINT.H

    int x[] = { -50, -25, 0, 25, 50 };
    int y[] = { -50, 30, -10, 20, 0 };

    Graf g(BAR, LINE_GRAF, LIGHTGREEN, RED, 4, SLASH_FILL);
    g.show(x, y, 5, 60, 60);

    setviewport(120, 0, 240, 240, 1);
    g.set_type(BAR, MARKER_GRAF, LIGHTGREEN, RED, 4, SLASH_FILL);
    g.show(x, y, 5, 60, 60);

    setviewport(240, 0, 360, 240, 1);
    g.set_type(BAR, COMBINED_GRAF, LIGHTGREEN, RED, 4, SLASH_FILL);
    g.show(x, y, 5, 60, 60);

    setviewport(360, 0, 480, 240, 1);
    g.set_type(BAR, BAR_GRAF, LIGHTGREEN, RED, 12, SLASH_FILL);
    g.show(x, y, 5, 60, 60);

    setviewport(500, 0, 630, 240, 1);
    g.set_type(BAR, BAR_3D_GRAF, LIGHTGREEN, RED, 12, SLASH_FILL);
    g.show(x, y, 5, 60, 60);

    delete drawTool;
    closegraph();
    }
*/