#include <stdlib.h>
#include "global.h"
#include "filter.h"
#include "simple.h"

#include <stdio.h>

int w[10] = { -1, -1, -1, -1, -1, -1, -1, -1, -1 };
		  // color - weight
int used1 = 0;
////////////////////////
void filter(int** kernel, rect coord)
    {
    FILE* file;                                // We can not immediately show
    if((file = fopen("_filter", "w+b")) == NULL)  // changes on screen, to avoid
	return;                                // side effects we use file
    int sum, ksum;
    for(int y = coord.origin.Y + 1; y < coord.corner.Y - 1; y++)
	for(int x = coord.origin.X + 1; x < coord.corner.X - 1; x++)
	    {
	    sum = 0, ksum = 0;
	    for(int j = 0; j < 3; j++)
		for(int i = 0; i < 3; i++)
		    {
		    sum = sum + kernel[i][j]
			* getpixel(x + i - 1, y + j - 1);
		    ksum = ksum + kernel[i][j];
		    }
	    fputc(sum / ksum, file);
	    }
    rewind(file);
    for(y = coord.origin.Y + 1; y < coord.corner.Y - 1; y++)
	for(int x = coord.origin.X + 1; x < coord.corner.X - 1; x++)
	    putpixel(x, y, fgetc(file));    // now redraw work area
    fclose(file);
    unlink("_filter");
    }
////////////////////////
inline int mini(int x, int y)
    {
    return (x > y) ? y : x;
    }
////////////////////////
void add(int color)
    {
    for(int i = 0; i < used1; i++)
	{
	if(w[i] == color)
	    return;
	}
    w[used1] = color;
    used1++;
    }
////////////////////////
int near_color(int color)
    {
    register int i;
    register int delta = 16;
    register int d;
    register int s;
    for(i = 0; i < used1; i++)
	{
	if((d = mini(abs(color - w[i]), delta)) != delta)
	    {
	    delta = d;
	    s = i;
	    }
	}
    return w[s];
    }
////////////////////////
void color_filter(int* kernel, rect coord)
    {
    FILE* file;                                // We can not immediately show
    if((file = fopen("_filter", "w+b")) == NULL)  // changes on screen, to avoid
	return;                                // side effects we use file
    int sum, ksum, color;

    for(int y = coord.origin.Y + 1; y < coord.corner.Y - 1; y++)
	for(int x = coord.origin.X + 1; x < coord.corner.X - 1; x++)
	    {
	    sum = 0, ksum = 0; used1 = 0;
	    for(int j = 0; j < 3; j++)
		for(int i = 0; i < 3; i++)
		    {
		    sum = sum + kernel[i + 3 * j]
			* (color = getpixel(x + i - 1, y + j - 1));
		    ksum = ksum + kernel[i + 3 * j];
		    add(color);
		    }
	    fputc(near_color(sum / ksum), file);
	    }
    rewind(file);
    for(y = coord.origin.Y + 1; y < coord.corner.Y - 1; y++)
	for(int x = coord.origin.X + 1; x < coord.corner.X - 1; x++)
	    putpixel(x, y, fgetc(file));    // now redraw work area
    fclose(file);
    unlink("_filter");
    }
////////////////////////
void dither_BW(int* threshold, rect coord, loc dim)
    {
    int max_color = getmaxcolor();
    for(int y = coord.origin.Y; y < coord.corner.Y; y++)
	{
	int j = ((y - 1) % dim.Y) + 1;
	for(int x = coord.origin.X; x < coord.corner.X; x++)
	    {
	    int i = ((x - 1) % dim.X) + 1;
	    if(getpixel(x, y) > threshold[i + j * dim.X] * max_color / (dim.X * dim.Y))
		putpixel(x, y, global_i[6]);
	    else
		putpixel(x, y, global_i[7]);
	    }
	}
    }
//////////////////////////
void dither_BW(int* threshold, rect coord, loc dim,
			  GrafBuffer* buf)
    {
    int max_color = getmaxcolor();

    int end_bound = coord.corner.Y / buf->bound_size.Y + 1;
    int start_bound = coord.origin.Y / buf->bound_size.Y;

    for(int bound = start_bound; bound < end_bound; bound++)
	{
	buf->get_bound(bound);
	int s_y = (bound > start_bound) ? 0
	      : coord.origin.Y - bound * buf->bound_size.Y;  // y coord inside image
	int e_y = (bound < end_bound - 1) ? buf->bound_size.Y
	      : coord.corner.Y - bound * buf->bound_size.Y;
	for(int y = s_y; y < e_y; y++)
	    {
	    int j = (y % dim.Y) + 1;
	    for(int x = coord.origin.X; x < coord.corner.X; x++)
		{
		int i = (x % dim.X) + 1;
		if(image_get_pixel(buf->image, loc(x, y), buf->bitpx,
		    buf->nplanes) > threshold[i + dim.X * j] * max_color
						     / (dim.X * dim.Y))
		    image_put_pixel(buf->image, loc(x, y), global_i[6],
			buf->bitpx, buf->nplanes);
		else
		    image_put_pixel(buf->image, loc(x, y), global_i[7],
			buf->bitpx, buf->nplanes);
		}
	    }

	buf->put_bound(bound);
	}
    }
//////////////////////////
void error_dither(rect work)
    {
    for(int y = work.origin.Y; y < work.corner.Y; y++)
	for(int x = work.origin.X; x < work.corner.X; x++)
	    {
            if(random(16) > getpixel(x, y))
	        putpixel(x, y, global_i[6]);
            else
		putpixel(x, y, global_i[7]);
	    }
    }
////////////////////
void error_dither_buf(GrafBuffer* buf, rect coord)
    {
    int end_bound = coord.corner.Y / buf->bound_size.Y + 1;
    int start_bound = coord.origin.Y / buf->bound_size.Y;

    for(int bound = start_bound; bound < end_bound; bound++)
	{
	buf->get_bound(bound);
	int s_y = (bound > start_bound) ? 0
	      : coord.origin.Y - bound * buf->bound_size.Y;  // y coord inside image
	int e_y = (bound < end_bound - 1) ? buf->bound_size.Y
	      : coord.corner.Y - bound * buf->bound_size.Y;
	for(int y = s_y; y < e_y; y++)
	    for(int x = coord.origin.X; x < coord.corner.X; x++)
		{
		if(image_get_pixel(buf->image, loc(x, y), buf->bitpx,
		    buf->nplanes) < random(16))
		    image_put_pixel(buf->image, loc(x, y), global_i[6],
			buf->bitpx, buf->nplanes);
		else
		    image_put_pixel(buf->image, loc(x, y), global_i[7],
			buf->bitpx, buf->nplanes);
		}

	buf->put_bound(bound);
	}
    }



